/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.futures;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.CompletableFuture;

class ListenableToCompletableFutureWrapper<V>
extends CompletableFuture<V>
implements FutureCallback<V> {
    private final ListenableFuture<V> future;

    ListenableToCompletableFutureWrapper(ListenableFuture<V> future) {
        this.future = (ListenableFuture)Preconditions.checkNotNull(future, (Object)"future");
        Futures.addCallback(future, (FutureCallback)this);
    }

    public ListenableFuture<V> unwrap() {
        return this.future;
    }

    public void onSuccess(V result) {
        this.complete(result);
    }

    public void onFailure(Throwable t) {
        this.completeExceptionally(t);
    }
}

