/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.futures;

import com.google.api.core.ApiFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.futures.ApiFutureToCompletableFutureWrapper;
import com.spotify.futures.ApiFuturesExtra;
import com.spotify.futures.CompletableToApiFutureWrapper;
import com.spotify.futures.CompletableToListenableFutureWrapper;
import com.spotify.futures.ListenableFuturesExtra;
import com.spotify.futures.ListenableToCompletableFutureWrapper;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;

public class CompletableFuturesExtra {
    private CompletableFuturesExtra() {
        throw new AssertionError();
    }

    public static <V> ListenableFuture<V> toListenableFuture(CompletableFuture<V> future) {
        return CompletableFuturesExtra.toListenableFuture(future);
    }

    public static <V> ListenableFuture<V> toListenableFuture(CompletionStage<V> future) {
        if (future instanceof ListenableToCompletableFutureWrapper) {
            return ((ListenableToCompletableFutureWrapper)future).unwrap();
        }
        return new CompletableToListenableFutureWrapper<V>(future);
    }

    @Deprecated
    public static <V> CompletableFuture<V> toCompletableFuture(ListenableFuture<V> future) {
        return ListenableFuturesExtra.toCompletableFuture(future);
    }

    @Deprecated
    public static <V> CompletableFuture<V> toCompletableFuture(ApiFuture<V> future) {
        return ApiFuturesExtra.toCompletableFuture(future);
    }

    @Deprecated
    public static <V> CompletableFuture<V> toCompletableFuture(ApiFuture<V> future, Executor executor) {
        return ApiFuturesExtra.toCompletableFuture(future, executor);
    }

    public static <V> ApiFuture<V> toApiFuture(CompletionStage<V> future) {
        if (future instanceof ApiFutureToCompletableFutureWrapper) {
            return ((ApiFutureToCompletableFutureWrapper)future).unwrap();
        }
        return new CompletableToApiFutureWrapper<V>(future);
    }

    public static <T> CompletableFuture<T> exceptionallyCompletedFuture(Throwable throwable) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(throwable);
        return future;
    }

    public static <T, U> CompletionStage<U> handleCompose(CompletionStage<T> stage, BiFunction<? super T, Throwable, ? extends CompletionStage<U>> fn) {
        return CompletableFuturesExtra.dereference(stage.handle(fn));
    }

    public static <T> CompletionStage<T> exceptionallyCompose(CompletionStage<T> stage, Function<Throwable, ? extends CompletionStage<T>> fn) {
        return CompletableFuturesExtra.dereference(CompletableFuturesExtra.wrap(stage).exceptionally(fn));
    }

    public static <T> void checkCompleted(CompletionStage<T> stage) {
        if (!stage.toCompletableFuture().isDone()) {
            throw new IllegalStateException("future was not completed");
        }
    }

    public static <T> T getCompleted(CompletionStage<T> stage) {
        CompletableFuture<T> future = stage.toCompletableFuture();
        CompletableFuturesExtra.checkCompleted(future);
        return future.join();
    }

    public static Throwable getCompletedException(CompletionStage<?> stage) {
        CompletableFuture<?> future = stage.toCompletableFuture();
        CompletableFuturesExtra.checkCompleted(future);
        if (!future.isCompletedExceptionally()) {
            throw new IllegalStateException("future was not completed exceptionally");
        }
        try {
            future.join();
            throw new IllegalStateException("Unreachable");
        }
        catch (CancellationException | CompletionException e) {
            return e;
        }
    }

    public static <T> CompletionStage<T> dereference(CompletionStage<? extends CompletionStage<T>> stage) {
        return stage.thenCompose(Identity.INSTANCE);
    }

    private static <T> CompletionStage<CompletionStage<T>> wrap(CompletionStage<T> future) {
        return future.thenApply(WrapFunction.INSTANCE);
    }

    private static enum WrapFunction implements Function
    {
        INSTANCE;


        public Object apply(Object o) {
            return CompletableFuture.completedFuture(o);
        }
    }

    private static enum Identity implements Function
    {
        INSTANCE;


        public Object apply(Object o) {
            return o;
        }
    }
}

