/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.futures;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import com.spotify.futures.JoinedResults;
import com.spotify.futures.Validator;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class FuturesExtra {
    public static <T> ListenableFuture<T> makeTimeoutFuture(ScheduledExecutorService scheduledExecutorService, ListenableFuture<T> future, long timeout, TimeUnit unit) {
        final SettableFuture promise = SettableFuture.create();
        scheduledExecutorService.schedule(() -> {
            String message = "Future timed out after " + timeout + " " + unit.name();
            promise.setException((Throwable)new TimeoutException(message));
        }, timeout, unit);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                promise.set(result);
            }

            public void onFailure(Throwable t) {
                promise.setException(t);
            }
        }, (Executor)scheduledExecutorService);
        return promise;
    }

    public static <A, B> ListenableFuture<A> fastFail(ListenableFuture<B> conditionValue, ListenableFuture<A> future, Validator<B> validator) {
        return FuturesExtra.fastFail(conditionValue, future, validator, MoreExecutors.directExecutor());
    }

    public static <A, B> ListenableFuture<A> fastFail(ListenableFuture<B> conditionValue, ListenableFuture<A> future, Validator<B> validator, Executor executor) {
        return Futures.transformAsync(conditionValue, value -> {
            try {
                validator.validate(value);
                return future;
            }
            catch (Exception e) {
                future.cancel(false);
                throw e;
            }
        }, (Executor)executor);
    }

    public static <T> ListenableFuture<T> select(List<? extends ListenableFuture<T>> futures) {
        return FuturesExtra.select(futures, MoreExecutors.directExecutor());
    }

    public static <T> ListenableFuture<T> select(List<? extends ListenableFuture<T>> futures, Executor executor) {
        Preconditions.checkNotNull(futures);
        if (futures.isEmpty()) {
            return Futures.immediateFailedFuture((Throwable)new NoSuchElementException("List is empty"));
        }
        final int count = futures.size();
        final AtomicInteger failures = new AtomicInteger();
        final SettableFuture promise = SettableFuture.create();
        FutureCallback cb = new FutureCallback<T>(){

            public void onSuccess(T result) {
                promise.set(result);
            }

            public void onFailure(Throwable t) {
                if (failures.incrementAndGet() == count) {
                    promise.setException(t);
                }
            }
        };
        for (ListenableFuture<T> future : futures) {
            Futures.addCallback(future, (FutureCallback)cb, (Executor)executor);
        }
        return promise;
    }

    public static <T> void addCallback(ListenableFuture<T> future, Consumer<? super T> success, Consumer<Throwable> failure) {
        FuturesExtra.addCallback(future, success, failure, MoreExecutors.directExecutor());
    }

    public static <T> void addCallback(ListenableFuture<T> future, final Consumer<? super T> success, final Consumer<Throwable> failure, Executor executor) {
        if (success == null && failure == null) {
            throw new NullPointerException();
        }
        Futures.addCallback(future, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                if (success != null) {
                    success.accept(result);
                }
            }

            public void onFailure(Throwable throwable) {
                if (failure != null) {
                    failure.accept(throwable);
                }
            }
        }, (Executor)executor);
    }

    public static <T> void addSuccessCallback(ListenableFuture<T> future, Consumer<? super T> consumer) {
        FuturesExtra.addSuccessCallback(future, consumer, MoreExecutors.directExecutor());
    }

    public static <T> void addSuccessCallback(ListenableFuture<T> future, Consumer<? super T> consumer, Executor executor) {
        FuturesExtra.addCallback(future, consumer, null, executor);
    }

    public static <T> void addFailureCallback(ListenableFuture<T> future, Consumer<Throwable> consumer) {
        FuturesExtra.addFailureCallback(future, consumer, MoreExecutors.directExecutor());
    }

    public static <T> void addFailureCallback(ListenableFuture<T> future, Consumer<Throwable> consumer, Executor executor) {
        FuturesExtra.addCallback(future, null, consumer, executor);
    }

    public static <Z, A, B> ListenableFuture<Z> syncTransform2(ListenableFuture<A> a, ListenableFuture<B> b, Function2<Z, ? super A, ? super B> function) {
        return FuturesExtra.syncTransform2(a, b, function, MoreExecutors.directExecutor());
    }

    public static <Z, A, B> ListenableFuture<Z> syncTransform2(ListenableFuture<A> a, ListenableFuture<B> b, Function2<Z, ? super A, ? super B> function, Executor executor) {
        return FuturesExtra.transform(Arrays.asList(a, b), results -> function.apply((Object)results.get(0), (Object)results.get(1)), executor);
    }

    public static <Z, A, B> ListenableFuture<Z> asyncTransform2(ListenableFuture<A> a, ListenableFuture<B> b, AsyncFunction2<Z, ? super A, ? super B> function) {
        return FuturesExtra.asyncTransform2(a, b, function, MoreExecutors.directExecutor());
    }

    public static <Z, A, B> ListenableFuture<Z> asyncTransform2(ListenableFuture<A> a, ListenableFuture<B> b, AsyncFunction2<Z, ? super A, ? super B> function, Executor executor) {
        return FuturesExtra.transform(Arrays.asList(a, b), results -> function.apply((Object)results.get(0), (Object)results.get(1)), executor);
    }

    public static <Z, A, B, C> ListenableFuture<Z> syncTransform3(ListenableFuture<A> a, ListenableFuture<B> b, ListenableFuture<C> c, Function3<Z, ? super A, ? super B, ? super C> function) {
        return FuturesExtra.syncTransform3(a, b, c, function, MoreExecutors.directExecutor());
    }

    public static <Z, A, B, C> ListenableFuture<Z> syncTransform3(ListenableFuture<A> a, ListenableFuture<B> b, ListenableFuture<C> c, Function3<Z, ? super A, ? super B, ? super C> function, Executor executor) {
        return FuturesExtra.transform(Arrays.asList(a, b, c), results -> function.apply((Object)results.get(0), (Object)results.get(1), (Object)results.get(2)), executor);
    }

    public static <Z, A, B, C> ListenableFuture<Z> asyncTransform3(ListenableFuture<A> a, ListenableFuture<B> b, ListenableFuture<C> c, AsyncFunction3<Z, ? super A, ? super B, ? super C> function) {
        return FuturesExtra.asyncTransform3(a, b, c, function, MoreExecutors.directExecutor());
    }

    public static <Z, A, B, C> ListenableFuture<Z> asyncTransform3(ListenableFuture<A> a, ListenableFuture<B> b, ListenableFuture<C> c, AsyncFunction3<Z, ? super A, ? super B, ? super C> function, Executor executor) {
        return FuturesExtra.transform(Arrays.asList(a, b, c), results -> function.apply((Object)results.get(0), (Object)results.get(1), (Object)results.get(2)), executor);
    }

    public static <Z, A, B, C, D> ListenableFuture<Z> syncTransform4(ListenableFuture<A> a, ListenableFuture<B> b, ListenableFuture<C> c, ListenableFuture<D> d, Function4<Z, ? super A, ? super B, ? super C, ? super D> function) {
        return FuturesExtra.syncTransform4(a, b, c, d, function, MoreExecutors.directExecutor());
    }

    public static <Z, A, B, C, D> ListenableFuture<Z> syncTransform4(ListenableFuture<A> a, ListenableFuture<B> b, ListenableFuture<C> c, ListenableFuture<D> d, Function4<Z, ? super A, ? super B, ? super C, ? super D> function, Executor executor) {
        return FuturesExtra.transform(Arrays.asList(a, b, c, d), results -> function.apply((Object)results.get(0), (Object)results.get(1), (Object)results.get(2), (Object)results.get(3)), executor);
    }

    public static <Z, A, B, C, D> ListenableFuture<Z> asyncTransform4(ListenableFuture<A> a, ListenableFuture<B> b, ListenableFuture<C> c, ListenableFuture<D> d, AsyncFunction4<Z, ? super A, ? super B, ? super C, ? super D> function) {
        return FuturesExtra.asyncTransform4(a, b, c, d, function, MoreExecutors.directExecutor());
    }

    public static <Z, A, B, C, D> ListenableFuture<Z> asyncTransform4(ListenableFuture<A> a, ListenableFuture<B> b, ListenableFuture<C> c, ListenableFuture<D> d, AsyncFunction4<Z, ? super A, ? super B, ? super C, ? super D> function, Executor executor) {
        return FuturesExtra.transform(Arrays.asList(a, b, c, d), results -> function.apply((Object)results.get(0), (Object)results.get(1), (Object)results.get(2), (Object)results.get(3)), executor);
    }

    public static <Z, A, B, C, D, E> ListenableFuture<Z> syncTransform5(ListenableFuture<A> a, ListenableFuture<B> b, ListenableFuture<C> c, ListenableFuture<D> d, ListenableFuture<E> e, Function5<Z, ? super A, ? super B, ? super C, ? super D, ? super E> function) {
        return FuturesExtra.syncTransform5(a, b, c, d, e, function, MoreExecutors.directExecutor());
    }

    public static <Z, A, B, C, D, E> ListenableFuture<Z> syncTransform5(ListenableFuture<A> a, ListenableFuture<B> b, ListenableFuture<C> c, ListenableFuture<D> d, ListenableFuture<E> e, Function5<Z, ? super A, ? super B, ? super C, ? super D, ? super E> function, Executor executor) {
        return FuturesExtra.transform(Arrays.asList(a, b, c, d, e), results -> function.apply((Object)results.get(0), (Object)results.get(1), (Object)results.get(2), (Object)results.get(3), (Object)results.get(4)), executor);
    }

    public static <Z, A, B, C, D, E> ListenableFuture<Z> asyncTransform5(ListenableFuture<A> a, ListenableFuture<B> b, ListenableFuture<C> c, ListenableFuture<D> d, ListenableFuture<E> e, AsyncFunction5<Z, ? super A, ? super B, ? super C, ? super D, ? super E> function) {
        return FuturesExtra.asyncTransform5(a, b, c, d, e, function, MoreExecutors.directExecutor());
    }

    public static <Z, A, B, C, D, E> ListenableFuture<Z> asyncTransform5(ListenableFuture<A> a, ListenableFuture<B> b, ListenableFuture<C> c, ListenableFuture<D> d, ListenableFuture<E> e, AsyncFunction5<Z, ? super A, ? super B, ? super C, ? super D, ? super E> function, Executor executor) {
        return FuturesExtra.transform(Arrays.asList(a, b, c, d, e), results -> function.apply((Object)results.get(0), (Object)results.get(1), (Object)results.get(2), (Object)results.get(3), (Object)results.get(4)), executor);
    }

    public static <Z, A, B, C, D, E, F> ListenableFuture<Z> syncTransform6(ListenableFuture<A> a, ListenableFuture<B> b, ListenableFuture<C> c, ListenableFuture<D> d, ListenableFuture<E> e, ListenableFuture<F> f, Function6<Z, ? super A, ? super B, ? super C, ? super D, ? super E, ? super F> function) {
        return FuturesExtra.syncTransform6(a, b, c, d, e, f, function, MoreExecutors.directExecutor());
    }

    public static <Z, A, B, C, D, E, F> ListenableFuture<Z> syncTransform6(ListenableFuture<A> a, ListenableFuture<B> b, ListenableFuture<C> c, ListenableFuture<D> d, ListenableFuture<E> e, ListenableFuture<F> f, Function6<Z, ? super A, ? super B, ? super C, ? super D, ? super E, ? super F> function, Executor executor) {
        return FuturesExtra.transform(Arrays.asList(a, b, c, d, e, f), results -> function.apply((Object)results.get(0), (Object)results.get(1), (Object)results.get(2), (Object)results.get(3), (Object)results.get(4), (Object)results.get(5)), executor);
    }

    public static <Z, A, B, C, D, E, F> ListenableFuture<Z> asyncTransform6(ListenableFuture<A> a, ListenableFuture<B> b, ListenableFuture<C> c, ListenableFuture<D> d, ListenableFuture<E> e, ListenableFuture<F> f, AsyncFunction6<Z, ? super A, ? super B, ? super C, ? super D, ? super E, ? super F> function) {
        return FuturesExtra.asyncTransform6(a, b, c, d, e, f, function, MoreExecutors.directExecutor());
    }

    public static <Z, A, B, C, D, E, F> ListenableFuture<Z> asyncTransform6(ListenableFuture<A> a, ListenableFuture<B> b, ListenableFuture<C> c, ListenableFuture<D> d, ListenableFuture<E> e, ListenableFuture<F> f, AsyncFunction6<Z, ? super A, ? super B, ? super C, ? super D, ? super E, ? super F> function, Executor executor) {
        return FuturesExtra.transform(Arrays.asList(a, b, c, d, e, f), results -> function.apply((Object)results.get(0), (Object)results.get(1), (Object)results.get(2), (Object)results.get(3), (Object)results.get(4), (Object)results.get(5)), executor);
    }

    private static <Z> ListenableFuture<Z> transform(List<? extends ListenableFuture<?>> inputs, Function<List<Object>, Z> function, Executor executor) {
        return Futures.transform((ListenableFuture)Futures.allAsList(inputs), function, (Executor)executor);
    }

    private static <Z> ListenableFuture<Z> transform(List<? extends ListenableFuture<?>> inputs, AsyncFunction<List<Object>, Z> function, Executor executor) {
        return Futures.transformAsync((ListenableFuture)Futures.allAsList(inputs), function, (Executor)executor);
    }

    public static ListenableFuture<JoinedResults> join(List<? extends ListenableFuture<?>> inputs) {
        return FuturesExtra.join(MoreExecutors.directExecutor(), inputs);
    }

    public static ListenableFuture<JoinedResults> join(Executor executor, List<? extends ListenableFuture<?>> inputs) {
        return Futures.transform((ListenableFuture)Futures.allAsList(inputs), (Function)new JoinedResults.Transform(inputs), (Executor)executor);
    }

    public static ListenableFuture<JoinedResults> join(ListenableFuture<?> ... inputs) {
        return FuturesExtra.join(MoreExecutors.directExecutor(), Arrays.asList(inputs));
    }

    public static ListenableFuture<JoinedResults> join(Executor executor, ListenableFuture<?> ... inputs) {
        return FuturesExtra.join(executor, Arrays.asList(inputs));
    }

    public static <I, O> ListenableFuture<O> syncTransform(ListenableFuture<I> input, Function<? super I, ? extends O> function) {
        return Futures.transform(input, function, (Executor)MoreExecutors.directExecutor());
    }

    public static <I, O> ListenableFuture<O> asyncTransform(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function) {
        return Futures.transformAsync(input, function, (Executor)MoreExecutors.directExecutor());
    }

    public static <T> void checkCompleted(ListenableFuture<T> future) {
        if (!future.isDone()) {
            throw new IllegalStateException("future was not completed");
        }
    }

    public static <T> T getCompleted(ListenableFuture<T> future) {
        FuturesExtra.checkCompleted(future);
        return (T)Futures.getUnchecked(future);
    }

    public static <T> Throwable getException(ListenableFuture<T> future) {
        FuturesExtra.checkCompleted(future);
        try {
            Uninterruptibles.getUninterruptibly(future);
            return null;
        }
        catch (ExecutionException e) {
            return e.getCause();
        }
    }

    public static interface AsyncFunction6<Z, A, B, C, D, E, F> {
        public ListenableFuture<Z> apply(A var1, B var2, C var3, D var4, E var5, F var6) throws Exception;
    }

    public static interface Function6<Z, A, B, C, D, E, F> {
        public Z apply(A var1, B var2, C var3, D var4, E var5, F var6);
    }

    public static interface AsyncFunction5<Z, A, B, C, D, E> {
        public ListenableFuture<Z> apply(A var1, B var2, C var3, D var4, E var5) throws Exception;
    }

    public static interface Function5<Z, A, B, C, D, E> {
        public Z apply(A var1, B var2, C var3, D var4, E var5);
    }

    public static interface AsyncFunction4<Z, A, B, C, D> {
        public ListenableFuture<Z> apply(A var1, B var2, C var3, D var4) throws Exception;
    }

    public static interface Function4<Z, A, B, C, D> {
        public Z apply(A var1, B var2, C var3, D var4);
    }

    public static interface AsyncFunction3<Z, A, B, C> {
        public ListenableFuture<Z> apply(A var1, B var2, C var3) throws Exception;
    }

    public static interface Function3<Z, A, B, C> {
        public Z apply(A var1, B var2, C var3);
    }

    public static interface AsyncFunction2<Z, A, B> {
        public ListenableFuture<Z> apply(A var1, B var2) throws Exception;
    }

    public static interface Function2<Z, A, B> {
        public Z apply(A var1, B var2);
    }

    public static interface Consumer<T> {
        public void accept(T var1);
    }
}

