/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.spotify.github.v3.git.ImmutableShaLink;
import com.spotify.github.v3.repos.ImmutableBranch;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class BranchDeserializer
extends JsonDeserializer<ImmutableBranch> {
    private URI fixInvalidGithubUrl(String invalidUrl) throws IOException {
        String[] schemaAndPath = invalidUrl.split("//");
        CharSequence[] pathParts = schemaAndPath[1].split("/");
        for (int i = 0; i < pathParts.length; ++i) {
            pathParts[i] = URLEncoder.encode(pathParts[i], StandardCharsets.UTF_8);
        }
        String fixedUrlString = schemaAndPath[0] + "//" + String.join((CharSequence)"/", pathParts);
        return URI.create(fixedUrlString);
    }

    public ImmutableBranch deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        ImmutableBranch.Builder immutableBranchBuilder = ImmutableBranch.builder();
        if (node.has("protected")) {
            URI protectionUrl;
            immutableBranchBuilder.isProtected(node.get("protected").asBoolean());
            String protectionUrlString = node.get("protection_url").asText();
            try {
                protectionUrl = new URI(protectionUrlString);
            }
            catch (URISyntaxException e) {
                protectionUrl = this.fixInvalidGithubUrl(protectionUrlString);
            }
            immutableBranchBuilder.protectionUrl(protectionUrl);
        }
        ImmutableShaLink shaLink = ImmutableShaLink.builder().sha(node.get("commit").get("sha").asText()).url(URI.create(node.at("/commit/url").asText())).build();
        return immutableBranchBuilder.name(node.get("name").textValue()).commit(shaLink).build();
    }
}

