/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.issues;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.issues.Label;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Label", generator="Immutables")
@Immutable
public final class ImmutableLabel
implements Label {
    @Nullable
    private final URI url;
    @Nullable
    private final String name;
    @Nullable
    private final String color;

    private ImmutableLabel(@Nullable URI url, @Nullable String name, @Nullable String color) {
        this.url = url;
        this.name = name;
        this.color = color;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    @Nullable
    public String color() {
        return this.color;
    }

    public final ImmutableLabel withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableLabel(value, this.name, this.color);
    }

    public final ImmutableLabel withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableLabel(this.url, value, this.color);
    }

    public final ImmutableLabel withColor(@Nullable String value) {
        if (Objects.equals(this.color, value)) {
            return this;
        }
        return new ImmutableLabel(this.url, this.name, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLabel && this.equalTo((ImmutableLabel)another);
    }

    private boolean equalTo(ImmutableLabel another) {
        return Objects.equals(this.url, another.url) && Objects.equals(this.name, another.name) && Objects.equals(this.color, another.color);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.color);
        return h;
    }

    public String toString() {
        return "Label{url=" + this.url + ", name=" + this.name + ", color=" + this.color + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLabel fromJson(Json json) {
        Builder builder = ImmutableLabel.builder();
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.color != null) {
            builder.color(json.color);
        }
        return builder.build();
    }

    public static ImmutableLabel copyOf(Label instance) {
        if (instance instanceof ImmutableLabel) {
            return (ImmutableLabel)instance;
        }
        return ImmutableLabel.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Label", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private URI url;
        @Nullable
        private String name;
        @Nullable
        private String color;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Label instance) {
            String colorValue;
            String nameValue;
            Objects.requireNonNull(instance, "instance");
            URI urlValue = instance.url();
            if (urlValue != null) {
                this.url(urlValue);
            }
            if ((nameValue = instance.name()) != null) {
                this.name(nameValue);
            }
            if ((colorValue = instance.color()) != null) {
                this.color(colorValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder color(@Nullable String color) {
            this.color = color;
            return this;
        }

        public ImmutableLabel build() {
            return new ImmutableLabel(this.url, this.name, this.color);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Label", generator="Immutables")
    static final class Json
    implements Label {
        @Nullable
        URI url;
        @Nullable
        String name;
        @Nullable
        String color;

        Json() {
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty
        public void setColor(@Nullable String color) {
            this.color = color;
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String color() {
            throw new UnsupportedOperationException();
        }
    }
}

