/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.git.ShaLink;
import com.spotify.github.v3.repos.Branch;
import com.spotify.github.v3.repos.BranchProtectionUrlDeserializer;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Branch", generator="Immutables")
@Immutable
public final class ImmutableBranch
implements Branch {
    @Nullable
    private final String name;
    @Nullable
    private final ShaLink commit;
    @Nullable
    private final Boolean isProtected;
    @Nullable
    private final URI protectionUrl;

    private ImmutableBranch(@Nullable String name, @Nullable ShaLink commit, @Nullable Boolean isProtected, @Nullable URI protectionUrl) {
        this.name = name;
        this.commit = commit;
        this.isProtected = isProtected;
        this.protectionUrl = protectionUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    @Nullable
    public ShaLink commit() {
        return this.commit;
    }

    @Override
    @JsonProperty(value="protected")
    public Optional<Boolean> isProtected() {
        return Optional.ofNullable(this.isProtected);
    }

    @Override
    @JsonProperty
    @JsonDeserialize(using=BranchProtectionUrlDeserializer.class)
    public Optional<URI> protectionUrl() {
        return Optional.ofNullable(this.protectionUrl);
    }

    public final ImmutableBranch withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableBranch(value, this.commit, this.isProtected, this.protectionUrl);
    }

    public final ImmutableBranch withCommit(@Nullable ShaLink value) {
        if (this.commit == value) {
            return this;
        }
        return new ImmutableBranch(this.name, value, this.isProtected, this.protectionUrl);
    }

    public final ImmutableBranch withIsProtected(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isProtected, newValue)) {
            return this;
        }
        return new ImmutableBranch(this.name, this.commit, newValue, this.protectionUrl);
    }

    public final ImmutableBranch withIsProtected(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isProtected, value)) {
            return this;
        }
        return new ImmutableBranch(this.name, this.commit, value, this.protectionUrl);
    }

    public final ImmutableBranch withProtectionUrl(URI value) {
        URI newValue = Objects.requireNonNull(value, "protectionUrl");
        if (this.protectionUrl == newValue) {
            return this;
        }
        return new ImmutableBranch(this.name, this.commit, this.isProtected, newValue);
    }

    public final ImmutableBranch withProtectionUrl(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.protectionUrl == value) {
            return this;
        }
        return new ImmutableBranch(this.name, this.commit, this.isProtected, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBranch && this.equalTo((ImmutableBranch)another);
    }

    private boolean equalTo(ImmutableBranch another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.commit, another.commit) && Objects.equals(this.isProtected, another.isProtected) && Objects.equals(this.protectionUrl, another.protectionUrl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.commit);
        h += (h << 5) + Objects.hashCode(this.isProtected);
        h += (h << 5) + Objects.hashCode(this.protectionUrl);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Branch{");
        if (this.name != null) {
            builder.append("name=").append(this.name);
        }
        if (this.commit != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("commit=").append(this.commit);
        }
        if (this.isProtected != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("isProtected=").append(this.isProtected);
        }
        if (this.protectionUrl != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("protectionUrl=").append(this.protectionUrl);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBranch fromJson(Json json) {
        Builder builder = ImmutableBranch.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.commit != null) {
            builder.commit(json.commit);
        }
        if (json.isProtected != null) {
            builder.isProtected(json.isProtected);
        }
        if (json.protectionUrl != null) {
            builder.protectionUrl(json.protectionUrl);
        }
        return builder.build();
    }

    public static ImmutableBranch copyOf(Branch instance) {
        if (instance instanceof ImmutableBranch) {
            return (ImmutableBranch)instance;
        }
        return ImmutableBranch.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Branch", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String name;
        @Nullable
        private ShaLink commit;
        @Nullable
        private Boolean isProtected;
        @Nullable
        private URI protectionUrl;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Branch instance) {
            Optional<URI> protectionUrlOptional;
            Optional<Boolean> isProtectedOptional;
            ShaLink commitValue;
            Objects.requireNonNull(instance, "instance");
            String nameValue = instance.name();
            if (nameValue != null) {
                this.name(nameValue);
            }
            if ((commitValue = instance.commit()) != null) {
                this.commit(commitValue);
            }
            if ((isProtectedOptional = instance.isProtected()).isPresent()) {
                this.isProtected(isProtectedOptional);
            }
            if ((protectionUrlOptional = instance.protectionUrl()).isPresent()) {
                this.protectionUrl(protectionUrlOptional);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commit(@Nullable ShaLink commit) {
            this.commit = commit;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isProtected(boolean isProtected) {
            this.isProtected = isProtected;
            return this;
        }

        @JsonProperty(value="protected")
        @CanIgnoreReturnValue
        public final Builder isProtected(Optional<Boolean> isProtected) {
            this.isProtected = isProtected.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder protectionUrl(URI protectionUrl) {
            this.protectionUrl = Objects.requireNonNull(protectionUrl, "protectionUrl");
            return this;
        }

        @JsonProperty
        @JsonDeserialize(using=BranchProtectionUrlDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder protectionUrl(Optional<? extends URI> protectionUrl) {
            this.protectionUrl = protectionUrl.orElse(null);
            return this;
        }

        public ImmutableBranch build() {
            return new ImmutableBranch(this.name, this.commit, this.isProtected, this.protectionUrl);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Branch", generator="Immutables")
    static final class Json
    implements Branch {
        @Nullable
        String name;
        @Nullable
        ShaLink commit;
        @Nullable
        Optional<Boolean> isProtected = Optional.empty();
        @Nullable
        Optional<URI> protectionUrl = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty
        public void setCommit(@Nullable ShaLink commit) {
            this.commit = commit;
        }

        @JsonProperty(value="protected")
        public void setIsProtected(Optional<Boolean> isProtected) {
            this.isProtected = isProtected;
        }

        @JsonProperty
        @JsonDeserialize(using=BranchProtectionUrlDeserializer.class)
        public void setProtectionUrl(Optional<URI> protectionUrl) {
            this.protectionUrl = protectionUrl;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ShaLink commit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isProtected() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<URI> protectionUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

