/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Preconditions;
import com.spotify.github.GithubStyle;
import com.spotify.github.v3.checks.AnnotationLevel;
import com.spotify.github.v3.checks.ImmutableAnnotation;
import java.util.Optional;
import org.immutables.value.Value;

@JsonDeserialize(as=ImmutableAnnotation.class)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Value.Immutable
@GithubStyle
public interface Annotation {
    public String path();

    public Optional<String> blobHref();

    public AnnotationLevel annotationLevel();

    public String message();

    public Optional<String> title();

    public Optional<String> rawDetails();

    public int startLine();

    public int endLine();

    public Optional<Integer> startColumn();

    public Optional<Integer> endColumn();

    @Value.Check
    default public void check() {
        Preconditions.checkState((this.title().map(String::length).orElse(0) <= 255 ? 1 : 0) != 0, (Object)"'title' exceeded max length of 255");
        Preconditions.checkState((this.message().length() <= 65536 ? 1 : 0) != 0, (Object)"'message' exceeded max length of 64kB");
        Preconditions.checkState((this.rawDetails().map(String::length).orElse(0) <= 65536 ? 1 : 0) != 0, (Object)"'rawDetails' exceeded max length of 64kB");
    }
}

