/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.spotify.github.async.AsyncPage;
import com.spotify.github.http.ImmutablePagination;
import com.spotify.github.http.Link;
import com.spotify.github.http.Pagination;
import com.spotify.github.v3.clients.GitHubClient;
import com.spotify.githubclient.shade.okhttp3.ResponseBody;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GithubPage<T>
implements AsyncPage<T> {
    private final GitHubClient github;
    private final String path;
    private final TypeReference<List<T>> typeReference;

    GithubPage(GitHubClient github, String path, TypeReference<List<T>> typeReference) {
        this.github = github;
        this.path = path;
        this.typeReference = typeReference;
    }

    @Override
    public CompletableFuture<Pagination> pagination() {
        return this.linkMapAsync().thenApply(linkMap -> {
            Optional<Integer> maybePreviousPageNumber = Optional.ofNullable((Link)linkMap.get("prev")).map(prevLink -> this.pageNumberFromUri(prevLink.url().toString() + "1").orElse(1));
            Optional<Integer> maybeNextPageNumber = Optional.ofNullable((Link)linkMap.get("next")).map(prevLink -> this.pageNumberFromUri(prevLink.url().toString()).orElseThrow(() -> new RuntimeException("Could not parse page number from Link header with rel=\"next\"")));
            Integer lastPageNumber = maybePreviousPageNumber.map(pageNumber -> pageNumber + 1).orElseGet(() -> Optional.ofNullable((Link)linkMap.get("last")).map(lastLink -> this.pageNumberFromUri(lastLink.url().toString()).orElseThrow(() -> new RuntimeException("Could not parse page number from Link header with rel=\"last\""))).orElse(1));
            Integer currentPageNumber = maybeNextPageNumber.map(pageNumber -> pageNumber - 1).orElse(lastPageNumber);
            ImmutablePagination.Builder builder = ImmutablePagination.builder().current(currentPageNumber).last(lastPageNumber);
            maybePreviousPageNumber.ifPresent(builder::previous);
            maybeNextPageNumber.ifPresent(builder::next);
            return builder.build();
        });
    }

    @Override
    public CompletableFuture<AsyncPage<T>> nextPage() {
        return this.linkMapAsync().thenApply(linkMap -> {
            String nextPath = Optional.ofNullable((Link)linkMap.get("next")).map(nextLink -> nextLink.url().toString().replaceAll(this.github.urlFor(""), "")).orElseThrow(() -> new NoSuchElementException("Page iteration exhausted"));
            return new GithubPage<T>(this.github, nextPath, this.typeReference);
        });
    }

    @Override
    public CompletableFuture<Boolean> hasNextPage() {
        return this.linkMapAsync().thenApply(linkMap -> Objects.nonNull(linkMap.get("next")));
    }

    @Override
    public AsyncPage<T> clone() {
        return new GithubPage<T>(this.github, this.path, this.typeReference);
    }

    @Override
    public Iterator<T> iterator() {
        return ((List)((CompletableFuture)this.github.request(this.path).thenApply(response -> this.github.json().fromJsonUncheckedNotNull(GitHubClient.responseBodyUnchecked(response), this.typeReference))).join()).iterator();
    }

    private CompletableFuture<Map<String, Link>> linkMapAsync() {
        return this.github.request(this.path).thenApply(response -> {
            Optional.ofNullable(response.body()).ifPresent(ResponseBody::close);
            return Optional.ofNullable(response.headers().get("Link")).map(linkHeader -> Arrays.stream(linkHeader.split(","))).orElseGet(Stream::empty).map(linkString -> Link.from(linkString.split(";"))).filter(link -> link.rel().isPresent()).collect(Collectors.toMap(link -> link.rel().get(), Function.identity()));
        });
    }

    private Optional<Integer> pageNumberFromUri(String uri) {
        return Optional.ofNullable(uri.replaceAll(".*\\?page=", "").replaceAll("&.*", "")).filter(string -> string.matches("\\d+")).map(Integer::parseInt);
    }
}

