/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.clients;

import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PKCS1PEMKey {
    private static final Pattern PKCS1_PEM_KEY_PATTERN = Pattern.compile("(?m)(?s)^---*BEGIN RSA PRIVATE KEY.*---*$(.*)^---*END.*---*$.*");

    private PKCS1PEMKey() {
    }

    public static Optional<KeySpec> loadKeySpec(byte[] privateKey) {
        Matcher isPEM = PKCS1_PEM_KEY_PATTERN.matcher(new String(privateKey));
        if (!isPEM.matches()) {
            return Optional.empty();
        }
        byte[] pkcs1Key = Base64.getMimeDecoder().decode(isPEM.group(1));
        byte[] pkcs8Key = PKCS1PEMKey.toPkcs8(pkcs1Key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pkcs8Key);
        return Optional.of(keySpec);
    }

    private static byte[] toPkcs8(byte[] pkcs1Bytes) {
        int pkcs1Length = pkcs1Bytes.length;
        int totalLength = pkcs1Length + 22;
        byte[] pkcs8Header = new byte[]{48, -126, (byte)(totalLength >> 8 & 0xFF), (byte)(totalLength & 0xFF), 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 4, -126, (byte)(pkcs1Length >> 8 & 0xFF), (byte)(pkcs1Length & 0xFF)};
        byte[] pkcs8bytes = new byte[pkcs8Header.length + pkcs1Bytes.length];
        System.arraycopy(pkcs8Header, 0, pkcs8bytes, 0, pkcs8Header.length);
        System.arraycopy(pkcs1Bytes, 0, pkcs8bytes, pkcs8Header.length, pkcs1Bytes.length);
        return pkcs8bytes;
    }
}

