/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.hooks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.hooks.WebhookConfig;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="WebhookConfig", generator="Immutables")
@Immutable
public final class ImmutableWebhookConfig
implements WebhookConfig {
    @Nullable
    private final URI url;
    @Nullable
    private final String contentType;

    private ImmutableWebhookConfig(@Nullable URI url, @Nullable String contentType) {
        this.url = url;
        this.contentType = contentType;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public String contentType() {
        return this.contentType;
    }

    public final ImmutableWebhookConfig withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableWebhookConfig(value, this.contentType);
    }

    public final ImmutableWebhookConfig withContentType(@Nullable String value) {
        if (Objects.equals(this.contentType, value)) {
            return this;
        }
        return new ImmutableWebhookConfig(this.url, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebhookConfig && this.equalTo((ImmutableWebhookConfig)another);
    }

    private boolean equalTo(ImmutableWebhookConfig another) {
        return Objects.equals(this.url, another.url) && Objects.equals(this.contentType, another.contentType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.contentType);
        return h;
    }

    public String toString() {
        return "WebhookConfig{url=" + this.url + ", contentType=" + this.contentType + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableWebhookConfig fromJson(Json json) {
        Builder builder = ImmutableWebhookConfig.builder();
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.contentType != null) {
            builder.contentType(json.contentType);
        }
        return builder.build();
    }

    public static ImmutableWebhookConfig copyOf(WebhookConfig instance) {
        if (instance instanceof ImmutableWebhookConfig) {
            return (ImmutableWebhookConfig)instance;
        }
        return ImmutableWebhookConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="WebhookConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private URI url;
        @Nullable
        private String contentType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(WebhookConfig instance) {
            String contentTypeValue;
            Objects.requireNonNull(instance, "instance");
            URI urlValue = instance.url();
            if (urlValue != null) {
                this.url(urlValue);
            }
            if ((contentTypeValue = instance.contentType()) != null) {
                this.contentType(contentTypeValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder contentType(@Nullable String contentType) {
            this.contentType = contentType;
            return this;
        }

        public ImmutableWebhookConfig build() {
            return new ImmutableWebhookConfig(this.url, this.contentType);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="WebhookConfig", generator="Immutables")
    static final class Json
    implements WebhookConfig {
        @Nullable
        URI url;
        @Nullable
        String contentType;

        Json() {
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setContentType(@Nullable String contentType) {
            this.contentType = contentType;
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String contentType() {
            throw new UnsupportedOperationException();
        }
    }
}

