/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class GitHubInstant {
    private Optional<Long> epochSeconds;
    private Optional<Instant> instant;

    private GitHubInstant(Optional<Long> epoch, Optional<Instant> inst) {
        this.epochSeconds = epoch;
        this.instant = inst;
    }

    public static GitHubInstant create(@Nonnull Number inst) {
        Number number = Objects.requireNonNull(inst);
        return new GitHubInstant(Optional.of(number.longValue()), Optional.empty());
    }

    public static GitHubInstant create(@Nonnull Instant inst) {
        Instant instant = Objects.requireNonNull(inst);
        return new GitHubInstant(Optional.empty(), Optional.of(instant));
    }

    public Class<?> type() {
        return this.epochSeconds.isPresent() ? this.epochSeconds.get().getClass() : this.instant.get().getClass();
    }

    public Long epoch() {
        return this.epochSeconds.orElseGet(() -> this.instant.get().getEpochSecond());
    }

    public Instant instant() {
        return this.instant.orElseGet(() -> Instant.ofEpochSecond(this.epochSeconds.get()));
    }
}

