/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.opencensus;

import com.spotify.github.Span;
import com.spotify.github.v3.exceptions.RequestNotOkException;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Status;
import java.util.Objects;

class OpenCensusSpan
implements Span {
    public static final int NOT_FOUND = 404;
    public static final int INTERNAL_SERVER_ERROR = 500;
    private final io.opencensus.trace.Span span;

    OpenCensusSpan(io.opencensus.trace.Span span) {
        this.span = Objects.requireNonNull(span);
    }

    @Override
    public Span success() {
        this.span.setStatus(Status.OK);
        return this;
    }

    @Override
    public Span failure(Throwable t) {
        if (t instanceof RequestNotOkException) {
            RequestNotOkException ex = (RequestNotOkException)t;
            this.span.putAttribute("http.status_code", AttributeValue.longAttributeValue((long)ex.statusCode()));
            this.span.putAttribute("message", AttributeValue.stringAttributeValue((String)ex.getRawMessage()));
            if (ex.statusCode() - 500 >= 0) {
                this.span.putAttribute("error", AttributeValue.booleanAttributeValue((boolean)true));
            }
        }
        this.span.setStatus(Status.UNKNOWN);
        return this;
    }

    @Override
    public void close() {
        this.span.end();
    }
}

