/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.checks.AccessToken;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccessToken", generator="Immutables")
@Immutable
public final class ImmutableAccessToken
implements AccessToken {
    private final String token;
    private final ZonedDateTime expiresAt;

    private ImmutableAccessToken(String token, ZonedDateTime expiresAt) {
        this.token = token;
        this.expiresAt = expiresAt;
    }

    @Override
    @JsonProperty
    public String token() {
        return this.token;
    }

    @Override
    @JsonProperty
    public ZonedDateTime expiresAt() {
        return this.expiresAt;
    }

    public final ImmutableAccessToken withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (this.token.equals(newValue)) {
            return this;
        }
        return new ImmutableAccessToken(newValue, this.expiresAt);
    }

    public final ImmutableAccessToken withExpiresAt(ZonedDateTime value) {
        if (this.expiresAt == value) {
            return this;
        }
        ZonedDateTime newValue = Objects.requireNonNull(value, "expiresAt");
        return new ImmutableAccessToken(this.token, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccessToken && this.equalTo((ImmutableAccessToken)another);
    }

    private boolean equalTo(ImmutableAccessToken another) {
        return this.token.equals(another.token) && this.expiresAt.equals(another.expiresAt);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + this.expiresAt.hashCode();
        return h;
    }

    public String toString() {
        return "AccessToken{token=" + this.token + ", expiresAt=" + this.expiresAt + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAccessToken fromJson(Json json) {
        Builder builder = ImmutableAccessToken.builder();
        if (json.token != null) {
            builder.token(json.token);
        }
        if (json.expiresAt != null) {
            builder.expiresAt(json.expiresAt);
        }
        return builder.build();
    }

    public static ImmutableAccessToken copyOf(AccessToken instance) {
        if (instance instanceof ImmutableAccessToken) {
            return (ImmutableAccessToken)instance;
        }
        return ImmutableAccessToken.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccessToken", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOKEN = 1L;
        private static final long INIT_BIT_EXPIRES_AT = 2L;
        private long initBits = 3L;
        @Nullable
        private String token;
        @Nullable
        private ZonedDateTime expiresAt;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AccessToken instance) {
            Objects.requireNonNull(instance, "instance");
            this.token(instance.token());
            this.expiresAt(instance.expiresAt());
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder token(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder expiresAt(ZonedDateTime expiresAt) {
            this.expiresAt = Objects.requireNonNull(expiresAt, "expiresAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableAccessToken build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccessToken(this.token, this.expiresAt);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("token");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("expiresAt");
            }
            return "Cannot build AccessToken, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccessToken", generator="Immutables")
    static final class Json
    implements AccessToken {
        @Nullable
        String token;
        @Nullable
        ZonedDateTime expiresAt;

        Json() {
        }

        @JsonProperty
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty
        public void setExpiresAt(ZonedDateTime expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public String token() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZonedDateTime expiresAt() {
            throw new UnsupportedOperationException();
        }
    }
}

