/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.prs.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.prs.requests.PullRequestUpdate;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PullRequestUpdate", generator="Immutables")
@Immutable
public final class ImmutablePullRequestUpdate
implements PullRequestUpdate {
    @Nullable
    private final String title;
    @Nullable
    private final String body;
    @Nullable
    private final String state;

    private ImmutablePullRequestUpdate(@Nullable String title, @Nullable String body, @Nullable String state) {
        this.title = title;
        this.body = body;
        this.state = state;
    }

    @Override
    @JsonProperty
    public Optional<String> title() {
        return Optional.ofNullable(this.title);
    }

    @Override
    @JsonProperty
    public Optional<String> body() {
        return Optional.ofNullable(this.body);
    }

    @Override
    @JsonProperty
    public Optional<String> state() {
        return Optional.ofNullable(this.state);
    }

    public final ImmutablePullRequestUpdate withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (Objects.equals(this.title, newValue)) {
            return this;
        }
        return new ImmutablePullRequestUpdate(newValue, this.body, this.state);
    }

    public final ImmutablePullRequestUpdate withTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutablePullRequestUpdate(value, this.body, this.state);
    }

    public final ImmutablePullRequestUpdate withBody(String value) {
        String newValue = Objects.requireNonNull(value, "body");
        if (Objects.equals(this.body, newValue)) {
            return this;
        }
        return new ImmutablePullRequestUpdate(this.title, newValue, this.state);
    }

    public final ImmutablePullRequestUpdate withBody(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.body, value)) {
            return this;
        }
        return new ImmutablePullRequestUpdate(this.title, value, this.state);
    }

    public final ImmutablePullRequestUpdate withState(String value) {
        String newValue = Objects.requireNonNull(value, "state");
        if (Objects.equals(this.state, newValue)) {
            return this;
        }
        return new ImmutablePullRequestUpdate(this.title, this.body, newValue);
    }

    public final ImmutablePullRequestUpdate withState(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.state, value)) {
            return this;
        }
        return new ImmutablePullRequestUpdate(this.title, this.body, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePullRequestUpdate && this.equalTo((ImmutablePullRequestUpdate)another);
    }

    private boolean equalTo(ImmutablePullRequestUpdate another) {
        return Objects.equals(this.title, another.title) && Objects.equals(this.body, another.body) && Objects.equals(this.state, another.state);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.body);
        h += (h << 5) + Objects.hashCode(this.state);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PullRequestUpdate{");
        if (this.title != null) {
            builder.append("title=").append(this.title);
        }
        if (this.body != null) {
            if (builder.length() > 18) {
                builder.append(", ");
            }
            builder.append("body=").append(this.body);
        }
        if (this.state != null) {
            if (builder.length() > 18) {
                builder.append(", ");
            }
            builder.append("state=").append(this.state);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePullRequestUpdate fromJson(Json json) {
        Builder builder = ImmutablePullRequestUpdate.builder();
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.body != null) {
            builder.body(json.body);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        return builder.build();
    }

    public static ImmutablePullRequestUpdate copyOf(PullRequestUpdate instance) {
        if (instance instanceof ImmutablePullRequestUpdate) {
            return (ImmutablePullRequestUpdate)instance;
        }
        return ImmutablePullRequestUpdate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PullRequestUpdate", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String title;
        @Nullable
        private String body;
        @Nullable
        private String state;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PullRequestUpdate instance) {
            Optional<String> stateOptional;
            Optional<String> bodyOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> titleOptional = instance.title();
            if (titleOptional.isPresent()) {
                this.title(titleOptional);
            }
            if ((bodyOptional = instance.body()).isPresent()) {
                this.body(bodyOptional);
            }
            if ((stateOptional = instance.state()).isPresent()) {
                this.state(stateOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder title(Optional<String> title) {
            this.title = title.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder body(String body) {
            this.body = Objects.requireNonNull(body, "body");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder body(Optional<String> body) {
            this.body = body.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder state(String state) {
            this.state = Objects.requireNonNull(state, "state");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder state(Optional<String> state) {
            this.state = state.orElse(null);
            return this;
        }

        public ImmutablePullRequestUpdate build() {
            return new ImmutablePullRequestUpdate(this.title, this.body, this.state);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PullRequestUpdate", generator="Immutables")
    static final class Json
    implements PullRequestUpdate {
        @Nullable
        Optional<String> title = Optional.empty();
        @Nullable
        Optional<String> body = Optional.empty();
        @Nullable
        Optional<String> state = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setTitle(Optional<String> title) {
            this.title = title;
        }

        @JsonProperty
        public void setBody(Optional<String> body) {
            this.body = body;
        }

        @JsonProperty
        public void setState(Optional<String> state) {
            this.state = state;
        }

        @Override
        public Optional<String> title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> body() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> state() {
            throw new UnsupportedOperationException();
        }
    }
}

