/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.clients;

import com.google.common.collect.ImmutableMap;
import com.spotify.github.v3.checks.CheckRunRequest;
import com.spotify.github.v3.checks.CheckRunResponse;
import com.spotify.github.v3.checks.CheckRunResponseList;
import com.spotify.github.v3.checks.CheckSuite;
import com.spotify.github.v3.checks.CheckSuiteResponseList;
import com.spotify.github.v3.clients.GitHubClient;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class ChecksClient {
    private static final String GET_CHECK_SUITE_URI = "/repos/%s/%s/check-suites/%s";
    private static final String LIST_CHECK_SUITES_REF_URI = "/repos/%s/%s/commits/%s/check-suites";
    private static final String CHECK_RUNS_URI = "/repos/%s/%s/check-runs";
    private static final String LIST_CHECK_RUNS_URI = "/repos/%s/%s/commits/%s/check-runs";
    private static final String GET_CHECK_RUN_URI = "/repos/%s/%s/check-runs/%s";
    private final GitHubClient github;
    private final String owner;
    private final String repo;
    private final Map<String, String> extraHeaders = ImmutableMap.of((Object)"Accept", (Object)"application/vnd.github.antiope-preview+json");

    ChecksClient(GitHubClient github, String owner, String repo) {
        this.github = github;
        this.owner = owner;
        this.repo = repo;
    }

    static ChecksClient create(GitHubClient github, String owner, String repo) {
        return new ChecksClient(github, owner, repo);
    }

    public CompletableFuture<CheckRunResponse> createCheckRun(CheckRunRequest checkRun) {
        String path = String.format(CHECK_RUNS_URI, this.owner, this.repo);
        return this.github.post(path, this.github.json().toJsonUnchecked(checkRun), CheckRunResponse.class, this.extraHeaders);
    }

    public CompletableFuture<CheckRunResponse> updateCheckRun(long id, CheckRunRequest checkRun) {
        String path = String.format(GET_CHECK_RUN_URI, this.owner, this.repo, id);
        return this.github.patch(path, this.github.json().toJsonUnchecked(checkRun), CheckRunResponse.class, this.extraHeaders);
    }

    public CompletableFuture<CheckRunResponse> getCheckRun(long id) {
        String path = String.format(GET_CHECK_RUN_URI, this.owner, this.repo, id);
        return this.github.request(path, CheckRunResponse.class, this.extraHeaders);
    }

    public CompletableFuture<CheckRunResponseList> getCheckRuns(String ref) {
        String path = String.format(LIST_CHECK_RUNS_URI, this.owner, this.repo, ref);
        return this.github.request(path, CheckRunResponseList.class, this.extraHeaders);
    }

    public CompletableFuture<CheckSuite> getCheckSuite(String id) {
        String path = String.format(GET_CHECK_SUITE_URI, this.owner, this.repo, id);
        return this.github.request(path, CheckSuite.class, this.extraHeaders);
    }

    public CompletableFuture<CheckSuiteResponseList> getCheckSuites(String sha) {
        String path = String.format(LIST_CHECK_SUITES_REF_URI, this.owner, this.repo, sha);
        return this.github.request(path, CheckSuiteResponseList.class, this.extraHeaders);
    }
}

