/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.exceptions;

import com.spotify.github.v3.exceptions.GithubException;

public class RequestNotOkException
extends GithubException {
    private final int statusCode;
    private final String method;
    private final String path;
    private final String msg;

    private static String decoratedMessage(String method, String path, int statusCode, String msg) {
        return String.format("%s %s %d: %s", method, path, statusCode, msg);
    }

    public RequestNotOkException(String method, String path, int statusCode, String msg) {
        super(RequestNotOkException.decoratedMessage(method, path, statusCode, msg));
        this.statusCode = statusCode;
        this.method = method;
        this.path = path;
        this.msg = msg;
    }

    public String getRawMessage() {
        return this.msg;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public String method() {
        return this.method;
    }

    public String path() {
        return this.path;
    }
}

