/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.orgs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.orgs.Membership;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Membership", generator="Immutables")
@Immutable
public final class ImmutableMembership
implements Membership {
    @Nullable
    private final URI url;
    @Nullable
    private final String role;
    @Nullable
    private final String state;

    private ImmutableMembership(@Nullable URI url, @Nullable String role, @Nullable String state) {
        this.url = url;
        this.role = role;
        this.state = state;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public String role() {
        return this.role;
    }

    @Override
    @JsonProperty
    @Nullable
    public String state() {
        return this.state;
    }

    public final ImmutableMembership withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableMembership(value, this.role, this.state);
    }

    public final ImmutableMembership withRole(@Nullable String value) {
        if (Objects.equals(this.role, value)) {
            return this;
        }
        return new ImmutableMembership(this.url, value, this.state);
    }

    public final ImmutableMembership withState(@Nullable String value) {
        if (Objects.equals(this.state, value)) {
            return this;
        }
        return new ImmutableMembership(this.url, this.role, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMembership && this.equalTo((ImmutableMembership)another);
    }

    private boolean equalTo(ImmutableMembership another) {
        return Objects.equals(this.url, another.url) && Objects.equals(this.role, another.role) && Objects.equals(this.state, another.state);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.role);
        h += (h << 5) + Objects.hashCode(this.state);
        return h;
    }

    public String toString() {
        return "Membership{url=" + this.url + ", role=" + this.role + ", state=" + this.state + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMembership fromJson(Json json) {
        Builder builder = ImmutableMembership.builder();
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.role != null) {
            builder.role(json.role);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        return builder.build();
    }

    public static ImmutableMembership copyOf(Membership instance) {
        if (instance instanceof ImmutableMembership) {
            return (ImmutableMembership)instance;
        }
        return ImmutableMembership.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Membership", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private URI url;
        @Nullable
        private String role;
        @Nullable
        private String state;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Membership instance) {
            String stateValue;
            String roleValue;
            Objects.requireNonNull(instance, "instance");
            URI urlValue = instance.url();
            if (urlValue != null) {
                this.url(urlValue);
            }
            if ((roleValue = instance.role()) != null) {
                this.role(roleValue);
            }
            if ((stateValue = instance.state()) != null) {
                this.state(stateValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder role(@Nullable String role) {
            this.role = role;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder state(@Nullable String state) {
            this.state = state;
            return this;
        }

        public ImmutableMembership build() {
            return new ImmutableMembership(this.url, this.role, this.state);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Membership", generator="Immutables")
    static final class Json
    implements Membership {
        @Nullable
        URI url;
        @Nullable
        String role;
        @Nullable
        String state;

        Json() {
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setRole(@Nullable String role) {
            this.role = role;
        }

        @JsonProperty
        public void setState(@Nullable String state) {
            this.state = state;
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String role() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String state() {
            throw new UnsupportedOperationException();
        }
    }
}

