/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.orgs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.orgs.TeamInvitation;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TeamInvitation", generator="Immutables")
@Immutable
public final class ImmutableTeamInvitation
implements TeamInvitation {
    @Nullable
    private final Integer id;
    @Nullable
    private final String login;
    @Nullable
    private final String nodeId;
    @Nullable
    private final String email;
    @Nullable
    private final String role;
    @Nullable
    private final String failedReason;
    @Nullable
    private final User inviter;
    @Nullable
    private final Integer teamCount;
    @Nullable
    private final URI invitationTeamsUrl;
    @Nullable
    private final String invitationSource;

    private ImmutableTeamInvitation(@Nullable Integer id, @Nullable String login, @Nullable String nodeId, @Nullable String email, @Nullable String role, @Nullable String failedReason, @Nullable User inviter, @Nullable Integer teamCount, @Nullable URI invitationTeamsUrl, @Nullable String invitationSource) {
        this.id = id;
        this.login = login;
        this.nodeId = nodeId;
        this.email = email;
        this.role = role;
        this.failedReason = failedReason;
        this.inviter = inviter;
        this.teamCount = teamCount;
        this.invitationTeamsUrl = invitationTeamsUrl;
        this.invitationSource = invitationSource;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer id() {
        return this.id;
    }

    @Override
    @JsonProperty
    @Nullable
    public String login() {
        return this.login;
    }

    @Override
    @JsonProperty
    @Nullable
    public String nodeId() {
        return this.nodeId;
    }

    @Override
    @JsonProperty
    @Nullable
    public String email() {
        return this.email;
    }

    @Override
    @JsonProperty
    @Nullable
    public String role() {
        return this.role;
    }

    @Override
    @JsonProperty
    @Nullable
    public String failedReason() {
        return this.failedReason;
    }

    @Override
    @JsonProperty
    @Nullable
    public User inviter() {
        return this.inviter;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer teamCount() {
        return this.teamCount;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI invitationTeamsUrl() {
        return this.invitationTeamsUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public String invitationSource() {
        return this.invitationSource;
    }

    public final ImmutableTeamInvitation withId(@Nullable Integer value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableTeamInvitation(value, this.login, this.nodeId, this.email, this.role, this.failedReason, this.inviter, this.teamCount, this.invitationTeamsUrl, this.invitationSource);
    }

    public final ImmutableTeamInvitation withLogin(@Nullable String value) {
        if (Objects.equals(this.login, value)) {
            return this;
        }
        return new ImmutableTeamInvitation(this.id, value, this.nodeId, this.email, this.role, this.failedReason, this.inviter, this.teamCount, this.invitationTeamsUrl, this.invitationSource);
    }

    public final ImmutableTeamInvitation withNodeId(@Nullable String value) {
        if (Objects.equals(this.nodeId, value)) {
            return this;
        }
        return new ImmutableTeamInvitation(this.id, this.login, value, this.email, this.role, this.failedReason, this.inviter, this.teamCount, this.invitationTeamsUrl, this.invitationSource);
    }

    public final ImmutableTeamInvitation withEmail(@Nullable String value) {
        if (Objects.equals(this.email, value)) {
            return this;
        }
        return new ImmutableTeamInvitation(this.id, this.login, this.nodeId, value, this.role, this.failedReason, this.inviter, this.teamCount, this.invitationTeamsUrl, this.invitationSource);
    }

    public final ImmutableTeamInvitation withRole(@Nullable String value) {
        if (Objects.equals(this.role, value)) {
            return this;
        }
        return new ImmutableTeamInvitation(this.id, this.login, this.nodeId, this.email, value, this.failedReason, this.inviter, this.teamCount, this.invitationTeamsUrl, this.invitationSource);
    }

    public final ImmutableTeamInvitation withFailedReason(@Nullable String value) {
        if (Objects.equals(this.failedReason, value)) {
            return this;
        }
        return new ImmutableTeamInvitation(this.id, this.login, this.nodeId, this.email, this.role, value, this.inviter, this.teamCount, this.invitationTeamsUrl, this.invitationSource);
    }

    public final ImmutableTeamInvitation withInviter(@Nullable User value) {
        if (this.inviter == value) {
            return this;
        }
        return new ImmutableTeamInvitation(this.id, this.login, this.nodeId, this.email, this.role, this.failedReason, value, this.teamCount, this.invitationTeamsUrl, this.invitationSource);
    }

    public final ImmutableTeamInvitation withTeamCount(@Nullable Integer value) {
        if (Objects.equals(this.teamCount, value)) {
            return this;
        }
        return new ImmutableTeamInvitation(this.id, this.login, this.nodeId, this.email, this.role, this.failedReason, this.inviter, value, this.invitationTeamsUrl, this.invitationSource);
    }

    public final ImmutableTeamInvitation withInvitationTeamsUrl(@Nullable URI value) {
        if (this.invitationTeamsUrl == value) {
            return this;
        }
        return new ImmutableTeamInvitation(this.id, this.login, this.nodeId, this.email, this.role, this.failedReason, this.inviter, this.teamCount, value, this.invitationSource);
    }

    public final ImmutableTeamInvitation withInvitationSource(@Nullable String value) {
        if (Objects.equals(this.invitationSource, value)) {
            return this;
        }
        return new ImmutableTeamInvitation(this.id, this.login, this.nodeId, this.email, this.role, this.failedReason, this.inviter, this.teamCount, this.invitationTeamsUrl, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTeamInvitation && this.equalTo((ImmutableTeamInvitation)another);
    }

    private boolean equalTo(ImmutableTeamInvitation another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.login, another.login) && Objects.equals(this.nodeId, another.nodeId) && Objects.equals(this.email, another.email) && Objects.equals(this.role, another.role) && Objects.equals(this.failedReason, another.failedReason) && Objects.equals(this.inviter, another.inviter) && Objects.equals(this.teamCount, another.teamCount) && Objects.equals(this.invitationTeamsUrl, another.invitationTeamsUrl) && Objects.equals(this.invitationSource, another.invitationSource);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.login);
        h += (h << 5) + Objects.hashCode(this.nodeId);
        h += (h << 5) + Objects.hashCode(this.email);
        h += (h << 5) + Objects.hashCode(this.role);
        h += (h << 5) + Objects.hashCode(this.failedReason);
        h += (h << 5) + Objects.hashCode(this.inviter);
        h += (h << 5) + Objects.hashCode(this.teamCount);
        h += (h << 5) + Objects.hashCode(this.invitationTeamsUrl);
        h += (h << 5) + Objects.hashCode(this.invitationSource);
        return h;
    }

    public String toString() {
        return "TeamInvitation{id=" + this.id + ", login=" + this.login + ", nodeId=" + this.nodeId + ", email=" + this.email + ", role=" + this.role + ", failedReason=" + this.failedReason + ", inviter=" + this.inviter + ", teamCount=" + this.teamCount + ", invitationTeamsUrl=" + this.invitationTeamsUrl + ", invitationSource=" + this.invitationSource + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTeamInvitation fromJson(Json json) {
        Builder builder = ImmutableTeamInvitation.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.login != null) {
            builder.login(json.login);
        }
        if (json.nodeId != null) {
            builder.nodeId(json.nodeId);
        }
        if (json.email != null) {
            builder.email(json.email);
        }
        if (json.role != null) {
            builder.role(json.role);
        }
        if (json.failedReason != null) {
            builder.failedReason(json.failedReason);
        }
        if (json.inviter != null) {
            builder.inviter(json.inviter);
        }
        if (json.teamCount != null) {
            builder.teamCount(json.teamCount);
        }
        if (json.invitationTeamsUrl != null) {
            builder.invitationTeamsUrl(json.invitationTeamsUrl);
        }
        if (json.invitationSource != null) {
            builder.invitationSource(json.invitationSource);
        }
        return builder.build();
    }

    public static ImmutableTeamInvitation copyOf(TeamInvitation instance) {
        if (instance instanceof ImmutableTeamInvitation) {
            return (ImmutableTeamInvitation)instance;
        }
        return ImmutableTeamInvitation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TeamInvitation", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Integer id;
        @Nullable
        private String login;
        @Nullable
        private String nodeId;
        @Nullable
        private String email;
        @Nullable
        private String role;
        @Nullable
        private String failedReason;
        @Nullable
        private User inviter;
        @Nullable
        private Integer teamCount;
        @Nullable
        private URI invitationTeamsUrl;
        @Nullable
        private String invitationSource;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TeamInvitation instance) {
            String invitationSourceValue;
            URI invitationTeamsUrlValue;
            Integer teamCountValue;
            User inviterValue;
            String failedReasonValue;
            String roleValue;
            String emailValue;
            String nodeIdValue;
            String loginValue;
            Objects.requireNonNull(instance, "instance");
            Integer idValue = instance.id();
            if (idValue != null) {
                this.id(idValue);
            }
            if ((loginValue = instance.login()) != null) {
                this.login(loginValue);
            }
            if ((nodeIdValue = instance.nodeId()) != null) {
                this.nodeId(nodeIdValue);
            }
            if ((emailValue = instance.email()) != null) {
                this.email(emailValue);
            }
            if ((roleValue = instance.role()) != null) {
                this.role(roleValue);
            }
            if ((failedReasonValue = instance.failedReason()) != null) {
                this.failedReason(failedReasonValue);
            }
            if ((inviterValue = instance.inviter()) != null) {
                this.inviter(inviterValue);
            }
            if ((teamCountValue = instance.teamCount()) != null) {
                this.teamCount(teamCountValue);
            }
            if ((invitationTeamsUrlValue = instance.invitationTeamsUrl()) != null) {
                this.invitationTeamsUrl(invitationTeamsUrlValue);
            }
            if ((invitationSourceValue = instance.invitationSource()) != null) {
                this.invitationSource(invitationSourceValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(@Nullable Integer id) {
            this.id = id;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder login(@Nullable String login) {
            this.login = login;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder nodeId(@Nullable String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder email(@Nullable String email) {
            this.email = email;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder role(@Nullable String role) {
            this.role = role;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder failedReason(@Nullable String failedReason) {
            this.failedReason = failedReason;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder inviter(@Nullable User inviter) {
            this.inviter = inviter;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder teamCount(@Nullable Integer teamCount) {
            this.teamCount = teamCount;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder invitationTeamsUrl(@Nullable URI invitationTeamsUrl) {
            this.invitationTeamsUrl = invitationTeamsUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder invitationSource(@Nullable String invitationSource) {
            this.invitationSource = invitationSource;
            return this;
        }

        public ImmutableTeamInvitation build() {
            return new ImmutableTeamInvitation(this.id, this.login, this.nodeId, this.email, this.role, this.failedReason, this.inviter, this.teamCount, this.invitationTeamsUrl, this.invitationSource);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TeamInvitation", generator="Immutables")
    static final class Json
    implements TeamInvitation {
        @Nullable
        Integer id;
        @Nullable
        String login;
        @Nullable
        String nodeId;
        @Nullable
        String email;
        @Nullable
        String role;
        @Nullable
        String failedReason;
        @Nullable
        User inviter;
        @Nullable
        Integer teamCount;
        @Nullable
        URI invitationTeamsUrl;
        @Nullable
        String invitationSource;

        Json() {
        }

        @JsonProperty
        public void setId(@Nullable Integer id) {
            this.id = id;
        }

        @JsonProperty
        public void setLogin(@Nullable String login) {
            this.login = login;
        }

        @JsonProperty
        public void setNodeId(@Nullable String nodeId) {
            this.nodeId = nodeId;
        }

        @JsonProperty
        public void setEmail(@Nullable String email) {
            this.email = email;
        }

        @JsonProperty
        public void setRole(@Nullable String role) {
            this.role = role;
        }

        @JsonProperty
        public void setFailedReason(@Nullable String failedReason) {
            this.failedReason = failedReason;
        }

        @JsonProperty
        public void setInviter(@Nullable User inviter) {
            this.inviter = inviter;
        }

        @JsonProperty
        public void setTeamCount(@Nullable Integer teamCount) {
            this.teamCount = teamCount;
        }

        @JsonProperty
        public void setInvitationTeamsUrl(@Nullable URI invitationTeamsUrl) {
            this.invitationTeamsUrl = invitationTeamsUrl;
        }

        @JsonProperty
        public void setInvitationSource(@Nullable String invitationSource) {
            this.invitationSource = invitationSource;
        }

        @Override
        public Integer id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String login() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String nodeId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String email() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String role() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String failedReason() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User inviter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer teamCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI invitationTeamsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String invitationSource() {
            throw new UnsupportedOperationException();
        }
    }
}

