package com.spotify.github;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CloseTracking}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCloseTracking.builder()}.
 */
@Generated(from = "CloseTracking", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCloseTracking implements CloseTracking {
  private final @Nullable GitHubInstant createdAt;
  private final @Nullable GitHubInstant updatedAt;
  private final @Nullable GitHubInstant closedAt;

  private ImmutableCloseTracking(
      @Nullable GitHubInstant createdAt,
      @Nullable GitHubInstant updatedAt,
      @Nullable GitHubInstant closedAt) {
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.closedAt = closedAt;
  }

  /**
   * Created date
   * @return The date when the issue was created
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant createdAt() {
    return createdAt;
  }

  /**
   * Updated date
   * @return The date when the issue was updated
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant updatedAt() {
    return updatedAt;
  }

  /**
   * Closed date.
   * @return The date when the issue was closed
   */
  @JsonProperty
  @Override
  public Optional<GitHubInstant> closedAt() {
    return Optional.ofNullable(closedAt);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CloseTracking#createdAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCloseTracking withCreatedAt(@Nullable GitHubInstant value) {
    if (this.createdAt == value) return this;
    return new ImmutableCloseTracking(value, this.updatedAt, this.closedAt);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CloseTracking#updatedAt() updatedAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCloseTracking withUpdatedAt(@Nullable GitHubInstant value) {
    if (this.updatedAt == value) return this;
    return new ImmutableCloseTracking(this.createdAt, value, this.closedAt);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CloseTracking#closedAt() closedAt} attribute.
   * @param value The value for closedAt
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCloseTracking withClosedAt(GitHubInstant value) {
    GitHubInstant newValue = Objects.requireNonNull(value, "closedAt");
    if (this.closedAt == newValue) return this;
    return new ImmutableCloseTracking(this.createdAt, this.updatedAt, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CloseTracking#closedAt() closedAt} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for closedAt
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableCloseTracking withClosedAt(Optional<? extends GitHubInstant> optional) {
    @Nullable GitHubInstant value = optional.orElse(null);
    if (this.closedAt == value) return this;
    return new ImmutableCloseTracking(this.createdAt, this.updatedAt, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCloseTracking} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCloseTracking
        && equalTo(0, (ImmutableCloseTracking) another);
  }

  private boolean equalTo(int synthetic, ImmutableCloseTracking another) {
    return Objects.equals(createdAt, another.createdAt)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(closedAt, another.closedAt);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code updatedAt}, {@code closedAt}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(closedAt);
    return h;
  }

  /**
   * Prints the immutable value {@code CloseTracking} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("CloseTracking{");
    if (createdAt != null) {
      builder.append("createdAt=").append(createdAt);
    }
    if (updatedAt != null) {
      if (builder.length() > 14) builder.append(", ");
      builder.append("updatedAt=").append(updatedAt);
    }
    if (closedAt != null) {
      if (builder.length() > 14) builder.append(", ");
      builder.append("closedAt=").append(closedAt);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CloseTracking", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CloseTracking {
    @Nullable GitHubInstant createdAt;
    @Nullable GitHubInstant updatedAt;
    @Nullable Optional<GitHubInstant> closedAt = Optional.empty();
    @JsonProperty
    public void setCreatedAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty
    public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty
    public void setClosedAt(Optional<GitHubInstant> closedAt) {
      this.closedAt = closedAt;
    }
    @Override
    public GitHubInstant createdAt() { throw new UnsupportedOperationException(); }
    @Override
    public GitHubInstant updatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<GitHubInstant> closedAt() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCloseTracking fromJson(Json json) {
    ImmutableCloseTracking.Builder builder = ImmutableCloseTracking.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.closedAt != null) {
      builder.closedAt(json.closedAt);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CloseTracking} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CloseTracking instance
   */
  public static ImmutableCloseTracking copyOf(CloseTracking instance) {
    if (instance instanceof ImmutableCloseTracking) {
      return (ImmutableCloseTracking) instance;
    }
    return ImmutableCloseTracking.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCloseTracking ImmutableCloseTracking}.
   * <pre>
   * ImmutableCloseTracking.builder()
   *    .createdAt(com.spotify.github.GitHubInstant | null) // nullable {@link CloseTracking#createdAt() createdAt}
   *    .updatedAt(com.spotify.github.GitHubInstant | null) // nullable {@link CloseTracking#updatedAt() updatedAt}
   *    .closedAt(com.spotify.github.GitHubInstant) // optional {@link CloseTracking#closedAt() closedAt}
   *    .build();
   * </pre>
   * @return A new ImmutableCloseTracking builder
   */
  public static ImmutableCloseTracking.Builder builder() {
    return new ImmutableCloseTracking.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCloseTracking ImmutableCloseTracking}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CloseTracking", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable GitHubInstant createdAt;
    private @Nullable GitHubInstant updatedAt;
    private @Nullable GitHubInstant closedAt;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.CloseTracking} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CloseTracking instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.UpdateTracking} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateTracking instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof CloseTracking) {
        CloseTracking instance = (CloseTracking) object;
        Optional<GitHubInstant> closedAtOptional = instance.closedAt();
        if (closedAtOptional.isPresent()) {
          closedAt(closedAtOptional);
        }
        if ((bits & 0x1L) == 0) {
          @Nullable GitHubInstant createdAtValue = instance.createdAt();
          if (createdAtValue != null) {
            createdAt(createdAtValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable GitHubInstant updatedAtValue = instance.updatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x2L;
        }
      }
      if (object instanceof UpdateTracking) {
        UpdateTracking instance = (UpdateTracking) object;
        if ((bits & 0x1L) == 0) {
          @Nullable GitHubInstant createdAtValue = instance.createdAt();
          if (createdAtValue != null) {
            createdAt(createdAtValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable GitHubInstant updatedAtValue = instance.updatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link CloseTracking#createdAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder createdAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link CloseTracking#updatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the optional value {@link CloseTracking#closedAt() closedAt} to closedAt.
     * @param closedAt The value for closedAt
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder closedAt(GitHubInstant closedAt) {
      this.closedAt = Objects.requireNonNull(closedAt, "closedAt");
      return this;
    }

    /**
     * Initializes the optional value {@link CloseTracking#closedAt() closedAt} to closedAt.
     * @param closedAt The value for closedAt
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder closedAt(Optional<? extends GitHubInstant> closedAt) {
      this.closedAt = closedAt.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCloseTracking ImmutableCloseTracking}.
     * @return An immutable instance of CloseTracking
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCloseTracking build() {
      return new ImmutableCloseTracking(createdAt, updatedAt, closedAt);
    }
  }
}
