package com.spotify.github.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.CloseTracking;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Milestone}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMilestone.builder()}.
 */
@Generated(from = "Milestone", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableMilestone implements Milestone {
  private final @Nullable GitHubInstant createdAt;
  private final @Nullable GitHubInstant updatedAt;
  private final @Nullable GitHubInstant closedAt;
  private final @Nullable URI url;
  private final @Nullable URI htmlUrl;
  private final @Nullable URI labelsUrl;
  private final @Nullable Integer id;
  private final @Nullable Integer number;
  private final @Nullable String state;
  private final @Nullable String title;
  private final @Nullable String description;
  private final @Nullable User creator;
  private final @Nullable Integer openIssues;
  private final @Nullable Integer closedIssues;
  private final @Nullable GitHubInstant dueOn;

  private ImmutableMilestone(
      @Nullable GitHubInstant createdAt,
      @Nullable GitHubInstant updatedAt,
      @Nullable GitHubInstant closedAt,
      @Nullable URI url,
      @Nullable URI htmlUrl,
      @Nullable URI labelsUrl,
      @Nullable Integer id,
      @Nullable Integer number,
      @Nullable String state,
      @Nullable String title,
      @Nullable String description,
      @Nullable User creator,
      @Nullable Integer openIssues,
      @Nullable Integer closedIssues,
      @Nullable GitHubInstant dueOn) {
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.closedAt = closedAt;
    this.url = url;
    this.htmlUrl = htmlUrl;
    this.labelsUrl = labelsUrl;
    this.id = id;
    this.number = number;
    this.state = state;
    this.title = title;
    this.description = description;
    this.creator = creator;
    this.openIssues = openIssues;
    this.closedIssues = closedIssues;
    this.dueOn = dueOn;
  }

  /**
   * Created date
   * @return The date when the issue was created
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant createdAt() {
    return createdAt;
  }

  /**
   * Updated date
   * @return The date when the issue was updated
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant updatedAt() {
    return updatedAt;
  }

  /**
   * Closed date.
   * @return The date when the issue was closed
   */
  @JsonProperty
  @Override
  public Optional<GitHubInstant> closedAt() {
    return Optional.ofNullable(closedAt);
  }

  /**
   *URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *HTML URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI htmlUrl() {
    return htmlUrl;
  }

  /**
   *Labels URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI labelsUrl() {
    return labelsUrl;
  }

  /**
   *ID 
   */
  @JsonProperty
  @Override
  public @Nullable Integer id() {
    return id;
  }

  /**
   *Number 
   */
  @JsonProperty
  @Override
  public @Nullable Integer number() {
    return number;
  }

  /**
   *The state of the milestone. Either open, closed, or all. 
   */
  @JsonProperty
  @Override
  public @Nullable String state() {
    return state;
  }

  /**
   *Title 
   */
  @JsonProperty
  @Override
  public @Nullable String title() {
    return title;
  }

  /**
   *Description 
   */
  @JsonProperty
  @Override
  public Optional<String> description() {
    return Optional.ofNullable(description);
  }

  /**
   *Creator user 
   */
  @JsonProperty
  @Override
  public @Nullable User creator() {
    return creator;
  }

  /**
   *Number of open issues 
   */
  @JsonProperty
  @Override
  public @Nullable Integer openIssues() {
    return openIssues;
  }

  /**
   *Number of closed issues 
   */
  @JsonProperty
  @Override
  public @Nullable Integer closedIssues() {
    return closedIssues;
  }

  /**
   *Due date 
   */
  @JsonProperty
  @Override
  public Optional<GitHubInstant> dueOn() {
    return Optional.ofNullable(dueOn);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Milestone#createdAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMilestone withCreatedAt(@Nullable GitHubInstant value) {
    if (this.createdAt == value) return this;
    return new ImmutableMilestone(
        value,
        this.updatedAt,
        this.closedAt,
        this.url,
        this.htmlUrl,
        this.labelsUrl,
        this.id,
        this.number,
        this.state,
        this.title,
        this.description,
        this.creator,
        this.openIssues,
        this.closedIssues,
        this.dueOn);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Milestone#updatedAt() updatedAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMilestone withUpdatedAt(@Nullable GitHubInstant value) {
    if (this.updatedAt == value) return this;
    return new ImmutableMilestone(
        this.createdAt,
        value,
        this.closedAt,
        this.url,
        this.htmlUrl,
        this.labelsUrl,
        this.id,
        this.number,
        this.state,
        this.title,
        this.description,
        this.creator,
        this.openIssues,
        this.closedIssues,
        this.dueOn);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Milestone#closedAt() closedAt} attribute.
   * @param value The value for closedAt
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMilestone withClosedAt(GitHubInstant value) {
    GitHubInstant newValue = Objects.requireNonNull(value, "closedAt");
    if (this.closedAt == newValue) return this;
    return new ImmutableMilestone(
        this.createdAt,
        this.updatedAt,
        newValue,
        this.url,
        this.htmlUrl,
        this.labelsUrl,
        this.id,
        this.number,
        this.state,
        this.title,
        this.description,
        this.creator,
        this.openIssues,
        this.closedIssues,
        this.dueOn);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Milestone#closedAt() closedAt} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for closedAt
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableMilestone withClosedAt(Optional<? extends GitHubInstant> optional) {
    @Nullable GitHubInstant value = optional.orElse(null);
    if (this.closedAt == value) return this;
    return new ImmutableMilestone(
        this.createdAt,
        this.updatedAt,
        value,
        this.url,
        this.htmlUrl,
        this.labelsUrl,
        this.id,
        this.number,
        this.state,
        this.title,
        this.description,
        this.creator,
        this.openIssues,
        this.closedIssues,
        this.dueOn);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Milestone#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMilestone withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableMilestone(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        value,
        this.htmlUrl,
        this.labelsUrl,
        this.id,
        this.number,
        this.state,
        this.title,
        this.description,
        this.creator,
        this.openIssues,
        this.closedIssues,
        this.dueOn);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Milestone#htmlUrl() htmlUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for htmlUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMilestone withHtmlUrl(@Nullable URI value) {
    if (this.htmlUrl == value) return this;
    return new ImmutableMilestone(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.url,
        value,
        this.labelsUrl,
        this.id,
        this.number,
        this.state,
        this.title,
        this.description,
        this.creator,
        this.openIssues,
        this.closedIssues,
        this.dueOn);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Milestone#labelsUrl() labelsUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for labelsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMilestone withLabelsUrl(@Nullable URI value) {
    if (this.labelsUrl == value) return this;
    return new ImmutableMilestone(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.url,
        this.htmlUrl,
        value,
        this.id,
        this.number,
        this.state,
        this.title,
        this.description,
        this.creator,
        this.openIssues,
        this.closedIssues,
        this.dueOn);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Milestone#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMilestone withId(@Nullable Integer value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableMilestone(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.url,
        this.htmlUrl,
        this.labelsUrl,
        value,
        this.number,
        this.state,
        this.title,
        this.description,
        this.creator,
        this.openIssues,
        this.closedIssues,
        this.dueOn);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Milestone#number() number} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for number (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMilestone withNumber(@Nullable Integer value) {
    if (Objects.equals(this.number, value)) return this;
    return new ImmutableMilestone(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.url,
        this.htmlUrl,
        this.labelsUrl,
        this.id,
        value,
        this.state,
        this.title,
        this.description,
        this.creator,
        this.openIssues,
        this.closedIssues,
        this.dueOn);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Milestone#state() state} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for state (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMilestone withState(@Nullable String value) {
    if (Objects.equals(this.state, value)) return this;
    return new ImmutableMilestone(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.url,
        this.htmlUrl,
        this.labelsUrl,
        this.id,
        this.number,
        value,
        this.title,
        this.description,
        this.creator,
        this.openIssues,
        this.closedIssues,
        this.dueOn);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Milestone#title() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for title (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMilestone withTitle(@Nullable String value) {
    if (Objects.equals(this.title, value)) return this;
    return new ImmutableMilestone(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.url,
        this.htmlUrl,
        this.labelsUrl,
        this.id,
        this.number,
        this.state,
        value,
        this.description,
        this.creator,
        this.openIssues,
        this.closedIssues,
        this.dueOn);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Milestone#description() description} attribute.
   * @param value The value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMilestone withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (Objects.equals(this.description, newValue)) return this;
    return new ImmutableMilestone(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.url,
        this.htmlUrl,
        this.labelsUrl,
        this.id,
        this.number,
        this.state,
        this.title,
        newValue,
        this.creator,
        this.openIssues,
        this.closedIssues,
        this.dueOn);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Milestone#description() description} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMilestone withDescription(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableMilestone(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.url,
        this.htmlUrl,
        this.labelsUrl,
        this.id,
        this.number,
        this.state,
        this.title,
        value,
        this.creator,
        this.openIssues,
        this.closedIssues,
        this.dueOn);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Milestone#creator() creator} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for creator (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMilestone withCreator(@Nullable User value) {
    if (this.creator == value) return this;
    return new ImmutableMilestone(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.url,
        this.htmlUrl,
        this.labelsUrl,
        this.id,
        this.number,
        this.state,
        this.title,
        this.description,
        value,
        this.openIssues,
        this.closedIssues,
        this.dueOn);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Milestone#openIssues() openIssues} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for openIssues (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMilestone withOpenIssues(@Nullable Integer value) {
    if (Objects.equals(this.openIssues, value)) return this;
    return new ImmutableMilestone(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.url,
        this.htmlUrl,
        this.labelsUrl,
        this.id,
        this.number,
        this.state,
        this.title,
        this.description,
        this.creator,
        value,
        this.closedIssues,
        this.dueOn);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Milestone#closedIssues() closedIssues} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for closedIssues (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMilestone withClosedIssues(@Nullable Integer value) {
    if (Objects.equals(this.closedIssues, value)) return this;
    return new ImmutableMilestone(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.url,
        this.htmlUrl,
        this.labelsUrl,
        this.id,
        this.number,
        this.state,
        this.title,
        this.description,
        this.creator,
        this.openIssues,
        value,
        this.dueOn);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Milestone#dueOn() dueOn} attribute.
   * @param value The value for dueOn
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMilestone withDueOn(GitHubInstant value) {
    GitHubInstant newValue = Objects.requireNonNull(value, "dueOn");
    if (this.dueOn == newValue) return this;
    return new ImmutableMilestone(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.url,
        this.htmlUrl,
        this.labelsUrl,
        this.id,
        this.number,
        this.state,
        this.title,
        this.description,
        this.creator,
        this.openIssues,
        this.closedIssues,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Milestone#dueOn() dueOn} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for dueOn
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableMilestone withDueOn(Optional<? extends GitHubInstant> optional) {
    @Nullable GitHubInstant value = optional.orElse(null);
    if (this.dueOn == value) return this;
    return new ImmutableMilestone(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.url,
        this.htmlUrl,
        this.labelsUrl,
        this.id,
        this.number,
        this.state,
        this.title,
        this.description,
        this.creator,
        this.openIssues,
        this.closedIssues,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMilestone} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMilestone
        && equalTo(0, (ImmutableMilestone) another);
  }

  private boolean equalTo(int synthetic, ImmutableMilestone another) {
    return Objects.equals(createdAt, another.createdAt)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(closedAt, another.closedAt)
        && Objects.equals(url, another.url)
        && Objects.equals(htmlUrl, another.htmlUrl)
        && Objects.equals(labelsUrl, another.labelsUrl)
        && Objects.equals(id, another.id)
        && Objects.equals(number, another.number)
        && Objects.equals(state, another.state)
        && Objects.equals(title, another.title)
        && Objects.equals(description, another.description)
        && Objects.equals(creator, another.creator)
        && Objects.equals(openIssues, another.openIssues)
        && Objects.equals(closedIssues, another.closedIssues)
        && Objects.equals(dueOn, another.dueOn);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code updatedAt}, {@code closedAt}, {@code url}, {@code htmlUrl}, {@code labelsUrl}, {@code id}, {@code number}, {@code state}, {@code title}, {@code description}, {@code creator}, {@code openIssues}, {@code closedIssues}, {@code dueOn}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(closedAt);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(htmlUrl);
    h += (h << 5) + Objects.hashCode(labelsUrl);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(number);
    h += (h << 5) + Objects.hashCode(state);
    h += (h << 5) + Objects.hashCode(title);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(creator);
    h += (h << 5) + Objects.hashCode(openIssues);
    h += (h << 5) + Objects.hashCode(closedIssues);
    h += (h << 5) + Objects.hashCode(dueOn);
    return h;
  }

  /**
   * Prints the immutable value {@code Milestone} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Milestone{");
    if (createdAt != null) {
      builder.append("createdAt=").append(createdAt);
    }
    if (updatedAt != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("updatedAt=").append(updatedAt);
    }
    if (closedAt != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("closedAt=").append(closedAt);
    }
    if (url != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("url=").append(url);
    }
    if (htmlUrl != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("htmlUrl=").append(htmlUrl);
    }
    if (labelsUrl != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("labelsUrl=").append(labelsUrl);
    }
    if (id != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("id=").append(id);
    }
    if (number != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("number=").append(number);
    }
    if (state != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("state=").append(state);
    }
    if (title != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("title=").append(title);
    }
    if (description != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("description=").append(description);
    }
    if (creator != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("creator=").append(creator);
    }
    if (openIssues != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("openIssues=").append(openIssues);
    }
    if (closedIssues != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("closedIssues=").append(closedIssues);
    }
    if (dueOn != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("dueOn=").append(dueOn);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Milestone", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Milestone {
    @Nullable GitHubInstant createdAt;
    @Nullable GitHubInstant updatedAt;
    @Nullable Optional<GitHubInstant> closedAt = Optional.empty();
    @Nullable URI url;
    @Nullable URI htmlUrl;
    @Nullable URI labelsUrl;
    @Nullable Integer id;
    @Nullable Integer number;
    @Nullable String state;
    @Nullable String title;
    @Nullable Optional<String> description = Optional.empty();
    @Nullable User creator;
    @Nullable Integer openIssues;
    @Nullable Integer closedIssues;
    @Nullable Optional<GitHubInstant> dueOn = Optional.empty();
    @JsonProperty
    public void setCreatedAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty
    public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty
    public void setClosedAt(Optional<GitHubInstant> closedAt) {
      this.closedAt = closedAt;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setHtmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
    }
    @JsonProperty
    public void setLabelsUrl(@Nullable URI labelsUrl) {
      this.labelsUrl = labelsUrl;
    }
    @JsonProperty
    public void setId(@Nullable Integer id) {
      this.id = id;
    }
    @JsonProperty
    public void setNumber(@Nullable Integer number) {
      this.number = number;
    }
    @JsonProperty
    public void setState(@Nullable String state) {
      this.state = state;
    }
    @JsonProperty
    public void setTitle(@Nullable String title) {
      this.title = title;
    }
    @JsonProperty
    public void setDescription(Optional<String> description) {
      this.description = description;
    }
    @JsonProperty
    public void setCreator(@Nullable User creator) {
      this.creator = creator;
    }
    @JsonProperty
    public void setOpenIssues(@Nullable Integer openIssues) {
      this.openIssues = openIssues;
    }
    @JsonProperty
    public void setClosedIssues(@Nullable Integer closedIssues) {
      this.closedIssues = closedIssues;
    }
    @JsonProperty
    public void setDueOn(Optional<GitHubInstant> dueOn) {
      this.dueOn = dueOn;
    }
    @Override
    public GitHubInstant createdAt() { throw new UnsupportedOperationException(); }
    @Override
    public GitHubInstant updatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<GitHubInstant> closedAt() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public URI htmlUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI labelsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Integer id() { throw new UnsupportedOperationException(); }
    @Override
    public Integer number() { throw new UnsupportedOperationException(); }
    @Override
    public String state() { throw new UnsupportedOperationException(); }
    @Override
    public String title() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> description() { throw new UnsupportedOperationException(); }
    @Override
    public User creator() { throw new UnsupportedOperationException(); }
    @Override
    public Integer openIssues() { throw new UnsupportedOperationException(); }
    @Override
    public Integer closedIssues() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<GitHubInstant> dueOn() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableMilestone fromJson(Json json) {
    ImmutableMilestone.Builder builder = ImmutableMilestone.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.closedAt != null) {
      builder.closedAt(json.closedAt);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.htmlUrl != null) {
      builder.htmlUrl(json.htmlUrl);
    }
    if (json.labelsUrl != null) {
      builder.labelsUrl(json.labelsUrl);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.number != null) {
      builder.number(json.number);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.title != null) {
      builder.title(json.title);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.creator != null) {
      builder.creator(json.creator);
    }
    if (json.openIssues != null) {
      builder.openIssues(json.openIssues);
    }
    if (json.closedIssues != null) {
      builder.closedIssues(json.closedIssues);
    }
    if (json.dueOn != null) {
      builder.dueOn(json.dueOn);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Milestone} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Milestone instance
   */
  public static ImmutableMilestone copyOf(Milestone instance) {
    if (instance instanceof ImmutableMilestone) {
      return (ImmutableMilestone) instance;
    }
    return ImmutableMilestone.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMilestone ImmutableMilestone}.
   * <pre>
   * ImmutableMilestone.builder()
   *    .createdAt(com.spotify.github.GitHubInstant | null) // nullable {@link Milestone#createdAt() createdAt}
   *    .updatedAt(com.spotify.github.GitHubInstant | null) // nullable {@link Milestone#updatedAt() updatedAt}
   *    .closedAt(com.spotify.github.GitHubInstant) // optional {@link Milestone#closedAt() closedAt}
   *    .url(java.net.URI | null) // nullable {@link Milestone#url() url}
   *    .htmlUrl(java.net.URI | null) // nullable {@link Milestone#htmlUrl() htmlUrl}
   *    .labelsUrl(java.net.URI | null) // nullable {@link Milestone#labelsUrl() labelsUrl}
   *    .id(Integer | null) // nullable {@link Milestone#id() id}
   *    .number(Integer | null) // nullable {@link Milestone#number() number}
   *    .state(String | null) // nullable {@link Milestone#state() state}
   *    .title(String | null) // nullable {@link Milestone#title() title}
   *    .description(String) // optional {@link Milestone#description() description}
   *    .creator(com.spotify.github.v3.User | null) // nullable {@link Milestone#creator() creator}
   *    .openIssues(Integer | null) // nullable {@link Milestone#openIssues() openIssues}
   *    .closedIssues(Integer | null) // nullable {@link Milestone#closedIssues() closedIssues}
   *    .dueOn(com.spotify.github.GitHubInstant) // optional {@link Milestone#dueOn() dueOn}
   *    .build();
   * </pre>
   * @return A new ImmutableMilestone builder
   */
  public static ImmutableMilestone.Builder builder() {
    return new ImmutableMilestone.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMilestone ImmutableMilestone}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Milestone", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable GitHubInstant createdAt;
    private @Nullable GitHubInstant updatedAt;
    private @Nullable GitHubInstant closedAt;
    private @Nullable URI url;
    private @Nullable URI htmlUrl;
    private @Nullable URI labelsUrl;
    private @Nullable Integer id;
    private @Nullable Integer number;
    private @Nullable String state;
    private @Nullable String title;
    private @Nullable String description;
    private @Nullable User creator;
    private @Nullable Integer openIssues;
    private @Nullable Integer closedIssues;
    private @Nullable GitHubInstant dueOn;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.Milestone} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Milestone instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.CloseTracking} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CloseTracking instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.UpdateTracking} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateTracking instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof Milestone) {
        Milestone instance = (Milestone) object;
        @Nullable Integer closedIssuesValue = instance.closedIssues();
        if (closedIssuesValue != null) {
          closedIssues(closedIssuesValue);
        }
        @Nullable User creatorValue = instance.creator();
        if (creatorValue != null) {
          creator(creatorValue);
        }
        @Nullable URI labelsUrlValue = instance.labelsUrl();
        if (labelsUrlValue != null) {
          labelsUrl(labelsUrlValue);
        }
        Optional<GitHubInstant> dueOnOptional = instance.dueOn();
        if (dueOnOptional.isPresent()) {
          dueOn(dueOnOptional);
        }
        @Nullable URI htmlUrlValue = instance.htmlUrl();
        if (htmlUrlValue != null) {
          htmlUrl(htmlUrlValue);
        }
        Optional<String> descriptionOptional = instance.description();
        if (descriptionOptional.isPresent()) {
          description(descriptionOptional);
        }
        @Nullable String titleValue = instance.title();
        if (titleValue != null) {
          title(titleValue);
        }
        @Nullable Integer openIssuesValue = instance.openIssues();
        if (openIssuesValue != null) {
          openIssues(openIssuesValue);
        }
        @Nullable URI urlValue = instance.url();
        if (urlValue != null) {
          url(urlValue);
        }
        if ((bits & 0x1L) == 0) {
          @Nullable GitHubInstant createdAtValue = instance.createdAt();
          if (createdAtValue != null) {
            createdAt(createdAtValue);
          }
          bits |= 0x1L;
        }
        @Nullable Integer numberValue = instance.number();
        if (numberValue != null) {
          number(numberValue);
        }
        @Nullable Integer idValue = instance.id();
        if (idValue != null) {
          id(idValue);
        }
        @Nullable String stateValue = instance.state();
        if (stateValue != null) {
          state(stateValue);
        }
        if ((bits & 0x2L) == 0) {
          Optional<GitHubInstant> closedAtOptional = instance.closedAt();
          if (closedAtOptional.isPresent()) {
            closedAt(closedAtOptional);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          @Nullable GitHubInstant updatedAtValue = instance.updatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x4L;
        }
      }
      if (object instanceof CloseTracking) {
        CloseTracking instance = (CloseTracking) object;
        if ((bits & 0x2L) == 0) {
          Optional<GitHubInstant> closedAtOptional = instance.closedAt();
          if (closedAtOptional.isPresent()) {
            closedAt(closedAtOptional);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          @Nullable GitHubInstant createdAtValue = instance.createdAt();
          if (createdAtValue != null) {
            createdAt(createdAtValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          @Nullable GitHubInstant updatedAtValue = instance.updatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x4L;
        }
      }
      if (object instanceof UpdateTracking) {
        UpdateTracking instance = (UpdateTracking) object;
        if ((bits & 0x1L) == 0) {
          @Nullable GitHubInstant createdAtValue = instance.createdAt();
          if (createdAtValue != null) {
            createdAt(createdAtValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          @Nullable GitHubInstant updatedAtValue = instance.updatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x4L;
        }
      }
    }

    /**
     * Initializes the value for the {@link Milestone#createdAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder createdAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link Milestone#updatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the optional value {@link Milestone#closedAt() closedAt} to closedAt.
     * @param closedAt The value for closedAt
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder closedAt(GitHubInstant closedAt) {
      this.closedAt = Objects.requireNonNull(closedAt, "closedAt");
      return this;
    }

    /**
     * Initializes the optional value {@link Milestone#closedAt() closedAt} to closedAt.
     * @param closedAt The value for closedAt
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder closedAt(Optional<? extends GitHubInstant> closedAt) {
      this.closedAt = closedAt.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link Milestone#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link Milestone#htmlUrl() htmlUrl} attribute.
     * @param htmlUrl The value for htmlUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder htmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link Milestone#labelsUrl() labelsUrl} attribute.
     * @param labelsUrl The value for labelsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder labelsUrl(@Nullable URI labelsUrl) {
      this.labelsUrl = labelsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link Milestone#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(@Nullable Integer id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Milestone#number() number} attribute.
     * @param number The value for number (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder number(@Nullable Integer number) {
      this.number = number;
      return this;
    }

    /**
     * Initializes the value for the {@link Milestone#state() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the value for the {@link Milestone#title() title} attribute.
     * @param title The value for title (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder title(@Nullable String title) {
      this.title = title;
      return this;
    }

    /**
     * Initializes the optional value {@link Milestone#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      return this;
    }

    /**
     * Initializes the optional value {@link Milestone#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder description(Optional<String> description) {
      this.description = description.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link Milestone#creator() creator} attribute.
     * @param creator The value for creator (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder creator(@Nullable User creator) {
      this.creator = creator;
      return this;
    }

    /**
     * Initializes the value for the {@link Milestone#openIssues() openIssues} attribute.
     * @param openIssues The value for openIssues (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder openIssues(@Nullable Integer openIssues) {
      this.openIssues = openIssues;
      return this;
    }

    /**
     * Initializes the value for the {@link Milestone#closedIssues() closedIssues} attribute.
     * @param closedIssues The value for closedIssues (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder closedIssues(@Nullable Integer closedIssues) {
      this.closedIssues = closedIssues;
      return this;
    }

    /**
     * Initializes the optional value {@link Milestone#dueOn() dueOn} to dueOn.
     * @param dueOn The value for dueOn
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder dueOn(GitHubInstant dueOn) {
      this.dueOn = Objects.requireNonNull(dueOn, "dueOn");
      return this;
    }

    /**
     * Initializes the optional value {@link Milestone#dueOn() dueOn} to dueOn.
     * @param dueOn The value for dueOn
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder dueOn(Optional<? extends GitHubInstant> dueOn) {
      this.dueOn = dueOn.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableMilestone ImmutableMilestone}.
     * @return An immutable instance of Milestone
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMilestone build() {
      return new ImmutableMilestone(
          createdAt,
          updatedAt,
          closedAt,
          url,
          htmlUrl,
          labelsUrl,
          id,
          number,
          state,
          title,
          description,
          creator,
          openIssues,
          closedIssues,
          dueOn);
    }
  }
}
