package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.User;
import com.spotify.github.v3.checks.CheckRunResponse;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CheckRunEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCheckRunEvent.builder()}.
 */
@Generated(from = "CheckRunEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCheckRunEvent implements CheckRunEvent {
  private final @Nullable Repository repository;
  private final @Nullable User sender;
  private final @Nullable EventInstallation eventInstallation;
  private final @Nullable GitHubInstant createdAt;
  private final @Nullable GitHubInstant updatedAt;
  private final @Nullable String action;
  private final @Nullable CheckRunResponse checkRun;

  private ImmutableCheckRunEvent(
      @Nullable Repository repository,
      @Nullable User sender,
      @Nullable EventInstallation eventInstallation,
      @Nullable GitHubInstant createdAt,
      @Nullable GitHubInstant updatedAt,
      @Nullable String action,
      @Nullable CheckRunResponse checkRun) {
    this.repository = repository;
    this.sender = sender;
    this.eventInstallation = eventInstallation;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.action = action;
    this.checkRun = checkRun;
  }

  /**
   *The {@link Repository} 
   */
  @JsonProperty
  @Override
  public @Nullable Repository repository() {
    return repository;
  }

  /**
   *The {@link User} that triggered/sent the event. 
   */
  @JsonProperty
  @Override
  public @Nullable User sender() {
    return sender;
  }

  /**
   *The {@link EventInstallation}, if the event comes from a Github App. 
   */
  @JsonProperty("installation")
  @Override
  public @Nullable EventInstallation eventInstallation() {
    return eventInstallation;
  }

  /**
   * Created date
   * @return The date when the issue was created
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant createdAt() {
    return createdAt;
  }

  /**
   * Updated date
   * @return The date when the issue was updated
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant updatedAt() {
    return updatedAt;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @JsonProperty
  @Override
  public @Nullable String action() {
    return action;
  }

  /**
   * @return The value of the {@code checkRun} attribute
   */
  @JsonProperty
  @Override
  public @Nullable CheckRunResponse checkRun() {
    return checkRun;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunEvent#repository() repository} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repository (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunEvent withRepository(@Nullable Repository value) {
    if (this.repository == value) return this;
    return new ImmutableCheckRunEvent(
        value,
        this.sender,
        this.eventInstallation,
        this.createdAt,
        this.updatedAt,
        this.action,
        this.checkRun);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunEvent#sender() sender} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sender (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunEvent withSender(@Nullable User value) {
    if (this.sender == value) return this;
    return new ImmutableCheckRunEvent(
        this.repository,
        value,
        this.eventInstallation,
        this.createdAt,
        this.updatedAt,
        this.action,
        this.checkRun);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunEvent#eventInstallation() eventInstallation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventInstallation (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunEvent withEventInstallation(@Nullable EventInstallation value) {
    if (this.eventInstallation == value) return this;
    return new ImmutableCheckRunEvent(this.repository, this.sender, value, this.createdAt, this.updatedAt, this.action, this.checkRun);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunEvent#createdAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunEvent withCreatedAt(@Nullable GitHubInstant value) {
    if (this.createdAt == value) return this;
    return new ImmutableCheckRunEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        value,
        this.updatedAt,
        this.action,
        this.checkRun);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunEvent#updatedAt() updatedAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunEvent withUpdatedAt(@Nullable GitHubInstant value) {
    if (this.updatedAt == value) return this;
    return new ImmutableCheckRunEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.createdAt,
        value,
        this.action,
        this.checkRun);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunEvent#action() action} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunEvent withAction(@Nullable String value) {
    if (Objects.equals(this.action, value)) return this;
    return new ImmutableCheckRunEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.createdAt,
        this.updatedAt,
        value,
        this.checkRun);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunEvent#checkRun() checkRun} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for checkRun (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunEvent withCheckRun(@Nullable CheckRunResponse value) {
    if (this.checkRun == value) return this;
    return new ImmutableCheckRunEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.createdAt,
        this.updatedAt,
        this.action,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCheckRunEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCheckRunEvent
        && equalTo(0, (ImmutableCheckRunEvent) another);
  }

  private boolean equalTo(int synthetic, ImmutableCheckRunEvent another) {
    return Objects.equals(repository, another.repository)
        && Objects.equals(sender, another.sender)
        && Objects.equals(eventInstallation, another.eventInstallation)
        && Objects.equals(createdAt, another.createdAt)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(action, another.action)
        && Objects.equals(checkRun, another.checkRun);
  }

  /**
   * Computes a hash code from attributes: {@code repository}, {@code sender}, {@code eventInstallation}, {@code createdAt}, {@code updatedAt}, {@code action}, {@code checkRun}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(repository);
    h += (h << 5) + Objects.hashCode(sender);
    h += (h << 5) + Objects.hashCode(eventInstallation);
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(checkRun);
    return h;
  }

  /**
   * Prints the immutable value {@code CheckRunEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CheckRunEvent{"
        + "repository=" + repository
        + ", sender=" + sender
        + ", eventInstallation=" + eventInstallation
        + ", createdAt=" + createdAt
        + ", updatedAt=" + updatedAt
        + ", action=" + action
        + ", checkRun=" + checkRun
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CheckRunEvent", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CheckRunEvent {
    @Nullable Repository repository;
    @Nullable User sender;
    @Nullable EventInstallation eventInstallation;
    @Nullable GitHubInstant createdAt;
    @Nullable GitHubInstant updatedAt;
    @Nullable String action;
    @Nullable CheckRunResponse checkRun;
    @JsonProperty
    public void setRepository(@Nullable Repository repository) {
      this.repository = repository;
    }
    @JsonProperty
    public void setSender(@Nullable User sender) {
      this.sender = sender;
    }
    @JsonProperty("installation")
    public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
    }
    @JsonProperty
    public void setCreatedAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty
    public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty
    public void setAction(@Nullable String action) {
      this.action = action;
    }
    @JsonProperty
    public void setCheckRun(@Nullable CheckRunResponse checkRun) {
      this.checkRun = checkRun;
    }
    @Override
    public Repository repository() { throw new UnsupportedOperationException(); }
    @Override
    public User sender() { throw new UnsupportedOperationException(); }
    @Override
    public EventInstallation eventInstallation() { throw new UnsupportedOperationException(); }
    @Override
    public GitHubInstant createdAt() { throw new UnsupportedOperationException(); }
    @Override
    public GitHubInstant updatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String action() { throw new UnsupportedOperationException(); }
    @Override
    public CheckRunResponse checkRun() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCheckRunEvent fromJson(Json json) {
    ImmutableCheckRunEvent.Builder builder = ImmutableCheckRunEvent.builder();
    if (json.repository != null) {
      builder.repository(json.repository);
    }
    if (json.sender != null) {
      builder.sender(json.sender);
    }
    if (json.eventInstallation != null) {
      builder.eventInstallation(json.eventInstallation);
    }
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.action != null) {
      builder.action(json.action);
    }
    if (json.checkRun != null) {
      builder.checkRun(json.checkRun);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CheckRunEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CheckRunEvent instance
   */
  public static ImmutableCheckRunEvent copyOf(CheckRunEvent instance) {
    if (instance instanceof ImmutableCheckRunEvent) {
      return (ImmutableCheckRunEvent) instance;
    }
    return ImmutableCheckRunEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCheckRunEvent ImmutableCheckRunEvent}.
   * <pre>
   * ImmutableCheckRunEvent.builder()
   *    .repository(com.spotify.github.v3.repos.Repository | null) // nullable {@link CheckRunEvent#repository() repository}
   *    .sender(com.spotify.github.v3.User | null) // nullable {@link CheckRunEvent#sender() sender}
   *    .eventInstallation(com.spotify.github.v3.activity.events.EventInstallation | null) // nullable {@link CheckRunEvent#eventInstallation() eventInstallation}
   *    .createdAt(com.spotify.github.GitHubInstant | null) // nullable {@link CheckRunEvent#createdAt() createdAt}
   *    .updatedAt(com.spotify.github.GitHubInstant | null) // nullable {@link CheckRunEvent#updatedAt() updatedAt}
   *    .action(String | null) // nullable {@link CheckRunEvent#action() action}
   *    .checkRun(com.spotify.github.v3.checks.CheckRunResponse | null) // nullable {@link CheckRunEvent#checkRun() checkRun}
   *    .build();
   * </pre>
   * @return A new ImmutableCheckRunEvent builder
   */
  public static ImmutableCheckRunEvent.Builder builder() {
    return new ImmutableCheckRunEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCheckRunEvent ImmutableCheckRunEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CheckRunEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Repository repository;
    private @Nullable User sender;
    private @Nullable EventInstallation eventInstallation;
    private @Nullable GitHubInstant createdAt;
    private @Nullable GitHubInstant updatedAt;
    private @Nullable String action;
    private @Nullable CheckRunResponse checkRun;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.CheckRunEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CheckRunEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.BaseEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BaseEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.UpdateTracking} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateTracking instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof CheckRunEvent) {
        CheckRunEvent instance = (CheckRunEvent) object;
        if ((bits & 0x1L) == 0) {
          @Nullable GitHubInstant createdAtValue = instance.createdAt();
          if (createdAtValue != null) {
            createdAt(createdAtValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable EventInstallation eventInstallationValue = instance.eventInstallation();
          if (eventInstallationValue != null) {
            eventInstallation(eventInstallationValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          @Nullable User senderValue = instance.sender();
          if (senderValue != null) {
            sender(senderValue);
          }
          bits |= 0x4L;
        }
        @Nullable String actionValue = instance.action();
        if (actionValue != null) {
          action(actionValue);
        }
        @Nullable CheckRunResponse checkRunValue = instance.checkRun();
        if (checkRunValue != null) {
          checkRun(checkRunValue);
        }
        if ((bits & 0x8L) == 0) {
          @Nullable Repository repositoryValue = instance.repository();
          if (repositoryValue != null) {
            repository(repositoryValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          @Nullable GitHubInstant updatedAtValue = instance.updatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x10L;
        }
      }
      if (object instanceof BaseEvent) {
        BaseEvent instance = (BaseEvent) object;
        if ((bits & 0x8L) == 0) {
          @Nullable Repository repositoryValue = instance.repository();
          if (repositoryValue != null) {
            repository(repositoryValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x4L) == 0) {
          @Nullable User senderValue = instance.sender();
          if (senderValue != null) {
            sender(senderValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable EventInstallation eventInstallationValue = instance.eventInstallation();
          if (eventInstallationValue != null) {
            eventInstallation(eventInstallationValue);
          }
          bits |= 0x2L;
        }
      }
      if (object instanceof UpdateTracking) {
        UpdateTracking instance = (UpdateTracking) object;
        if ((bits & 0x1L) == 0) {
          @Nullable GitHubInstant createdAtValue = instance.createdAt();
          if (createdAtValue != null) {
            createdAt(createdAtValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x10L) == 0) {
          @Nullable GitHubInstant updatedAtValue = instance.updatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x10L;
        }
      }
    }

    /**
     * Initializes the value for the {@link CheckRunEvent#repository() repository} attribute.
     * @param repository The value for repository (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repository(@Nullable Repository repository) {
      this.repository = repository;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRunEvent#sender() sender} attribute.
     * @param sender The value for sender (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sender(@Nullable User sender) {
      this.sender = sender;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRunEvent#eventInstallation() eventInstallation} attribute.
     * @param eventInstallation The value for eventInstallation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("installation")
    public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRunEvent#createdAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder createdAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRunEvent#updatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRunEvent#action() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder action(@Nullable String action) {
      this.action = action;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRunEvent#checkRun() checkRun} attribute.
     * @param checkRun The value for checkRun (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder checkRun(@Nullable CheckRunResponse checkRun) {
      this.checkRun = checkRun;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCheckRunEvent ImmutableCheckRunEvent}.
     * @return An immutable instance of CheckRunEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCheckRunEvent build() {
      return new ImmutableCheckRunEvent(repository, sender, eventInstallation, createdAt, updatedAt, action, checkRun);
    }
  }
}
