package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.User;
import com.spotify.github.v3.repos.Deployment;
import com.spotify.github.v3.repos.Repository;
import com.spotify.github.v3.repos.Status;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DeploymentStatusEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDeploymentStatusEvent.builder()}.
 */
@Generated(from = "DeploymentStatusEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDeploymentStatusEvent
    implements DeploymentStatusEvent {
  private final @Nullable Repository repository;
  private final @Nullable User sender;
  private final @Nullable EventInstallation eventInstallation;
  private final @Nullable Status deploymentStatus;
  private final @Nullable Deployment deployment;

  private ImmutableDeploymentStatusEvent(
      @Nullable Repository repository,
      @Nullable User sender,
      @Nullable EventInstallation eventInstallation,
      @Nullable Status deploymentStatus,
      @Nullable Deployment deployment) {
    this.repository = repository;
    this.sender = sender;
    this.eventInstallation = eventInstallation;
    this.deploymentStatus = deploymentStatus;
    this.deployment = deployment;
  }

  /**
   *The {@link Repository} 
   */
  @JsonProperty
  @Override
  public @Nullable Repository repository() {
    return repository;
  }

  /**
   *The {@link User} that triggered/sent the event. 
   */
  @JsonProperty
  @Override
  public @Nullable User sender() {
    return sender;
  }

  /**
   *The {@link EventInstallation}, if the event comes from a Github App. 
   */
  @JsonProperty("installation")
  @Override
  public @Nullable EventInstallation eventInstallation() {
    return eventInstallation;
  }

  /**
   *The deployment status. 
   */
  @JsonProperty
  @Override
  public @Nullable Status deploymentStatus() {
    return deploymentStatus;
  }

  /**
   *Deployment 
   */
  @JsonProperty
  @Override
  public @Nullable Deployment deployment() {
    return deployment;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeploymentStatusEvent#repository() repository} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repository (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeploymentStatusEvent withRepository(@Nullable Repository value) {
    if (this.repository == value) return this;
    return new ImmutableDeploymentStatusEvent(value, this.sender, this.eventInstallation, this.deploymentStatus, this.deployment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeploymentStatusEvent#sender() sender} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sender (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeploymentStatusEvent withSender(@Nullable User value) {
    if (this.sender == value) return this;
    return new ImmutableDeploymentStatusEvent(this.repository, value, this.eventInstallation, this.deploymentStatus, this.deployment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeploymentStatusEvent#eventInstallation() eventInstallation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventInstallation (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeploymentStatusEvent withEventInstallation(@Nullable EventInstallation value) {
    if (this.eventInstallation == value) return this;
    return new ImmutableDeploymentStatusEvent(this.repository, this.sender, value, this.deploymentStatus, this.deployment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeploymentStatusEvent#deploymentStatus() deploymentStatus} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deploymentStatus (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeploymentStatusEvent withDeploymentStatus(@Nullable Status value) {
    if (this.deploymentStatus == value) return this;
    return new ImmutableDeploymentStatusEvent(this.repository, this.sender, this.eventInstallation, value, this.deployment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeploymentStatusEvent#deployment() deployment} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deployment (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeploymentStatusEvent withDeployment(@Nullable Deployment value) {
    if (this.deployment == value) return this;
    return new ImmutableDeploymentStatusEvent(this.repository, this.sender, this.eventInstallation, this.deploymentStatus, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDeploymentStatusEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDeploymentStatusEvent
        && equalTo(0, (ImmutableDeploymentStatusEvent) another);
  }

  private boolean equalTo(int synthetic, ImmutableDeploymentStatusEvent another) {
    return Objects.equals(repository, another.repository)
        && Objects.equals(sender, another.sender)
        && Objects.equals(eventInstallation, another.eventInstallation)
        && Objects.equals(deploymentStatus, another.deploymentStatus)
        && Objects.equals(deployment, another.deployment);
  }

  /**
   * Computes a hash code from attributes: {@code repository}, {@code sender}, {@code eventInstallation}, {@code deploymentStatus}, {@code deployment}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(repository);
    h += (h << 5) + Objects.hashCode(sender);
    h += (h << 5) + Objects.hashCode(eventInstallation);
    h += (h << 5) + Objects.hashCode(deploymentStatus);
    h += (h << 5) + Objects.hashCode(deployment);
    return h;
  }

  /**
   * Prints the immutable value {@code DeploymentStatusEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeploymentStatusEvent{"
        + "repository=" + repository
        + ", sender=" + sender
        + ", eventInstallation=" + eventInstallation
        + ", deploymentStatus=" + deploymentStatus
        + ", deployment=" + deployment
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DeploymentStatusEvent", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DeploymentStatusEvent {
    @Nullable Repository repository;
    @Nullable User sender;
    @Nullable EventInstallation eventInstallation;
    @Nullable Status deploymentStatus;
    @Nullable Deployment deployment;
    @JsonProperty
    public void setRepository(@Nullable Repository repository) {
      this.repository = repository;
    }
    @JsonProperty
    public void setSender(@Nullable User sender) {
      this.sender = sender;
    }
    @JsonProperty("installation")
    public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
    }
    @JsonProperty
    public void setDeploymentStatus(@Nullable Status deploymentStatus) {
      this.deploymentStatus = deploymentStatus;
    }
    @JsonProperty
    public void setDeployment(@Nullable Deployment deployment) {
      this.deployment = deployment;
    }
    @Override
    public Repository repository() { throw new UnsupportedOperationException(); }
    @Override
    public User sender() { throw new UnsupportedOperationException(); }
    @Override
    public EventInstallation eventInstallation() { throw new UnsupportedOperationException(); }
    @Override
    public Status deploymentStatus() { throw new UnsupportedOperationException(); }
    @Override
    public Deployment deployment() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDeploymentStatusEvent fromJson(Json json) {
    ImmutableDeploymentStatusEvent.Builder builder = ImmutableDeploymentStatusEvent.builder();
    if (json.repository != null) {
      builder.repository(json.repository);
    }
    if (json.sender != null) {
      builder.sender(json.sender);
    }
    if (json.eventInstallation != null) {
      builder.eventInstallation(json.eventInstallation);
    }
    if (json.deploymentStatus != null) {
      builder.deploymentStatus(json.deploymentStatus);
    }
    if (json.deployment != null) {
      builder.deployment(json.deployment);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DeploymentStatusEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DeploymentStatusEvent instance
   */
  public static ImmutableDeploymentStatusEvent copyOf(DeploymentStatusEvent instance) {
    if (instance instanceof ImmutableDeploymentStatusEvent) {
      return (ImmutableDeploymentStatusEvent) instance;
    }
    return ImmutableDeploymentStatusEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDeploymentStatusEvent ImmutableDeploymentStatusEvent}.
   * <pre>
   * ImmutableDeploymentStatusEvent.builder()
   *    .repository(com.spotify.github.v3.repos.Repository | null) // nullable {@link DeploymentStatusEvent#repository() repository}
   *    .sender(com.spotify.github.v3.User | null) // nullable {@link DeploymentStatusEvent#sender() sender}
   *    .eventInstallation(com.spotify.github.v3.activity.events.EventInstallation | null) // nullable {@link DeploymentStatusEvent#eventInstallation() eventInstallation}
   *    .deploymentStatus(com.spotify.github.v3.repos.Status | null) // nullable {@link DeploymentStatusEvent#deploymentStatus() deploymentStatus}
   *    .deployment(com.spotify.github.v3.repos.Deployment | null) // nullable {@link DeploymentStatusEvent#deployment() deployment}
   *    .build();
   * </pre>
   * @return A new ImmutableDeploymentStatusEvent builder
   */
  public static ImmutableDeploymentStatusEvent.Builder builder() {
    return new ImmutableDeploymentStatusEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDeploymentStatusEvent ImmutableDeploymentStatusEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DeploymentStatusEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Repository repository;
    private @Nullable User sender;
    private @Nullable EventInstallation eventInstallation;
    private @Nullable Status deploymentStatus;
    private @Nullable Deployment deployment;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.DeploymentStatusEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DeploymentStatusEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.BaseEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BaseEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof DeploymentStatusEvent) {
        DeploymentStatusEvent instance = (DeploymentStatusEvent) object;
        if ((bits & 0x1L) == 0) {
          @Nullable EventInstallation eventInstallationValue = instance.eventInstallation();
          if (eventInstallationValue != null) {
            eventInstallation(eventInstallationValue);
          }
          bits |= 0x1L;
        }
        @Nullable Status deploymentStatusValue = instance.deploymentStatus();
        if (deploymentStatusValue != null) {
          deploymentStatus(deploymentStatusValue);
        }
        if ((bits & 0x4L) == 0) {
          @Nullable Repository repositoryValue = instance.repository();
          if (repositoryValue != null) {
            repository(repositoryValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable User senderValue = instance.sender();
          if (senderValue != null) {
            sender(senderValue);
          }
          bits |= 0x2L;
        }
        @Nullable Deployment deploymentValue = instance.deployment();
        if (deploymentValue != null) {
          deployment(deploymentValue);
        }
      }
      if (object instanceof BaseEvent) {
        BaseEvent instance = (BaseEvent) object;
        if ((bits & 0x4L) == 0) {
          @Nullable Repository repositoryValue = instance.repository();
          if (repositoryValue != null) {
            repository(repositoryValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable User senderValue = instance.sender();
          if (senderValue != null) {
            sender(senderValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          @Nullable EventInstallation eventInstallationValue = instance.eventInstallation();
          if (eventInstallationValue != null) {
            eventInstallation(eventInstallationValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link DeploymentStatusEvent#repository() repository} attribute.
     * @param repository The value for repository (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repository(@Nullable Repository repository) {
      this.repository = repository;
      return this;
    }

    /**
     * Initializes the value for the {@link DeploymentStatusEvent#sender() sender} attribute.
     * @param sender The value for sender (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sender(@Nullable User sender) {
      this.sender = sender;
      return this;
    }

    /**
     * Initializes the value for the {@link DeploymentStatusEvent#eventInstallation() eventInstallation} attribute.
     * @param eventInstallation The value for eventInstallation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("installation")
    public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
      return this;
    }

    /**
     * Initializes the value for the {@link DeploymentStatusEvent#deploymentStatus() deploymentStatus} attribute.
     * @param deploymentStatus The value for deploymentStatus (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder deploymentStatus(@Nullable Status deploymentStatus) {
      this.deploymentStatus = deploymentStatus;
      return this;
    }

    /**
     * Initializes the value for the {@link DeploymentStatusEvent#deployment() deployment} attribute.
     * @param deployment The value for deployment (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder deployment(@Nullable Deployment deployment) {
      this.deployment = deployment;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDeploymentStatusEvent ImmutableDeploymentStatusEvent}.
     * @return An immutable instance of DeploymentStatusEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDeploymentStatusEvent build() {
      return new ImmutableDeploymentStatusEvent(repository, sender, eventInstallation, deploymentStatus, deployment);
    }
  }
}
