package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.User;
import com.spotify.github.v3.repos.Organization;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RepositoryEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRepositoryEvent.builder()}.
 */
@Generated(from = "RepositoryEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRepositoryEvent implements RepositoryEvent {
  private final @Nullable Repository repository;
  private final @Nullable User sender;
  private final @Nullable EventInstallation eventInstallation;
  private final @Nullable String action;
  private final @Nullable Organization organization;

  private ImmutableRepositoryEvent(
      @Nullable Repository repository,
      @Nullable User sender,
      @Nullable EventInstallation eventInstallation,
      @Nullable String action,
      @Nullable Organization organization) {
    this.repository = repository;
    this.sender = sender;
    this.eventInstallation = eventInstallation;
    this.action = action;
    this.organization = organization;
  }

  /**
   *The {@link Repository} 
   */
  @JsonProperty
  @Override
  public @Nullable Repository repository() {
    return repository;
  }

  /**
   *The {@link User} that triggered/sent the event. 
   */
  @JsonProperty
  @Override
  public @Nullable User sender() {
    return sender;
  }

  /**
   *The {@link EventInstallation}, if the event comes from a Github App. 
   */
  @JsonProperty("installation")
  @Override
  public @Nullable EventInstallation eventInstallation() {
    return eventInstallation;
  }

  /**
   * The action that was performed. This can be one of "created", "deleted", "publicized", or
   * "privatized".
   */
  @JsonProperty
  @Override
  public @Nullable String action() {
    return action;
  }

  /**
   *Organization 
   */
  @JsonProperty
  @Override
  public @Nullable Organization organization() {
    return organization;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryEvent#repository() repository} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repository (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryEvent withRepository(@Nullable Repository value) {
    if (this.repository == value) return this;
    return new ImmutableRepositoryEvent(value, this.sender, this.eventInstallation, this.action, this.organization);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryEvent#sender() sender} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sender (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryEvent withSender(@Nullable User value) {
    if (this.sender == value) return this;
    return new ImmutableRepositoryEvent(this.repository, value, this.eventInstallation, this.action, this.organization);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryEvent#eventInstallation() eventInstallation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventInstallation (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryEvent withEventInstallation(@Nullable EventInstallation value) {
    if (this.eventInstallation == value) return this;
    return new ImmutableRepositoryEvent(this.repository, this.sender, value, this.action, this.organization);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryEvent#action() action} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryEvent withAction(@Nullable String value) {
    if (Objects.equals(this.action, value)) return this;
    return new ImmutableRepositoryEvent(this.repository, this.sender, this.eventInstallation, value, this.organization);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryEvent#organization() organization} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for organization (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryEvent withOrganization(@Nullable Organization value) {
    if (this.organization == value) return this;
    return new ImmutableRepositoryEvent(this.repository, this.sender, this.eventInstallation, this.action, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRepositoryEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRepositoryEvent
        && equalTo(0, (ImmutableRepositoryEvent) another);
  }

  private boolean equalTo(int synthetic, ImmutableRepositoryEvent another) {
    return Objects.equals(repository, another.repository)
        && Objects.equals(sender, another.sender)
        && Objects.equals(eventInstallation, another.eventInstallation)
        && Objects.equals(action, another.action)
        && Objects.equals(organization, another.organization);
  }

  /**
   * Computes a hash code from attributes: {@code repository}, {@code sender}, {@code eventInstallation}, {@code action}, {@code organization}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(repository);
    h += (h << 5) + Objects.hashCode(sender);
    h += (h << 5) + Objects.hashCode(eventInstallation);
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(organization);
    return h;
  }

  /**
   * Prints the immutable value {@code RepositoryEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RepositoryEvent{"
        + "repository=" + repository
        + ", sender=" + sender
        + ", eventInstallation=" + eventInstallation
        + ", action=" + action
        + ", organization=" + organization
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "RepositoryEvent", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements RepositoryEvent {
    @Nullable Repository repository;
    @Nullable User sender;
    @Nullable EventInstallation eventInstallation;
    @Nullable String action;
    @Nullable Organization organization;
    @JsonProperty
    public void setRepository(@Nullable Repository repository) {
      this.repository = repository;
    }
    @JsonProperty
    public void setSender(@Nullable User sender) {
      this.sender = sender;
    }
    @JsonProperty("installation")
    public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
    }
    @JsonProperty
    public void setAction(@Nullable String action) {
      this.action = action;
    }
    @JsonProperty
    public void setOrganization(@Nullable Organization organization) {
      this.organization = organization;
    }
    @Override
    public Repository repository() { throw new UnsupportedOperationException(); }
    @Override
    public User sender() { throw new UnsupportedOperationException(); }
    @Override
    public EventInstallation eventInstallation() { throw new UnsupportedOperationException(); }
    @Override
    public String action() { throw new UnsupportedOperationException(); }
    @Override
    public Organization organization() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRepositoryEvent fromJson(Json json) {
    ImmutableRepositoryEvent.Builder builder = ImmutableRepositoryEvent.builder();
    if (json.repository != null) {
      builder.repository(json.repository);
    }
    if (json.sender != null) {
      builder.sender(json.sender);
    }
    if (json.eventInstallation != null) {
      builder.eventInstallation(json.eventInstallation);
    }
    if (json.action != null) {
      builder.action(json.action);
    }
    if (json.organization != null) {
      builder.organization(json.organization);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link RepositoryEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RepositoryEvent instance
   */
  public static ImmutableRepositoryEvent copyOf(RepositoryEvent instance) {
    if (instance instanceof ImmutableRepositoryEvent) {
      return (ImmutableRepositoryEvent) instance;
    }
    return ImmutableRepositoryEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRepositoryEvent ImmutableRepositoryEvent}.
   * <pre>
   * ImmutableRepositoryEvent.builder()
   *    .repository(com.spotify.github.v3.repos.Repository | null) // nullable {@link RepositoryEvent#repository() repository}
   *    .sender(com.spotify.github.v3.User | null) // nullable {@link RepositoryEvent#sender() sender}
   *    .eventInstallation(com.spotify.github.v3.activity.events.EventInstallation | null) // nullable {@link RepositoryEvent#eventInstallation() eventInstallation}
   *    .action(String | null) // nullable {@link RepositoryEvent#action() action}
   *    .organization(com.spotify.github.v3.repos.Organization | null) // nullable {@link RepositoryEvent#organization() organization}
   *    .build();
   * </pre>
   * @return A new ImmutableRepositoryEvent builder
   */
  public static ImmutableRepositoryEvent.Builder builder() {
    return new ImmutableRepositoryEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRepositoryEvent ImmutableRepositoryEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RepositoryEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Repository repository;
    private @Nullable User sender;
    private @Nullable EventInstallation eventInstallation;
    private @Nullable String action;
    private @Nullable Organization organization;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.RepositoryEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RepositoryEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.BaseEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BaseEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof RepositoryEvent) {
        RepositoryEvent instance = (RepositoryEvent) object;
        @Nullable String actionValue = instance.action();
        if (actionValue != null) {
          action(actionValue);
        }
        if ((bits & 0x1L) == 0) {
          @Nullable EventInstallation eventInstallationValue = instance.eventInstallation();
          if (eventInstallationValue != null) {
            eventInstallation(eventInstallationValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          @Nullable Repository repositoryValue = instance.repository();
          if (repositoryValue != null) {
            repository(repositoryValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable User senderValue = instance.sender();
          if (senderValue != null) {
            sender(senderValue);
          }
          bits |= 0x2L;
        }
        @Nullable Organization organizationValue = instance.organization();
        if (organizationValue != null) {
          organization(organizationValue);
        }
      }
      if (object instanceof BaseEvent) {
        BaseEvent instance = (BaseEvent) object;
        if ((bits & 0x4L) == 0) {
          @Nullable Repository repositoryValue = instance.repository();
          if (repositoryValue != null) {
            repository(repositoryValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable User senderValue = instance.sender();
          if (senderValue != null) {
            sender(senderValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          @Nullable EventInstallation eventInstallationValue = instance.eventInstallation();
          if (eventInstallationValue != null) {
            eventInstallation(eventInstallationValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link RepositoryEvent#repository() repository} attribute.
     * @param repository The value for repository (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repository(@Nullable Repository repository) {
      this.repository = repository;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryEvent#sender() sender} attribute.
     * @param sender The value for sender (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sender(@Nullable User sender) {
      this.sender = sender;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryEvent#eventInstallation() eventInstallation} attribute.
     * @param eventInstallation The value for eventInstallation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("installation")
    public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryEvent#action() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder action(@Nullable String action) {
      this.action = action;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryEvent#organization() organization} attribute.
     * @param organization The value for organization (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder organization(@Nullable Organization organization) {
      this.organization = organization;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRepositoryEvent ImmutableRepositoryEvent}.
     * @return An immutable instance of RepositoryEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRepositoryEvent build() {
      return new ImmutableRepositoryEvent(repository, sender, eventInstallation, action, organization);
    }
  }
}
