package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.User;
import com.spotify.github.v3.repos.Branch;
import com.spotify.github.v3.repos.CommitItem;
import com.spotify.github.v3.repos.Repository;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StatusEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStatusEvent.builder()}.
 */
@Generated(from = "StatusEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableStatusEvent implements StatusEvent {
  private final @Nullable Repository repository;
  private final @Nullable User sender;
  private final @Nullable EventInstallation eventInstallation;
  private final @Nullable GitHubInstant createdAt;
  private final @Nullable GitHubInstant updatedAt;
  private final @Nullable Long id;
  private final @Nullable String sha;
  private final @Nullable String name;
  private final @Nullable URI targetUrl;
  private final @Nullable String context;
  private final @Nullable Optional<String> description;
  private final @Nullable String state;
  private final @Nullable CommitItem commit;
  private final @Nullable List<Branch> branches;

  private ImmutableStatusEvent(
      @Nullable Repository repository,
      @Nullable User sender,
      @Nullable EventInstallation eventInstallation,
      @Nullable GitHubInstant createdAt,
      @Nullable GitHubInstant updatedAt,
      @Nullable Long id,
      @Nullable String sha,
      @Nullable String name,
      @Nullable URI targetUrl,
      @Nullable String context,
      @Nullable Optional<String> description,
      @Nullable String state,
      @Nullable CommitItem commit,
      @Nullable List<Branch> branches) {
    this.repository = repository;
    this.sender = sender;
    this.eventInstallation = eventInstallation;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.id = id;
    this.sha = sha;
    this.name = name;
    this.targetUrl = targetUrl;
    this.context = context;
    this.description = description;
    this.state = state;
    this.commit = commit;
    this.branches = branches;
  }

  /**
   *The {@link Repository} 
   */
  @JsonProperty
  @Override
  public @Nullable Repository repository() {
    return repository;
  }

  /**
   *The {@link User} that triggered/sent the event. 
   */
  @JsonProperty
  @Override
  public @Nullable User sender() {
    return sender;
  }

  /**
   *The {@link EventInstallation}, if the event comes from a Github App. 
   */
  @JsonProperty("installation")
  @Override
  public @Nullable EventInstallation eventInstallation() {
    return eventInstallation;
  }

  /**
   * Created date
   * @return The date when the issue was created
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant createdAt() {
    return createdAt;
  }

  /**
   * Updated date
   * @return The date when the issue was updated
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant updatedAt() {
    return updatedAt;
  }

  /**
   *Status event id 
   */
  @JsonProperty
  @Override
  public @Nullable Long id() {
    return id;
  }

  /**
   *The Commit SHA. 
   */
  @JsonProperty
  @Override
  public @Nullable String sha() {
    return sha;
  }

  /**
   *Full repository name. E.g. organization/repo-name 
   */
  @JsonProperty
  @Override
  public @Nullable String name() {
    return name;
  }

  /**
   *The optional link added to the status. 
   */
  @JsonProperty
  @Override
  public Optional<URI> targetUrl() {
    return Optional.ofNullable(targetUrl);
  }

  /**
   * A string label to differentiate this status from the status of other systems. Example:
   * continuous-integration/jenkins Default: "default"
   */
  @JsonProperty
  @Override
  public @Nullable String context() {
    return context;
  }

  /**
   *The optional human-readable description added to the status. 
   */
  @JsonProperty
  @Override
  public @Nullable Optional<String> description() {
    return description;
  }

  /**
   *The new state. Can be pending, success, failure, or error. 
   */
  @JsonProperty
  @Override
  public @Nullable String state() {
    return state;
  }

  /**
   *Related git commit 
   */
  @JsonProperty
  @Override
  public @Nullable CommitItem commit() {
    return commit;
  }

  /**
   * An array of branch objects containing the status' SHA. Each branch contains the given SHA, but
   * the SHA may or may not be the head of the branch. The array includes a maximum of 10 branches.
   */
  @JsonProperty
  @Override
  public @Nullable List<Branch> branches() {
    return branches;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StatusEvent#repository() repository} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repository (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStatusEvent withRepository(@Nullable Repository value) {
    if (this.repository == value) return this;
    return new ImmutableStatusEvent(
        value,
        this.sender,
        this.eventInstallation,
        this.createdAt,
        this.updatedAt,
        this.id,
        this.sha,
        this.name,
        this.targetUrl,
        this.context,
        this.description,
        this.state,
        this.commit,
        this.branches);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StatusEvent#sender() sender} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sender (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStatusEvent withSender(@Nullable User value) {
    if (this.sender == value) return this;
    return new ImmutableStatusEvent(
        this.repository,
        value,
        this.eventInstallation,
        this.createdAt,
        this.updatedAt,
        this.id,
        this.sha,
        this.name,
        this.targetUrl,
        this.context,
        this.description,
        this.state,
        this.commit,
        this.branches);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StatusEvent#eventInstallation() eventInstallation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventInstallation (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStatusEvent withEventInstallation(@Nullable EventInstallation value) {
    if (this.eventInstallation == value) return this;
    return new ImmutableStatusEvent(
        this.repository,
        this.sender,
        value,
        this.createdAt,
        this.updatedAt,
        this.id,
        this.sha,
        this.name,
        this.targetUrl,
        this.context,
        this.description,
        this.state,
        this.commit,
        this.branches);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StatusEvent#createdAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStatusEvent withCreatedAt(@Nullable GitHubInstant value) {
    if (this.createdAt == value) return this;
    return new ImmutableStatusEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        value,
        this.updatedAt,
        this.id,
        this.sha,
        this.name,
        this.targetUrl,
        this.context,
        this.description,
        this.state,
        this.commit,
        this.branches);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StatusEvent#updatedAt() updatedAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStatusEvent withUpdatedAt(@Nullable GitHubInstant value) {
    if (this.updatedAt == value) return this;
    return new ImmutableStatusEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.createdAt,
        value,
        this.id,
        this.sha,
        this.name,
        this.targetUrl,
        this.context,
        this.description,
        this.state,
        this.commit,
        this.branches);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StatusEvent#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStatusEvent withId(@Nullable Long value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableStatusEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.createdAt,
        this.updatedAt,
        value,
        this.sha,
        this.name,
        this.targetUrl,
        this.context,
        this.description,
        this.state,
        this.commit,
        this.branches);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StatusEvent#sha() sha} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sha (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStatusEvent withSha(@Nullable String value) {
    if (Objects.equals(this.sha, value)) return this;
    return new ImmutableStatusEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.createdAt,
        this.updatedAt,
        this.id,
        value,
        this.name,
        this.targetUrl,
        this.context,
        this.description,
        this.state,
        this.commit,
        this.branches);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StatusEvent#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStatusEvent withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableStatusEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.createdAt,
        this.updatedAt,
        this.id,
        this.sha,
        value,
        this.targetUrl,
        this.context,
        this.description,
        this.state,
        this.commit,
        this.branches);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link StatusEvent#targetUrl() targetUrl} attribute.
   * @param value The value for targetUrl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStatusEvent withTargetUrl(URI value) {
    URI newValue = Objects.requireNonNull(value, "targetUrl");
    if (this.targetUrl == newValue) return this;
    return new ImmutableStatusEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.createdAt,
        this.updatedAt,
        this.id,
        this.sha,
        this.name,
        newValue,
        this.context,
        this.description,
        this.state,
        this.commit,
        this.branches);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link StatusEvent#targetUrl() targetUrl} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for targetUrl
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableStatusEvent withTargetUrl(Optional<? extends URI> optional) {
    @Nullable URI value = optional.orElse(null);
    if (this.targetUrl == value) return this;
    return new ImmutableStatusEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.createdAt,
        this.updatedAt,
        this.id,
        this.sha,
        this.name,
        value,
        this.context,
        this.description,
        this.state,
        this.commit,
        this.branches);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StatusEvent#context() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStatusEvent withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return new ImmutableStatusEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.createdAt,
        this.updatedAt,
        this.id,
        this.sha,
        this.name,
        this.targetUrl,
        value,
        this.description,
        this.state,
        this.commit,
        this.branches);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StatusEvent#description() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStatusEvent withDescription(@Nullable Optional<String> value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableStatusEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.createdAt,
        this.updatedAt,
        this.id,
        this.sha,
        this.name,
        this.targetUrl,
        this.context,
        value,
        this.state,
        this.commit,
        this.branches);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StatusEvent#state() state} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for state (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStatusEvent withState(@Nullable String value) {
    if (Objects.equals(this.state, value)) return this;
    return new ImmutableStatusEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.createdAt,
        this.updatedAt,
        this.id,
        this.sha,
        this.name,
        this.targetUrl,
        this.context,
        this.description,
        value,
        this.commit,
        this.branches);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StatusEvent#commit() commit} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commit (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStatusEvent withCommit(@Nullable CommitItem value) {
    if (this.commit == value) return this;
    return new ImmutableStatusEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.createdAt,
        this.updatedAt,
        this.id,
        this.sha,
        this.name,
        this.targetUrl,
        this.context,
        this.description,
        this.state,
        value,
        this.branches);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StatusEvent#branches() branches}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStatusEvent withBranches(@Nullable Branch... elements) {
    if (elements == null) {
      return new ImmutableStatusEvent(
          this.repository,
          this.sender,
          this.eventInstallation,
          this.createdAt,
          this.updatedAt,
          this.id,
          this.sha,
          this.name,
          this.targetUrl,
          this.context,
          this.description,
          this.state,
          this.commit,
          null);
    }
    @Nullable List<Branch> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableStatusEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.createdAt,
        this.updatedAt,
        this.id,
        this.sha,
        this.name,
        this.targetUrl,
        this.context,
        this.description,
        this.state,
        this.commit,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StatusEvent#branches() branches}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of branches elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStatusEvent withBranches(@Nullable Iterable<? extends Branch> elements) {
    if (this.branches == elements) return this;
    @Nullable List<Branch> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableStatusEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.createdAt,
        this.updatedAt,
        this.id,
        this.sha,
        this.name,
        this.targetUrl,
        this.context,
        this.description,
        this.state,
        this.commit,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStatusEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStatusEvent
        && equalTo(0, (ImmutableStatusEvent) another);
  }

  private boolean equalTo(int synthetic, ImmutableStatusEvent another) {
    return Objects.equals(repository, another.repository)
        && Objects.equals(sender, another.sender)
        && Objects.equals(eventInstallation, another.eventInstallation)
        && Objects.equals(createdAt, another.createdAt)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(id, another.id)
        && Objects.equals(sha, another.sha)
        && Objects.equals(name, another.name)
        && Objects.equals(targetUrl, another.targetUrl)
        && Objects.equals(context, another.context)
        && Objects.equals(description, another.description)
        && Objects.equals(state, another.state)
        && Objects.equals(commit, another.commit)
        && Objects.equals(branches, another.branches);
  }

  /**
   * Computes a hash code from attributes: {@code repository}, {@code sender}, {@code eventInstallation}, {@code createdAt}, {@code updatedAt}, {@code id}, {@code sha}, {@code name}, {@code targetUrl}, {@code context}, {@code description}, {@code state}, {@code commit}, {@code branches}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(repository);
    h += (h << 5) + Objects.hashCode(sender);
    h += (h << 5) + Objects.hashCode(eventInstallation);
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(sha);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(targetUrl);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(state);
    h += (h << 5) + Objects.hashCode(commit);
    h += (h << 5) + Objects.hashCode(branches);
    return h;
  }

  /**
   * Prints the immutable value {@code StatusEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("StatusEvent{");
    if (repository != null) {
      builder.append("repository=").append(repository);
    }
    if (sender != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("sender=").append(sender);
    }
    if (eventInstallation != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("eventInstallation=").append(eventInstallation);
    }
    if (createdAt != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("createdAt=").append(createdAt);
    }
    if (updatedAt != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("updatedAt=").append(updatedAt);
    }
    if (id != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("id=").append(id);
    }
    if (sha != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("sha=").append(sha);
    }
    if (name != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("name=").append(name);
    }
    if (targetUrl != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("targetUrl=").append(targetUrl);
    }
    if (context != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("context=").append(context);
    }
    if (description != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("description=").append(description);
    }
    if (state != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("state=").append(state);
    }
    if (commit != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("commit=").append(commit);
    }
    if (branches != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("branches=").append(branches);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "StatusEvent", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StatusEvent {
    @Nullable Repository repository;
    @Nullable User sender;
    @Nullable EventInstallation eventInstallation;
    @Nullable GitHubInstant createdAt;
    @Nullable GitHubInstant updatedAt;
    @Nullable Long id;
    @Nullable String sha;
    @Nullable String name;
    @Nullable Optional<URI> targetUrl = Optional.empty();
    @Nullable String context;
    @Nullable Optional<String> description;
    @Nullable String state;
    @Nullable CommitItem commit;
    @Nullable List<Branch> branches = null;
    @JsonProperty
    public void setRepository(@Nullable Repository repository) {
      this.repository = repository;
    }
    @JsonProperty
    public void setSender(@Nullable User sender) {
      this.sender = sender;
    }
    @JsonProperty("installation")
    public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
    }
    @JsonProperty
    public void setCreatedAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty
    public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty
    public void setId(@Nullable Long id) {
      this.id = id;
    }
    @JsonProperty
    public void setSha(@Nullable String sha) {
      this.sha = sha;
    }
    @JsonProperty
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty
    public void setTargetUrl(Optional<URI> targetUrl) {
      this.targetUrl = targetUrl;
    }
    @JsonProperty
    public void setContext(@Nullable String context) {
      this.context = context;
    }
    @JsonProperty
    public void setDescription(@Nullable Optional<String> description) {
      this.description = description;
    }
    @JsonProperty
    public void setState(@Nullable String state) {
      this.state = state;
    }
    @JsonProperty
    public void setCommit(@Nullable CommitItem commit) {
      this.commit = commit;
    }
    @JsonProperty
    public void setBranches(@Nullable List<Branch> branches) {
      this.branches = branches;
    }
    @Override
    public Repository repository() { throw new UnsupportedOperationException(); }
    @Override
    public User sender() { throw new UnsupportedOperationException(); }
    @Override
    public EventInstallation eventInstallation() { throw new UnsupportedOperationException(); }
    @Override
    public GitHubInstant createdAt() { throw new UnsupportedOperationException(); }
    @Override
    public GitHubInstant updatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Long id() { throw new UnsupportedOperationException(); }
    @Override
    public String sha() { throw new UnsupportedOperationException(); }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<URI> targetUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String context() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> description() { throw new UnsupportedOperationException(); }
    @Override
    public String state() { throw new UnsupportedOperationException(); }
    @Override
    public CommitItem commit() { throw new UnsupportedOperationException(); }
    @Override
    public List<Branch> branches() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableStatusEvent fromJson(Json json) {
    ImmutableStatusEvent.Builder builder = ImmutableStatusEvent.builder();
    if (json.repository != null) {
      builder.repository(json.repository);
    }
    if (json.sender != null) {
      builder.sender(json.sender);
    }
    if (json.eventInstallation != null) {
      builder.eventInstallation(json.eventInstallation);
    }
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.sha != null) {
      builder.sha(json.sha);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.targetUrl != null) {
      builder.targetUrl(json.targetUrl);
    }
    if (json.context != null) {
      builder.context(json.context);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.commit != null) {
      builder.commit(json.commit);
    }
    if (json.branches != null) {
      builder.addAllBranches(json.branches);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StatusEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StatusEvent instance
   */
  public static ImmutableStatusEvent copyOf(StatusEvent instance) {
    if (instance instanceof ImmutableStatusEvent) {
      return (ImmutableStatusEvent) instance;
    }
    return ImmutableStatusEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStatusEvent ImmutableStatusEvent}.
   * <pre>
   * ImmutableStatusEvent.builder()
   *    .repository(com.spotify.github.v3.repos.Repository | null) // nullable {@link StatusEvent#repository() repository}
   *    .sender(com.spotify.github.v3.User | null) // nullable {@link StatusEvent#sender() sender}
   *    .eventInstallation(com.spotify.github.v3.activity.events.EventInstallation | null) // nullable {@link StatusEvent#eventInstallation() eventInstallation}
   *    .createdAt(com.spotify.github.GitHubInstant | null) // nullable {@link StatusEvent#createdAt() createdAt}
   *    .updatedAt(com.spotify.github.GitHubInstant | null) // nullable {@link StatusEvent#updatedAt() updatedAt}
   *    .id(Long | null) // nullable {@link StatusEvent#id() id}
   *    .sha(String | null) // nullable {@link StatusEvent#sha() sha}
   *    .name(String | null) // nullable {@link StatusEvent#name() name}
   *    .targetUrl(java.net.URI) // optional {@link StatusEvent#targetUrl() targetUrl}
   *    .context(String | null) // nullable {@link StatusEvent#context() context}
   *    .description(Optional&amp;lt;String&amp;gt; | null) // nullable {@link StatusEvent#description() description}
   *    .state(String | null) // nullable {@link StatusEvent#state() state}
   *    .commit(com.spotify.github.v3.repos.CommitItem | null) // nullable {@link StatusEvent#commit() commit}
   *    .branches(List&amp;lt;com.spotify.github.v3.repos.Branch&amp;gt; | null) // nullable {@link StatusEvent#branches() branches}
   *    .build();
   * </pre>
   * @return A new ImmutableStatusEvent builder
   */
  public static ImmutableStatusEvent.Builder builder() {
    return new ImmutableStatusEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStatusEvent ImmutableStatusEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StatusEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Repository repository;
    private @Nullable User sender;
    private @Nullable EventInstallation eventInstallation;
    private @Nullable GitHubInstant createdAt;
    private @Nullable GitHubInstant updatedAt;
    private @Nullable Long id;
    private @Nullable String sha;
    private @Nullable String name;
    private @Nullable URI targetUrl;
    private @Nullable String context;
    private @Nullable Optional<String> description;
    private @Nullable String state;
    private @Nullable CommitItem commit;
    private List<Branch> branches = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.BaseEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BaseEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.UpdateTracking} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateTracking instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.StatusEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StatusEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof BaseEvent) {
        BaseEvent instance = (BaseEvent) object;
        if ((bits & 0x2L) == 0) {
          @Nullable Repository repositoryValue = instance.repository();
          if (repositoryValue != null) {
            repository(repositoryValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x8L) == 0) {
          @Nullable User senderValue = instance.sender();
          if (senderValue != null) {
            sender(senderValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x1L) == 0) {
          @Nullable EventInstallation eventInstallationValue = instance.eventInstallation();
          if (eventInstallationValue != null) {
            eventInstallation(eventInstallationValue);
          }
          bits |= 0x1L;
        }
      }
      if (object instanceof UpdateTracking) {
        UpdateTracking instance = (UpdateTracking) object;
        if ((bits & 0x4L) == 0) {
          @Nullable GitHubInstant createdAtValue = instance.createdAt();
          if (createdAtValue != null) {
            createdAt(createdAtValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x10L) == 0) {
          @Nullable GitHubInstant updatedAtValue = instance.updatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x10L;
        }
      }
      if (object instanceof StatusEvent) {
        StatusEvent instance = (StatusEvent) object;
        if ((bits & 0x1L) == 0) {
          @Nullable EventInstallation eventInstallationValue = instance.eventInstallation();
          if (eventInstallationValue != null) {
            eventInstallation(eventInstallationValue);
          }
          bits |= 0x1L;
        }
        @Nullable CommitItem commitValue = instance.commit();
        if (commitValue != null) {
          commit(commitValue);
        }
        @Nullable Optional<String> descriptionValue = instance.description();
        if (descriptionValue != null) {
          description(descriptionValue);
        }
        if ((bits & 0x2L) == 0) {
          @Nullable Repository repositoryValue = instance.repository();
          if (repositoryValue != null) {
            repository(repositoryValue);
          }
          bits |= 0x2L;
        }
        @Nullable List<Branch> branchesValue = instance.branches();
        if (branchesValue != null) {
          addAllBranches(branchesValue);
        }
        @Nullable String shaValue = instance.sha();
        if (shaValue != null) {
          sha(shaValue);
        }
        if ((bits & 0x4L) == 0) {
          @Nullable GitHubInstant createdAtValue = instance.createdAt();
          if (createdAtValue != null) {
            createdAt(createdAtValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          @Nullable User senderValue = instance.sender();
          if (senderValue != null) {
            sender(senderValue);
          }
          bits |= 0x8L;
        }
        @Nullable String nameValue = instance.name();
        if (nameValue != null) {
          name(nameValue);
        }
        @Nullable String contextValue = instance.context();
        if (contextValue != null) {
          context(contextValue);
        }
        @Nullable Long idValue = instance.id();
        if (idValue != null) {
          id(idValue);
        }
        @Nullable String stateValue = instance.state();
        if (stateValue != null) {
          state(stateValue);
        }
        Optional<URI> targetUrlOptional = instance.targetUrl();
        if (targetUrlOptional.isPresent()) {
          targetUrl(targetUrlOptional);
        }
        if ((bits & 0x10L) == 0) {
          @Nullable GitHubInstant updatedAtValue = instance.updatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x10L;
        }
      }
    }

    /**
     * Initializes the value for the {@link StatusEvent#repository() repository} attribute.
     * @param repository The value for repository (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repository(@Nullable Repository repository) {
      this.repository = repository;
      return this;
    }

    /**
     * Initializes the value for the {@link StatusEvent#sender() sender} attribute.
     * @param sender The value for sender (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sender(@Nullable User sender) {
      this.sender = sender;
      return this;
    }

    /**
     * Initializes the value for the {@link StatusEvent#eventInstallation() eventInstallation} attribute.
     * @param eventInstallation The value for eventInstallation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("installation")
    public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
      return this;
    }

    /**
     * Initializes the value for the {@link StatusEvent#createdAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder createdAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link StatusEvent#updatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link StatusEvent#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(@Nullable Long id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link StatusEvent#sha() sha} attribute.
     * @param sha The value for sha (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sha(@Nullable String sha) {
      this.sha = sha;
      return this;
    }

    /**
     * Initializes the value for the {@link StatusEvent#name() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the optional value {@link StatusEvent#targetUrl() targetUrl} to targetUrl.
     * @param targetUrl The value for targetUrl
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targetUrl(URI targetUrl) {
      this.targetUrl = Objects.requireNonNull(targetUrl, "targetUrl");
      return this;
    }

    /**
     * Initializes the optional value {@link StatusEvent#targetUrl() targetUrl} to targetUrl.
     * @param targetUrl The value for targetUrl
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder targetUrl(Optional<? extends URI> targetUrl) {
      this.targetUrl = targetUrl.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link StatusEvent#context() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder context(@Nullable String context) {
      this.context = context;
      return this;
    }

    /**
     * Initializes the value for the {@link StatusEvent#description() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder description(@Nullable Optional<String> description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link StatusEvent#state() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the value for the {@link StatusEvent#commit() commit} attribute.
     * @param commit The value for commit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commit(@Nullable CommitItem commit) {
      this.commit = commit;
      return this;
    }

    /**
     * Adds one element to {@link StatusEvent#branches() branches} list.
     * @param element A branches element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBranches(Branch element) {
      if (this.branches == null) {
        this.branches = new ArrayList<Branch>();
      }
      this.branches.add(Objects.requireNonNull(element, "branches element"));
      return this;
    }

    /**
     * Adds elements to {@link StatusEvent#branches() branches} list.
     * @param elements An array of branches elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBranches(Branch... elements) {
      if (this.branches == null) {
        this.branches = new ArrayList<Branch>();
      }
      for (Branch element : elements) {
        this.branches.add(Objects.requireNonNull(element, "branches element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StatusEvent#branches() branches} list.
     * @param elements An iterable of branches elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder branches(@Nullable Iterable<? extends Branch> elements) {
      if (elements == null) {
        this.branches = null;
        return this;
      }
      this.branches = new ArrayList<Branch>();
      return addAllBranches(elements);
    }

    /**
     * Adds elements to {@link StatusEvent#branches() branches} list.
     * @param elements An iterable of branches elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllBranches(Iterable<? extends Branch> elements) {
      Objects.requireNonNull(elements, "branches element");
      if (this.branches == null) {
        this.branches = new ArrayList<Branch>();
      }
      for (Branch element : elements) {
        this.branches.add(Objects.requireNonNull(element, "branches element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableStatusEvent ImmutableStatusEvent}.
     * @return An immutable instance of StatusEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStatusEvent build() {
      return new ImmutableStatusEvent(
          repository,
          sender,
          eventInstallation,
          createdAt,
          updatedAt,
          id,
          sha,
          name,
          targetUrl,
          context,
          description,
          state,
          commit,
          branches == null ? null : createUnmodifiableList(true, branches));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
