package com.spotify.github.v3.apps;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.repos.Repository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link InstallationRepositoriesResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableInstallationRepositoriesResponse.builder()}.
 */
@Generated(from = "InstallationRepositoriesResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableInstallationRepositoriesResponse
    implements InstallationRepositoriesResponse {
  private final int totalCount;
  private final List<Repository> repositories;

  private ImmutableInstallationRepositoriesResponse(int totalCount, List<Repository> repositories) {
    this.totalCount = totalCount;
    this.repositories = repositories;
  }

  /**
   * @return The value of the {@code totalCount} attribute
   */
  @JsonProperty
  @Override
  public int totalCount() {
    return totalCount;
  }

  /**
   * @return The value of the {@code repositories} attribute
   */
  @JsonProperty
  @Override
  public List<Repository> repositories() {
    return repositories;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InstallationRepositoriesResponse#totalCount() totalCount} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for totalCount
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInstallationRepositoriesResponse withTotalCount(int value) {
    if (this.totalCount == value) return this;
    return new ImmutableInstallationRepositoriesResponse(value, this.repositories);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InstallationRepositoriesResponse#repositories() repositories}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInstallationRepositoriesResponse withRepositories(Repository... elements) {
    List<Repository> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableInstallationRepositoriesResponse(this.totalCount, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InstallationRepositoriesResponse#repositories() repositories}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of repositories elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInstallationRepositoriesResponse withRepositories(Iterable<? extends Repository> elements) {
    if (this.repositories == elements) return this;
    List<Repository> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableInstallationRepositoriesResponse(this.totalCount, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableInstallationRepositoriesResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableInstallationRepositoriesResponse
        && equalTo(0, (ImmutableInstallationRepositoriesResponse) another);
  }

  private boolean equalTo(int synthetic, ImmutableInstallationRepositoriesResponse another) {
    return totalCount == another.totalCount
        && repositories.equals(another.repositories);
  }

  /**
   * Computes a hash code from attributes: {@code totalCount}, {@code repositories}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + totalCount;
    h += (h << 5) + repositories.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code InstallationRepositoriesResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InstallationRepositoriesResponse{"
        + "totalCount=" + totalCount
        + ", repositories=" + repositories
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "InstallationRepositoriesResponse", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements InstallationRepositoriesResponse {
    int totalCount;
    boolean totalCountIsSet;
    @Nullable List<Repository> repositories = Collections.emptyList();
    @JsonProperty
    public void setTotalCount(int totalCount) {
      this.totalCount = totalCount;
      this.totalCountIsSet = true;
    }
    @JsonProperty
    public void setRepositories(List<Repository> repositories) {
      this.repositories = repositories;
    }
    @Override
    public int totalCount() { throw new UnsupportedOperationException(); }
    @Override
    public List<Repository> repositories() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableInstallationRepositoriesResponse fromJson(Json json) {
    ImmutableInstallationRepositoriesResponse.Builder builder = ImmutableInstallationRepositoriesResponse.builder();
    if (json.totalCountIsSet) {
      builder.totalCount(json.totalCount);
    }
    if (json.repositories != null) {
      builder.addAllRepositories(json.repositories);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link InstallationRepositoriesResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InstallationRepositoriesResponse instance
   */
  public static ImmutableInstallationRepositoriesResponse copyOf(InstallationRepositoriesResponse instance) {
    if (instance instanceof ImmutableInstallationRepositoriesResponse) {
      return (ImmutableInstallationRepositoriesResponse) instance;
    }
    return ImmutableInstallationRepositoriesResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableInstallationRepositoriesResponse ImmutableInstallationRepositoriesResponse}.
   * <pre>
   * ImmutableInstallationRepositoriesResponse.builder()
   *    .totalCount(int) // required {@link InstallationRepositoriesResponse#totalCount() totalCount}
   *    .addRepositories|addAllRepositories(com.spotify.github.v3.repos.Repository) // {@link InstallationRepositoriesResponse#repositories() repositories} elements
   *    .build();
   * </pre>
   * @return A new ImmutableInstallationRepositoriesResponse builder
   */
  public static ImmutableInstallationRepositoriesResponse.Builder builder() {
    return new ImmutableInstallationRepositoriesResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableInstallationRepositoriesResponse ImmutableInstallationRepositoriesResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "InstallationRepositoriesResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TOTAL_COUNT = 0x1L;
    private long initBits = 0x1L;

    private int totalCount;
    private List<Repository> repositories = new ArrayList<Repository>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InstallationRepositoriesResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(InstallationRepositoriesResponse instance) {
      Objects.requireNonNull(instance, "instance");
      totalCount(instance.totalCount());
      addAllRepositories(instance.repositories());
      return this;
    }

    /**
     * Initializes the value for the {@link InstallationRepositoriesResponse#totalCount() totalCount} attribute.
     * @param totalCount The value for totalCount 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder totalCount(int totalCount) {
      this.totalCount = totalCount;
      initBits &= ~INIT_BIT_TOTAL_COUNT;
      return this;
    }

    /**
     * Adds one element to {@link InstallationRepositoriesResponse#repositories() repositories} list.
     * @param element A repositories element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRepositories(Repository element) {
      this.repositories.add(Objects.requireNonNull(element, "repositories element"));
      return this;
    }

    /**
     * Adds elements to {@link InstallationRepositoriesResponse#repositories() repositories} list.
     * @param elements An array of repositories elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRepositories(Repository... elements) {
      for (Repository element : elements) {
        this.repositories.add(Objects.requireNonNull(element, "repositories element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link InstallationRepositoriesResponse#repositories() repositories} list.
     * @param elements An iterable of repositories elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repositories(Iterable<? extends Repository> elements) {
      this.repositories.clear();
      return addAllRepositories(elements);
    }

    /**
     * Adds elements to {@link InstallationRepositoriesResponse#repositories() repositories} list.
     * @param elements An iterable of repositories elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllRepositories(Iterable<? extends Repository> elements) {
      for (Repository element : elements) {
        this.repositories.add(Objects.requireNonNull(element, "repositories element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableInstallationRepositoriesResponse ImmutableInstallationRepositoriesResponse}.
     * @return An immutable instance of InstallationRepositoriesResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableInstallationRepositoriesResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableInstallationRepositoriesResponse(totalCount, createUnmodifiableList(true, repositories));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TOTAL_COUNT) != 0) attributes.add("totalCount");
      return "Cannot build InstallationRepositoriesResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
