package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CheckRunImage}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCheckRunImage.builder()}.
 */
@Generated(from = "CheckRunImage", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCheckRunImage implements CheckRunImage {
  private final String alt;
  private final String imageUrl;
  private final @Nullable String caption;

  private ImmutableCheckRunImage(
      String alt,
      String imageUrl,
      @Nullable String caption) {
    this.alt = alt;
    this.imageUrl = imageUrl;
    this.caption = caption;
  }

  /**
   * The alternative text for the image.
   * @return the string
   */
  @JsonProperty
  @Override
  public String alt() {
    return alt;
  }

  /**
   * The full URL of the image.
   * @return the string
   */
  @JsonProperty
  @Override
  public String imageUrl() {
    return imageUrl;
  }

  /**
   * A short image description.
   * @return the optional string
   */
  @JsonProperty
  @Override
  public Optional<String> caption() {
    return Optional.ofNullable(caption);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunImage#alt() alt} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for alt
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunImage withAlt(String value) {
    String newValue = Objects.requireNonNull(value, "alt");
    if (this.alt.equals(newValue)) return this;
    return new ImmutableCheckRunImage(newValue, this.imageUrl, this.caption);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunImage#imageUrl() imageUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for imageUrl
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunImage withImageUrl(String value) {
    String newValue = Objects.requireNonNull(value, "imageUrl");
    if (this.imageUrl.equals(newValue)) return this;
    return new ImmutableCheckRunImage(this.alt, newValue, this.caption);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CheckRunImage#caption() caption} attribute.
   * @param value The value for caption
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunImage withCaption(String value) {
    String newValue = Objects.requireNonNull(value, "caption");
    if (Objects.equals(this.caption, newValue)) return this;
    return new ImmutableCheckRunImage(this.alt, this.imageUrl, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CheckRunImage#caption() caption} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for caption
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunImage withCaption(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.caption, value)) return this;
    return new ImmutableCheckRunImage(this.alt, this.imageUrl, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCheckRunImage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCheckRunImage
        && equalTo(0, (ImmutableCheckRunImage) another);
  }

  private boolean equalTo(int synthetic, ImmutableCheckRunImage another) {
    return alt.equals(another.alt)
        && imageUrl.equals(another.imageUrl)
        && Objects.equals(caption, another.caption);
  }

  /**
   * Computes a hash code from attributes: {@code alt}, {@code imageUrl}, {@code caption}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + alt.hashCode();
    h += (h << 5) + imageUrl.hashCode();
    h += (h << 5) + Objects.hashCode(caption);
    return h;
  }

  /**
   * Prints the immutable value {@code CheckRunImage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("CheckRunImage{");
    builder.append("alt=").append(alt);
    builder.append(", ");
    builder.append("imageUrl=").append(imageUrl);
    if (caption != null) {
      builder.append(", ");
      builder.append("caption=").append(caption);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CheckRunImage", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CheckRunImage {
    @Nullable String alt;
    @Nullable String imageUrl;
    @Nullable Optional<String> caption = Optional.empty();
    @JsonProperty
    public void setAlt(String alt) {
      this.alt = alt;
    }
    @JsonProperty
    public void setImageUrl(String imageUrl) {
      this.imageUrl = imageUrl;
    }
    @JsonProperty
    public void setCaption(Optional<String> caption) {
      this.caption = caption;
    }
    @Override
    public String alt() { throw new UnsupportedOperationException(); }
    @Override
    public String imageUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> caption() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCheckRunImage fromJson(Json json) {
    ImmutableCheckRunImage.Builder builder = ImmutableCheckRunImage.builder();
    if (json.alt != null) {
      builder.alt(json.alt);
    }
    if (json.imageUrl != null) {
      builder.imageUrl(json.imageUrl);
    }
    if (json.caption != null) {
      builder.caption(json.caption);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CheckRunImage} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CheckRunImage instance
   */
  public static ImmutableCheckRunImage copyOf(CheckRunImage instance) {
    if (instance instanceof ImmutableCheckRunImage) {
      return (ImmutableCheckRunImage) instance;
    }
    return ImmutableCheckRunImage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCheckRunImage ImmutableCheckRunImage}.
   * <pre>
   * ImmutableCheckRunImage.builder()
   *    .alt(String) // required {@link CheckRunImage#alt() alt}
   *    .imageUrl(String) // required {@link CheckRunImage#imageUrl() imageUrl}
   *    .caption(String) // optional {@link CheckRunImage#caption() caption}
   *    .build();
   * </pre>
   * @return A new ImmutableCheckRunImage builder
   */
  public static ImmutableCheckRunImage.Builder builder() {
    return new ImmutableCheckRunImage.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCheckRunImage ImmutableCheckRunImage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CheckRunImage", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ALT = 0x1L;
    private static final long INIT_BIT_IMAGE_URL = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String alt;
    private @Nullable String imageUrl;
    private @Nullable String caption;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CheckRunImage} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CheckRunImage instance) {
      Objects.requireNonNull(instance, "instance");
      alt(instance.alt());
      imageUrl(instance.imageUrl());
      Optional<String> captionOptional = instance.caption();
      if (captionOptional.isPresent()) {
        caption(captionOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRunImage#alt() alt} attribute.
     * @param alt The value for alt 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder alt(String alt) {
      this.alt = Objects.requireNonNull(alt, "alt");
      initBits &= ~INIT_BIT_ALT;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRunImage#imageUrl() imageUrl} attribute.
     * @param imageUrl The value for imageUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder imageUrl(String imageUrl) {
      this.imageUrl = Objects.requireNonNull(imageUrl, "imageUrl");
      initBits &= ~INIT_BIT_IMAGE_URL;
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunImage#caption() caption} to caption.
     * @param caption The value for caption
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder caption(String caption) {
      this.caption = Objects.requireNonNull(caption, "caption");
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunImage#caption() caption} to caption.
     * @param caption The value for caption
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder caption(Optional<String> caption) {
      this.caption = caption.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCheckRunImage ImmutableCheckRunImage}.
     * @return An immutable instance of CheckRunImage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCheckRunImage build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCheckRunImage(alt, imageUrl, caption);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ALT) != 0) attributes.add("alt");
      if ((initBits & INIT_BIT_IMAGE_URL) != 0) attributes.add("imageUrl");
      return "Cannot build CheckRunImage, some of required attributes are not set " + attributes;
    }
  }
}
