package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CheckRunResponseList}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCheckRunResponseList.builder()}.
 */
@Generated(from = "CheckRunResponseList", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCheckRunResponseList implements CheckRunResponseList {
  private final int totalCount;
  private final List<CheckRunResponse> checkRuns;

  private ImmutableCheckRunResponseList(int totalCount, List<CheckRunResponse> checkRuns) {
    this.totalCount = totalCount;
    this.checkRuns = checkRuns;
  }

  /**
   * The count of checks in the response
   * @return the int
   */
  @JsonProperty
  @Override
  public int totalCount() {
    return totalCount;
  }

  /**
   * CheckRuns list.
   * @return the list
   */
  @JsonProperty
  @Override
  public List<CheckRunResponse> checkRuns() {
    return checkRuns;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunResponseList#totalCount() totalCount} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for totalCount
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunResponseList withTotalCount(int value) {
    if (this.totalCount == value) return this;
    return new ImmutableCheckRunResponseList(value, this.checkRuns);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CheckRunResponseList#checkRuns() checkRuns}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunResponseList withCheckRuns(CheckRunResponse... elements) {
    List<CheckRunResponse> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableCheckRunResponseList(this.totalCount, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CheckRunResponseList#checkRuns() checkRuns}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of checkRuns elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunResponseList withCheckRuns(Iterable<? extends CheckRunResponse> elements) {
    if (this.checkRuns == elements) return this;
    List<CheckRunResponse> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableCheckRunResponseList(this.totalCount, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCheckRunResponseList} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCheckRunResponseList
        && equalTo(0, (ImmutableCheckRunResponseList) another);
  }

  private boolean equalTo(int synthetic, ImmutableCheckRunResponseList another) {
    return totalCount == another.totalCount
        && checkRuns.equals(another.checkRuns);
  }

  /**
   * Computes a hash code from attributes: {@code totalCount}, {@code checkRuns}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + totalCount;
    h += (h << 5) + checkRuns.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CheckRunResponseList} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CheckRunResponseList{"
        + "totalCount=" + totalCount
        + ", checkRuns=" + checkRuns
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CheckRunResponseList", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CheckRunResponseList {
    int totalCount;
    boolean totalCountIsSet;
    @Nullable List<CheckRunResponse> checkRuns = Collections.emptyList();
    @JsonProperty
    public void setTotalCount(int totalCount) {
      this.totalCount = totalCount;
      this.totalCountIsSet = true;
    }
    @JsonProperty
    public void setCheckRuns(List<CheckRunResponse> checkRuns) {
      this.checkRuns = checkRuns;
    }
    @Override
    public int totalCount() { throw new UnsupportedOperationException(); }
    @Override
    public List<CheckRunResponse> checkRuns() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCheckRunResponseList fromJson(Json json) {
    ImmutableCheckRunResponseList.Builder builder = ImmutableCheckRunResponseList.builder();
    if (json.totalCountIsSet) {
      builder.totalCount(json.totalCount);
    }
    if (json.checkRuns != null) {
      builder.addAllCheckRuns(json.checkRuns);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CheckRunResponseList} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CheckRunResponseList instance
   */
  public static ImmutableCheckRunResponseList copyOf(CheckRunResponseList instance) {
    if (instance instanceof ImmutableCheckRunResponseList) {
      return (ImmutableCheckRunResponseList) instance;
    }
    return ImmutableCheckRunResponseList.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCheckRunResponseList ImmutableCheckRunResponseList}.
   * <pre>
   * ImmutableCheckRunResponseList.builder()
   *    .totalCount(int) // required {@link CheckRunResponseList#totalCount() totalCount}
   *    .addCheckRuns|addAllCheckRuns(com.spotify.github.v3.checks.CheckRunResponse) // {@link CheckRunResponseList#checkRuns() checkRuns} elements
   *    .build();
   * </pre>
   * @return A new ImmutableCheckRunResponseList builder
   */
  public static ImmutableCheckRunResponseList.Builder builder() {
    return new ImmutableCheckRunResponseList.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCheckRunResponseList ImmutableCheckRunResponseList}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CheckRunResponseList", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TOTAL_COUNT = 0x1L;
    private long initBits = 0x1L;

    private int totalCount;
    private List<CheckRunResponse> checkRuns = new ArrayList<CheckRunResponse>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CheckRunResponseList} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CheckRunResponseList instance) {
      Objects.requireNonNull(instance, "instance");
      totalCount(instance.totalCount());
      addAllCheckRuns(instance.checkRuns());
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRunResponseList#totalCount() totalCount} attribute.
     * @param totalCount The value for totalCount 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder totalCount(int totalCount) {
      this.totalCount = totalCount;
      initBits &= ~INIT_BIT_TOTAL_COUNT;
      return this;
    }

    /**
     * Adds one element to {@link CheckRunResponseList#checkRuns() checkRuns} list.
     * @param element A checkRuns element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addCheckRuns(CheckRunResponse element) {
      this.checkRuns.add(Objects.requireNonNull(element, "checkRuns element"));
      return this;
    }

    /**
     * Adds elements to {@link CheckRunResponseList#checkRuns() checkRuns} list.
     * @param elements An array of checkRuns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addCheckRuns(CheckRunResponse... elements) {
      for (CheckRunResponse element : elements) {
        this.checkRuns.add(Objects.requireNonNull(element, "checkRuns element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CheckRunResponseList#checkRuns() checkRuns} list.
     * @param elements An iterable of checkRuns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder checkRuns(Iterable<? extends CheckRunResponse> elements) {
      this.checkRuns.clear();
      return addAllCheckRuns(elements);
    }

    /**
     * Adds elements to {@link CheckRunResponseList#checkRuns() checkRuns} list.
     * @param elements An iterable of checkRuns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllCheckRuns(Iterable<? extends CheckRunResponse> elements) {
      for (CheckRunResponse element : elements) {
        this.checkRuns.add(Objects.requireNonNull(element, "checkRuns element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableCheckRunResponseList ImmutableCheckRunResponseList}.
     * @return An immutable instance of CheckRunResponseList
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCheckRunResponseList build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCheckRunResponseList(totalCount, createUnmodifiableList(true, checkRuns));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TOTAL_COUNT) != 0) attributes.add("totalCount");
      return "Cannot build CheckRunResponseList, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
