package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CheckSuite}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCheckSuite.builder()}.
 */
@Generated(from = "CheckSuite", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCheckSuite implements CheckSuite {
  private final Long id;
  private final @Nullable App app;
  private final @Nullable String headBranch;

  private ImmutableCheckSuite(
      Long id,
      @Nullable App app,
      @Nullable String headBranch) {
    this.id = id;
    this.app = app;
    this.headBranch = headBranch;
  }

  /**
   * The Check Suite Id.
   * @return the integer
   */
  @JsonProperty
  @Override
  public Long id() {
    return id;
  }

  /**
   * @return The value of the {@code app} attribute
   */
  @JsonProperty
  @Override
  public Optional<App> app() {
    return Optional.ofNullable(app);
  }

  /**
   * @return The value of the {@code headBranch} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> headBranch() {
    return Optional.ofNullable(headBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckSuite#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckSuite withId(Long value) {
    Long newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableCheckSuite(newValue, this.app, this.headBranch);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CheckSuite#app() app} attribute.
   * @param value The value for app
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckSuite withApp(App value) {
    App newValue = Objects.requireNonNull(value, "app");
    if (this.app == newValue) return this;
    return new ImmutableCheckSuite(this.id, newValue, this.headBranch);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CheckSuite#app() app} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for app
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableCheckSuite withApp(Optional<? extends App> optional) {
    @Nullable App value = optional.orElse(null);
    if (this.app == value) return this;
    return new ImmutableCheckSuite(this.id, value, this.headBranch);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CheckSuite#headBranch() headBranch} attribute.
   * @param value The value for headBranch
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckSuite withHeadBranch(String value) {
    String newValue = Objects.requireNonNull(value, "headBranch");
    if (Objects.equals(this.headBranch, newValue)) return this;
    return new ImmutableCheckSuite(this.id, this.app, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CheckSuite#headBranch() headBranch} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for headBranch
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckSuite withHeadBranch(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.headBranch, value)) return this;
    return new ImmutableCheckSuite(this.id, this.app, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCheckSuite} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCheckSuite
        && equalTo(0, (ImmutableCheckSuite) another);
  }

  private boolean equalTo(int synthetic, ImmutableCheckSuite another) {
    return id.equals(another.id)
        && Objects.equals(app, another.app)
        && Objects.equals(headBranch, another.headBranch);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code app}, {@code headBranch}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(app);
    h += (h << 5) + Objects.hashCode(headBranch);
    return h;
  }

  /**
   * Prints the immutable value {@code CheckSuite} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("CheckSuite{");
    builder.append("id=").append(id);
    if (app != null) {
      builder.append(", ");
      builder.append("app=").append(app);
    }
    if (headBranch != null) {
      builder.append(", ");
      builder.append("headBranch=").append(headBranch);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CheckSuite", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CheckSuite {
    @Nullable Long id;
    @Nullable Optional<App> app = Optional.empty();
    @Nullable Optional<String> headBranch = Optional.empty();
    @JsonProperty
    public void setId(Long id) {
      this.id = id;
    }
    @JsonProperty
    public void setApp(Optional<App> app) {
      this.app = app;
    }
    @JsonProperty
    public void setHeadBranch(Optional<String> headBranch) {
      this.headBranch = headBranch;
    }
    @Override
    public Long id() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<App> app() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> headBranch() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCheckSuite fromJson(Json json) {
    ImmutableCheckSuite.Builder builder = ImmutableCheckSuite.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.app != null) {
      builder.app(json.app);
    }
    if (json.headBranch != null) {
      builder.headBranch(json.headBranch);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CheckSuite} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CheckSuite instance
   */
  public static ImmutableCheckSuite copyOf(CheckSuite instance) {
    if (instance instanceof ImmutableCheckSuite) {
      return (ImmutableCheckSuite) instance;
    }
    return ImmutableCheckSuite.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCheckSuite ImmutableCheckSuite}.
   * <pre>
   * ImmutableCheckSuite.builder()
   *    .id(Long) // required {@link CheckSuite#id() id}
   *    .app(com.spotify.github.v3.checks.App) // optional {@link CheckSuite#app() app}
   *    .headBranch(String) // optional {@link CheckSuite#headBranch() headBranch}
   *    .build();
   * </pre>
   * @return A new ImmutableCheckSuite builder
   */
  public static ImmutableCheckSuite.Builder builder() {
    return new ImmutableCheckSuite.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCheckSuite ImmutableCheckSuite}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CheckSuite", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Long id;
    private @Nullable App app;
    private @Nullable String headBranch;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CheckSuite} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CheckSuite instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.id());
      Optional<App> appOptional = instance.app();
      if (appOptional.isPresent()) {
        app(appOptional);
      }
      Optional<String> headBranchOptional = instance.headBranch();
      if (headBranchOptional.isPresent()) {
        headBranch(headBranchOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CheckSuite#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(Long id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link CheckSuite#app() app} to app.
     * @param app The value for app
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder app(App app) {
      this.app = Objects.requireNonNull(app, "app");
      return this;
    }

    /**
     * Initializes the optional value {@link CheckSuite#app() app} to app.
     * @param app The value for app
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder app(Optional<? extends App> app) {
      this.app = app.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CheckSuite#headBranch() headBranch} to headBranch.
     * @param headBranch The value for headBranch
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder headBranch(String headBranch) {
      this.headBranch = Objects.requireNonNull(headBranch, "headBranch");
      return this;
    }

    /**
     * Initializes the optional value {@link CheckSuite#headBranch() headBranch} to headBranch.
     * @param headBranch The value for headBranch
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder headBranch(Optional<String> headBranch) {
      this.headBranch = headBranch.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCheckSuite ImmutableCheckSuite}.
     * @return An immutable instance of CheckSuite
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCheckSuite build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCheckSuite(id, app, headBranch);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build CheckSuite, some of required attributes are not set " + attributes;
    }
  }
}
