package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link InstallationList}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableInstallationList.builder()}.
 */
@Generated(from = "InstallationList", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableInstallationList implements InstallationList {
  private final int totalCount;
  private final List<Installation> installations;

  private ImmutableInstallationList(int totalCount, List<Installation> installations) {
    this.totalCount = totalCount;
    this.installations = installations;
  }

  /**
   * Count of installations of the App the caller has access to.
   * @see "https://developer.github.com/v3/apps/installations/#list-installations-for-a-user"
   * @return the int
   */
  @JsonProperty
  @Override
  public int totalCount() {
    return totalCount;
  }

  /**
   * Installations list.
   * @return the list
   */
  @JsonProperty
  @Override
  public List<Installation> installations() {
    return installations;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InstallationList#totalCount() totalCount} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for totalCount
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInstallationList withTotalCount(int value) {
    if (this.totalCount == value) return this;
    return new ImmutableInstallationList(value, this.installations);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InstallationList#installations() installations}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInstallationList withInstallations(Installation... elements) {
    List<Installation> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableInstallationList(this.totalCount, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InstallationList#installations() installations}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of installations elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInstallationList withInstallations(Iterable<? extends Installation> elements) {
    if (this.installations == elements) return this;
    List<Installation> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableInstallationList(this.totalCount, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableInstallationList} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableInstallationList
        && equalTo(0, (ImmutableInstallationList) another);
  }

  private boolean equalTo(int synthetic, ImmutableInstallationList another) {
    return totalCount == another.totalCount
        && installations.equals(another.installations);
  }

  /**
   * Computes a hash code from attributes: {@code totalCount}, {@code installations}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + totalCount;
    h += (h << 5) + installations.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code InstallationList} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InstallationList{"
        + "totalCount=" + totalCount
        + ", installations=" + installations
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "InstallationList", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements InstallationList {
    int totalCount;
    boolean totalCountIsSet;
    @Nullable List<Installation> installations = Collections.emptyList();
    @JsonProperty
    public void setTotalCount(int totalCount) {
      this.totalCount = totalCount;
      this.totalCountIsSet = true;
    }
    @JsonProperty
    public void setInstallations(List<Installation> installations) {
      this.installations = installations;
    }
    @Override
    public int totalCount() { throw new UnsupportedOperationException(); }
    @Override
    public List<Installation> installations() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableInstallationList fromJson(Json json) {
    ImmutableInstallationList.Builder builder = ImmutableInstallationList.builder();
    if (json.totalCountIsSet) {
      builder.totalCount(json.totalCount);
    }
    if (json.installations != null) {
      builder.addAllInstallations(json.installations);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link InstallationList} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InstallationList instance
   */
  public static ImmutableInstallationList copyOf(InstallationList instance) {
    if (instance instanceof ImmutableInstallationList) {
      return (ImmutableInstallationList) instance;
    }
    return ImmutableInstallationList.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableInstallationList ImmutableInstallationList}.
   * <pre>
   * ImmutableInstallationList.builder()
   *    .totalCount(int) // required {@link InstallationList#totalCount() totalCount}
   *    .addInstallations|addAllInstallations(com.spotify.github.v3.checks.Installation) // {@link InstallationList#installations() installations} elements
   *    .build();
   * </pre>
   * @return A new ImmutableInstallationList builder
   */
  public static ImmutableInstallationList.Builder builder() {
    return new ImmutableInstallationList.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableInstallationList ImmutableInstallationList}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "InstallationList", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TOTAL_COUNT = 0x1L;
    private long initBits = 0x1L;

    private int totalCount;
    private List<Installation> installations = new ArrayList<Installation>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InstallationList} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(InstallationList instance) {
      Objects.requireNonNull(instance, "instance");
      totalCount(instance.totalCount());
      addAllInstallations(instance.installations());
      return this;
    }

    /**
     * Initializes the value for the {@link InstallationList#totalCount() totalCount} attribute.
     * @param totalCount The value for totalCount 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder totalCount(int totalCount) {
      this.totalCount = totalCount;
      initBits &= ~INIT_BIT_TOTAL_COUNT;
      return this;
    }

    /**
     * Adds one element to {@link InstallationList#installations() installations} list.
     * @param element A installations element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInstallations(Installation element) {
      this.installations.add(Objects.requireNonNull(element, "installations element"));
      return this;
    }

    /**
     * Adds elements to {@link InstallationList#installations() installations} list.
     * @param elements An array of installations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInstallations(Installation... elements) {
      for (Installation element : elements) {
        this.installations.add(Objects.requireNonNull(element, "installations element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link InstallationList#installations() installations} list.
     * @param elements An iterable of installations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder installations(Iterable<? extends Installation> elements) {
      this.installations.clear();
      return addAllInstallations(elements);
    }

    /**
     * Adds elements to {@link InstallationList#installations() installations} list.
     * @param elements An iterable of installations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllInstallations(Iterable<? extends Installation> elements) {
      for (Installation element : elements) {
        this.installations.add(Objects.requireNonNull(element, "installations element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableInstallationList ImmutableInstallationList}.
     * @return An immutable instance of InstallationList
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableInstallationList build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableInstallationList(totalCount, createUnmodifiableList(true, installations));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TOTAL_COUNT) != 0) attributes.add("totalCount");
      return "Cannot build InstallationList, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
