package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Blob}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBlob.builder()}.
 */
@Generated(from = "Blob", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableBlob implements Blob {
  private final @Nullable String sha;
  private final @Nullable URI url;
  private final @Nullable String content;
  private final @Nullable String encoding;
  private final @Nullable Integer size;

  private ImmutableBlob(
      @Nullable String sha,
      @Nullable URI url,
      @Nullable String content,
      @Nullable String encoding,
      @Nullable Integer size) {
    this.sha = sha;
    this.url = url;
    this.content = content;
    this.encoding = encoding;
    this.size = size;
  }

  /**
   *SHA. 
   */
  @JsonProperty
  @Override
  public @Nullable String sha() {
    return sha;
  }

  /**
   *URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *Encoded blob content. 
   */
  @JsonProperty
  @Override
  public @Nullable String content() {
    return content;
  }

  /**
   *Encoding name. Currently, "utf-8" and "base64" are supported. Default: "utf-8". 
   */
  @JsonProperty
  @Override
  public @Nullable String encoding() {
    return encoding;
  }

  /**
   *Content size in bytes. 
   */
  @JsonProperty
  @Override
  public @Nullable Integer size() {
    return size;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Blob#sha() sha} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sha (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBlob withSha(@Nullable String value) {
    if (Objects.equals(this.sha, value)) return this;
    return new ImmutableBlob(value, this.url, this.content, this.encoding, this.size);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Blob#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBlob withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableBlob(this.sha, value, this.content, this.encoding, this.size);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Blob#content() content} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for content (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBlob withContent(@Nullable String value) {
    if (Objects.equals(this.content, value)) return this;
    return new ImmutableBlob(this.sha, this.url, value, this.encoding, this.size);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Blob#encoding() encoding} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for encoding (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBlob withEncoding(@Nullable String value) {
    if (Objects.equals(this.encoding, value)) return this;
    return new ImmutableBlob(this.sha, this.url, this.content, value, this.size);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Blob#size() size} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for size (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBlob withSize(@Nullable Integer value) {
    if (Objects.equals(this.size, value)) return this;
    return new ImmutableBlob(this.sha, this.url, this.content, this.encoding, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBlob} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBlob
        && equalTo(0, (ImmutableBlob) another);
  }

  private boolean equalTo(int synthetic, ImmutableBlob another) {
    return Objects.equals(sha, another.sha)
        && Objects.equals(url, another.url)
        && Objects.equals(content, another.content)
        && Objects.equals(encoding, another.encoding)
        && Objects.equals(size, another.size);
  }

  /**
   * Computes a hash code from attributes: {@code sha}, {@code url}, {@code content}, {@code encoding}, {@code size}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(sha);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(content);
    h += (h << 5) + Objects.hashCode(encoding);
    h += (h << 5) + Objects.hashCode(size);
    return h;
  }

  /**
   * Prints the immutable value {@code Blob} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Blob{"
        + "sha=" + sha
        + ", url=" + url
        + ", content=" + content
        + ", encoding=" + encoding
        + ", size=" + size
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Blob", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Blob {
    @Nullable String sha;
    @Nullable URI url;
    @Nullable String content;
    @Nullable String encoding;
    @Nullable Integer size;
    @JsonProperty
    public void setSha(@Nullable String sha) {
      this.sha = sha;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setContent(@Nullable String content) {
      this.content = content;
    }
    @JsonProperty
    public void setEncoding(@Nullable String encoding) {
      this.encoding = encoding;
    }
    @JsonProperty
    public void setSize(@Nullable Integer size) {
      this.size = size;
    }
    @Override
    public String sha() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public String content() { throw new UnsupportedOperationException(); }
    @Override
    public String encoding() { throw new UnsupportedOperationException(); }
    @Override
    public Integer size() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableBlob fromJson(Json json) {
    ImmutableBlob.Builder builder = ImmutableBlob.builder();
    if (json.sha != null) {
      builder.sha(json.sha);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.content != null) {
      builder.content(json.content);
    }
    if (json.encoding != null) {
      builder.encoding(json.encoding);
    }
    if (json.size != null) {
      builder.size(json.size);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Blob} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Blob instance
   */
  public static ImmutableBlob copyOf(Blob instance) {
    if (instance instanceof ImmutableBlob) {
      return (ImmutableBlob) instance;
    }
    return ImmutableBlob.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBlob ImmutableBlob}.
   * <pre>
   * ImmutableBlob.builder()
   *    .sha(String | null) // nullable {@link Blob#sha() sha}
   *    .url(java.net.URI | null) // nullable {@link Blob#url() url}
   *    .content(String | null) // nullable {@link Blob#content() content}
   *    .encoding(String | null) // nullable {@link Blob#encoding() encoding}
   *    .size(Integer | null) // nullable {@link Blob#size() size}
   *    .build();
   * </pre>
   * @return A new ImmutableBlob builder
   */
  public static ImmutableBlob.Builder builder() {
    return new ImmutableBlob.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBlob ImmutableBlob}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Blob", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String sha;
    private @Nullable URI url;
    private @Nullable String content;
    private @Nullable String encoding;
    private @Nullable Integer size;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.git.ShaLink} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ShaLink instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.git.Blob} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Blob instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof ShaLink) {
        ShaLink instance = (ShaLink) object;
        if ((bits & 0x1L) == 0) {
          @Nullable String shaValue = instance.sha();
          if (shaValue != null) {
            sha(shaValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable URI urlValue = instance.url();
          if (urlValue != null) {
            url(urlValue);
          }
          bits |= 0x2L;
        }
      }
      if (object instanceof Blob) {
        Blob instance = (Blob) object;
        @Nullable Integer sizeValue = instance.size();
        if (sizeValue != null) {
          size(sizeValue);
        }
        @Nullable String encodingValue = instance.encoding();
        if (encodingValue != null) {
          encoding(encodingValue);
        }
        if ((bits & 0x1L) == 0) {
          @Nullable String shaValue = instance.sha();
          if (shaValue != null) {
            sha(shaValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable URI urlValue = instance.url();
          if (urlValue != null) {
            url(urlValue);
          }
          bits |= 0x2L;
        }
        @Nullable String contentValue = instance.content();
        if (contentValue != null) {
          content(contentValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link Blob#sha() sha} attribute.
     * @param sha The value for sha (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sha(@Nullable String sha) {
      this.sha = sha;
      return this;
    }

    /**
     * Initializes the value for the {@link Blob#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link Blob#content() content} attribute.
     * @param content The value for content (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder content(@Nullable String content) {
      this.content = content;
      return this;
    }

    /**
     * Initializes the value for the {@link Blob#encoding() encoding} attribute.
     * @param encoding The value for encoding (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder encoding(@Nullable String encoding) {
      this.encoding = encoding;
      return this;
    }

    /**
     * Initializes the value for the {@link Blob#size() size} attribute.
     * @param size The value for size (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder size(@Nullable Integer size) {
      this.size = size;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBlob ImmutableBlob}.
     * @return An immutable instance of Blob
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBlob build() {
      return new ImmutableBlob(sha, url, content, encoding, size);
    }
  }
}
