package com.spotify.github.v3.issues;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.GitHubInstant;
import com.spotify.github.v3.User;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Event}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEvent.builder()}.
 */
@Generated(from = "Event", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableEvent implements Event {
  private final @Nullable Integer id;
  private final @Nullable URI url;
  private final @Nullable User actor;
  private final @Nullable String event;
  private final @Nullable String commitId;
  private final @Nullable URI commitUrl;
  private final @Nullable GitHubInstant createdAt;
  private final @Nullable Issue issue;

  private ImmutableEvent(
      @Nullable Integer id,
      @Nullable URI url,
      @Nullable User actor,
      @Nullable String event,
      @Nullable String commitId,
      @Nullable URI commitUrl,
      @Nullable GitHubInstant createdAt,
      @Nullable Issue issue) {
    this.id = id;
    this.url = url;
    this.actor = actor;
    this.event = event;
    this.commitId = commitId;
    this.commitUrl = commitUrl;
    this.createdAt = createdAt;
    this.issue = issue;
  }

  /**
   *The Integer ID of the event. 
   */
  @JsonProperty
  @Override
  public @Nullable Integer id() {
    return id;
  }

  /**
   *The API URL for fetching the event. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *The User object that generated the event. 
   */
  @JsonProperty
  @Override
  public @Nullable User actor() {
    return actor;
  }

  /**
   *Identifies the actual type of Event that occurred. 
   */
  @JsonProperty
  @Override
  public @Nullable String event() {
    return event;
  }

  /**
   *The String SHA of a commit that referenced this Issue. 
   */
  @JsonProperty
  @Override
  public @Nullable String commitId() {
    return commitId;
  }

  /**
   *The GitHub API link to a commit that referenced this Issue. 
   */
  @JsonProperty
  @Override
  public @Nullable URI commitUrl() {
    return commitUrl;
  }

  /**
   *The timestamp indicating when the event occurred. 
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant createdAt() {
    return createdAt;
  }

  /**
   *Issue. 
   */
  @JsonProperty
  @Override
  public Optional<Issue> issue() {
    return Optional.ofNullable(issue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Event#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvent withId(@Nullable Integer value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableEvent(
        value,
        this.url,
        this.actor,
        this.event,
        this.commitId,
        this.commitUrl,
        this.createdAt,
        this.issue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Event#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvent withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableEvent(
        this.id,
        value,
        this.actor,
        this.event,
        this.commitId,
        this.commitUrl,
        this.createdAt,
        this.issue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Event#actor() actor} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for actor (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvent withActor(@Nullable User value) {
    if (this.actor == value) return this;
    return new ImmutableEvent(this.id, this.url, value, this.event, this.commitId, this.commitUrl, this.createdAt, this.issue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Event#event() event} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for event (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvent withEvent(@Nullable String value) {
    if (Objects.equals(this.event, value)) return this;
    return new ImmutableEvent(this.id, this.url, this.actor, value, this.commitId, this.commitUrl, this.createdAt, this.issue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Event#commitId() commitId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commitId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvent withCommitId(@Nullable String value) {
    if (Objects.equals(this.commitId, value)) return this;
    return new ImmutableEvent(this.id, this.url, this.actor, this.event, value, this.commitUrl, this.createdAt, this.issue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Event#commitUrl() commitUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commitUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvent withCommitUrl(@Nullable URI value) {
    if (this.commitUrl == value) return this;
    return new ImmutableEvent(this.id, this.url, this.actor, this.event, this.commitId, value, this.createdAt, this.issue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Event#createdAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvent withCreatedAt(@Nullable GitHubInstant value) {
    if (this.createdAt == value) return this;
    return new ImmutableEvent(this.id, this.url, this.actor, this.event, this.commitId, this.commitUrl, value, this.issue);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Event#issue() issue} attribute.
   * @param value The value for issue
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvent withIssue(Issue value) {
    Issue newValue = Objects.requireNonNull(value, "issue");
    if (this.issue == newValue) return this;
    return new ImmutableEvent(
        this.id,
        this.url,
        this.actor,
        this.event,
        this.commitId,
        this.commitUrl,
        this.createdAt,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Event#issue() issue} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for issue
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableEvent withIssue(Optional<? extends Issue> optional) {
    @Nullable Issue value = optional.orElse(null);
    if (this.issue == value) return this;
    return new ImmutableEvent(this.id, this.url, this.actor, this.event, this.commitId, this.commitUrl, this.createdAt, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEvent
        && equalTo(0, (ImmutableEvent) another);
  }

  private boolean equalTo(int synthetic, ImmutableEvent another) {
    return Objects.equals(id, another.id)
        && Objects.equals(url, another.url)
        && Objects.equals(actor, another.actor)
        && Objects.equals(event, another.event)
        && Objects.equals(commitId, another.commitId)
        && Objects.equals(commitUrl, another.commitUrl)
        && Objects.equals(createdAt, another.createdAt)
        && Objects.equals(issue, another.issue);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code url}, {@code actor}, {@code event}, {@code commitId}, {@code commitUrl}, {@code createdAt}, {@code issue}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(actor);
    h += (h << 5) + Objects.hashCode(event);
    h += (h << 5) + Objects.hashCode(commitId);
    h += (h << 5) + Objects.hashCode(commitUrl);
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(issue);
    return h;
  }

  /**
   * Prints the immutable value {@code Event} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Event{");
    if (id != null) {
      builder.append("id=").append(id);
    }
    if (url != null) {
      if (builder.length() > 6) builder.append(", ");
      builder.append("url=").append(url);
    }
    if (actor != null) {
      if (builder.length() > 6) builder.append(", ");
      builder.append("actor=").append(actor);
    }
    if (event != null) {
      if (builder.length() > 6) builder.append(", ");
      builder.append("event=").append(event);
    }
    if (commitId != null) {
      if (builder.length() > 6) builder.append(", ");
      builder.append("commitId=").append(commitId);
    }
    if (commitUrl != null) {
      if (builder.length() > 6) builder.append(", ");
      builder.append("commitUrl=").append(commitUrl);
    }
    if (createdAt != null) {
      if (builder.length() > 6) builder.append(", ");
      builder.append("createdAt=").append(createdAt);
    }
    if (issue != null) {
      if (builder.length() > 6) builder.append(", ");
      builder.append("issue=").append(issue);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Event", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Event {
    @Nullable Integer id;
    @Nullable URI url;
    @Nullable User actor;
    @Nullable String event;
    @Nullable String commitId;
    @Nullable URI commitUrl;
    @Nullable GitHubInstant createdAt;
    @Nullable Optional<Issue> issue = Optional.empty();
    @JsonProperty
    public void setId(@Nullable Integer id) {
      this.id = id;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setActor(@Nullable User actor) {
      this.actor = actor;
    }
    @JsonProperty
    public void setEvent(@Nullable String event) {
      this.event = event;
    }
    @JsonProperty
    public void setCommitId(@Nullable String commitId) {
      this.commitId = commitId;
    }
    @JsonProperty
    public void setCommitUrl(@Nullable URI commitUrl) {
      this.commitUrl = commitUrl;
    }
    @JsonProperty
    public void setCreatedAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty
    public void setIssue(Optional<Issue> issue) {
      this.issue = issue;
    }
    @Override
    public Integer id() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public User actor() { throw new UnsupportedOperationException(); }
    @Override
    public String event() { throw new UnsupportedOperationException(); }
    @Override
    public String commitId() { throw new UnsupportedOperationException(); }
    @Override
    public URI commitUrl() { throw new UnsupportedOperationException(); }
    @Override
    public GitHubInstant createdAt() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Issue> issue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableEvent fromJson(Json json) {
    ImmutableEvent.Builder builder = ImmutableEvent.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.actor != null) {
      builder.actor(json.actor);
    }
    if (json.event != null) {
      builder.event(json.event);
    }
    if (json.commitId != null) {
      builder.commitId(json.commitId);
    }
    if (json.commitUrl != null) {
      builder.commitUrl(json.commitUrl);
    }
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.issue != null) {
      builder.issue(json.issue);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Event} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Event instance
   */
  public static ImmutableEvent copyOf(Event instance) {
    if (instance instanceof ImmutableEvent) {
      return (ImmutableEvent) instance;
    }
    return ImmutableEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEvent ImmutableEvent}.
   * <pre>
   * ImmutableEvent.builder()
   *    .id(Integer | null) // nullable {@link Event#id() id}
   *    .url(java.net.URI | null) // nullable {@link Event#url() url}
   *    .actor(com.spotify.github.v3.User | null) // nullable {@link Event#actor() actor}
   *    .event(String | null) // nullable {@link Event#event() event}
   *    .commitId(String | null) // nullable {@link Event#commitId() commitId}
   *    .commitUrl(java.net.URI | null) // nullable {@link Event#commitUrl() commitUrl}
   *    .createdAt(com.spotify.github.GitHubInstant | null) // nullable {@link Event#createdAt() createdAt}
   *    .issue(com.spotify.github.v3.issues.Issue) // optional {@link Event#issue() issue}
   *    .build();
   * </pre>
   * @return A new ImmutableEvent builder
   */
  public static ImmutableEvent.Builder builder() {
    return new ImmutableEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEvent ImmutableEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Event", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Integer id;
    private @Nullable URI url;
    private @Nullable User actor;
    private @Nullable String event;
    private @Nullable String commitId;
    private @Nullable URI commitUrl;
    private @Nullable GitHubInstant createdAt;
    private @Nullable Issue issue;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Event} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Event instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Integer idValue = instance.id();
      if (idValue != null) {
        id(idValue);
      }
      @Nullable URI urlValue = instance.url();
      if (urlValue != null) {
        url(urlValue);
      }
      @Nullable User actorValue = instance.actor();
      if (actorValue != null) {
        actor(actorValue);
      }
      @Nullable String eventValue = instance.event();
      if (eventValue != null) {
        event(eventValue);
      }
      @Nullable String commitIdValue = instance.commitId();
      if (commitIdValue != null) {
        commitId(commitIdValue);
      }
      @Nullable URI commitUrlValue = instance.commitUrl();
      if (commitUrlValue != null) {
        commitUrl(commitUrlValue);
      }
      @Nullable GitHubInstant createdAtValue = instance.createdAt();
      if (createdAtValue != null) {
        createdAt(createdAtValue);
      }
      Optional<Issue> issueOptional = instance.issue();
      if (issueOptional.isPresent()) {
        issue(issueOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Event#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(@Nullable Integer id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Event#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link Event#actor() actor} attribute.
     * @param actor The value for actor (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder actor(@Nullable User actor) {
      this.actor = actor;
      return this;
    }

    /**
     * Initializes the value for the {@link Event#event() event} attribute.
     * @param event The value for event (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder event(@Nullable String event) {
      this.event = event;
      return this;
    }

    /**
     * Initializes the value for the {@link Event#commitId() commitId} attribute.
     * @param commitId The value for commitId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commitId(@Nullable String commitId) {
      this.commitId = commitId;
      return this;
    }

    /**
     * Initializes the value for the {@link Event#commitUrl() commitUrl} attribute.
     * @param commitUrl The value for commitUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commitUrl(@Nullable URI commitUrl) {
      this.commitUrl = commitUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link Event#createdAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder createdAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the optional value {@link Event#issue() issue} to issue.
     * @param issue The value for issue
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder issue(Issue issue) {
      this.issue = Objects.requireNonNull(issue, "issue");
      return this;
    }

    /**
     * Initializes the optional value {@link Event#issue() issue} to issue.
     * @param issue The value for issue
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder issue(Optional<? extends Issue> issue) {
      this.issue = issue.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableEvent ImmutableEvent}.
     * @return An immutable instance of Event
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEvent build() {
      return new ImmutableEvent(id, url, actor, event, commitId, commitUrl, createdAt, issue);
    }
  }
}
