package com.spotify.github.v3.issues;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PullRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePullRequest.builder()}.
 */
@Generated(from = "PullRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePullRequest implements PullRequest {
  private final @Nullable URI url;
  private final @Nullable URI htmlUrl;
  private final @Nullable URI diffUrl;
  private final @Nullable URI patchUrl;

  private ImmutablePullRequest(
      @Nullable URI url,
      @Nullable URI htmlUrl,
      @Nullable URI diffUrl,
      @Nullable URI patchUrl) {
    this.url = url;
    this.htmlUrl = htmlUrl;
    this.diffUrl = diffUrl;
    this.patchUrl = patchUrl;
  }

  /**
   *URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *HTML URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI htmlUrl() {
    return htmlUrl;
  }

  /**
   *Diff URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI diffUrl() {
    return diffUrl;
  }

  /**
   *Patch URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI patchUrl() {
    return patchUrl;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutablePullRequest(value, this.htmlUrl, this.diffUrl, this.patchUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#htmlUrl() htmlUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for htmlUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withHtmlUrl(@Nullable URI value) {
    if (this.htmlUrl == value) return this;
    return new ImmutablePullRequest(this.url, value, this.diffUrl, this.patchUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#diffUrl() diffUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for diffUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withDiffUrl(@Nullable URI value) {
    if (this.diffUrl == value) return this;
    return new ImmutablePullRequest(this.url, this.htmlUrl, value, this.patchUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#patchUrl() patchUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for patchUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withPatchUrl(@Nullable URI value) {
    if (this.patchUrl == value) return this;
    return new ImmutablePullRequest(this.url, this.htmlUrl, this.diffUrl, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePullRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePullRequest
        && equalTo(0, (ImmutablePullRequest) another);
  }

  private boolean equalTo(int synthetic, ImmutablePullRequest another) {
    return Objects.equals(url, another.url)
        && Objects.equals(htmlUrl, another.htmlUrl)
        && Objects.equals(diffUrl, another.diffUrl)
        && Objects.equals(patchUrl, another.patchUrl);
  }

  /**
   * Computes a hash code from attributes: {@code url}, {@code htmlUrl}, {@code diffUrl}, {@code patchUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(htmlUrl);
    h += (h << 5) + Objects.hashCode(diffUrl);
    h += (h << 5) + Objects.hashCode(patchUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code PullRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PullRequest{"
        + "url=" + url
        + ", htmlUrl=" + htmlUrl
        + ", diffUrl=" + diffUrl
        + ", patchUrl=" + patchUrl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PullRequest", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PullRequest {
    @Nullable URI url;
    @Nullable URI htmlUrl;
    @Nullable URI diffUrl;
    @Nullable URI patchUrl;
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setHtmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
    }
    @JsonProperty
    public void setDiffUrl(@Nullable URI diffUrl) {
      this.diffUrl = diffUrl;
    }
    @JsonProperty
    public void setPatchUrl(@Nullable URI patchUrl) {
      this.patchUrl = patchUrl;
    }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public URI htmlUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI diffUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI patchUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePullRequest fromJson(Json json) {
    ImmutablePullRequest.Builder builder = ImmutablePullRequest.builder();
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.htmlUrl != null) {
      builder.htmlUrl(json.htmlUrl);
    }
    if (json.diffUrl != null) {
      builder.diffUrl(json.diffUrl);
    }
    if (json.patchUrl != null) {
      builder.patchUrl(json.patchUrl);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PullRequest} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PullRequest instance
   */
  public static ImmutablePullRequest copyOf(PullRequest instance) {
    if (instance instanceof ImmutablePullRequest) {
      return (ImmutablePullRequest) instance;
    }
    return ImmutablePullRequest.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePullRequest ImmutablePullRequest}.
   * <pre>
   * ImmutablePullRequest.builder()
   *    .url(java.net.URI | null) // nullable {@link PullRequest#url() url}
   *    .htmlUrl(java.net.URI | null) // nullable {@link PullRequest#htmlUrl() htmlUrl}
   *    .diffUrl(java.net.URI | null) // nullable {@link PullRequest#diffUrl() diffUrl}
   *    .patchUrl(java.net.URI | null) // nullable {@link PullRequest#patchUrl() patchUrl}
   *    .build();
   * </pre>
   * @return A new ImmutablePullRequest builder
   */
  public static ImmutablePullRequest.Builder builder() {
    return new ImmutablePullRequest.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePullRequest ImmutablePullRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PullRequest", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable URI url;
    private @Nullable URI htmlUrl;
    private @Nullable URI diffUrl;
    private @Nullable URI patchUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PullRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PullRequest instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable URI urlValue = instance.url();
      if (urlValue != null) {
        url(urlValue);
      }
      @Nullable URI htmlUrlValue = instance.htmlUrl();
      if (htmlUrlValue != null) {
        htmlUrl(htmlUrlValue);
      }
      @Nullable URI diffUrlValue = instance.diffUrl();
      if (diffUrlValue != null) {
        diffUrl(diffUrlValue);
      }
      @Nullable URI patchUrlValue = instance.patchUrl();
      if (patchUrlValue != null) {
        patchUrl(patchUrlValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#htmlUrl() htmlUrl} attribute.
     * @param htmlUrl The value for htmlUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder htmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#diffUrl() diffUrl} attribute.
     * @param diffUrl The value for diffUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder diffUrl(@Nullable URI diffUrl) {
      this.diffUrl = diffUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#patchUrl() patchUrl} attribute.
     * @param patchUrl The value for patchUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder patchUrl(@Nullable URI patchUrl) {
      this.patchUrl = patchUrl;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePullRequest ImmutablePullRequest}.
     * @return An immutable instance of PullRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePullRequest build() {
      return new ImmutablePullRequest(url, htmlUrl, diffUrl, patchUrl);
    }
  }
}
