package com.spotify.github.v3.orgs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.User;
import com.spotify.github.v3.repos.Organization;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OrgMembership}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOrgMembership.builder()}.
 */
@Generated(from = "OrgMembership", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableOrgMembership implements OrgMembership {
  private final @Nullable URI url;
  private final @Nullable String role;
  private final @Nullable String state;
  private final @Nullable Organization organization;
  private final @Nullable User user;

  private ImmutableOrgMembership(
      @Nullable URI url,
      @Nullable String role,
      @Nullable String state,
      @Nullable Organization organization,
      @Nullable User user) {
    this.url = url;
    this.role = role;
    this.state = state;
    this.organization = organization;
    this.user = user;
  }

  /**
   *URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *ROLE 
   */
  @JsonProperty
  @Override
  public @Nullable String role() {
    return role;
  }

  /**
   *STATE 
   */
  @JsonProperty
  @Override
  public @Nullable String state() {
    return state;
  }

  /**
   * @return The value of the {@code organization} attribute
   */
  @JsonProperty
  @Override
  public @Nullable Organization organization() {
    return organization;
  }

  /**
   *USER 
   */
  @JsonProperty
  @Override
  public @Nullable User user() {
    return user;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OrgMembership#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOrgMembership withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableOrgMembership(value, this.role, this.state, this.organization, this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OrgMembership#role() role} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for role (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOrgMembership withRole(@Nullable String value) {
    if (Objects.equals(this.role, value)) return this;
    return new ImmutableOrgMembership(this.url, value, this.state, this.organization, this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OrgMembership#state() state} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for state (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOrgMembership withState(@Nullable String value) {
    if (Objects.equals(this.state, value)) return this;
    return new ImmutableOrgMembership(this.url, this.role, value, this.organization, this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OrgMembership#organization() organization} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for organization (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOrgMembership withOrganization(@Nullable Organization value) {
    if (this.organization == value) return this;
    return new ImmutableOrgMembership(this.url, this.role, this.state, value, this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OrgMembership#user() user} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for user (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOrgMembership withUser(@Nullable User value) {
    if (this.user == value) return this;
    return new ImmutableOrgMembership(this.url, this.role, this.state, this.organization, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOrgMembership} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOrgMembership
        && equalTo(0, (ImmutableOrgMembership) another);
  }

  private boolean equalTo(int synthetic, ImmutableOrgMembership another) {
    return Objects.equals(url, another.url)
        && Objects.equals(role, another.role)
        && Objects.equals(state, another.state)
        && Objects.equals(organization, another.organization)
        && Objects.equals(user, another.user);
  }

  /**
   * Computes a hash code from attributes: {@code url}, {@code role}, {@code state}, {@code organization}, {@code user}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(role);
    h += (h << 5) + Objects.hashCode(state);
    h += (h << 5) + Objects.hashCode(organization);
    h += (h << 5) + Objects.hashCode(user);
    return h;
  }

  /**
   * Prints the immutable value {@code OrgMembership} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OrgMembership{"
        + "url=" + url
        + ", role=" + role
        + ", state=" + state
        + ", organization=" + organization
        + ", user=" + user
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "OrgMembership", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements OrgMembership {
    @Nullable URI url;
    @Nullable String role;
    @Nullable String state;
    @Nullable Organization organization;
    @Nullable User user;
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setRole(@Nullable String role) {
      this.role = role;
    }
    @JsonProperty
    public void setState(@Nullable String state) {
      this.state = state;
    }
    @JsonProperty
    public void setOrganization(@Nullable Organization organization) {
      this.organization = organization;
    }
    @JsonProperty
    public void setUser(@Nullable User user) {
      this.user = user;
    }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public String role() { throw new UnsupportedOperationException(); }
    @Override
    public String state() { throw new UnsupportedOperationException(); }
    @Override
    public Organization organization() { throw new UnsupportedOperationException(); }
    @Override
    public User user() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableOrgMembership fromJson(Json json) {
    ImmutableOrgMembership.Builder builder = ImmutableOrgMembership.builder();
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.role != null) {
      builder.role(json.role);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.organization != null) {
      builder.organization(json.organization);
    }
    if (json.user != null) {
      builder.user(json.user);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link OrgMembership} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OrgMembership instance
   */
  public static ImmutableOrgMembership copyOf(OrgMembership instance) {
    if (instance instanceof ImmutableOrgMembership) {
      return (ImmutableOrgMembership) instance;
    }
    return ImmutableOrgMembership.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOrgMembership ImmutableOrgMembership}.
   * <pre>
   * ImmutableOrgMembership.builder()
   *    .url(java.net.URI | null) // nullable {@link OrgMembership#url() url}
   *    .role(String | null) // nullable {@link OrgMembership#role() role}
   *    .state(String | null) // nullable {@link OrgMembership#state() state}
   *    .organization(com.spotify.github.v3.repos.Organization | null) // nullable {@link OrgMembership#organization() organization}
   *    .user(com.spotify.github.v3.User | null) // nullable {@link OrgMembership#user() user}
   *    .build();
   * </pre>
   * @return A new ImmutableOrgMembership builder
   */
  public static ImmutableOrgMembership.Builder builder() {
    return new ImmutableOrgMembership.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOrgMembership ImmutableOrgMembership}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OrgMembership", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable URI url;
    private @Nullable String role;
    private @Nullable String state;
    private @Nullable Organization organization;
    private @Nullable User user;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OrgMembership} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(OrgMembership instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable URI urlValue = instance.url();
      if (urlValue != null) {
        url(urlValue);
      }
      @Nullable String roleValue = instance.role();
      if (roleValue != null) {
        role(roleValue);
      }
      @Nullable String stateValue = instance.state();
      if (stateValue != null) {
        state(stateValue);
      }
      @Nullable Organization organizationValue = instance.organization();
      if (organizationValue != null) {
        organization(organizationValue);
      }
      @Nullable User userValue = instance.user();
      if (userValue != null) {
        user(userValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link OrgMembership#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link OrgMembership#role() role} attribute.
     * @param role The value for role (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder role(@Nullable String role) {
      this.role = role;
      return this;
    }

    /**
     * Initializes the value for the {@link OrgMembership#state() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the value for the {@link OrgMembership#organization() organization} attribute.
     * @param organization The value for organization (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder organization(@Nullable Organization organization) {
      this.organization = organization;
      return this;
    }

    /**
     * Initializes the value for the {@link OrgMembership#user() user} attribute.
     * @param user The value for user (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder user(@Nullable User user) {
      this.user = user;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOrgMembership ImmutableOrgMembership}.
     * @return An immutable instance of OrgMembership
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOrgMembership build() {
      return new ImmutableOrgMembership(url, role, state, organization, user);
    }
  }
}
