package com.spotify.github.v3.orgs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.User;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TeamInvitation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTeamInvitation.builder()}.
 */
@Generated(from = "TeamInvitation", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTeamInvitation implements TeamInvitation {
  private final @Nullable Integer id;
  private final @Nullable String login;
  private final @Nullable String nodeId;
  private final @Nullable String email;
  private final @Nullable String role;
  private final @Nullable String failedReason;
  private final @Nullable User inviter;
  private final @Nullable Integer teamCount;
  private final @Nullable URI invitationTeamsUrl;
  private final @Nullable String invitationSource;

  private ImmutableTeamInvitation(
      @Nullable Integer id,
      @Nullable String login,
      @Nullable String nodeId,
      @Nullable String email,
      @Nullable String role,
      @Nullable String failedReason,
      @Nullable User inviter,
      @Nullable Integer teamCount,
      @Nullable URI invitationTeamsUrl,
      @Nullable String invitationSource) {
    this.id = id;
    this.login = login;
    this.nodeId = nodeId;
    this.email = email;
    this.role = role;
    this.failedReason = failedReason;
    this.inviter = inviter;
    this.teamCount = teamCount;
    this.invitationTeamsUrl = invitationTeamsUrl;
    this.invitationSource = invitationSource;
  }

  /**
   *ID 
   */
  @JsonProperty
  @Override
  public @Nullable Integer id() {
    return id;
  }

  /**
   *login username 
   */
  @JsonProperty
  @Override
  public @Nullable String login() {
    return login;
  }

  /**
   *Node ID 
   */
  @JsonProperty
  @Override
  public @Nullable String nodeId() {
    return nodeId;
  }

  /**
   *Email address 
   */
  @JsonProperty
  @Override
  public @Nullable String email() {
    return email;
  }

  /**
   *Role 
   */
  @JsonProperty
  @Override
  public @Nullable String role() {
    return role;
  }

  /**
   *Failed reason 
   */
  @JsonProperty
  @Override
  public @Nullable String failedReason() {
    return failedReason;
  }

  /**
   *Inviter 
   */
  @JsonProperty
  @Override
  public @Nullable User inviter() {
    return inviter;
  }

  /**
   *Team Count 
   */
  @JsonProperty
  @Override
  public @Nullable Integer teamCount() {
    return teamCount;
  }

  /**
   *Invitation Teams URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI invitationTeamsUrl() {
    return invitationTeamsUrl;
  }

  /**
   *Invitation Source 
   */
  @JsonProperty
  @Override
  public @Nullable String invitationSource() {
    return invitationSource;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TeamInvitation#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeamInvitation withId(@Nullable Integer value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableTeamInvitation(
        value,
        this.login,
        this.nodeId,
        this.email,
        this.role,
        this.failedReason,
        this.inviter,
        this.teamCount,
        this.invitationTeamsUrl,
        this.invitationSource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TeamInvitation#login() login} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for login (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeamInvitation withLogin(@Nullable String value) {
    if (Objects.equals(this.login, value)) return this;
    return new ImmutableTeamInvitation(
        this.id,
        value,
        this.nodeId,
        this.email,
        this.role,
        this.failedReason,
        this.inviter,
        this.teamCount,
        this.invitationTeamsUrl,
        this.invitationSource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TeamInvitation#nodeId() nodeId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nodeId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeamInvitation withNodeId(@Nullable String value) {
    if (Objects.equals(this.nodeId, value)) return this;
    return new ImmutableTeamInvitation(
        this.id,
        this.login,
        value,
        this.email,
        this.role,
        this.failedReason,
        this.inviter,
        this.teamCount,
        this.invitationTeamsUrl,
        this.invitationSource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TeamInvitation#email() email} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for email (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeamInvitation withEmail(@Nullable String value) {
    if (Objects.equals(this.email, value)) return this;
    return new ImmutableTeamInvitation(
        this.id,
        this.login,
        this.nodeId,
        value,
        this.role,
        this.failedReason,
        this.inviter,
        this.teamCount,
        this.invitationTeamsUrl,
        this.invitationSource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TeamInvitation#role() role} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for role (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeamInvitation withRole(@Nullable String value) {
    if (Objects.equals(this.role, value)) return this;
    return new ImmutableTeamInvitation(
        this.id,
        this.login,
        this.nodeId,
        this.email,
        value,
        this.failedReason,
        this.inviter,
        this.teamCount,
        this.invitationTeamsUrl,
        this.invitationSource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TeamInvitation#failedReason() failedReason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for failedReason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeamInvitation withFailedReason(@Nullable String value) {
    if (Objects.equals(this.failedReason, value)) return this;
    return new ImmutableTeamInvitation(
        this.id,
        this.login,
        this.nodeId,
        this.email,
        this.role,
        value,
        this.inviter,
        this.teamCount,
        this.invitationTeamsUrl,
        this.invitationSource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TeamInvitation#inviter() inviter} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for inviter (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeamInvitation withInviter(@Nullable User value) {
    if (this.inviter == value) return this;
    return new ImmutableTeamInvitation(
        this.id,
        this.login,
        this.nodeId,
        this.email,
        this.role,
        this.failedReason,
        value,
        this.teamCount,
        this.invitationTeamsUrl,
        this.invitationSource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TeamInvitation#teamCount() teamCount} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for teamCount (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeamInvitation withTeamCount(@Nullable Integer value) {
    if (Objects.equals(this.teamCount, value)) return this;
    return new ImmutableTeamInvitation(
        this.id,
        this.login,
        this.nodeId,
        this.email,
        this.role,
        this.failedReason,
        this.inviter,
        value,
        this.invitationTeamsUrl,
        this.invitationSource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TeamInvitation#invitationTeamsUrl() invitationTeamsUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for invitationTeamsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeamInvitation withInvitationTeamsUrl(@Nullable URI value) {
    if (this.invitationTeamsUrl == value) return this;
    return new ImmutableTeamInvitation(
        this.id,
        this.login,
        this.nodeId,
        this.email,
        this.role,
        this.failedReason,
        this.inviter,
        this.teamCount,
        value,
        this.invitationSource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TeamInvitation#invitationSource() invitationSource} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for invitationSource (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeamInvitation withInvitationSource(@Nullable String value) {
    if (Objects.equals(this.invitationSource, value)) return this;
    return new ImmutableTeamInvitation(
        this.id,
        this.login,
        this.nodeId,
        this.email,
        this.role,
        this.failedReason,
        this.inviter,
        this.teamCount,
        this.invitationTeamsUrl,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTeamInvitation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTeamInvitation
        && equalTo(0, (ImmutableTeamInvitation) another);
  }

  private boolean equalTo(int synthetic, ImmutableTeamInvitation another) {
    return Objects.equals(id, another.id)
        && Objects.equals(login, another.login)
        && Objects.equals(nodeId, another.nodeId)
        && Objects.equals(email, another.email)
        && Objects.equals(role, another.role)
        && Objects.equals(failedReason, another.failedReason)
        && Objects.equals(inviter, another.inviter)
        && Objects.equals(teamCount, another.teamCount)
        && Objects.equals(invitationTeamsUrl, another.invitationTeamsUrl)
        && Objects.equals(invitationSource, another.invitationSource);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code login}, {@code nodeId}, {@code email}, {@code role}, {@code failedReason}, {@code inviter}, {@code teamCount}, {@code invitationTeamsUrl}, {@code invitationSource}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(login);
    h += (h << 5) + Objects.hashCode(nodeId);
    h += (h << 5) + Objects.hashCode(email);
    h += (h << 5) + Objects.hashCode(role);
    h += (h << 5) + Objects.hashCode(failedReason);
    h += (h << 5) + Objects.hashCode(inviter);
    h += (h << 5) + Objects.hashCode(teamCount);
    h += (h << 5) + Objects.hashCode(invitationTeamsUrl);
    h += (h << 5) + Objects.hashCode(invitationSource);
    return h;
  }

  /**
   * Prints the immutable value {@code TeamInvitation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TeamInvitation{"
        + "id=" + id
        + ", login=" + login
        + ", nodeId=" + nodeId
        + ", email=" + email
        + ", role=" + role
        + ", failedReason=" + failedReason
        + ", inviter=" + inviter
        + ", teamCount=" + teamCount
        + ", invitationTeamsUrl=" + invitationTeamsUrl
        + ", invitationSource=" + invitationSource
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TeamInvitation", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements TeamInvitation {
    @Nullable Integer id;
    @Nullable String login;
    @Nullable String nodeId;
    @Nullable String email;
    @Nullable String role;
    @Nullable String failedReason;
    @Nullable User inviter;
    @Nullable Integer teamCount;
    @Nullable URI invitationTeamsUrl;
    @Nullable String invitationSource;
    @JsonProperty
    public void setId(@Nullable Integer id) {
      this.id = id;
    }
    @JsonProperty
    public void setLogin(@Nullable String login) {
      this.login = login;
    }
    @JsonProperty
    public void setNodeId(@Nullable String nodeId) {
      this.nodeId = nodeId;
    }
    @JsonProperty
    public void setEmail(@Nullable String email) {
      this.email = email;
    }
    @JsonProperty
    public void setRole(@Nullable String role) {
      this.role = role;
    }
    @JsonProperty
    public void setFailedReason(@Nullable String failedReason) {
      this.failedReason = failedReason;
    }
    @JsonProperty
    public void setInviter(@Nullable User inviter) {
      this.inviter = inviter;
    }
    @JsonProperty
    public void setTeamCount(@Nullable Integer teamCount) {
      this.teamCount = teamCount;
    }
    @JsonProperty
    public void setInvitationTeamsUrl(@Nullable URI invitationTeamsUrl) {
      this.invitationTeamsUrl = invitationTeamsUrl;
    }
    @JsonProperty
    public void setInvitationSource(@Nullable String invitationSource) {
      this.invitationSource = invitationSource;
    }
    @Override
    public Integer id() { throw new UnsupportedOperationException(); }
    @Override
    public String login() { throw new UnsupportedOperationException(); }
    @Override
    public String nodeId() { throw new UnsupportedOperationException(); }
    @Override
    public String email() { throw new UnsupportedOperationException(); }
    @Override
    public String role() { throw new UnsupportedOperationException(); }
    @Override
    public String failedReason() { throw new UnsupportedOperationException(); }
    @Override
    public User inviter() { throw new UnsupportedOperationException(); }
    @Override
    public Integer teamCount() { throw new UnsupportedOperationException(); }
    @Override
    public URI invitationTeamsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String invitationSource() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTeamInvitation fromJson(Json json) {
    ImmutableTeamInvitation.Builder builder = ImmutableTeamInvitation.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.login != null) {
      builder.login(json.login);
    }
    if (json.nodeId != null) {
      builder.nodeId(json.nodeId);
    }
    if (json.email != null) {
      builder.email(json.email);
    }
    if (json.role != null) {
      builder.role(json.role);
    }
    if (json.failedReason != null) {
      builder.failedReason(json.failedReason);
    }
    if (json.inviter != null) {
      builder.inviter(json.inviter);
    }
    if (json.teamCount != null) {
      builder.teamCount(json.teamCount);
    }
    if (json.invitationTeamsUrl != null) {
      builder.invitationTeamsUrl(json.invitationTeamsUrl);
    }
    if (json.invitationSource != null) {
      builder.invitationSource(json.invitationSource);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TeamInvitation} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TeamInvitation instance
   */
  public static ImmutableTeamInvitation copyOf(TeamInvitation instance) {
    if (instance instanceof ImmutableTeamInvitation) {
      return (ImmutableTeamInvitation) instance;
    }
    return ImmutableTeamInvitation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTeamInvitation ImmutableTeamInvitation}.
   * <pre>
   * ImmutableTeamInvitation.builder()
   *    .id(Integer | null) // nullable {@link TeamInvitation#id() id}
   *    .login(String | null) // nullable {@link TeamInvitation#login() login}
   *    .nodeId(String | null) // nullable {@link TeamInvitation#nodeId() nodeId}
   *    .email(String | null) // nullable {@link TeamInvitation#email() email}
   *    .role(String | null) // nullable {@link TeamInvitation#role() role}
   *    .failedReason(String | null) // nullable {@link TeamInvitation#failedReason() failedReason}
   *    .inviter(com.spotify.github.v3.User | null) // nullable {@link TeamInvitation#inviter() inviter}
   *    .teamCount(Integer | null) // nullable {@link TeamInvitation#teamCount() teamCount}
   *    .invitationTeamsUrl(java.net.URI | null) // nullable {@link TeamInvitation#invitationTeamsUrl() invitationTeamsUrl}
   *    .invitationSource(String | null) // nullable {@link TeamInvitation#invitationSource() invitationSource}
   *    .build();
   * </pre>
   * @return A new ImmutableTeamInvitation builder
   */
  public static ImmutableTeamInvitation.Builder builder() {
    return new ImmutableTeamInvitation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTeamInvitation ImmutableTeamInvitation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TeamInvitation", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Integer id;
    private @Nullable String login;
    private @Nullable String nodeId;
    private @Nullable String email;
    private @Nullable String role;
    private @Nullable String failedReason;
    private @Nullable User inviter;
    private @Nullable Integer teamCount;
    private @Nullable URI invitationTeamsUrl;
    private @Nullable String invitationSource;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TeamInvitation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TeamInvitation instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Integer idValue = instance.id();
      if (idValue != null) {
        id(idValue);
      }
      @Nullable String loginValue = instance.login();
      if (loginValue != null) {
        login(loginValue);
      }
      @Nullable String nodeIdValue = instance.nodeId();
      if (nodeIdValue != null) {
        nodeId(nodeIdValue);
      }
      @Nullable String emailValue = instance.email();
      if (emailValue != null) {
        email(emailValue);
      }
      @Nullable String roleValue = instance.role();
      if (roleValue != null) {
        role(roleValue);
      }
      @Nullable String failedReasonValue = instance.failedReason();
      if (failedReasonValue != null) {
        failedReason(failedReasonValue);
      }
      @Nullable User inviterValue = instance.inviter();
      if (inviterValue != null) {
        inviter(inviterValue);
      }
      @Nullable Integer teamCountValue = instance.teamCount();
      if (teamCountValue != null) {
        teamCount(teamCountValue);
      }
      @Nullable URI invitationTeamsUrlValue = instance.invitationTeamsUrl();
      if (invitationTeamsUrlValue != null) {
        invitationTeamsUrl(invitationTeamsUrlValue);
      }
      @Nullable String invitationSourceValue = instance.invitationSource();
      if (invitationSourceValue != null) {
        invitationSource(invitationSourceValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link TeamInvitation#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(@Nullable Integer id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link TeamInvitation#login() login} attribute.
     * @param login The value for login (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder login(@Nullable String login) {
      this.login = login;
      return this;
    }

    /**
     * Initializes the value for the {@link TeamInvitation#nodeId() nodeId} attribute.
     * @param nodeId The value for nodeId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder nodeId(@Nullable String nodeId) {
      this.nodeId = nodeId;
      return this;
    }

    /**
     * Initializes the value for the {@link TeamInvitation#email() email} attribute.
     * @param email The value for email (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder email(@Nullable String email) {
      this.email = email;
      return this;
    }

    /**
     * Initializes the value for the {@link TeamInvitation#role() role} attribute.
     * @param role The value for role (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder role(@Nullable String role) {
      this.role = role;
      return this;
    }

    /**
     * Initializes the value for the {@link TeamInvitation#failedReason() failedReason} attribute.
     * @param failedReason The value for failedReason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder failedReason(@Nullable String failedReason) {
      this.failedReason = failedReason;
      return this;
    }

    /**
     * Initializes the value for the {@link TeamInvitation#inviter() inviter} attribute.
     * @param inviter The value for inviter (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder inviter(@Nullable User inviter) {
      this.inviter = inviter;
      return this;
    }

    /**
     * Initializes the value for the {@link TeamInvitation#teamCount() teamCount} attribute.
     * @param teamCount The value for teamCount (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder teamCount(@Nullable Integer teamCount) {
      this.teamCount = teamCount;
      return this;
    }

    /**
     * Initializes the value for the {@link TeamInvitation#invitationTeamsUrl() invitationTeamsUrl} attribute.
     * @param invitationTeamsUrl The value for invitationTeamsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder invitationTeamsUrl(@Nullable URI invitationTeamsUrl) {
      this.invitationTeamsUrl = invitationTeamsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link TeamInvitation#invitationSource() invitationSource} attribute.
     * @param invitationSource The value for invitationSource (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder invitationSource(@Nullable String invitationSource) {
      this.invitationSource = invitationSource;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTeamInvitation ImmutableTeamInvitation}.
     * @return An immutable instance of TeamInvitation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTeamInvitation build() {
      return new ImmutableTeamInvitation(
          id,
          login,
          nodeId,
          email,
          role,
          failedReason,
          inviter,
          teamCount,
          invitationTeamsUrl,
          invitationSource);
    }
  }
}
