package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.User;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Comment}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableComment.builder()}.
 */
@Generated(from = "Comment", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableComment implements Comment {
  private final @Nullable GitHubInstant createdAt;
  private final @Nullable GitHubInstant updatedAt;
  private final @Nullable URI url;
  private final @Nullable Long id;
  private final @Nullable String diffHunk;
  private final @Nullable String path;
  private final @Nullable Integer position;
  private final @Nullable Integer originalPosition;
  private final @Nullable String commitId;
  private final @Nullable String originalCommitId;
  private final @Nullable User user;
  private final @Nullable String body;
  private final @Nullable URI htmlUrl;
  private final @Nullable URI pullRequestUrl;
  private final @Nullable CommentLinks links;

  private ImmutableComment(
      @Nullable GitHubInstant createdAt,
      @Nullable GitHubInstant updatedAt,
      @Nullable URI url,
      @Nullable Long id,
      @Nullable String diffHunk,
      @Nullable String path,
      @Nullable Integer position,
      @Nullable Integer originalPosition,
      @Nullable String commitId,
      @Nullable String originalCommitId,
      @Nullable User user,
      @Nullable String body,
      @Nullable URI htmlUrl,
      @Nullable URI pullRequestUrl,
      @Nullable CommentLinks links) {
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.url = url;
    this.id = id;
    this.diffHunk = diffHunk;
    this.path = path;
    this.position = position;
    this.originalPosition = originalPosition;
    this.commitId = commitId;
    this.originalCommitId = originalCommitId;
    this.user = user;
    this.body = body;
    this.htmlUrl = htmlUrl;
    this.pullRequestUrl = pullRequestUrl;
    this.links = links;
  }

  /**
   * Created date
   * @return The date when the issue was created
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant createdAt() {
    return createdAt;
  }

  /**
   * Updated date
   * @return The date when the issue was updated
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant updatedAt() {
    return updatedAt;
  }

  /**
   *Comment API URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *Comment id. 
   */
  @JsonProperty
  @Override
  public @Nullable Long id() {
    return id;
  }

  /**
   *Unified diff. 
   */
  @JsonProperty
  @Override
  public @Nullable String diffHunk() {
    return diffHunk;
  }

  /**
   *The relative path of the file to comment on. 
   */
  @JsonProperty
  @Override
  public @Nullable String path() {
    return path;
  }

  /**
   *The line index in the diff to comment on. 
   */
  @JsonProperty
  @Override
  public @Nullable Integer position() {
    return position;
  }

  /**
   *Base content line position. 
   */
  @JsonProperty
  @Override
  public @Nullable Integer originalPosition() {
    return originalPosition;
  }

  /**
   *The SHA of the commit to comment on. 
   */
  @JsonProperty
  @Override
  public @Nullable String commitId() {
    return commitId;
  }

  /**
   *Base commit sha. 
   */
  @JsonProperty
  @Override
  public @Nullable String originalCommitId() {
    return originalCommitId;
  }

  /**
   *Comment author. 
   */
  @JsonProperty
  @Override
  public @Nullable User user() {
    return user;
  }

  /**
   *The text of the comment. 
   */
  @JsonProperty
  @Override
  public @Nullable String body() {
    return body;
  }

  /**
   *Comment URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI htmlUrl() {
    return htmlUrl;
  }

  /**
   *Pull request API URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI pullRequestUrl() {
    return pullRequestUrl;
  }

  /**
   *Link references. 
   */
  @JsonProperty("_links")
  @Override
  public @Nullable CommentLinks links() {
    return links;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Comment#createdAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComment withCreatedAt(@Nullable GitHubInstant value) {
    if (this.createdAt == value) return this;
    return new ImmutableComment(
        value,
        this.updatedAt,
        this.url,
        this.id,
        this.diffHunk,
        this.path,
        this.position,
        this.originalPosition,
        this.commitId,
        this.originalCommitId,
        this.user,
        this.body,
        this.htmlUrl,
        this.pullRequestUrl,
        this.links);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Comment#updatedAt() updatedAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComment withUpdatedAt(@Nullable GitHubInstant value) {
    if (this.updatedAt == value) return this;
    return new ImmutableComment(
        this.createdAt,
        value,
        this.url,
        this.id,
        this.diffHunk,
        this.path,
        this.position,
        this.originalPosition,
        this.commitId,
        this.originalCommitId,
        this.user,
        this.body,
        this.htmlUrl,
        this.pullRequestUrl,
        this.links);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Comment#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComment withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        value,
        this.id,
        this.diffHunk,
        this.path,
        this.position,
        this.originalPosition,
        this.commitId,
        this.originalCommitId,
        this.user,
        this.body,
        this.htmlUrl,
        this.pullRequestUrl,
        this.links);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Comment#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComment withId(@Nullable Long value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        value,
        this.diffHunk,
        this.path,
        this.position,
        this.originalPosition,
        this.commitId,
        this.originalCommitId,
        this.user,
        this.body,
        this.htmlUrl,
        this.pullRequestUrl,
        this.links);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Comment#diffHunk() diffHunk} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for diffHunk (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComment withDiffHunk(@Nullable String value) {
    if (Objects.equals(this.diffHunk, value)) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.id,
        value,
        this.path,
        this.position,
        this.originalPosition,
        this.commitId,
        this.originalCommitId,
        this.user,
        this.body,
        this.htmlUrl,
        this.pullRequestUrl,
        this.links);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Comment#path() path} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for path (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComment withPath(@Nullable String value) {
    if (Objects.equals(this.path, value)) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.id,
        this.diffHunk,
        value,
        this.position,
        this.originalPosition,
        this.commitId,
        this.originalCommitId,
        this.user,
        this.body,
        this.htmlUrl,
        this.pullRequestUrl,
        this.links);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Comment#position() position} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for position (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComment withPosition(@Nullable Integer value) {
    if (Objects.equals(this.position, value)) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.id,
        this.diffHunk,
        this.path,
        value,
        this.originalPosition,
        this.commitId,
        this.originalCommitId,
        this.user,
        this.body,
        this.htmlUrl,
        this.pullRequestUrl,
        this.links);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Comment#originalPosition() originalPosition} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for originalPosition (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComment withOriginalPosition(@Nullable Integer value) {
    if (Objects.equals(this.originalPosition, value)) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.id,
        this.diffHunk,
        this.path,
        this.position,
        value,
        this.commitId,
        this.originalCommitId,
        this.user,
        this.body,
        this.htmlUrl,
        this.pullRequestUrl,
        this.links);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Comment#commitId() commitId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commitId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComment withCommitId(@Nullable String value) {
    if (Objects.equals(this.commitId, value)) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.id,
        this.diffHunk,
        this.path,
        this.position,
        this.originalPosition,
        value,
        this.originalCommitId,
        this.user,
        this.body,
        this.htmlUrl,
        this.pullRequestUrl,
        this.links);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Comment#originalCommitId() originalCommitId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for originalCommitId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComment withOriginalCommitId(@Nullable String value) {
    if (Objects.equals(this.originalCommitId, value)) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.id,
        this.diffHunk,
        this.path,
        this.position,
        this.originalPosition,
        this.commitId,
        value,
        this.user,
        this.body,
        this.htmlUrl,
        this.pullRequestUrl,
        this.links);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Comment#user() user} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for user (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComment withUser(@Nullable User value) {
    if (this.user == value) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.id,
        this.diffHunk,
        this.path,
        this.position,
        this.originalPosition,
        this.commitId,
        this.originalCommitId,
        value,
        this.body,
        this.htmlUrl,
        this.pullRequestUrl,
        this.links);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Comment#body() body} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for body (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComment withBody(@Nullable String value) {
    if (Objects.equals(this.body, value)) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.id,
        this.diffHunk,
        this.path,
        this.position,
        this.originalPosition,
        this.commitId,
        this.originalCommitId,
        this.user,
        value,
        this.htmlUrl,
        this.pullRequestUrl,
        this.links);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Comment#htmlUrl() htmlUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for htmlUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComment withHtmlUrl(@Nullable URI value) {
    if (this.htmlUrl == value) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.id,
        this.diffHunk,
        this.path,
        this.position,
        this.originalPosition,
        this.commitId,
        this.originalCommitId,
        this.user,
        this.body,
        value,
        this.pullRequestUrl,
        this.links);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Comment#pullRequestUrl() pullRequestUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pullRequestUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComment withPullRequestUrl(@Nullable URI value) {
    if (this.pullRequestUrl == value) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.id,
        this.diffHunk,
        this.path,
        this.position,
        this.originalPosition,
        this.commitId,
        this.originalCommitId,
        this.user,
        this.body,
        this.htmlUrl,
        value,
        this.links);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Comment#links() links} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for links (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComment withLinks(@Nullable CommentLinks value) {
    if (this.links == value) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.id,
        this.diffHunk,
        this.path,
        this.position,
        this.originalPosition,
        this.commitId,
        this.originalCommitId,
        this.user,
        this.body,
        this.htmlUrl,
        this.pullRequestUrl,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableComment} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableComment
        && equalTo(0, (ImmutableComment) another);
  }

  private boolean equalTo(int synthetic, ImmutableComment another) {
    return Objects.equals(createdAt, another.createdAt)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(url, another.url)
        && Objects.equals(id, another.id)
        && Objects.equals(diffHunk, another.diffHunk)
        && Objects.equals(path, another.path)
        && Objects.equals(position, another.position)
        && Objects.equals(originalPosition, another.originalPosition)
        && Objects.equals(commitId, another.commitId)
        && Objects.equals(originalCommitId, another.originalCommitId)
        && Objects.equals(user, another.user)
        && Objects.equals(body, another.body)
        && Objects.equals(htmlUrl, another.htmlUrl)
        && Objects.equals(pullRequestUrl, another.pullRequestUrl)
        && Objects.equals(links, another.links);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code updatedAt}, {@code url}, {@code id}, {@code diffHunk}, {@code path}, {@code position}, {@code originalPosition}, {@code commitId}, {@code originalCommitId}, {@code user}, {@code body}, {@code htmlUrl}, {@code pullRequestUrl}, {@code links}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(diffHunk);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + Objects.hashCode(position);
    h += (h << 5) + Objects.hashCode(originalPosition);
    h += (h << 5) + Objects.hashCode(commitId);
    h += (h << 5) + Objects.hashCode(originalCommitId);
    h += (h << 5) + Objects.hashCode(user);
    h += (h << 5) + Objects.hashCode(body);
    h += (h << 5) + Objects.hashCode(htmlUrl);
    h += (h << 5) + Objects.hashCode(pullRequestUrl);
    h += (h << 5) + Objects.hashCode(links);
    return h;
  }

  /**
   * Prints the immutable value {@code Comment} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Comment{"
        + "createdAt=" + createdAt
        + ", updatedAt=" + updatedAt
        + ", url=" + url
        + ", id=" + id
        + ", diffHunk=" + diffHunk
        + ", path=" + path
        + ", position=" + position
        + ", originalPosition=" + originalPosition
        + ", commitId=" + commitId
        + ", originalCommitId=" + originalCommitId
        + ", user=" + user
        + ", body=" + body
        + ", htmlUrl=" + htmlUrl
        + ", pullRequestUrl=" + pullRequestUrl
        + ", links=" + links
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Comment", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Comment {
    @Nullable GitHubInstant createdAt;
    @Nullable GitHubInstant updatedAt;
    @Nullable URI url;
    @Nullable Long id;
    @Nullable String diffHunk;
    @Nullable String path;
    @Nullable Integer position;
    @Nullable Integer originalPosition;
    @Nullable String commitId;
    @Nullable String originalCommitId;
    @Nullable User user;
    @Nullable String body;
    @Nullable URI htmlUrl;
    @Nullable URI pullRequestUrl;
    @Nullable CommentLinks links;
    @JsonProperty
    public void setCreatedAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty
    public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setId(@Nullable Long id) {
      this.id = id;
    }
    @JsonProperty
    public void setDiffHunk(@Nullable String diffHunk) {
      this.diffHunk = diffHunk;
    }
    @JsonProperty
    public void setPath(@Nullable String path) {
      this.path = path;
    }
    @JsonProperty
    public void setPosition(@Nullable Integer position) {
      this.position = position;
    }
    @JsonProperty
    public void setOriginalPosition(@Nullable Integer originalPosition) {
      this.originalPosition = originalPosition;
    }
    @JsonProperty
    public void setCommitId(@Nullable String commitId) {
      this.commitId = commitId;
    }
    @JsonProperty
    public void setOriginalCommitId(@Nullable String originalCommitId) {
      this.originalCommitId = originalCommitId;
    }
    @JsonProperty
    public void setUser(@Nullable User user) {
      this.user = user;
    }
    @JsonProperty
    public void setBody(@Nullable String body) {
      this.body = body;
    }
    @JsonProperty
    public void setHtmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
    }
    @JsonProperty
    public void setPullRequestUrl(@Nullable URI pullRequestUrl) {
      this.pullRequestUrl = pullRequestUrl;
    }
    @JsonProperty("_links")
    public void setLinks(@Nullable CommentLinks links) {
      this.links = links;
    }
    @Override
    public GitHubInstant createdAt() { throw new UnsupportedOperationException(); }
    @Override
    public GitHubInstant updatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public Long id() { throw new UnsupportedOperationException(); }
    @Override
    public String diffHunk() { throw new UnsupportedOperationException(); }
    @Override
    public String path() { throw new UnsupportedOperationException(); }
    @Override
    public Integer position() { throw new UnsupportedOperationException(); }
    @Override
    public Integer originalPosition() { throw new UnsupportedOperationException(); }
    @Override
    public String commitId() { throw new UnsupportedOperationException(); }
    @Override
    public String originalCommitId() { throw new UnsupportedOperationException(); }
    @Override
    public User user() { throw new UnsupportedOperationException(); }
    @Override
    public String body() { throw new UnsupportedOperationException(); }
    @Override
    public URI htmlUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI pullRequestUrl() { throw new UnsupportedOperationException(); }
    @Override
    public CommentLinks links() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableComment fromJson(Json json) {
    ImmutableComment.Builder builder = ImmutableComment.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.diffHunk != null) {
      builder.diffHunk(json.diffHunk);
    }
    if (json.path != null) {
      builder.path(json.path);
    }
    if (json.position != null) {
      builder.position(json.position);
    }
    if (json.originalPosition != null) {
      builder.originalPosition(json.originalPosition);
    }
    if (json.commitId != null) {
      builder.commitId(json.commitId);
    }
    if (json.originalCommitId != null) {
      builder.originalCommitId(json.originalCommitId);
    }
    if (json.user != null) {
      builder.user(json.user);
    }
    if (json.body != null) {
      builder.body(json.body);
    }
    if (json.htmlUrl != null) {
      builder.htmlUrl(json.htmlUrl);
    }
    if (json.pullRequestUrl != null) {
      builder.pullRequestUrl(json.pullRequestUrl);
    }
    if (json.links != null) {
      builder.links(json.links);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Comment} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Comment instance
   */
  public static ImmutableComment copyOf(Comment instance) {
    if (instance instanceof ImmutableComment) {
      return (ImmutableComment) instance;
    }
    return ImmutableComment.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableComment ImmutableComment}.
   * <pre>
   * ImmutableComment.builder()
   *    .createdAt(com.spotify.github.GitHubInstant | null) // nullable {@link Comment#createdAt() createdAt}
   *    .updatedAt(com.spotify.github.GitHubInstant | null) // nullable {@link Comment#updatedAt() updatedAt}
   *    .url(java.net.URI | null) // nullable {@link Comment#url() url}
   *    .id(Long | null) // nullable {@link Comment#id() id}
   *    .diffHunk(String | null) // nullable {@link Comment#diffHunk() diffHunk}
   *    .path(String | null) // nullable {@link Comment#path() path}
   *    .position(Integer | null) // nullable {@link Comment#position() position}
   *    .originalPosition(Integer | null) // nullable {@link Comment#originalPosition() originalPosition}
   *    .commitId(String | null) // nullable {@link Comment#commitId() commitId}
   *    .originalCommitId(String | null) // nullable {@link Comment#originalCommitId() originalCommitId}
   *    .user(com.spotify.github.v3.User | null) // nullable {@link Comment#user() user}
   *    .body(String | null) // nullable {@link Comment#body() body}
   *    .htmlUrl(java.net.URI | null) // nullable {@link Comment#htmlUrl() htmlUrl}
   *    .pullRequestUrl(java.net.URI | null) // nullable {@link Comment#pullRequestUrl() pullRequestUrl}
   *    .links(com.spotify.github.v3.prs.CommentLinks | null) // nullable {@link Comment#links() links}
   *    .build();
   * </pre>
   * @return A new ImmutableComment builder
   */
  public static ImmutableComment.Builder builder() {
    return new ImmutableComment.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableComment ImmutableComment}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Comment", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable GitHubInstant createdAt;
    private @Nullable GitHubInstant updatedAt;
    private @Nullable URI url;
    private @Nullable Long id;
    private @Nullable String diffHunk;
    private @Nullable String path;
    private @Nullable Integer position;
    private @Nullable Integer originalPosition;
    private @Nullable String commitId;
    private @Nullable String originalCommitId;
    private @Nullable User user;
    private @Nullable String body;
    private @Nullable URI htmlUrl;
    private @Nullable URI pullRequestUrl;
    private @Nullable CommentLinks links;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.prs.Comment} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Comment instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.UpdateTracking} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateTracking instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof Comment) {
        Comment instance = (Comment) object;
        @Nullable URI htmlUrlValue = instance.htmlUrl();
        if (htmlUrlValue != null) {
          htmlUrl(htmlUrlValue);
        }
        @Nullable String commitIdValue = instance.commitId();
        if (commitIdValue != null) {
          commitId(commitIdValue);
        }
        @Nullable String bodyValue = instance.body();
        if (bodyValue != null) {
          body(bodyValue);
        }
        @Nullable URI urlValue = instance.url();
        if (urlValue != null) {
          url(urlValue);
        }
        @Nullable String originalCommitIdValue = instance.originalCommitId();
        if (originalCommitIdValue != null) {
          originalCommitId(originalCommitIdValue);
        }
        if ((bits & 0x1L) == 0) {
          @Nullable GitHubInstant createdAtValue = instance.createdAt();
          if (createdAtValue != null) {
            createdAt(createdAtValue);
          }
          bits |= 0x1L;
        }
        @Nullable String pathValue = instance.path();
        if (pathValue != null) {
          path(pathValue);
        }
        @Nullable URI pullRequestUrlValue = instance.pullRequestUrl();
        if (pullRequestUrlValue != null) {
          pullRequestUrl(pullRequestUrlValue);
        }
        @Nullable CommentLinks linksValue = instance.links();
        if (linksValue != null) {
          links(linksValue);
        }
        @Nullable Long idValue = instance.id();
        if (idValue != null) {
          id(idValue);
        }
        @Nullable Integer positionValue = instance.position();
        if (positionValue != null) {
          position(positionValue);
        }
        @Nullable String diffHunkValue = instance.diffHunk();
        if (diffHunkValue != null) {
          diffHunk(diffHunkValue);
        }
        @Nullable User userValue = instance.user();
        if (userValue != null) {
          user(userValue);
        }
        if ((bits & 0x2L) == 0) {
          @Nullable GitHubInstant updatedAtValue = instance.updatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x2L;
        }
        @Nullable Integer originalPositionValue = instance.originalPosition();
        if (originalPositionValue != null) {
          originalPosition(originalPositionValue);
        }
      }
      if (object instanceof UpdateTracking) {
        UpdateTracking instance = (UpdateTracking) object;
        if ((bits & 0x1L) == 0) {
          @Nullable GitHubInstant createdAtValue = instance.createdAt();
          if (createdAtValue != null) {
            createdAt(createdAtValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable GitHubInstant updatedAtValue = instance.updatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link Comment#createdAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder createdAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link Comment#updatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link Comment#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link Comment#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(@Nullable Long id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Comment#diffHunk() diffHunk} attribute.
     * @param diffHunk The value for diffHunk (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder diffHunk(@Nullable String diffHunk) {
      this.diffHunk = diffHunk;
      return this;
    }

    /**
     * Initializes the value for the {@link Comment#path() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link Comment#position() position} attribute.
     * @param position The value for position (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder position(@Nullable Integer position) {
      this.position = position;
      return this;
    }

    /**
     * Initializes the value for the {@link Comment#originalPosition() originalPosition} attribute.
     * @param originalPosition The value for originalPosition (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder originalPosition(@Nullable Integer originalPosition) {
      this.originalPosition = originalPosition;
      return this;
    }

    /**
     * Initializes the value for the {@link Comment#commitId() commitId} attribute.
     * @param commitId The value for commitId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commitId(@Nullable String commitId) {
      this.commitId = commitId;
      return this;
    }

    /**
     * Initializes the value for the {@link Comment#originalCommitId() originalCommitId} attribute.
     * @param originalCommitId The value for originalCommitId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder originalCommitId(@Nullable String originalCommitId) {
      this.originalCommitId = originalCommitId;
      return this;
    }

    /**
     * Initializes the value for the {@link Comment#user() user} attribute.
     * @param user The value for user (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder user(@Nullable User user) {
      this.user = user;
      return this;
    }

    /**
     * Initializes the value for the {@link Comment#body() body} attribute.
     * @param body The value for body (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder body(@Nullable String body) {
      this.body = body;
      return this;
    }

    /**
     * Initializes the value for the {@link Comment#htmlUrl() htmlUrl} attribute.
     * @param htmlUrl The value for htmlUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder htmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link Comment#pullRequestUrl() pullRequestUrl} attribute.
     * @param pullRequestUrl The value for pullRequestUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder pullRequestUrl(@Nullable URI pullRequestUrl) {
      this.pullRequestUrl = pullRequestUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link Comment#links() links} attribute.
     * @param links The value for links (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("_links")
    public final Builder links(@Nullable CommentLinks links) {
      this.links = links;
      return this;
    }

    /**
     * Builds a new {@link ImmutableComment ImmutableComment}.
     * @return An immutable instance of Comment
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableComment build() {
      return new ImmutableComment(
          createdAt,
          updatedAt,
          url,
          id,
          diffHunk,
          path,
          position,
          originalPosition,
          commitId,
          originalCommitId,
          user,
          body,
          htmlUrl,
          pullRequestUrl,
          links);
    }
  }
}
