package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MergeParameters}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMergeParameters.builder()}.
 */
@Generated(from = "MergeParameters", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableMergeParameters extends MergeParameters {
  private final String sha;
  private final @Nullable String commitMessage;
  private final @Nullable String commitTitle;
  private final MergeMethod mergeMethod;

  private ImmutableMergeParameters(ImmutableMergeParameters.Builder builder) {
    this.sha = builder.sha;
    this.commitMessage = builder.commitMessage;
    this.commitTitle = builder.commitTitle;
    this.mergeMethod = builder.mergeMethod != null
        ? builder.mergeMethod
        : Objects.requireNonNull(super.mergeMethod(), "mergeMethod");
  }

  private ImmutableMergeParameters(
      String sha,
      @Nullable String commitMessage,
      @Nullable String commitTitle,
      MergeMethod mergeMethod) {
    this.sha = sha;
    this.commitMessage = commitMessage;
    this.commitTitle = commitTitle;
    this.mergeMethod = mergeMethod;
  }

  /**
   * SHA that pull request head must match to allow merge.
   * @return the string
   */
  @JsonProperty
  @Override
  public String sha() {
    return sha;
  }

  /**
   * Extra detail to append to automatic commit message.
   * @return the optional
   */
  @JsonProperty
  @Override
  public Optional<String> commitMessage() {
    return Optional.ofNullable(commitMessage);
  }

  /**
   * Title for the automatic commit message.
   * @return the optional commit title
   */
  @JsonProperty
  @Override
  public Optional<String> commitTitle() {
    return Optional.ofNullable(commitTitle);
  }

  /**
   * Merge method to use.
   * @return the merge method enum value
   */
  @JsonProperty
  @Override
  public MergeMethod mergeMethod() {
    return mergeMethod;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MergeParameters#sha() sha} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sha
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMergeParameters withSha(String value) {
    String newValue = Objects.requireNonNull(value, "sha");
    if (this.sha.equals(newValue)) return this;
    return new ImmutableMergeParameters(newValue, this.commitMessage, this.commitTitle, this.mergeMethod);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MergeParameters#commitMessage() commitMessage} attribute.
   * @param value The value for commitMessage
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMergeParameters withCommitMessage(String value) {
    String newValue = Objects.requireNonNull(value, "commitMessage");
    if (Objects.equals(this.commitMessage, newValue)) return this;
    return new ImmutableMergeParameters(this.sha, newValue, this.commitTitle, this.mergeMethod);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MergeParameters#commitMessage() commitMessage} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for commitMessage
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMergeParameters withCommitMessage(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.commitMessage, value)) return this;
    return new ImmutableMergeParameters(this.sha, value, this.commitTitle, this.mergeMethod);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MergeParameters#commitTitle() commitTitle} attribute.
   * @param value The value for commitTitle
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMergeParameters withCommitTitle(String value) {
    String newValue = Objects.requireNonNull(value, "commitTitle");
    if (Objects.equals(this.commitTitle, newValue)) return this;
    return new ImmutableMergeParameters(this.sha, this.commitMessage, newValue, this.mergeMethod);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MergeParameters#commitTitle() commitTitle} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for commitTitle
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMergeParameters withCommitTitle(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.commitTitle, value)) return this;
    return new ImmutableMergeParameters(this.sha, this.commitMessage, value, this.mergeMethod);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MergeParameters#mergeMethod() mergeMethod} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mergeMethod
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMergeParameters withMergeMethod(MergeMethod value) {
    MergeMethod newValue = Objects.requireNonNull(value, "mergeMethod");
    if (this.mergeMethod == newValue) return this;
    return new ImmutableMergeParameters(this.sha, this.commitMessage, this.commitTitle, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMergeParameters} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMergeParameters
        && equalTo(0, (ImmutableMergeParameters) another);
  }

  private boolean equalTo(int synthetic, ImmutableMergeParameters another) {
    return sha.equals(another.sha)
        && Objects.equals(commitMessage, another.commitMessage)
        && Objects.equals(commitTitle, another.commitTitle)
        && mergeMethod.equals(another.mergeMethod);
  }

  /**
   * Computes a hash code from attributes: {@code sha}, {@code commitMessage}, {@code commitTitle}, {@code mergeMethod}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + sha.hashCode();
    h += (h << 5) + Objects.hashCode(commitMessage);
    h += (h << 5) + Objects.hashCode(commitTitle);
    h += (h << 5) + mergeMethod.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MergeParameters} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("MergeParameters{");
    builder.append("sha=").append(sha);
    if (commitMessage != null) {
      builder.append(", ");
      builder.append("commitMessage=").append(commitMessage);
    }
    if (commitTitle != null) {
      builder.append(", ");
      builder.append("commitTitle=").append(commitTitle);
    }
    builder.append(", ");
    builder.append("mergeMethod=").append(mergeMethod);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "MergeParameters", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends MergeParameters {
    @Nullable String sha;
    @Nullable Optional<String> commitMessage = Optional.empty();
    @Nullable Optional<String> commitTitle = Optional.empty();
    @Nullable MergeMethod mergeMethod;
    @JsonProperty
    public void setSha(String sha) {
      this.sha = sha;
    }
    @JsonProperty
    public void setCommitMessage(Optional<String> commitMessage) {
      this.commitMessage = commitMessage;
    }
    @JsonProperty
    public void setCommitTitle(Optional<String> commitTitle) {
      this.commitTitle = commitTitle;
    }
    @JsonProperty
    public void setMergeMethod(MergeMethod mergeMethod) {
      this.mergeMethod = mergeMethod;
    }
    @Override
    public String sha() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> commitMessage() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> commitTitle() { throw new UnsupportedOperationException(); }
    @Override
    public MergeMethod mergeMethod() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableMergeParameters fromJson(Json json) {
    ImmutableMergeParameters.Builder builder = ImmutableMergeParameters.builder();
    if (json.sha != null) {
      builder.sha(json.sha);
    }
    if (json.commitMessage != null) {
      builder.commitMessage(json.commitMessage);
    }
    if (json.commitTitle != null) {
      builder.commitTitle(json.commitTitle);
    }
    if (json.mergeMethod != null) {
      builder.mergeMethod(json.mergeMethod);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link MergeParameters} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MergeParameters instance
   */
  public static ImmutableMergeParameters copyOf(MergeParameters instance) {
    if (instance instanceof ImmutableMergeParameters) {
      return (ImmutableMergeParameters) instance;
    }
    return ImmutableMergeParameters.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMergeParameters ImmutableMergeParameters}.
   * <pre>
   * ImmutableMergeParameters.builder()
   *    .sha(String) // required {@link MergeParameters#sha() sha}
   *    .commitMessage(String) // optional {@link MergeParameters#commitMessage() commitMessage}
   *    .commitTitle(String) // optional {@link MergeParameters#commitTitle() commitTitle}
   *    .mergeMethod(com.spotify.github.v3.prs.MergeMethod) // optional {@link MergeParameters#mergeMethod() mergeMethod}
   *    .build();
   * </pre>
   * @return A new ImmutableMergeParameters builder
   */
  public static ImmutableMergeParameters.Builder builder() {
    return new ImmutableMergeParameters.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMergeParameters ImmutableMergeParameters}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MergeParameters", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SHA = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String sha;
    private @Nullable String commitMessage;
    private @Nullable String commitTitle;
    private @Nullable MergeMethod mergeMethod;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MergeParameters} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(MergeParameters instance) {
      Objects.requireNonNull(instance, "instance");
      sha(instance.sha());
      Optional<String> commitMessageOptional = instance.commitMessage();
      if (commitMessageOptional.isPresent()) {
        commitMessage(commitMessageOptional);
      }
      Optional<String> commitTitleOptional = instance.commitTitle();
      if (commitTitleOptional.isPresent()) {
        commitTitle(commitTitleOptional);
      }
      mergeMethod(instance.mergeMethod());
      return this;
    }

    /**
     * Initializes the value for the {@link MergeParameters#sha() sha} attribute.
     * @param sha The value for sha 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sha(String sha) {
      this.sha = Objects.requireNonNull(sha, "sha");
      initBits &= ~INIT_BIT_SHA;
      return this;
    }

    /**
     * Initializes the optional value {@link MergeParameters#commitMessage() commitMessage} to commitMessage.
     * @param commitMessage The value for commitMessage
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commitMessage(String commitMessage) {
      this.commitMessage = Objects.requireNonNull(commitMessage, "commitMessage");
      return this;
    }

    /**
     * Initializes the optional value {@link MergeParameters#commitMessage() commitMessage} to commitMessage.
     * @param commitMessage The value for commitMessage
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commitMessage(Optional<String> commitMessage) {
      this.commitMessage = commitMessage.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MergeParameters#commitTitle() commitTitle} to commitTitle.
     * @param commitTitle The value for commitTitle
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commitTitle(String commitTitle) {
      this.commitTitle = Objects.requireNonNull(commitTitle, "commitTitle");
      return this;
    }

    /**
     * Initializes the optional value {@link MergeParameters#commitTitle() commitTitle} to commitTitle.
     * @param commitTitle The value for commitTitle
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commitTitle(Optional<String> commitTitle) {
      this.commitTitle = commitTitle.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link MergeParameters#mergeMethod() mergeMethod} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MergeParameters#mergeMethod() mergeMethod}.</em>
     * @param mergeMethod The value for mergeMethod 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder mergeMethod(MergeMethod mergeMethod) {
      this.mergeMethod = Objects.requireNonNull(mergeMethod, "mergeMethod");
      return this;
    }

    /**
     * Builds a new {@link ImmutableMergeParameters ImmutableMergeParameters}.
     * @return An immutable instance of MergeParameters
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMergeParameters build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMergeParameters(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SHA) != 0) attributes.add("sha");
      return "Cannot build MergeParameters, some of required attributes are not set " + attributes;
    }
  }
}
