package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.GitHubInstant;
import com.spotify.github.v3.User;
import com.spotify.github.v3.activity.events.ReviewLinks;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Review}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableReview.builder()}.
 */
@Generated(from = "Review", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableReview implements Review {
  private final @Nullable Integer id;
  private final @Nullable User user;
  private final @Nullable Optional<String> body;
  private final @Nullable GitHubInstant submittedAt;
  private final @Nullable String state;
  private final @Nullable URI htmlUrl;
  private final @Nullable URI pullRequestUrl;
  private final @Nullable ReviewLinks links;
  private final @Nullable String commitId;

  private ImmutableReview(
      @Nullable Integer id,
      @Nullable User user,
      @Nullable Optional<String> body,
      @Nullable GitHubInstant submittedAt,
      @Nullable String state,
      @Nullable URI htmlUrl,
      @Nullable URI pullRequestUrl,
      @Nullable ReviewLinks links,
      @Nullable String commitId) {
    this.id = id;
    this.user = user;
    this.body = body;
    this.submittedAt = submittedAt;
    this.state = state;
    this.htmlUrl = htmlUrl;
    this.pullRequestUrl = pullRequestUrl;
    this.links = links;
    this.commitId = commitId;
  }

  /**
   *Id. 
   */
  @JsonProperty
  @Override
  public @Nullable Integer id() {
    return id;
  }

  /**
   *User. 
   */
  @JsonProperty
  @Override
  public @Nullable User user() {
    return user;
  }

  /**
   *Body. 
   */
  @JsonProperty
  @Override
  public @Nullable Optional<String> body() {
    return body;
  }

  /**
   *Submitted at. 
   */
  @JsonProperty
  @Override
  public Optional<GitHubInstant> submittedAt() {
    return Optional.ofNullable(submittedAt);
  }

  /**
   *State. 
   */
  @JsonProperty
  @Override
  public @Nullable String state() {
    return state;
  }

  /**
   *Html URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI htmlUrl() {
    return htmlUrl;
  }

  /**
   *Pull Request URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI pullRequestUrl() {
    return pullRequestUrl;
  }

  /**
   *Hypermedia links. 
   */
  @JsonProperty("_links")
  @Override
  public @Nullable ReviewLinks links() {
    return links;
  }

  /**
   *Commit sha the review refers to 
   */
  @JsonProperty
  @Override
  public @Nullable String commitId() {
    return commitId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Review#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReview withId(@Nullable Integer value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableReview(
        value,
        this.user,
        this.body,
        this.submittedAt,
        this.state,
        this.htmlUrl,
        this.pullRequestUrl,
        this.links,
        this.commitId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Review#user() user} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for user (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReview withUser(@Nullable User value) {
    if (this.user == value) return this;
    return new ImmutableReview(
        this.id,
        value,
        this.body,
        this.submittedAt,
        this.state,
        this.htmlUrl,
        this.pullRequestUrl,
        this.links,
        this.commitId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Review#body() body} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for body (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReview withBody(@Nullable Optional<String> value) {
    if (Objects.equals(this.body, value)) return this;
    return new ImmutableReview(
        this.id,
        this.user,
        value,
        this.submittedAt,
        this.state,
        this.htmlUrl,
        this.pullRequestUrl,
        this.links,
        this.commitId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Review#submittedAt() submittedAt} attribute.
   * @param value The value for submittedAt
   * @return A modified copy of {@code this} object
   */
  public final ImmutableReview withSubmittedAt(GitHubInstant value) {
    GitHubInstant newValue = Objects.requireNonNull(value, "submittedAt");
    if (this.submittedAt == newValue) return this;
    return new ImmutableReview(
        this.id,
        this.user,
        this.body,
        newValue,
        this.state,
        this.htmlUrl,
        this.pullRequestUrl,
        this.links,
        this.commitId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Review#submittedAt() submittedAt} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for submittedAt
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableReview withSubmittedAt(Optional<? extends GitHubInstant> optional) {
    @Nullable GitHubInstant value = optional.orElse(null);
    if (this.submittedAt == value) return this;
    return new ImmutableReview(
        this.id,
        this.user,
        this.body,
        value,
        this.state,
        this.htmlUrl,
        this.pullRequestUrl,
        this.links,
        this.commitId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Review#state() state} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for state (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReview withState(@Nullable String value) {
    if (Objects.equals(this.state, value)) return this;
    return new ImmutableReview(
        this.id,
        this.user,
        this.body,
        this.submittedAt,
        value,
        this.htmlUrl,
        this.pullRequestUrl,
        this.links,
        this.commitId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Review#htmlUrl() htmlUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for htmlUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReview withHtmlUrl(@Nullable URI value) {
    if (this.htmlUrl == value) return this;
    return new ImmutableReview(
        this.id,
        this.user,
        this.body,
        this.submittedAt,
        this.state,
        value,
        this.pullRequestUrl,
        this.links,
        this.commitId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Review#pullRequestUrl() pullRequestUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pullRequestUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReview withPullRequestUrl(@Nullable URI value) {
    if (this.pullRequestUrl == value) return this;
    return new ImmutableReview(
        this.id,
        this.user,
        this.body,
        this.submittedAt,
        this.state,
        this.htmlUrl,
        value,
        this.links,
        this.commitId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Review#links() links} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for links (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReview withLinks(@Nullable ReviewLinks value) {
    if (this.links == value) return this;
    return new ImmutableReview(
        this.id,
        this.user,
        this.body,
        this.submittedAt,
        this.state,
        this.htmlUrl,
        this.pullRequestUrl,
        value,
        this.commitId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Review#commitId() commitId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commitId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReview withCommitId(@Nullable String value) {
    if (Objects.equals(this.commitId, value)) return this;
    return new ImmutableReview(
        this.id,
        this.user,
        this.body,
        this.submittedAt,
        this.state,
        this.htmlUrl,
        this.pullRequestUrl,
        this.links,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableReview} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableReview
        && equalTo(0, (ImmutableReview) another);
  }

  private boolean equalTo(int synthetic, ImmutableReview another) {
    return Objects.equals(id, another.id)
        && Objects.equals(user, another.user)
        && Objects.equals(body, another.body)
        && Objects.equals(submittedAt, another.submittedAt)
        && Objects.equals(state, another.state)
        && Objects.equals(htmlUrl, another.htmlUrl)
        && Objects.equals(pullRequestUrl, another.pullRequestUrl)
        && Objects.equals(links, another.links)
        && Objects.equals(commitId, another.commitId);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code user}, {@code body}, {@code submittedAt}, {@code state}, {@code htmlUrl}, {@code pullRequestUrl}, {@code links}, {@code commitId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(user);
    h += (h << 5) + Objects.hashCode(body);
    h += (h << 5) + Objects.hashCode(submittedAt);
    h += (h << 5) + Objects.hashCode(state);
    h += (h << 5) + Objects.hashCode(htmlUrl);
    h += (h << 5) + Objects.hashCode(pullRequestUrl);
    h += (h << 5) + Objects.hashCode(links);
    h += (h << 5) + Objects.hashCode(commitId);
    return h;
  }

  /**
   * Prints the immutable value {@code Review} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Review{");
    if (id != null) {
      builder.append("id=").append(id);
    }
    if (user != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("user=").append(user);
    }
    if (body != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("body=").append(body);
    }
    if (submittedAt != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("submittedAt=").append(submittedAt);
    }
    if (state != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("state=").append(state);
    }
    if (htmlUrl != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("htmlUrl=").append(htmlUrl);
    }
    if (pullRequestUrl != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("pullRequestUrl=").append(pullRequestUrl);
    }
    if (links != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("links=").append(links);
    }
    if (commitId != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("commitId=").append(commitId);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Review", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Review {
    @Nullable Integer id;
    @Nullable User user;
    @Nullable Optional<String> body;
    @Nullable Optional<GitHubInstant> submittedAt = Optional.empty();
    @Nullable String state;
    @Nullable URI htmlUrl;
    @Nullable URI pullRequestUrl;
    @Nullable ReviewLinks links;
    @Nullable String commitId;
    @JsonProperty
    public void setId(@Nullable Integer id) {
      this.id = id;
    }
    @JsonProperty
    public void setUser(@Nullable User user) {
      this.user = user;
    }
    @JsonProperty
    public void setBody(@Nullable Optional<String> body) {
      this.body = body;
    }
    @JsonProperty
    public void setSubmittedAt(Optional<GitHubInstant> submittedAt) {
      this.submittedAt = submittedAt;
    }
    @JsonProperty
    public void setState(@Nullable String state) {
      this.state = state;
    }
    @JsonProperty
    public void setHtmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
    }
    @JsonProperty
    public void setPullRequestUrl(@Nullable URI pullRequestUrl) {
      this.pullRequestUrl = pullRequestUrl;
    }
    @JsonProperty("_links")
    public void setLinks(@Nullable ReviewLinks links) {
      this.links = links;
    }
    @JsonProperty
    public void setCommitId(@Nullable String commitId) {
      this.commitId = commitId;
    }
    @Override
    public Integer id() { throw new UnsupportedOperationException(); }
    @Override
    public User user() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> body() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<GitHubInstant> submittedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String state() { throw new UnsupportedOperationException(); }
    @Override
    public URI htmlUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI pullRequestUrl() { throw new UnsupportedOperationException(); }
    @Override
    public ReviewLinks links() { throw new UnsupportedOperationException(); }
    @Override
    public String commitId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableReview fromJson(Json json) {
    ImmutableReview.Builder builder = ImmutableReview.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.user != null) {
      builder.user(json.user);
    }
    if (json.body != null) {
      builder.body(json.body);
    }
    if (json.submittedAt != null) {
      builder.submittedAt(json.submittedAt);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.htmlUrl != null) {
      builder.htmlUrl(json.htmlUrl);
    }
    if (json.pullRequestUrl != null) {
      builder.pullRequestUrl(json.pullRequestUrl);
    }
    if (json.links != null) {
      builder.links(json.links);
    }
    if (json.commitId != null) {
      builder.commitId(json.commitId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Review} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Review instance
   */
  public static ImmutableReview copyOf(Review instance) {
    if (instance instanceof ImmutableReview) {
      return (ImmutableReview) instance;
    }
    return ImmutableReview.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableReview ImmutableReview}.
   * <pre>
   * ImmutableReview.builder()
   *    .id(Integer | null) // nullable {@link Review#id() id}
   *    .user(com.spotify.github.v3.User | null) // nullable {@link Review#user() user}
   *    .body(Optional&amp;lt;String&amp;gt; | null) // nullable {@link Review#body() body}
   *    .submittedAt(com.spotify.github.GitHubInstant) // optional {@link Review#submittedAt() submittedAt}
   *    .state(String | null) // nullable {@link Review#state() state}
   *    .htmlUrl(java.net.URI | null) // nullable {@link Review#htmlUrl() htmlUrl}
   *    .pullRequestUrl(java.net.URI | null) // nullable {@link Review#pullRequestUrl() pullRequestUrl}
   *    .links(com.spotify.github.v3.activity.events.ReviewLinks | null) // nullable {@link Review#links() links}
   *    .commitId(String | null) // nullable {@link Review#commitId() commitId}
   *    .build();
   * </pre>
   * @return A new ImmutableReview builder
   */
  public static ImmutableReview.Builder builder() {
    return new ImmutableReview.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableReview ImmutableReview}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Review", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Integer id;
    private @Nullable User user;
    private @Nullable Optional<String> body;
    private @Nullable GitHubInstant submittedAt;
    private @Nullable String state;
    private @Nullable URI htmlUrl;
    private @Nullable URI pullRequestUrl;
    private @Nullable ReviewLinks links;
    private @Nullable String commitId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Review} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Review instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Integer idValue = instance.id();
      if (idValue != null) {
        id(idValue);
      }
      @Nullable User userValue = instance.user();
      if (userValue != null) {
        user(userValue);
      }
      @Nullable Optional<String> bodyValue = instance.body();
      if (bodyValue != null) {
        body(bodyValue);
      }
      Optional<GitHubInstant> submittedAtOptional = instance.submittedAt();
      if (submittedAtOptional.isPresent()) {
        submittedAt(submittedAtOptional);
      }
      @Nullable String stateValue = instance.state();
      if (stateValue != null) {
        state(stateValue);
      }
      @Nullable URI htmlUrlValue = instance.htmlUrl();
      if (htmlUrlValue != null) {
        htmlUrl(htmlUrlValue);
      }
      @Nullable URI pullRequestUrlValue = instance.pullRequestUrl();
      if (pullRequestUrlValue != null) {
        pullRequestUrl(pullRequestUrlValue);
      }
      @Nullable ReviewLinks linksValue = instance.links();
      if (linksValue != null) {
        links(linksValue);
      }
      @Nullable String commitIdValue = instance.commitId();
      if (commitIdValue != null) {
        commitId(commitIdValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Review#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(@Nullable Integer id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Review#user() user} attribute.
     * @param user The value for user (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder user(@Nullable User user) {
      this.user = user;
      return this;
    }

    /**
     * Initializes the value for the {@link Review#body() body} attribute.
     * @param body The value for body (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder body(@Nullable Optional<String> body) {
      this.body = body;
      return this;
    }

    /**
     * Initializes the optional value {@link Review#submittedAt() submittedAt} to submittedAt.
     * @param submittedAt The value for submittedAt
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder submittedAt(GitHubInstant submittedAt) {
      this.submittedAt = Objects.requireNonNull(submittedAt, "submittedAt");
      return this;
    }

    /**
     * Initializes the optional value {@link Review#submittedAt() submittedAt} to submittedAt.
     * @param submittedAt The value for submittedAt
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder submittedAt(Optional<? extends GitHubInstant> submittedAt) {
      this.submittedAt = submittedAt.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link Review#state() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the value for the {@link Review#htmlUrl() htmlUrl} attribute.
     * @param htmlUrl The value for htmlUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder htmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link Review#pullRequestUrl() pullRequestUrl} attribute.
     * @param pullRequestUrl The value for pullRequestUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder pullRequestUrl(@Nullable URI pullRequestUrl) {
      this.pullRequestUrl = pullRequestUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link Review#links() links} attribute.
     * @param links The value for links (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("_links")
    public final Builder links(@Nullable ReviewLinks links) {
      this.links = links;
      return this;
    }

    /**
     * Initializes the value for the {@link Review#commitId() commitId} attribute.
     * @param commitId The value for commitId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commitId(@Nullable String commitId) {
      this.commitId = commitId;
      return this;
    }

    /**
     * Builds a new {@link ImmutableReview ImmutableReview}.
     * @return An immutable instance of Review
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableReview build() {
      return new ImmutableReview(id, user, body, submittedAt, state, htmlUrl, pullRequestUrl, links, commitId);
    }
  }
}
