package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.Team;
import com.spotify.github.v3.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ReviewRequests}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableReviewRequests.builder()}.
 */
@Generated(from = "ReviewRequests", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableReviewRequests implements ReviewRequests {
  private final @Nullable List<User> users;
  private final @Nullable List<Team> teams;

  private ImmutableReviewRequests(
      @Nullable List<User> users,
      @Nullable List<Team> teams) {
    this.users = users;
    this.teams = teams;
  }

  /**
   * @return The value of the {@code users} attribute
   */
  @JsonProperty
  @Override
  public @Nullable List<User> users() {
    return users;
  }

  /**
   * @return The value of the {@code teams} attribute
   */
  @JsonProperty
  @Override
  public @Nullable List<Team> teams() {
    return teams;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ReviewRequests#users() users}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableReviewRequests withUsers(@Nullable User... elements) {
    if (elements == null) {
      return new ImmutableReviewRequests(null, this.teams);
    }
    @Nullable List<User> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableReviewRequests(newValue, this.teams);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ReviewRequests#users() users}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of users elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableReviewRequests withUsers(@Nullable Iterable<? extends User> elements) {
    if (this.users == elements) return this;
    @Nullable List<User> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableReviewRequests(newValue, this.teams);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ReviewRequests#teams() teams}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableReviewRequests withTeams(@Nullable Team... elements) {
    if (elements == null) {
      return new ImmutableReviewRequests(this.users, null);
    }
    @Nullable List<Team> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableReviewRequests(this.users, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ReviewRequests#teams() teams}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of teams elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableReviewRequests withTeams(@Nullable Iterable<? extends Team> elements) {
    if (this.teams == elements) return this;
    @Nullable List<Team> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableReviewRequests(this.users, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableReviewRequests} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableReviewRequests
        && equalTo(0, (ImmutableReviewRequests) another);
  }

  private boolean equalTo(int synthetic, ImmutableReviewRequests another) {
    return Objects.equals(users, another.users)
        && Objects.equals(teams, another.teams);
  }

  /**
   * Computes a hash code from attributes: {@code users}, {@code teams}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(users);
    h += (h << 5) + Objects.hashCode(teams);
    return h;
  }

  /**
   * Prints the immutable value {@code ReviewRequests} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ReviewRequests{"
        + "users=" + users
        + ", teams=" + teams
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ReviewRequests", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ReviewRequests {
    @Nullable List<User> users = null;
    @Nullable List<Team> teams = null;
    @JsonProperty
    public void setUsers(@Nullable List<User> users) {
      this.users = users;
    }
    @JsonProperty
    public void setTeams(@Nullable List<Team> teams) {
      this.teams = teams;
    }
    @Override
    public List<User> users() { throw new UnsupportedOperationException(); }
    @Override
    public List<Team> teams() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableReviewRequests fromJson(Json json) {
    ImmutableReviewRequests.Builder builder = ImmutableReviewRequests.builder();
    if (json.users != null) {
      builder.addAllUsers(json.users);
    }
    if (json.teams != null) {
      builder.addAllTeams(json.teams);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ReviewRequests} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ReviewRequests instance
   */
  public static ImmutableReviewRequests copyOf(ReviewRequests instance) {
    if (instance instanceof ImmutableReviewRequests) {
      return (ImmutableReviewRequests) instance;
    }
    return ImmutableReviewRequests.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableReviewRequests ImmutableReviewRequests}.
   * <pre>
   * ImmutableReviewRequests.builder()
   *    .users(List&amp;lt;com.spotify.github.v3.User&amp;gt; | null) // nullable {@link ReviewRequests#users() users}
   *    .teams(List&amp;lt;com.spotify.github.v3.Team&amp;gt; | null) // nullable {@link ReviewRequests#teams() teams}
   *    .build();
   * </pre>
   * @return A new ImmutableReviewRequests builder
   */
  public static ImmutableReviewRequests.Builder builder() {
    return new ImmutableReviewRequests.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableReviewRequests ImmutableReviewRequests}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ReviewRequests", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<User> users = null;
    private List<Team> teams = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReviewRequests} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ReviewRequests instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable List<User> usersValue = instance.users();
      if (usersValue != null) {
        addAllUsers(usersValue);
      }
      @Nullable List<Team> teamsValue = instance.teams();
      if (teamsValue != null) {
        addAllTeams(teamsValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link ReviewRequests#users() users} list.
     * @param element A users element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addUsers(User element) {
      if (this.users == null) {
        this.users = new ArrayList<User>();
      }
      this.users.add(Objects.requireNonNull(element, "users element"));
      return this;
    }

    /**
     * Adds elements to {@link ReviewRequests#users() users} list.
     * @param elements An array of users elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addUsers(User... elements) {
      if (this.users == null) {
        this.users = new ArrayList<User>();
      }
      for (User element : elements) {
        this.users.add(Objects.requireNonNull(element, "users element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ReviewRequests#users() users} list.
     * @param elements An iterable of users elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder users(@Nullable Iterable<? extends User> elements) {
      if (elements == null) {
        this.users = null;
        return this;
      }
      this.users = new ArrayList<User>();
      return addAllUsers(elements);
    }

    /**
     * Adds elements to {@link ReviewRequests#users() users} list.
     * @param elements An iterable of users elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllUsers(Iterable<? extends User> elements) {
      Objects.requireNonNull(elements, "users element");
      if (this.users == null) {
        this.users = new ArrayList<User>();
      }
      for (User element : elements) {
        this.users.add(Objects.requireNonNull(element, "users element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ReviewRequests#teams() teams} list.
     * @param element A teams element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTeams(Team element) {
      if (this.teams == null) {
        this.teams = new ArrayList<Team>();
      }
      this.teams.add(Objects.requireNonNull(element, "teams element"));
      return this;
    }

    /**
     * Adds elements to {@link ReviewRequests#teams() teams} list.
     * @param elements An array of teams elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTeams(Team... elements) {
      if (this.teams == null) {
        this.teams = new ArrayList<Team>();
      }
      for (Team element : elements) {
        this.teams.add(Objects.requireNonNull(element, "teams element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ReviewRequests#teams() teams} list.
     * @param elements An iterable of teams elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder teams(@Nullable Iterable<? extends Team> elements) {
      if (elements == null) {
        this.teams = null;
        return this;
      }
      this.teams = new ArrayList<Team>();
      return addAllTeams(elements);
    }

    /**
     * Adds elements to {@link ReviewRequests#teams() teams} list.
     * @param elements An iterable of teams elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTeams(Iterable<? extends Team> elements) {
      Objects.requireNonNull(elements, "teams element");
      if (this.teams == null) {
        this.teams = new ArrayList<Team>();
      }
      for (Team element : elements) {
        this.teams.add(Objects.requireNonNull(element, "teams element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableReviewRequests ImmutableReviewRequests}.
     * @return An immutable instance of ReviewRequests
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableReviewRequests build() {
      return new ImmutableReviewRequests(
          users == null ? null : createUnmodifiableList(true, users),
          teams == null ? null : createUnmodifiableList(true, teams));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
