package com.spotify.github.v3.prs.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PullRequestCreate}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePullRequestCreate.builder()}.
 */
@Generated(from = "PullRequestCreate", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePullRequestCreate implements PullRequestCreate {
  private final @Nullable String title;
  private final @Nullable String body;
  private final @Nullable String head;
  private final @Nullable String base;
  private final @Nullable Boolean draft;

  private ImmutablePullRequestCreate(
      @Nullable String title,
      @Nullable String body,
      @Nullable String head,
      @Nullable String base,
      @Nullable Boolean draft) {
    this.title = title;
    this.body = body;
    this.head = head;
    this.base = base;
    this.draft = draft;
  }

  /**
   *The title of the pull request. 
   */
  @JsonProperty
  @Override
  public @Nullable String title() {
    return title;
  }

  /**
   *The contents of the pull request. 
   */
  @JsonProperty
  @Override
  public Optional<String> body() {
    return Optional.ofNullable(body);
  }

  /**
   * The name of the branch where your changes are implemented. For cross-repository pull requests
   * in the same network, namespace head with a user like this: username:branch.
   */
  @JsonProperty
  @Override
  public @Nullable String head() {
    return head;
  }

  /**
   * The name of the branch you want your changes pulled into. This should be an existing branch on
   * the current repository. You cannot submit a pull request to one repository that requests a
   * merge to a base of another repository.
   */
  @JsonProperty
  @Override
  public @Nullable String base() {
    return base;
  }

  /**
   * Indicates whether the pull request is a draft.
   */
  @JsonProperty
  @Override
  public @Nullable Boolean draft() {
    return draft;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestCreate#title() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for title (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestCreate withTitle(@Nullable String value) {
    if (Objects.equals(this.title, value)) return this;
    return new ImmutablePullRequestCreate(value, this.body, this.head, this.base, this.draft);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequestCreate#body() body} attribute.
   * @param value The value for body
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestCreate withBody(String value) {
    String newValue = Objects.requireNonNull(value, "body");
    if (Objects.equals(this.body, newValue)) return this;
    return new ImmutablePullRequestCreate(this.title, newValue, this.head, this.base, this.draft);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequestCreate#body() body} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for body
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestCreate withBody(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.body, value)) return this;
    return new ImmutablePullRequestCreate(this.title, value, this.head, this.base, this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestCreate#head() head} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for head (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestCreate withHead(@Nullable String value) {
    if (Objects.equals(this.head, value)) return this;
    return new ImmutablePullRequestCreate(this.title, this.body, value, this.base, this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestCreate#base() base} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for base (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestCreate withBase(@Nullable String value) {
    if (Objects.equals(this.base, value)) return this;
    return new ImmutablePullRequestCreate(this.title, this.body, this.head, value, this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestCreate#draft() draft} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draft (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestCreate withDraft(@Nullable Boolean value) {
    if (Objects.equals(this.draft, value)) return this;
    return new ImmutablePullRequestCreate(this.title, this.body, this.head, this.base, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePullRequestCreate} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePullRequestCreate
        && equalTo(0, (ImmutablePullRequestCreate) another);
  }

  private boolean equalTo(int synthetic, ImmutablePullRequestCreate another) {
    return Objects.equals(title, another.title)
        && Objects.equals(body, another.body)
        && Objects.equals(head, another.head)
        && Objects.equals(base, another.base)
        && Objects.equals(draft, another.draft);
  }

  /**
   * Computes a hash code from attributes: {@code title}, {@code body}, {@code head}, {@code base}, {@code draft}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(title);
    h += (h << 5) + Objects.hashCode(body);
    h += (h << 5) + Objects.hashCode(head);
    h += (h << 5) + Objects.hashCode(base);
    h += (h << 5) + Objects.hashCode(draft);
    return h;
  }

  /**
   * Prints the immutable value {@code PullRequestCreate} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("PullRequestCreate{");
    if (title != null) {
      builder.append("title=").append(title);
    }
    if (body != null) {
      if (builder.length() > 18) builder.append(", ");
      builder.append("body=").append(body);
    }
    if (head != null) {
      if (builder.length() > 18) builder.append(", ");
      builder.append("head=").append(head);
    }
    if (base != null) {
      if (builder.length() > 18) builder.append(", ");
      builder.append("base=").append(base);
    }
    if (draft != null) {
      if (builder.length() > 18) builder.append(", ");
      builder.append("draft=").append(draft);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PullRequestCreate", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PullRequestCreate {
    @Nullable String title;
    @Nullable Optional<String> body = Optional.empty();
    @Nullable String head;
    @Nullable String base;
    @Nullable Boolean draft;
    @JsonProperty
    public void setTitle(@Nullable String title) {
      this.title = title;
    }
    @JsonProperty
    public void setBody(Optional<String> body) {
      this.body = body;
    }
    @JsonProperty
    public void setHead(@Nullable String head) {
      this.head = head;
    }
    @JsonProperty
    public void setBase(@Nullable String base) {
      this.base = base;
    }
    @JsonProperty
    public void setDraft(@Nullable Boolean draft) {
      this.draft = draft;
    }
    @Override
    public String title() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> body() { throw new UnsupportedOperationException(); }
    @Override
    public String head() { throw new UnsupportedOperationException(); }
    @Override
    public String base() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean draft() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePullRequestCreate fromJson(Json json) {
    ImmutablePullRequestCreate.Builder builder = ImmutablePullRequestCreate.builder();
    if (json.title != null) {
      builder.title(json.title);
    }
    if (json.body != null) {
      builder.body(json.body);
    }
    if (json.head != null) {
      builder.head(json.head);
    }
    if (json.base != null) {
      builder.base(json.base);
    }
    if (json.draft != null) {
      builder.draft(json.draft);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PullRequestCreate} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PullRequestCreate instance
   */
  public static ImmutablePullRequestCreate copyOf(PullRequestCreate instance) {
    if (instance instanceof ImmutablePullRequestCreate) {
      return (ImmutablePullRequestCreate) instance;
    }
    return ImmutablePullRequestCreate.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePullRequestCreate ImmutablePullRequestCreate}.
   * <pre>
   * ImmutablePullRequestCreate.builder()
   *    .title(String | null) // nullable {@link PullRequestCreate#title() title}
   *    .body(String) // optional {@link PullRequestCreate#body() body}
   *    .head(String | null) // nullable {@link PullRequestCreate#head() head}
   *    .base(String | null) // nullable {@link PullRequestCreate#base() base}
   *    .draft(Boolean | null) // nullable {@link PullRequestCreate#draft() draft}
   *    .build();
   * </pre>
   * @return A new ImmutablePullRequestCreate builder
   */
  public static ImmutablePullRequestCreate.Builder builder() {
    return new ImmutablePullRequestCreate.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePullRequestCreate ImmutablePullRequestCreate}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PullRequestCreate", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String title;
    private @Nullable String body;
    private @Nullable String head;
    private @Nullable String base;
    private @Nullable Boolean draft;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PullRequestCreate} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PullRequestCreate instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String titleValue = instance.title();
      if (titleValue != null) {
        title(titleValue);
      }
      Optional<String> bodyOptional = instance.body();
      if (bodyOptional.isPresent()) {
        body(bodyOptional);
      }
      @Nullable String headValue = instance.head();
      if (headValue != null) {
        head(headValue);
      }
      @Nullable String baseValue = instance.base();
      if (baseValue != null) {
        base(baseValue);
      }
      @Nullable Boolean draftValue = instance.draft();
      if (draftValue != null) {
        draft(draftValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestCreate#title() title} attribute.
     * @param title The value for title (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder title(@Nullable String title) {
      this.title = title;
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestCreate#body() body} to body.
     * @param body The value for body
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder body(String body) {
      this.body = Objects.requireNonNull(body, "body");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestCreate#body() body} to body.
     * @param body The value for body
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder body(Optional<String> body) {
      this.body = body.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestCreate#head() head} attribute.
     * @param head The value for head (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder head(@Nullable String head) {
      this.head = head;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestCreate#base() base} attribute.
     * @param base The value for base (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder base(@Nullable String base) {
      this.base = base;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestCreate#draft() draft} attribute.
     * @param draft The value for draft (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder draft(@Nullable Boolean draft) {
      this.draft = draft;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePullRequestCreate ImmutablePullRequestCreate}.
     * @return An immutable instance of PullRequestCreate
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePullRequestCreate build() {
      return new ImmutablePullRequestCreate(title, body, head, base, draft);
    }
  }
}
