package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.User;
import com.spotify.github.v3.git.ShaLink;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Commit}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCommit.builder()}.
 */
@Generated(from = "Commit", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCommit implements Commit {
  private final @Nullable String sha;
  private final @Nullable URI url;
  private final @Nullable com.spotify.github.v3.git.Commit commit;
  private final @Nullable URI htmlUrl;
  private final @Nullable URI commentsUrl;
  private final @Nullable User author;
  private final @Nullable List<ShaLink> parents;
  private final @Nullable Map<String, Integer> stats;
  private final @Nullable List<File> files;
  private final @Nullable ShaLink tree;

  private ImmutableCommit(
      @Nullable String sha,
      @Nullable URI url,
      @Nullable com.spotify.github.v3.git.Commit commit,
      @Nullable URI htmlUrl,
      @Nullable URI commentsUrl,
      @Nullable User author,
      @Nullable List<ShaLink> parents,
      @Nullable Map<String, Integer> stats,
      @Nullable List<File> files,
      @Nullable ShaLink tree) {
    this.sha = sha;
    this.url = url;
    this.commit = commit;
    this.htmlUrl = htmlUrl;
    this.commentsUrl = commentsUrl;
    this.author = author;
    this.parents = parents;
    this.stats = stats;
    this.files = files;
    this.tree = tree;
  }

  /**
   *SHA. 
   */
  @JsonProperty
  @Override
  public @Nullable String sha() {
    return sha;
  }

  /**
   *URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *Commit details 
   */
  @JsonProperty
  @Override
  public @Nullable com.spotify.github.v3.git.Commit commit() {
    return commit;
  }

  /**
   *HTML URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI htmlUrl() {
    return htmlUrl;
  }

  /**
   *Comments URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI commentsUrl() {
    return commentsUrl;
  }

  /**
   *Author user 
   */
  @JsonProperty
  @Override
  public Optional<User> author() {
    return Optional.ofNullable(author);
  }

  /**
   *The SHAs of the commits that were the parents of this commit 
   */
  @JsonProperty
  @Override
  public @Nullable List<ShaLink> parents() {
    return parents;
  }

  /**
   *Commit statistics key, value map. E.g. additions: 104 deletions: 4 total: 108 
   */
  @JsonProperty
  @Override
  public @Nullable Map<String, Integer> stats() {
    return stats;
  }

  /**
   *File objects included in the commit. 
   */
  @JsonProperty
  @Override
  public @Nullable List<File> files() {
    return files;
  }

  /**
   *The SHA of the tree object this commit points to. 
   */
  @JsonProperty
  @Override
  public @Nullable ShaLink tree() {
    return tree;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Commit#sha() sha} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sha (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommit withSha(@Nullable String value) {
    if (Objects.equals(this.sha, value)) return this;
    return new ImmutableCommit(
        value,
        this.url,
        this.commit,
        this.htmlUrl,
        this.commentsUrl,
        this.author,
        this.parents,
        this.stats,
        this.files,
        this.tree);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Commit#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommit withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableCommit(
        this.sha,
        value,
        this.commit,
        this.htmlUrl,
        this.commentsUrl,
        this.author,
        this.parents,
        this.stats,
        this.files,
        this.tree);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Commit#commit() commit} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commit (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommit withCommit(@Nullable com.spotify.github.v3.git.Commit value) {
    if (this.commit == value) return this;
    return new ImmutableCommit(
        this.sha,
        this.url,
        value,
        this.htmlUrl,
        this.commentsUrl,
        this.author,
        this.parents,
        this.stats,
        this.files,
        this.tree);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Commit#htmlUrl() htmlUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for htmlUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommit withHtmlUrl(@Nullable URI value) {
    if (this.htmlUrl == value) return this;
    return new ImmutableCommit(
        this.sha,
        this.url,
        this.commit,
        value,
        this.commentsUrl,
        this.author,
        this.parents,
        this.stats,
        this.files,
        this.tree);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Commit#commentsUrl() commentsUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commentsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommit withCommentsUrl(@Nullable URI value) {
    if (this.commentsUrl == value) return this;
    return new ImmutableCommit(
        this.sha,
        this.url,
        this.commit,
        this.htmlUrl,
        value,
        this.author,
        this.parents,
        this.stats,
        this.files,
        this.tree);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Commit#author() author} attribute.
   * @param value The value for author
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommit withAuthor(User value) {
    User newValue = Objects.requireNonNull(value, "author");
    if (this.author == newValue) return this;
    return new ImmutableCommit(
        this.sha,
        this.url,
        this.commit,
        this.htmlUrl,
        this.commentsUrl,
        newValue,
        this.parents,
        this.stats,
        this.files,
        this.tree);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Commit#author() author} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for author
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableCommit withAuthor(Optional<? extends User> optional) {
    @Nullable User value = optional.orElse(null);
    if (this.author == value) return this;
    return new ImmutableCommit(
        this.sha,
        this.url,
        this.commit,
        this.htmlUrl,
        this.commentsUrl,
        value,
        this.parents,
        this.stats,
        this.files,
        this.tree);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Commit#parents() parents}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommit withParents(@Nullable ShaLink... elements) {
    if (elements == null) {
      return new ImmutableCommit(
          this.sha,
          this.url,
          this.commit,
          this.htmlUrl,
          this.commentsUrl,
          this.author,
          null,
          this.stats,
          this.files,
          this.tree);
    }
    @Nullable List<ShaLink> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableCommit(
        this.sha,
        this.url,
        this.commit,
        this.htmlUrl,
        this.commentsUrl,
        this.author,
        newValue,
        this.stats,
        this.files,
        this.tree);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Commit#parents() parents}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of parents elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommit withParents(@Nullable Iterable<? extends ShaLink> elements) {
    if (this.parents == elements) return this;
    @Nullable List<ShaLink> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableCommit(
        this.sha,
        this.url,
        this.commit,
        this.htmlUrl,
        this.commentsUrl,
        this.author,
        newValue,
        this.stats,
        this.files,
        this.tree);
  }

  /**
   * Copy the current immutable object by replacing the {@link Commit#stats() stats} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the stats map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommit withStats(@Nullable Map<String, ? extends Integer> entries) {
    if (this.stats == entries) return this;
    @Nullable Map<String, Integer> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return new ImmutableCommit(
        this.sha,
        this.url,
        this.commit,
        this.htmlUrl,
        this.commentsUrl,
        this.author,
        this.parents,
        newValue,
        this.files,
        this.tree);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Commit#files() files}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommit withFiles(@Nullable File... elements) {
    if (elements == null) {
      return new ImmutableCommit(
          this.sha,
          this.url,
          this.commit,
          this.htmlUrl,
          this.commentsUrl,
          this.author,
          this.parents,
          this.stats,
          null,
          this.tree);
    }
    @Nullable List<File> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableCommit(
        this.sha,
        this.url,
        this.commit,
        this.htmlUrl,
        this.commentsUrl,
        this.author,
        this.parents,
        this.stats,
        newValue,
        this.tree);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Commit#files() files}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of files elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommit withFiles(@Nullable Iterable<? extends File> elements) {
    if (this.files == elements) return this;
    @Nullable List<File> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableCommit(
        this.sha,
        this.url,
        this.commit,
        this.htmlUrl,
        this.commentsUrl,
        this.author,
        this.parents,
        this.stats,
        newValue,
        this.tree);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Commit#tree() tree} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tree (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommit withTree(@Nullable ShaLink value) {
    if (this.tree == value) return this;
    return new ImmutableCommit(
        this.sha,
        this.url,
        this.commit,
        this.htmlUrl,
        this.commentsUrl,
        this.author,
        this.parents,
        this.stats,
        this.files,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCommit} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCommit
        && equalTo(0, (ImmutableCommit) another);
  }

  private boolean equalTo(int synthetic, ImmutableCommit another) {
    return Objects.equals(sha, another.sha)
        && Objects.equals(url, another.url)
        && Objects.equals(commit, another.commit)
        && Objects.equals(htmlUrl, another.htmlUrl)
        && Objects.equals(commentsUrl, another.commentsUrl)
        && Objects.equals(author, another.author)
        && Objects.equals(parents, another.parents)
        && Objects.equals(stats, another.stats)
        && Objects.equals(files, another.files)
        && Objects.equals(tree, another.tree);
  }

  /**
   * Computes a hash code from attributes: {@code sha}, {@code url}, {@code commit}, {@code htmlUrl}, {@code commentsUrl}, {@code author}, {@code parents}, {@code stats}, {@code files}, {@code tree}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(sha);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(commit);
    h += (h << 5) + Objects.hashCode(htmlUrl);
    h += (h << 5) + Objects.hashCode(commentsUrl);
    h += (h << 5) + Objects.hashCode(author);
    h += (h << 5) + Objects.hashCode(parents);
    h += (h << 5) + Objects.hashCode(stats);
    h += (h << 5) + Objects.hashCode(files);
    h += (h << 5) + Objects.hashCode(tree);
    return h;
  }

  /**
   * Prints the immutable value {@code Commit} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Commit{");
    if (sha != null) {
      builder.append("sha=").append(sha);
    }
    if (url != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("url=").append(url);
    }
    if (commit != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("commit=").append(commit);
    }
    if (htmlUrl != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("htmlUrl=").append(htmlUrl);
    }
    if (commentsUrl != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("commentsUrl=").append(commentsUrl);
    }
    if (author != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("author=").append(author);
    }
    if (parents != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("parents=").append(parents);
    }
    if (stats != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("stats=").append(stats);
    }
    if (files != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("files=").append(files);
    }
    if (tree != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("tree=").append(tree);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Commit", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Commit {
    @Nullable String sha;
    @Nullable URI url;
    @Nullable com.spotify.github.v3.git.Commit commit;
    @Nullable URI htmlUrl;
    @Nullable URI commentsUrl;
    @Nullable Optional<User> author = Optional.empty();
    @Nullable List<ShaLink> parents = null;
    @Nullable Map<String, Integer> stats = null;
    @Nullable List<File> files = null;
    @Nullable ShaLink tree;
    @JsonProperty
    public void setSha(@Nullable String sha) {
      this.sha = sha;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setCommit(@Nullable com.spotify.github.v3.git.Commit commit) {
      this.commit = commit;
    }
    @JsonProperty
    public void setHtmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
    }
    @JsonProperty
    public void setCommentsUrl(@Nullable URI commentsUrl) {
      this.commentsUrl = commentsUrl;
    }
    @JsonProperty
    public void setAuthor(Optional<User> author) {
      this.author = author;
    }
    @JsonProperty
    public void setParents(@Nullable List<ShaLink> parents) {
      this.parents = parents;
    }
    @JsonProperty
    public void setStats(@Nullable Map<String, Integer> stats) {
      this.stats = stats;
    }
    @JsonProperty
    public void setFiles(@Nullable List<File> files) {
      this.files = files;
    }
    @JsonProperty
    public void setTree(@Nullable ShaLink tree) {
      this.tree = tree;
    }
    @Override
    public String sha() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public com.spotify.github.v3.git.Commit commit() { throw new UnsupportedOperationException(); }
    @Override
    public URI htmlUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI commentsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<User> author() { throw new UnsupportedOperationException(); }
    @Override
    public List<ShaLink> parents() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Integer> stats() { throw new UnsupportedOperationException(); }
    @Override
    public List<File> files() { throw new UnsupportedOperationException(); }
    @Override
    public ShaLink tree() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCommit fromJson(Json json) {
    ImmutableCommit.Builder builder = ImmutableCommit.builder();
    if (json.sha != null) {
      builder.sha(json.sha);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.commit != null) {
      builder.commit(json.commit);
    }
    if (json.htmlUrl != null) {
      builder.htmlUrl(json.htmlUrl);
    }
    if (json.commentsUrl != null) {
      builder.commentsUrl(json.commentsUrl);
    }
    if (json.author != null) {
      builder.author(json.author);
    }
    if (json.parents != null) {
      builder.addAllParents(json.parents);
    }
    if (json.stats != null) {
      builder.putAllStats(json.stats);
    }
    if (json.files != null) {
      builder.addAllFiles(json.files);
    }
    if (json.tree != null) {
      builder.tree(json.tree);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Commit} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Commit instance
   */
  public static ImmutableCommit copyOf(Commit instance) {
    if (instance instanceof ImmutableCommit) {
      return (ImmutableCommit) instance;
    }
    return ImmutableCommit.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCommit ImmutableCommit}.
   * <pre>
   * ImmutableCommit.builder()
   *    .sha(String | null) // nullable {@link Commit#sha() sha}
   *    .url(java.net.URI | null) // nullable {@link Commit#url() url}
   *    .commit(com.spotify.github.v3.git.Commit | null) // nullable {@link Commit#commit() commit}
   *    .htmlUrl(java.net.URI | null) // nullable {@link Commit#htmlUrl() htmlUrl}
   *    .commentsUrl(java.net.URI | null) // nullable {@link Commit#commentsUrl() commentsUrl}
   *    .author(com.spotify.github.v3.User) // optional {@link Commit#author() author}
   *    .parents(List&amp;lt;com.spotify.github.v3.git.ShaLink&amp;gt; | null) // nullable {@link Commit#parents() parents}
   *    .stats(Map&amp;lt;String, Integer&amp;gt; | null) // nullable {@link Commit#stats() stats}
   *    .files(List&amp;lt;com.spotify.github.v3.repos.File&amp;gt; | null) // nullable {@link Commit#files() files}
   *    .tree(com.spotify.github.v3.git.ShaLink | null) // nullable {@link Commit#tree() tree}
   *    .build();
   * </pre>
   * @return A new ImmutableCommit builder
   */
  public static ImmutableCommit.Builder builder() {
    return new ImmutableCommit.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCommit ImmutableCommit}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Commit", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String sha;
    private @Nullable URI url;
    private @Nullable com.spotify.github.v3.git.Commit commit;
    private @Nullable URI htmlUrl;
    private @Nullable URI commentsUrl;
    private @Nullable User author;
    private List<ShaLink> parents = null;
    private Map<String, Integer> stats = null;
    private List<File> files = null;
    private @Nullable ShaLink tree;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.repos.Commit} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Commit instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.git.ShaLink} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ShaLink instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.repos.CommitItem} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CommitItem instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof Commit) {
        Commit instance = (Commit) object;
        if ((bits & 0x1L) == 0) {
          @Nullable URI commentsUrlValue = instance.commentsUrl();
          if (commentsUrlValue != null) {
            commentsUrl(commentsUrlValue);
          }
          bits |= 0x1L;
        }
        @Nullable Map<String, Integer> statsValue = instance.stats();
        if (statsValue != null) {
          putAllStats(statsValue);
        }
        if ((bits & 0x2L) == 0) {
          Optional<User> authorOptional = instance.author();
          if (authorOptional.isPresent()) {
            author(authorOptional);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          @Nullable com.spotify.github.v3.git.Commit commitValue = instance.commit();
          if (commitValue != null) {
            commit(commitValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          @Nullable URI htmlUrlValue = instance.htmlUrl();
          if (htmlUrlValue != null) {
            htmlUrl(htmlUrlValue);
          }
          bits |= 0x8L;
        }
        @Nullable ShaLink treeValue = instance.tree();
        if (treeValue != null) {
          tree(treeValue);
        }
        @Nullable List<File> filesValue = instance.files();
        if (filesValue != null) {
          addAllFiles(filesValue);
        }
        if ((bits & 0x10L) == 0) {
          @Nullable String shaValue = instance.sha();
          if (shaValue != null) {
            sha(shaValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          @Nullable URI urlValue = instance.url();
          if (urlValue != null) {
            url(urlValue);
          }
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          @Nullable List<ShaLink> parentsValue = instance.parents();
          if (parentsValue != null) {
            addAllParents(parentsValue);
          }
          bits |= 0x40L;
        }
      }
      if (object instanceof ShaLink) {
        ShaLink instance = (ShaLink) object;
        if ((bits & 0x10L) == 0) {
          @Nullable String shaValue = instance.sha();
          if (shaValue != null) {
            sha(shaValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          @Nullable URI urlValue = instance.url();
          if (urlValue != null) {
            url(urlValue);
          }
          bits |= 0x20L;
        }
      }
      if (object instanceof CommitItem) {
        CommitItem instance = (CommitItem) object;
        if ((bits & 0x1L) == 0) {
          @Nullable URI commentsUrlValue = instance.commentsUrl();
          if (commentsUrlValue != null) {
            commentsUrl(commentsUrlValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          Optional<User> authorOptional = instance.author();
          if (authorOptional.isPresent()) {
            author(authorOptional);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          @Nullable com.spotify.github.v3.git.Commit commitValue = instance.commit();
          if (commitValue != null) {
            commit(commitValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          @Nullable URI htmlUrlValue = instance.htmlUrl();
          if (htmlUrlValue != null) {
            htmlUrl(htmlUrlValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          @Nullable String shaValue = instance.sha();
          if (shaValue != null) {
            sha(shaValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          @Nullable URI urlValue = instance.url();
          if (urlValue != null) {
            url(urlValue);
          }
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          @Nullable List<ShaLink> parentsValue = instance.parents();
          if (parentsValue != null) {
            addAllParents(parentsValue);
          }
          bits |= 0x40L;
        }
      }
    }

    /**
     * Initializes the value for the {@link Commit#sha() sha} attribute.
     * @param sha The value for sha (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sha(@Nullable String sha) {
      this.sha = sha;
      return this;
    }

    /**
     * Initializes the value for the {@link Commit#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link Commit#commit() commit} attribute.
     * @param commit The value for commit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commit(@Nullable com.spotify.github.v3.git.Commit commit) {
      this.commit = commit;
      return this;
    }

    /**
     * Initializes the value for the {@link Commit#htmlUrl() htmlUrl} attribute.
     * @param htmlUrl The value for htmlUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder htmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link Commit#commentsUrl() commentsUrl} attribute.
     * @param commentsUrl The value for commentsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commentsUrl(@Nullable URI commentsUrl) {
      this.commentsUrl = commentsUrl;
      return this;
    }

    /**
     * Initializes the optional value {@link Commit#author() author} to author.
     * @param author The value for author
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder author(User author) {
      this.author = Objects.requireNonNull(author, "author");
      return this;
    }

    /**
     * Initializes the optional value {@link Commit#author() author} to author.
     * @param author The value for author
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder author(Optional<? extends User> author) {
      this.author = author.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link Commit#parents() parents} list.
     * @param element A parents element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addParents(ShaLink element) {
      if (this.parents == null) {
        this.parents = new ArrayList<ShaLink>();
      }
      this.parents.add(Objects.requireNonNull(element, "parents element"));
      return this;
    }

    /**
     * Adds elements to {@link Commit#parents() parents} list.
     * @param elements An array of parents elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addParents(ShaLink... elements) {
      if (this.parents == null) {
        this.parents = new ArrayList<ShaLink>();
      }
      for (ShaLink element : elements) {
        this.parents.add(Objects.requireNonNull(element, "parents element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Commit#parents() parents} list.
     * @param elements An iterable of parents elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder parents(@Nullable Iterable<? extends ShaLink> elements) {
      if (elements == null) {
        this.parents = null;
        return this;
      }
      this.parents = new ArrayList<ShaLink>();
      return addAllParents(elements);
    }

    /**
     * Adds elements to {@link Commit#parents() parents} list.
     * @param elements An iterable of parents elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllParents(Iterable<? extends ShaLink> elements) {
      Objects.requireNonNull(elements, "parents element");
      if (this.parents == null) {
        this.parents = new ArrayList<ShaLink>();
      }
      for (ShaLink element : elements) {
        this.parents.add(Objects.requireNonNull(element, "parents element"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link Commit#stats() stats} map.
     * @param key The key in the stats map
     * @param value The associated value in the stats map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putStats(String key, int value) {
      if (this.stats == null) {
        this.stats = new LinkedHashMap<String, Integer>();
      }
      this.stats.put(
          Objects.requireNonNull(key, "stats key"),
          value);
      return this;
    }

    /**
     * Put one entry to the {@link Commit#stats() stats} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putStats(Map.Entry<String, ? extends Integer> entry) {
      if (this.stats == null) {
        this.stats = new LinkedHashMap<String, Integer>();
      }
      String k = entry.getKey();
      Integer v = entry.getValue();
      this.stats.put(
          Objects.requireNonNull(k, "stats key"),
          v == null ? Objects.requireNonNull(v, "stats value for key: " + k) : v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Commit#stats() stats} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the stats map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder stats(@Nullable Map<String, ? extends Integer> entries) {
      if (entries == null) {
        this.stats = null;
        return this;
      }
      this.stats = new LinkedHashMap<String, Integer>();
      return putAllStats(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Commit#stats() stats} map. Nulls are not permitted
     * @param entries The entries that will be added to the stats map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllStats(Map<String, ? extends Integer> entries) {
      if (this.stats == null) {
        this.stats = new LinkedHashMap<String, Integer>();
      }
      for (Map.Entry<String, ? extends Integer> e : entries.entrySet()) {
        String k = e.getKey();
        Integer v = e.getValue();
        this.stats.put(
            Objects.requireNonNull(k, "stats key"),
            v == null ? Objects.requireNonNull(v, "stats value for key: " + k) : v);
      }
      return this;
    }

    /**
     * Adds one element to {@link Commit#files() files} list.
     * @param element A files element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFiles(File element) {
      if (this.files == null) {
        this.files = new ArrayList<File>();
      }
      this.files.add(Objects.requireNonNull(element, "files element"));
      return this;
    }

    /**
     * Adds elements to {@link Commit#files() files} list.
     * @param elements An array of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFiles(File... elements) {
      if (this.files == null) {
        this.files = new ArrayList<File>();
      }
      for (File element : elements) {
        this.files.add(Objects.requireNonNull(element, "files element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Commit#files() files} list.
     * @param elements An iterable of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder files(@Nullable Iterable<? extends File> elements) {
      if (elements == null) {
        this.files = null;
        return this;
      }
      this.files = new ArrayList<File>();
      return addAllFiles(elements);
    }

    /**
     * Adds elements to {@link Commit#files() files} list.
     * @param elements An iterable of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllFiles(Iterable<? extends File> elements) {
      Objects.requireNonNull(elements, "files element");
      if (this.files == null) {
        this.files = new ArrayList<File>();
      }
      for (File element : elements) {
        this.files.add(Objects.requireNonNull(element, "files element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Commit#tree() tree} attribute.
     * @param tree The value for tree (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder tree(@Nullable ShaLink tree) {
      this.tree = tree;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCommit ImmutableCommit}.
     * @return An immutable instance of Commit
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCommit build() {
      return new ImmutableCommit(
          sha,
          url,
          commit,
          htmlUrl,
          commentsUrl,
          author,
          parents == null ? null : createUnmodifiableList(true, parents),
          stats == null ? null : createUnmodifiableMap(false, false, stats),
          files == null ? null : createUnmodifiableList(true, files),
          tree);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
