package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CommitStatus}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCommitStatus.builder()}.
 */
@Generated(from = "CommitStatus", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCommitStatus implements CommitStatus {
  private final @Nullable String state;
  private final @Nullable List<Status> statuses;
  private final @Nullable String sha;

  private ImmutableCommitStatus(
      @Nullable String state,
      @Nullable List<Status> statuses,
      @Nullable String sha) {
    this.state = state;
    this.statuses = statuses;
    this.sha = sha;
  }

  /**
   * The result of the status. Can be success, failure or pending.
   * @return the string
   */
  @JsonProperty
  @Override
  public @Nullable String state() {
    return state;
  }

  /**
   * Statuses list.
   * @return the list
   */
  @JsonProperty
  @Override
  public @Nullable List<Status> statuses() {
    return statuses;
  }

  /**
   * The commit SHA.
   * @return the string
   */
  @JsonProperty
  @Override
  public @Nullable String sha() {
    return sha;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitStatus#state() state} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for state (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitStatus withState(@Nullable String value) {
    if (Objects.equals(this.state, value)) return this;
    return new ImmutableCommitStatus(value, this.statuses, this.sha);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommitStatus#statuses() statuses}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitStatus withStatuses(@Nullable Status... elements) {
    if (elements == null) {
      return new ImmutableCommitStatus(this.state, null, this.sha);
    }
    @Nullable List<Status> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableCommitStatus(this.state, newValue, this.sha);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommitStatus#statuses() statuses}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of statuses elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitStatus withStatuses(@Nullable Iterable<? extends Status> elements) {
    if (this.statuses == elements) return this;
    @Nullable List<Status> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableCommitStatus(this.state, newValue, this.sha);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitStatus#sha() sha} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sha (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitStatus withSha(@Nullable String value) {
    if (Objects.equals(this.sha, value)) return this;
    return new ImmutableCommitStatus(this.state, this.statuses, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCommitStatus} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCommitStatus
        && equalTo(0, (ImmutableCommitStatus) another);
  }

  private boolean equalTo(int synthetic, ImmutableCommitStatus another) {
    return Objects.equals(state, another.state)
        && Objects.equals(statuses, another.statuses)
        && Objects.equals(sha, another.sha);
  }

  /**
   * Computes a hash code from attributes: {@code state}, {@code statuses}, {@code sha}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(state);
    h += (h << 5) + Objects.hashCode(statuses);
    h += (h << 5) + Objects.hashCode(sha);
    return h;
  }

  /**
   * Prints the immutable value {@code CommitStatus} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CommitStatus{"
        + "state=" + state
        + ", statuses=" + statuses
        + ", sha=" + sha
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CommitStatus", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CommitStatus {
    @Nullable String state;
    @Nullable List<Status> statuses = null;
    @Nullable String sha;
    @JsonProperty
    public void setState(@Nullable String state) {
      this.state = state;
    }
    @JsonProperty
    public void setStatuses(@Nullable List<Status> statuses) {
      this.statuses = statuses;
    }
    @JsonProperty
    public void setSha(@Nullable String sha) {
      this.sha = sha;
    }
    @Override
    public String state() { throw new UnsupportedOperationException(); }
    @Override
    public List<Status> statuses() { throw new UnsupportedOperationException(); }
    @Override
    public String sha() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCommitStatus fromJson(Json json) {
    ImmutableCommitStatus.Builder builder = ImmutableCommitStatus.builder();
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.statuses != null) {
      builder.addAllStatuses(json.statuses);
    }
    if (json.sha != null) {
      builder.sha(json.sha);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CommitStatus} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CommitStatus instance
   */
  public static ImmutableCommitStatus copyOf(CommitStatus instance) {
    if (instance instanceof ImmutableCommitStatus) {
      return (ImmutableCommitStatus) instance;
    }
    return ImmutableCommitStatus.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCommitStatus ImmutableCommitStatus}.
   * <pre>
   * ImmutableCommitStatus.builder()
   *    .state(String | null) // nullable {@link CommitStatus#state() state}
   *    .statuses(List&amp;lt;com.spotify.github.v3.repos.Status&amp;gt; | null) // nullable {@link CommitStatus#statuses() statuses}
   *    .sha(String | null) // nullable {@link CommitStatus#sha() sha}
   *    .build();
   * </pre>
   * @return A new ImmutableCommitStatus builder
   */
  public static ImmutableCommitStatus.Builder builder() {
    return new ImmutableCommitStatus.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCommitStatus ImmutableCommitStatus}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CommitStatus", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String state;
    private List<Status> statuses = null;
    private @Nullable String sha;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CommitStatus} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CommitStatus instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String stateValue = instance.state();
      if (stateValue != null) {
        state(stateValue);
      }
      @Nullable List<Status> statusesValue = instance.statuses();
      if (statusesValue != null) {
        addAllStatuses(statusesValue);
      }
      @Nullable String shaValue = instance.sha();
      if (shaValue != null) {
        sha(shaValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CommitStatus#state() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Adds one element to {@link CommitStatus#statuses() statuses} list.
     * @param element A statuses element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addStatuses(Status element) {
      if (this.statuses == null) {
        this.statuses = new ArrayList<Status>();
      }
      this.statuses.add(Objects.requireNonNull(element, "statuses element"));
      return this;
    }

    /**
     * Adds elements to {@link CommitStatus#statuses() statuses} list.
     * @param elements An array of statuses elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addStatuses(Status... elements) {
      if (this.statuses == null) {
        this.statuses = new ArrayList<Status>();
      }
      for (Status element : elements) {
        this.statuses.add(Objects.requireNonNull(element, "statuses element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CommitStatus#statuses() statuses} list.
     * @param elements An iterable of statuses elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder statuses(@Nullable Iterable<? extends Status> elements) {
      if (elements == null) {
        this.statuses = null;
        return this;
      }
      this.statuses = new ArrayList<Status>();
      return addAllStatuses(elements);
    }

    /**
     * Adds elements to {@link CommitStatus#statuses() statuses} list.
     * @param elements An iterable of statuses elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllStatuses(Iterable<? extends Status> elements) {
      Objects.requireNonNull(elements, "statuses element");
      if (this.statuses == null) {
        this.statuses = new ArrayList<Status>();
      }
      for (Status element : elements) {
        this.statuses.add(Objects.requireNonNull(element, "statuses element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CommitStatus#sha() sha} attribute.
     * @param sha The value for sha (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sha(@Nullable String sha) {
      this.sha = sha;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCommitStatus ImmutableCommitStatus}.
     * @return An immutable instance of CommitStatus
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCommitStatus build() {
      return new ImmutableCommitStatus(state, statuses == null ? null : createUnmodifiableList(true, statuses), sha);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
