package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.git.Commit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CommitWithFolderContent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCommitWithFolderContent.builder()}.
 */
@Generated(from = "CommitWithFolderContent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCommitWithFolderContent
    implements CommitWithFolderContent {
  private final FolderContent content;
  private final Commit commit;

  private ImmutableCommitWithFolderContent(FolderContent content, Commit commit) {
    this.content = content;
    this.commit = commit;
  }

  /**
   *Repository content resource 
   */
  @JsonProperty
  @Override
  public FolderContent content() {
    return content;
  }

  /**
   *Commit resource 
   */
  @JsonProperty
  @Override
  public Commit commit() {
    return commit;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitWithFolderContent#content() content} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for content
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitWithFolderContent withContent(FolderContent value) {
    if (this.content == value) return this;
    FolderContent newValue = Objects.requireNonNull(value, "content");
    return new ImmutableCommitWithFolderContent(newValue, this.commit);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitWithFolderContent#commit() commit} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commit
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitWithFolderContent withCommit(Commit value) {
    if (this.commit == value) return this;
    Commit newValue = Objects.requireNonNull(value, "commit");
    return new ImmutableCommitWithFolderContent(this.content, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCommitWithFolderContent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCommitWithFolderContent
        && equalTo(0, (ImmutableCommitWithFolderContent) another);
  }

  private boolean equalTo(int synthetic, ImmutableCommitWithFolderContent another) {
    return content.equals(another.content)
        && commit.equals(another.commit);
  }

  /**
   * Computes a hash code from attributes: {@code content}, {@code commit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + content.hashCode();
    h += (h << 5) + commit.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CommitWithFolderContent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CommitWithFolderContent{"
        + "content=" + content
        + ", commit=" + commit
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CommitWithFolderContent", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CommitWithFolderContent {
    @Nullable FolderContent content;
    @Nullable Commit commit;
    @JsonProperty
    public void setContent(FolderContent content) {
      this.content = content;
    }
    @JsonProperty
    public void setCommit(Commit commit) {
      this.commit = commit;
    }
    @Override
    public FolderContent content() { throw new UnsupportedOperationException(); }
    @Override
    public Commit commit() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCommitWithFolderContent fromJson(Json json) {
    ImmutableCommitWithFolderContent.Builder builder = ImmutableCommitWithFolderContent.builder();
    if (json.content != null) {
      builder.content(json.content);
    }
    if (json.commit != null) {
      builder.commit(json.commit);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CommitWithFolderContent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CommitWithFolderContent instance
   */
  public static ImmutableCommitWithFolderContent copyOf(CommitWithFolderContent instance) {
    if (instance instanceof ImmutableCommitWithFolderContent) {
      return (ImmutableCommitWithFolderContent) instance;
    }
    return ImmutableCommitWithFolderContent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCommitWithFolderContent ImmutableCommitWithFolderContent}.
   * <pre>
   * ImmutableCommitWithFolderContent.builder()
   *    .content(com.spotify.github.v3.repos.FolderContent) // required {@link CommitWithFolderContent#content() content}
   *    .commit(com.spotify.github.v3.git.Commit) // required {@link CommitWithFolderContent#commit() commit}
   *    .build();
   * </pre>
   * @return A new ImmutableCommitWithFolderContent builder
   */
  public static ImmutableCommitWithFolderContent.Builder builder() {
    return new ImmutableCommitWithFolderContent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCommitWithFolderContent ImmutableCommitWithFolderContent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CommitWithFolderContent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CONTENT = 0x1L;
    private static final long INIT_BIT_COMMIT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable FolderContent content;
    private @Nullable Commit commit;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CommitWithFolderContent} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CommitWithFolderContent instance) {
      Objects.requireNonNull(instance, "instance");
      content(instance.content());
      commit(instance.commit());
      return this;
    }

    /**
     * Initializes the value for the {@link CommitWithFolderContent#content() content} attribute.
     * @param content The value for content 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder content(FolderContent content) {
      this.content = Objects.requireNonNull(content, "content");
      initBits &= ~INIT_BIT_CONTENT;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitWithFolderContent#commit() commit} attribute.
     * @param commit The value for commit 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commit(Commit commit) {
      this.commit = Objects.requireNonNull(commit, "commit");
      initBits &= ~INIT_BIT_COMMIT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCommitWithFolderContent ImmutableCommitWithFolderContent}.
     * @return An immutable instance of CommitWithFolderContent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCommitWithFolderContent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCommitWithFolderContent(content, commit);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONTENT) != 0) attributes.add("content");
      if ((initBits & INIT_BIT_COMMIT) != 0) attributes.add("commit");
      return "Cannot build CommitWithFolderContent, some of required attributes are not set " + attributes;
    }
  }
}
