package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.User;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Deployment}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDeployment.builder()}.
 */
@Generated(from = "Deployment", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDeployment implements Deployment {
  private final @Nullable GitHubInstant createdAt;
  private final @Nullable GitHubInstant updatedAt;
  private final @Nullable URI url;
  private final @Nullable Long id;
  private final @Nullable String sha;
  private final @Nullable String ref;
  private final @Nullable String task;
  private final @Nullable Map<String, String> payload;
  private final @Nullable String environment;
  private final @Nullable String description;
  private final @Nullable User creator;
  private final @Nullable URI statusesUrl;
  private final @Nullable URI repositoryUrl;

  private ImmutableDeployment(
      @Nullable GitHubInstant createdAt,
      @Nullable GitHubInstant updatedAt,
      @Nullable URI url,
      @Nullable Long id,
      @Nullable String sha,
      @Nullable String ref,
      @Nullable String task,
      @Nullable Map<String, String> payload,
      @Nullable String environment,
      @Nullable String description,
      @Nullable User creator,
      @Nullable URI statusesUrl,
      @Nullable URI repositoryUrl) {
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.url = url;
    this.id = id;
    this.sha = sha;
    this.ref = ref;
    this.task = task;
    this.payload = payload;
    this.environment = environment;
    this.description = description;
    this.creator = creator;
    this.statusesUrl = statusesUrl;
    this.repositoryUrl = repositoryUrl;
  }

  /**
   * Created date
   * @return The date when the issue was created
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant createdAt() {
    return createdAt;
  }

  /**
   * Updated date
   * @return The date when the issue was updated
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant updatedAt() {
    return updatedAt;
  }

  /**
   *Deployment API URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *The Deployment ID to list the statuses from. 
   */
  @JsonProperty
  @Override
  public @Nullable Long id() {
    return id;
  }

  /**
   *The SHA that was recorded at creation time. 
   */
  @JsonProperty
  @Override
  public @Nullable String sha() {
    return sha;
  }

  /**
   *The name of the ref. This can be a branch, tag, or SHA. 
   */
  @JsonProperty
  @Override
  public @Nullable String ref() {
    return ref;
  }

  /**
   *The name of the task 
   */
  @JsonProperty
  @Override
  public @Nullable String task() {
    return task;
  }

  /**
   *Optional JSON payload with extra information about the deployment. 
   */
  @JsonProperty
  @Override
  public Optional<Map<String, String>> payload() {
    return Optional.ofNullable(payload);
  }

  /**
   *The name of the environment that was deployed to. e.g. staging or production. 
   */
  @JsonProperty
  @Override
  public @Nullable String environment() {
    return environment;
  }

  /**
   *Optional short description. 
   */
  @JsonProperty
  @Override
  public Optional<String> description() {
    return Optional.ofNullable(description);
  }

  /**
   *Deployment creator 
   */
  @JsonProperty
  @Override
  public @Nullable User creator() {
    return creator;
  }

  /**
   *Deployment statuses API URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI statusesUrl() {
    return statusesUrl;
  }

  /**
   *Deployment repository API URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI repositoryUrl() {
    return repositoryUrl;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Deployment#createdAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeployment withCreatedAt(@Nullable GitHubInstant value) {
    if (this.createdAt == value) return this;
    return new ImmutableDeployment(
        value,
        this.updatedAt,
        this.url,
        this.id,
        this.sha,
        this.ref,
        this.task,
        this.payload,
        this.environment,
        this.description,
        this.creator,
        this.statusesUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Deployment#updatedAt() updatedAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeployment withUpdatedAt(@Nullable GitHubInstant value) {
    if (this.updatedAt == value) return this;
    return new ImmutableDeployment(
        this.createdAt,
        value,
        this.url,
        this.id,
        this.sha,
        this.ref,
        this.task,
        this.payload,
        this.environment,
        this.description,
        this.creator,
        this.statusesUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Deployment#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeployment withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableDeployment(
        this.createdAt,
        this.updatedAt,
        value,
        this.id,
        this.sha,
        this.ref,
        this.task,
        this.payload,
        this.environment,
        this.description,
        this.creator,
        this.statusesUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Deployment#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeployment withId(@Nullable Long value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableDeployment(
        this.createdAt,
        this.updatedAt,
        this.url,
        value,
        this.sha,
        this.ref,
        this.task,
        this.payload,
        this.environment,
        this.description,
        this.creator,
        this.statusesUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Deployment#sha() sha} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sha (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeployment withSha(@Nullable String value) {
    if (Objects.equals(this.sha, value)) return this;
    return new ImmutableDeployment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.id,
        value,
        this.ref,
        this.task,
        this.payload,
        this.environment,
        this.description,
        this.creator,
        this.statusesUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Deployment#ref() ref} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ref (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeployment withRef(@Nullable String value) {
    if (Objects.equals(this.ref, value)) return this;
    return new ImmutableDeployment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.id,
        this.sha,
        value,
        this.task,
        this.payload,
        this.environment,
        this.description,
        this.creator,
        this.statusesUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Deployment#task() task} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for task (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeployment withTask(@Nullable String value) {
    if (Objects.equals(this.task, value)) return this;
    return new ImmutableDeployment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.id,
        this.sha,
        this.ref,
        value,
        this.payload,
        this.environment,
        this.description,
        this.creator,
        this.statusesUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Deployment#payload() payload} attribute.
   * @param value The value for payload
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeployment withPayload(Map<String, String> value) {
    Map<String, String> newValue = Objects.requireNonNull(value, "payload");
    if (this.payload == newValue) return this;
    return new ImmutableDeployment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.id,
        this.sha,
        this.ref,
        this.task,
        newValue,
        this.environment,
        this.description,
        this.creator,
        this.statusesUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Deployment#payload() payload} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for payload
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableDeployment withPayload(Optional<? extends Map<String, String>> optional) {
    @Nullable Map<String, String> value = optional.orElse(null);
    if (this.payload == value) return this;
    return new ImmutableDeployment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.id,
        this.sha,
        this.ref,
        this.task,
        value,
        this.environment,
        this.description,
        this.creator,
        this.statusesUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Deployment#environment() environment} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for environment (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeployment withEnvironment(@Nullable String value) {
    if (Objects.equals(this.environment, value)) return this;
    return new ImmutableDeployment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.id,
        this.sha,
        this.ref,
        this.task,
        this.payload,
        value,
        this.description,
        this.creator,
        this.statusesUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Deployment#description() description} attribute.
   * @param value The value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeployment withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (Objects.equals(this.description, newValue)) return this;
    return new ImmutableDeployment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.id,
        this.sha,
        this.ref,
        this.task,
        this.payload,
        this.environment,
        newValue,
        this.creator,
        this.statusesUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Deployment#description() description} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeployment withDescription(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableDeployment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.id,
        this.sha,
        this.ref,
        this.task,
        this.payload,
        this.environment,
        value,
        this.creator,
        this.statusesUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Deployment#creator() creator} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for creator (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeployment withCreator(@Nullable User value) {
    if (this.creator == value) return this;
    return new ImmutableDeployment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.id,
        this.sha,
        this.ref,
        this.task,
        this.payload,
        this.environment,
        this.description,
        value,
        this.statusesUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Deployment#statusesUrl() statusesUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for statusesUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeployment withStatusesUrl(@Nullable URI value) {
    if (this.statusesUrl == value) return this;
    return new ImmutableDeployment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.id,
        this.sha,
        this.ref,
        this.task,
        this.payload,
        this.environment,
        this.description,
        this.creator,
        value,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Deployment#repositoryUrl() repositoryUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repositoryUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeployment withRepositoryUrl(@Nullable URI value) {
    if (this.repositoryUrl == value) return this;
    return new ImmutableDeployment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.id,
        this.sha,
        this.ref,
        this.task,
        this.payload,
        this.environment,
        this.description,
        this.creator,
        this.statusesUrl,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDeployment} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDeployment
        && equalTo(0, (ImmutableDeployment) another);
  }

  private boolean equalTo(int synthetic, ImmutableDeployment another) {
    return Objects.equals(createdAt, another.createdAt)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(url, another.url)
        && Objects.equals(id, another.id)
        && Objects.equals(sha, another.sha)
        && Objects.equals(ref, another.ref)
        && Objects.equals(task, another.task)
        && Objects.equals(payload, another.payload)
        && Objects.equals(environment, another.environment)
        && Objects.equals(description, another.description)
        && Objects.equals(creator, another.creator)
        && Objects.equals(statusesUrl, another.statusesUrl)
        && Objects.equals(repositoryUrl, another.repositoryUrl);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code updatedAt}, {@code url}, {@code id}, {@code sha}, {@code ref}, {@code task}, {@code payload}, {@code environment}, {@code description}, {@code creator}, {@code statusesUrl}, {@code repositoryUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(sha);
    h += (h << 5) + Objects.hashCode(ref);
    h += (h << 5) + Objects.hashCode(task);
    h += (h << 5) + Objects.hashCode(payload);
    h += (h << 5) + Objects.hashCode(environment);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(creator);
    h += (h << 5) + Objects.hashCode(statusesUrl);
    h += (h << 5) + Objects.hashCode(repositoryUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code Deployment} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Deployment{");
    if (createdAt != null) {
      builder.append("createdAt=").append(createdAt);
    }
    if (updatedAt != null) {
      if (builder.length() > 11) builder.append(", ");
      builder.append("updatedAt=").append(updatedAt);
    }
    if (url != null) {
      if (builder.length() > 11) builder.append(", ");
      builder.append("url=").append(url);
    }
    if (id != null) {
      if (builder.length() > 11) builder.append(", ");
      builder.append("id=").append(id);
    }
    if (sha != null) {
      if (builder.length() > 11) builder.append(", ");
      builder.append("sha=").append(sha);
    }
    if (ref != null) {
      if (builder.length() > 11) builder.append(", ");
      builder.append("ref=").append(ref);
    }
    if (task != null) {
      if (builder.length() > 11) builder.append(", ");
      builder.append("task=").append(task);
    }
    if (payload != null) {
      if (builder.length() > 11) builder.append(", ");
      builder.append("payload=").append(payload);
    }
    if (environment != null) {
      if (builder.length() > 11) builder.append(", ");
      builder.append("environment=").append(environment);
    }
    if (description != null) {
      if (builder.length() > 11) builder.append(", ");
      builder.append("description=").append(description);
    }
    if (creator != null) {
      if (builder.length() > 11) builder.append(", ");
      builder.append("creator=").append(creator);
    }
    if (statusesUrl != null) {
      if (builder.length() > 11) builder.append(", ");
      builder.append("statusesUrl=").append(statusesUrl);
    }
    if (repositoryUrl != null) {
      if (builder.length() > 11) builder.append(", ");
      builder.append("repositoryUrl=").append(repositoryUrl);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Deployment", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Deployment {
    @Nullable GitHubInstant createdAt;
    @Nullable GitHubInstant updatedAt;
    @Nullable URI url;
    @Nullable Long id;
    @Nullable String sha;
    @Nullable String ref;
    @Nullable String task;
    @Nullable Optional<Map<String, String>> payload = Optional.empty();
    @Nullable String environment;
    @Nullable Optional<String> description = Optional.empty();
    @Nullable User creator;
    @Nullable URI statusesUrl;
    @Nullable URI repositoryUrl;
    @JsonProperty
    public void setCreatedAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty
    public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setId(@Nullable Long id) {
      this.id = id;
    }
    @JsonProperty
    public void setSha(@Nullable String sha) {
      this.sha = sha;
    }
    @JsonProperty
    public void setRef(@Nullable String ref) {
      this.ref = ref;
    }
    @JsonProperty
    public void setTask(@Nullable String task) {
      this.task = task;
    }
    @JsonProperty
    public void setPayload(Optional<Map<String, String>> payload) {
      this.payload = payload;
    }
    @JsonProperty
    public void setEnvironment(@Nullable String environment) {
      this.environment = environment;
    }
    @JsonProperty
    public void setDescription(Optional<String> description) {
      this.description = description;
    }
    @JsonProperty
    public void setCreator(@Nullable User creator) {
      this.creator = creator;
    }
    @JsonProperty
    public void setStatusesUrl(@Nullable URI statusesUrl) {
      this.statusesUrl = statusesUrl;
    }
    @JsonProperty
    public void setRepositoryUrl(@Nullable URI repositoryUrl) {
      this.repositoryUrl = repositoryUrl;
    }
    @Override
    public GitHubInstant createdAt() { throw new UnsupportedOperationException(); }
    @Override
    public GitHubInstant updatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public Long id() { throw new UnsupportedOperationException(); }
    @Override
    public String sha() { throw new UnsupportedOperationException(); }
    @Override
    public String ref() { throw new UnsupportedOperationException(); }
    @Override
    public String task() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Map<String, String>> payload() { throw new UnsupportedOperationException(); }
    @Override
    public String environment() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> description() { throw new UnsupportedOperationException(); }
    @Override
    public User creator() { throw new UnsupportedOperationException(); }
    @Override
    public URI statusesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI repositoryUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDeployment fromJson(Json json) {
    ImmutableDeployment.Builder builder = ImmutableDeployment.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.sha != null) {
      builder.sha(json.sha);
    }
    if (json.ref != null) {
      builder.ref(json.ref);
    }
    if (json.task != null) {
      builder.task(json.task);
    }
    if (json.payload != null) {
      builder.payload(json.payload);
    }
    if (json.environment != null) {
      builder.environment(json.environment);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.creator != null) {
      builder.creator(json.creator);
    }
    if (json.statusesUrl != null) {
      builder.statusesUrl(json.statusesUrl);
    }
    if (json.repositoryUrl != null) {
      builder.repositoryUrl(json.repositoryUrl);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Deployment} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Deployment instance
   */
  public static ImmutableDeployment copyOf(Deployment instance) {
    if (instance instanceof ImmutableDeployment) {
      return (ImmutableDeployment) instance;
    }
    return ImmutableDeployment.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDeployment ImmutableDeployment}.
   * <pre>
   * ImmutableDeployment.builder()
   *    .createdAt(com.spotify.github.GitHubInstant | null) // nullable {@link Deployment#createdAt() createdAt}
   *    .updatedAt(com.spotify.github.GitHubInstant | null) // nullable {@link Deployment#updatedAt() updatedAt}
   *    .url(java.net.URI | null) // nullable {@link Deployment#url() url}
   *    .id(Long | null) // nullable {@link Deployment#id() id}
   *    .sha(String | null) // nullable {@link Deployment#sha() sha}
   *    .ref(String | null) // nullable {@link Deployment#ref() ref}
   *    .task(String | null) // nullable {@link Deployment#task() task}
   *    .payload(Map&amp;lt;String, String&amp;gt;) // optional {@link Deployment#payload() payload}
   *    .environment(String | null) // nullable {@link Deployment#environment() environment}
   *    .description(String) // optional {@link Deployment#description() description}
   *    .creator(com.spotify.github.v3.User | null) // nullable {@link Deployment#creator() creator}
   *    .statusesUrl(java.net.URI | null) // nullable {@link Deployment#statusesUrl() statusesUrl}
   *    .repositoryUrl(java.net.URI | null) // nullable {@link Deployment#repositoryUrl() repositoryUrl}
   *    .build();
   * </pre>
   * @return A new ImmutableDeployment builder
   */
  public static ImmutableDeployment.Builder builder() {
    return new ImmutableDeployment.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDeployment ImmutableDeployment}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Deployment", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable GitHubInstant createdAt;
    private @Nullable GitHubInstant updatedAt;
    private @Nullable URI url;
    private @Nullable Long id;
    private @Nullable String sha;
    private @Nullable String ref;
    private @Nullable String task;
    private @Nullable Map<String, String> payload;
    private @Nullable String environment;
    private @Nullable String description;
    private @Nullable User creator;
    private @Nullable URI statusesUrl;
    private @Nullable URI repositoryUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.repos.Deployment} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Deployment instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.UpdateTracking} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateTracking instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof Deployment) {
        Deployment instance = (Deployment) object;
        @Nullable User creatorValue = instance.creator();
        if (creatorValue != null) {
          creator(creatorValue);
        }
        Optional<String> descriptionOptional = instance.description();
        if (descriptionOptional.isPresent()) {
          description(descriptionOptional);
        }
        @Nullable String shaValue = instance.sha();
        if (shaValue != null) {
          sha(shaValue);
        }
        @Nullable URI urlValue = instance.url();
        if (urlValue != null) {
          url(urlValue);
        }
        @Nullable URI repositoryUrlValue = instance.repositoryUrl();
        if (repositoryUrlValue != null) {
          repositoryUrl(repositoryUrlValue);
        }
        if ((bits & 0x1L) == 0) {
          @Nullable GitHubInstant createdAtValue = instance.createdAt();
          if (createdAtValue != null) {
            createdAt(createdAtValue);
          }
          bits |= 0x1L;
        }
        @Nullable String refValue = instance.ref();
        if (refValue != null) {
          ref(refValue);
        }
        @Nullable String environmentValue = instance.environment();
        if (environmentValue != null) {
          environment(environmentValue);
        }
        @Nullable String taskValue = instance.task();
        if (taskValue != null) {
          task(taskValue);
        }
        Optional<Map<String, String>> payloadOptional = instance.payload();
        if (payloadOptional.isPresent()) {
          payload(payloadOptional);
        }
        @Nullable URI statusesUrlValue = instance.statusesUrl();
        if (statusesUrlValue != null) {
          statusesUrl(statusesUrlValue);
        }
        @Nullable Long idValue = instance.id();
        if (idValue != null) {
          id(idValue);
        }
        if ((bits & 0x2L) == 0) {
          @Nullable GitHubInstant updatedAtValue = instance.updatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x2L;
        }
      }
      if (object instanceof UpdateTracking) {
        UpdateTracking instance = (UpdateTracking) object;
        if ((bits & 0x1L) == 0) {
          @Nullable GitHubInstant createdAtValue = instance.createdAt();
          if (createdAtValue != null) {
            createdAt(createdAtValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable GitHubInstant updatedAtValue = instance.updatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link Deployment#createdAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder createdAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link Deployment#updatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link Deployment#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link Deployment#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(@Nullable Long id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Deployment#sha() sha} attribute.
     * @param sha The value for sha (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sha(@Nullable String sha) {
      this.sha = sha;
      return this;
    }

    /**
     * Initializes the value for the {@link Deployment#ref() ref} attribute.
     * @param ref The value for ref (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder ref(@Nullable String ref) {
      this.ref = ref;
      return this;
    }

    /**
     * Initializes the value for the {@link Deployment#task() task} attribute.
     * @param task The value for task (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder task(@Nullable String task) {
      this.task = task;
      return this;
    }

    /**
     * Initializes the optional value {@link Deployment#payload() payload} to payload.
     * @param payload The value for payload
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder payload(Map<String, String> payload) {
      this.payload = Objects.requireNonNull(payload, "payload");
      return this;
    }

    /**
     * Initializes the optional value {@link Deployment#payload() payload} to payload.
     * @param payload The value for payload
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder payload(Optional<? extends Map<String, String>> payload) {
      this.payload = payload.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link Deployment#environment() environment} attribute.
     * @param environment The value for environment (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder environment(@Nullable String environment) {
      this.environment = environment;
      return this;
    }

    /**
     * Initializes the optional value {@link Deployment#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      return this;
    }

    /**
     * Initializes the optional value {@link Deployment#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder description(Optional<String> description) {
      this.description = description.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link Deployment#creator() creator} attribute.
     * @param creator The value for creator (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder creator(@Nullable User creator) {
      this.creator = creator;
      return this;
    }

    /**
     * Initializes the value for the {@link Deployment#statusesUrl() statusesUrl} attribute.
     * @param statusesUrl The value for statusesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder statusesUrl(@Nullable URI statusesUrl) {
      this.statusesUrl = statusesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link Deployment#repositoryUrl() repositoryUrl} attribute.
     * @param repositoryUrl The value for repositoryUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repositoryUrl(@Nullable URI repositoryUrl) {
      this.repositoryUrl = repositoryUrl;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDeployment ImmutableDeployment}.
     * @return An immutable instance of Deployment
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDeployment build() {
      return new ImmutableDeployment(
          createdAt,
          updatedAt,
          url,
          id,
          sha,
          ref,
          task,
          payload,
          environment,
          description,
          creator,
          statusesUrl,
          repositoryUrl);
    }
  }
}
