package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link File}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFile.builder()}.
 */
@Generated(from = "File", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFile implements File {
  private final @Nullable String filename;
  private final @Nullable Integer additions;
  private final @Nullable Integer deletions;
  private final @Nullable Integer changes;
  private final @Nullable String status;
  private final @Nullable URI rawUrl;
  private final @Nullable URI blobUrl;
  private final @Nullable String patch;
  private final @Nullable String sha;
  private final @Nullable URI contentsUrl;

  private ImmutableFile(
      @Nullable String filename,
      @Nullable Integer additions,
      @Nullable Integer deletions,
      @Nullable Integer changes,
      @Nullable String status,
      @Nullable URI rawUrl,
      @Nullable URI blobUrl,
      @Nullable String patch,
      @Nullable String sha,
      @Nullable URI contentsUrl) {
    this.filename = filename;
    this.additions = additions;
    this.deletions = deletions;
    this.changes = changes;
    this.status = status;
    this.rawUrl = rawUrl;
    this.blobUrl = blobUrl;
    this.patch = patch;
    this.sha = sha;
    this.contentsUrl = contentsUrl;
  }

  /**
   *File name 
   */
  @JsonProperty
  @Override
  public @Nullable String filename() {
    return filename;
  }

  /**
   *Number of added lines 
   */
  @JsonProperty
  @Override
  public @Nullable Integer additions() {
    return additions;
  }

  /**
   *Number of removed lines 
   */
  @JsonProperty
  @Override
  public @Nullable Integer deletions() {
    return deletions;
  }

  /**
   *Numnber of changed lines 
   */
  @JsonProperty
  @Override
  public @Nullable Integer changes() {
    return changes;
  }

  /**
   *File status. E.g added, modified 
   */
  @JsonProperty
  @Override
  public @Nullable String status() {
    return status;
  }

  /**
   *Raw file content API URL 
   */
  @JsonProperty
  @Override
  public Optional<URI> rawUrl() {
    return Optional.ofNullable(rawUrl);
  }

  /**
   *Blob file content API URL 
   */
  @JsonProperty
  @Override
  public Optional<URI> blobUrl() {
    return Optional.ofNullable(blobUrl);
  }

  /**
   *Patch content 
   */
  @JsonProperty
  @Override
  public Optional<String> patch() {
    return Optional.ofNullable(patch);
  }

  /**
   *Sha that included action taken on the given file 
   */
  @JsonProperty
  @Override
  public Optional<String> sha() {
    return Optional.ofNullable(sha);
  }

  /**
   *File content API URL 
   */
  @JsonProperty
  @Override
  public Optional<URI> contentsUrl() {
    return Optional.ofNullable(contentsUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link File#filename() filename} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for filename (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFile withFilename(@Nullable String value) {
    if (Objects.equals(this.filename, value)) return this;
    return new ImmutableFile(
        value,
        this.additions,
        this.deletions,
        this.changes,
        this.status,
        this.rawUrl,
        this.blobUrl,
        this.patch,
        this.sha,
        this.contentsUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link File#additions() additions} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for additions (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFile withAdditions(@Nullable Integer value) {
    if (Objects.equals(this.additions, value)) return this;
    return new ImmutableFile(
        this.filename,
        value,
        this.deletions,
        this.changes,
        this.status,
        this.rawUrl,
        this.blobUrl,
        this.patch,
        this.sha,
        this.contentsUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link File#deletions() deletions} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deletions (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFile withDeletions(@Nullable Integer value) {
    if (Objects.equals(this.deletions, value)) return this;
    return new ImmutableFile(
        this.filename,
        this.additions,
        value,
        this.changes,
        this.status,
        this.rawUrl,
        this.blobUrl,
        this.patch,
        this.sha,
        this.contentsUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link File#changes() changes} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for changes (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFile withChanges(@Nullable Integer value) {
    if (Objects.equals(this.changes, value)) return this;
    return new ImmutableFile(
        this.filename,
        this.additions,
        this.deletions,
        value,
        this.status,
        this.rawUrl,
        this.blobUrl,
        this.patch,
        this.sha,
        this.contentsUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link File#status() status} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFile withStatus(@Nullable String value) {
    if (Objects.equals(this.status, value)) return this;
    return new ImmutableFile(
        this.filename,
        this.additions,
        this.deletions,
        this.changes,
        value,
        this.rawUrl,
        this.blobUrl,
        this.patch,
        this.sha,
        this.contentsUrl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link File#rawUrl() rawUrl} attribute.
   * @param value The value for rawUrl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFile withRawUrl(URI value) {
    URI newValue = Objects.requireNonNull(value, "rawUrl");
    if (this.rawUrl == newValue) return this;
    return new ImmutableFile(
        this.filename,
        this.additions,
        this.deletions,
        this.changes,
        this.status,
        newValue,
        this.blobUrl,
        this.patch,
        this.sha,
        this.contentsUrl);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link File#rawUrl() rawUrl} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for rawUrl
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableFile withRawUrl(Optional<? extends URI> optional) {
    @Nullable URI value = optional.orElse(null);
    if (this.rawUrl == value) return this;
    return new ImmutableFile(
        this.filename,
        this.additions,
        this.deletions,
        this.changes,
        this.status,
        value,
        this.blobUrl,
        this.patch,
        this.sha,
        this.contentsUrl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link File#blobUrl() blobUrl} attribute.
   * @param value The value for blobUrl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFile withBlobUrl(URI value) {
    URI newValue = Objects.requireNonNull(value, "blobUrl");
    if (this.blobUrl == newValue) return this;
    return new ImmutableFile(
        this.filename,
        this.additions,
        this.deletions,
        this.changes,
        this.status,
        this.rawUrl,
        newValue,
        this.patch,
        this.sha,
        this.contentsUrl);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link File#blobUrl() blobUrl} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for blobUrl
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableFile withBlobUrl(Optional<? extends URI> optional) {
    @Nullable URI value = optional.orElse(null);
    if (this.blobUrl == value) return this;
    return new ImmutableFile(
        this.filename,
        this.additions,
        this.deletions,
        this.changes,
        this.status,
        this.rawUrl,
        value,
        this.patch,
        this.sha,
        this.contentsUrl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link File#patch() patch} attribute.
   * @param value The value for patch
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFile withPatch(String value) {
    String newValue = Objects.requireNonNull(value, "patch");
    if (Objects.equals(this.patch, newValue)) return this;
    return new ImmutableFile(
        this.filename,
        this.additions,
        this.deletions,
        this.changes,
        this.status,
        this.rawUrl,
        this.blobUrl,
        newValue,
        this.sha,
        this.contentsUrl);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link File#patch() patch} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for patch
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFile withPatch(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.patch, value)) return this;
    return new ImmutableFile(
        this.filename,
        this.additions,
        this.deletions,
        this.changes,
        this.status,
        this.rawUrl,
        this.blobUrl,
        value,
        this.sha,
        this.contentsUrl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link File#sha() sha} attribute.
   * @param value The value for sha
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFile withSha(String value) {
    String newValue = Objects.requireNonNull(value, "sha");
    if (Objects.equals(this.sha, newValue)) return this;
    return new ImmutableFile(
        this.filename,
        this.additions,
        this.deletions,
        this.changes,
        this.status,
        this.rawUrl,
        this.blobUrl,
        this.patch,
        newValue,
        this.contentsUrl);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link File#sha() sha} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for sha
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFile withSha(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.sha, value)) return this;
    return new ImmutableFile(
        this.filename,
        this.additions,
        this.deletions,
        this.changes,
        this.status,
        this.rawUrl,
        this.blobUrl,
        this.patch,
        value,
        this.contentsUrl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link File#contentsUrl() contentsUrl} attribute.
   * @param value The value for contentsUrl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFile withContentsUrl(URI value) {
    URI newValue = Objects.requireNonNull(value, "contentsUrl");
    if (this.contentsUrl == newValue) return this;
    return new ImmutableFile(
        this.filename,
        this.additions,
        this.deletions,
        this.changes,
        this.status,
        this.rawUrl,
        this.blobUrl,
        this.patch,
        this.sha,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link File#contentsUrl() contentsUrl} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for contentsUrl
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableFile withContentsUrl(Optional<? extends URI> optional) {
    @Nullable URI value = optional.orElse(null);
    if (this.contentsUrl == value) return this;
    return new ImmutableFile(
        this.filename,
        this.additions,
        this.deletions,
        this.changes,
        this.status,
        this.rawUrl,
        this.blobUrl,
        this.patch,
        this.sha,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFile} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFile
        && equalTo(0, (ImmutableFile) another);
  }

  private boolean equalTo(int synthetic, ImmutableFile another) {
    return Objects.equals(filename, another.filename)
        && Objects.equals(additions, another.additions)
        && Objects.equals(deletions, another.deletions)
        && Objects.equals(changes, another.changes)
        && Objects.equals(status, another.status)
        && Objects.equals(rawUrl, another.rawUrl)
        && Objects.equals(blobUrl, another.blobUrl)
        && Objects.equals(patch, another.patch)
        && Objects.equals(sha, another.sha)
        && Objects.equals(contentsUrl, another.contentsUrl);
  }

  /**
   * Computes a hash code from attributes: {@code filename}, {@code additions}, {@code deletions}, {@code changes}, {@code status}, {@code rawUrl}, {@code blobUrl}, {@code patch}, {@code sha}, {@code contentsUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(filename);
    h += (h << 5) + Objects.hashCode(additions);
    h += (h << 5) + Objects.hashCode(deletions);
    h += (h << 5) + Objects.hashCode(changes);
    h += (h << 5) + Objects.hashCode(status);
    h += (h << 5) + Objects.hashCode(rawUrl);
    h += (h << 5) + Objects.hashCode(blobUrl);
    h += (h << 5) + Objects.hashCode(patch);
    h += (h << 5) + Objects.hashCode(sha);
    h += (h << 5) + Objects.hashCode(contentsUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code File} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("File{");
    if (filename != null) {
      builder.append("filename=").append(filename);
    }
    if (additions != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("additions=").append(additions);
    }
    if (deletions != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("deletions=").append(deletions);
    }
    if (changes != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("changes=").append(changes);
    }
    if (status != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("status=").append(status);
    }
    if (rawUrl != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("rawUrl=").append(rawUrl);
    }
    if (blobUrl != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("blobUrl=").append(blobUrl);
    }
    if (patch != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("patch=").append(patch);
    }
    if (sha != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("sha=").append(sha);
    }
    if (contentsUrl != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("contentsUrl=").append(contentsUrl);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "File", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements File {
    @Nullable String filename;
    @Nullable Integer additions;
    @Nullable Integer deletions;
    @Nullable Integer changes;
    @Nullable String status;
    @Nullable Optional<URI> rawUrl = Optional.empty();
    @Nullable Optional<URI> blobUrl = Optional.empty();
    @Nullable Optional<String> patch = Optional.empty();
    @Nullable Optional<String> sha = Optional.empty();
    @Nullable Optional<URI> contentsUrl = Optional.empty();
    @JsonProperty
    public void setFilename(@Nullable String filename) {
      this.filename = filename;
    }
    @JsonProperty
    public void setAdditions(@Nullable Integer additions) {
      this.additions = additions;
    }
    @JsonProperty
    public void setDeletions(@Nullable Integer deletions) {
      this.deletions = deletions;
    }
    @JsonProperty
    public void setChanges(@Nullable Integer changes) {
      this.changes = changes;
    }
    @JsonProperty
    public void setStatus(@Nullable String status) {
      this.status = status;
    }
    @JsonProperty
    public void setRawUrl(Optional<URI> rawUrl) {
      this.rawUrl = rawUrl;
    }
    @JsonProperty
    public void setBlobUrl(Optional<URI> blobUrl) {
      this.blobUrl = blobUrl;
    }
    @JsonProperty
    public void setPatch(Optional<String> patch) {
      this.patch = patch;
    }
    @JsonProperty
    public void setSha(Optional<String> sha) {
      this.sha = sha;
    }
    @JsonProperty
    public void setContentsUrl(Optional<URI> contentsUrl) {
      this.contentsUrl = contentsUrl;
    }
    @Override
    public String filename() { throw new UnsupportedOperationException(); }
    @Override
    public Integer additions() { throw new UnsupportedOperationException(); }
    @Override
    public Integer deletions() { throw new UnsupportedOperationException(); }
    @Override
    public Integer changes() { throw new UnsupportedOperationException(); }
    @Override
    public String status() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<URI> rawUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<URI> blobUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> patch() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> sha() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<URI> contentsUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFile fromJson(Json json) {
    ImmutableFile.Builder builder = ImmutableFile.builder();
    if (json.filename != null) {
      builder.filename(json.filename);
    }
    if (json.additions != null) {
      builder.additions(json.additions);
    }
    if (json.deletions != null) {
      builder.deletions(json.deletions);
    }
    if (json.changes != null) {
      builder.changes(json.changes);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    if (json.rawUrl != null) {
      builder.rawUrl(json.rawUrl);
    }
    if (json.blobUrl != null) {
      builder.blobUrl(json.blobUrl);
    }
    if (json.patch != null) {
      builder.patch(json.patch);
    }
    if (json.sha != null) {
      builder.sha(json.sha);
    }
    if (json.contentsUrl != null) {
      builder.contentsUrl(json.contentsUrl);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link File} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable File instance
   */
  public static ImmutableFile copyOf(File instance) {
    if (instance instanceof ImmutableFile) {
      return (ImmutableFile) instance;
    }
    return ImmutableFile.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFile ImmutableFile}.
   * <pre>
   * ImmutableFile.builder()
   *    .filename(String | null) // nullable {@link File#filename() filename}
   *    .additions(Integer | null) // nullable {@link File#additions() additions}
   *    .deletions(Integer | null) // nullable {@link File#deletions() deletions}
   *    .changes(Integer | null) // nullable {@link File#changes() changes}
   *    .status(String | null) // nullable {@link File#status() status}
   *    .rawUrl(java.net.URI) // optional {@link File#rawUrl() rawUrl}
   *    .blobUrl(java.net.URI) // optional {@link File#blobUrl() blobUrl}
   *    .patch(String) // optional {@link File#patch() patch}
   *    .sha(String) // optional {@link File#sha() sha}
   *    .contentsUrl(java.net.URI) // optional {@link File#contentsUrl() contentsUrl}
   *    .build();
   * </pre>
   * @return A new ImmutableFile builder
   */
  public static ImmutableFile.Builder builder() {
    return new ImmutableFile.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFile ImmutableFile}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "File", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String filename;
    private @Nullable Integer additions;
    private @Nullable Integer deletions;
    private @Nullable Integer changes;
    private @Nullable String status;
    private @Nullable URI rawUrl;
    private @Nullable URI blobUrl;
    private @Nullable String patch;
    private @Nullable String sha;
    private @Nullable URI contentsUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code File} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(File instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String filenameValue = instance.filename();
      if (filenameValue != null) {
        filename(filenameValue);
      }
      @Nullable Integer additionsValue = instance.additions();
      if (additionsValue != null) {
        additions(additionsValue);
      }
      @Nullable Integer deletionsValue = instance.deletions();
      if (deletionsValue != null) {
        deletions(deletionsValue);
      }
      @Nullable Integer changesValue = instance.changes();
      if (changesValue != null) {
        changes(changesValue);
      }
      @Nullable String statusValue = instance.status();
      if (statusValue != null) {
        status(statusValue);
      }
      Optional<URI> rawUrlOptional = instance.rawUrl();
      if (rawUrlOptional.isPresent()) {
        rawUrl(rawUrlOptional);
      }
      Optional<URI> blobUrlOptional = instance.blobUrl();
      if (blobUrlOptional.isPresent()) {
        blobUrl(blobUrlOptional);
      }
      Optional<String> patchOptional = instance.patch();
      if (patchOptional.isPresent()) {
        patch(patchOptional);
      }
      Optional<String> shaOptional = instance.sha();
      if (shaOptional.isPresent()) {
        sha(shaOptional);
      }
      Optional<URI> contentsUrlOptional = instance.contentsUrl();
      if (contentsUrlOptional.isPresent()) {
        contentsUrl(contentsUrlOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link File#filename() filename} attribute.
     * @param filename The value for filename (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder filename(@Nullable String filename) {
      this.filename = filename;
      return this;
    }

    /**
     * Initializes the value for the {@link File#additions() additions} attribute.
     * @param additions The value for additions (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder additions(@Nullable Integer additions) {
      this.additions = additions;
      return this;
    }

    /**
     * Initializes the value for the {@link File#deletions() deletions} attribute.
     * @param deletions The value for deletions (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder deletions(@Nullable Integer deletions) {
      this.deletions = deletions;
      return this;
    }

    /**
     * Initializes the value for the {@link File#changes() changes} attribute.
     * @param changes The value for changes (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder changes(@Nullable Integer changes) {
      this.changes = changes;
      return this;
    }

    /**
     * Initializes the value for the {@link File#status() status} attribute.
     * @param status The value for status (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder status(@Nullable String status) {
      this.status = status;
      return this;
    }

    /**
     * Initializes the optional value {@link File#rawUrl() rawUrl} to rawUrl.
     * @param rawUrl The value for rawUrl
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder rawUrl(URI rawUrl) {
      this.rawUrl = Objects.requireNonNull(rawUrl, "rawUrl");
      return this;
    }

    /**
     * Initializes the optional value {@link File#rawUrl() rawUrl} to rawUrl.
     * @param rawUrl The value for rawUrl
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder rawUrl(Optional<? extends URI> rawUrl) {
      this.rawUrl = rawUrl.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link File#blobUrl() blobUrl} to blobUrl.
     * @param blobUrl The value for blobUrl
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder blobUrl(URI blobUrl) {
      this.blobUrl = Objects.requireNonNull(blobUrl, "blobUrl");
      return this;
    }

    /**
     * Initializes the optional value {@link File#blobUrl() blobUrl} to blobUrl.
     * @param blobUrl The value for blobUrl
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder blobUrl(Optional<? extends URI> blobUrl) {
      this.blobUrl = blobUrl.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link File#patch() patch} to patch.
     * @param patch The value for patch
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder patch(String patch) {
      this.patch = Objects.requireNonNull(patch, "patch");
      return this;
    }

    /**
     * Initializes the optional value {@link File#patch() patch} to patch.
     * @param patch The value for patch
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder patch(Optional<String> patch) {
      this.patch = patch.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link File#sha() sha} to sha.
     * @param sha The value for sha
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sha(String sha) {
      this.sha = Objects.requireNonNull(sha, "sha");
      return this;
    }

    /**
     * Initializes the optional value {@link File#sha() sha} to sha.
     * @param sha The value for sha
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sha(Optional<String> sha) {
      this.sha = sha.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link File#contentsUrl() contentsUrl} to contentsUrl.
     * @param contentsUrl The value for contentsUrl
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder contentsUrl(URI contentsUrl) {
      this.contentsUrl = Objects.requireNonNull(contentsUrl, "contentsUrl");
      return this;
    }

    /**
     * Initializes the optional value {@link File#contentsUrl() contentsUrl} to contentsUrl.
     * @param contentsUrl The value for contentsUrl
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder contentsUrl(Optional<? extends URI> contentsUrl) {
      this.contentsUrl = contentsUrl.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableFile ImmutableFile}.
     * @return An immutable instance of File
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFile build() {
      return new ImmutableFile(filename, additions, deletions, changes, status, rawUrl, blobUrl, patch, sha, contentsUrl);
    }
  }
}
