package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.git.ShaLink;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FolderContent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFolderContent.builder()}.
 */
@Generated(from = "FolderContent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFolderContent implements FolderContent {
  private final @Nullable String sha;
  private final @Nullable URI url;
  private final @Nullable String type;
  private final @Nullable Integer size;
  private final @Nullable String name;
  private final @Nullable String path;
  private final @Nullable URI gitUrl;
  private final @Nullable URI htmlUrl;
  private final @Nullable URI downloadUrl;

  private ImmutableFolderContent(
      @Nullable String sha,
      @Nullable URI url,
      @Nullable String type,
      @Nullable Integer size,
      @Nullable String name,
      @Nullable String path,
      @Nullable URI gitUrl,
      @Nullable URI htmlUrl,
      @Nullable URI downloadUrl) {
    this.sha = sha;
    this.url = url;
    this.type = type;
    this.size = size;
    this.name = name;
    this.path = path;
    this.gitUrl = gitUrl;
    this.htmlUrl = htmlUrl;
    this.downloadUrl = downloadUrl;
  }

  /**
   *SHA. 
   */
  @JsonProperty
  @Override
  public @Nullable String sha() {
    return sha;
  }

  /**
   *URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *Content type. E.g file, dir, symlink, submodule 
   */
  @JsonProperty
  @Override
  public @Nullable String type() {
    return type;
  }

  /**
   *Content size in bytes 
   */
  @JsonProperty
  @Override
  public @Nullable Integer size() {
    return size;
  }

  /**
   *Content name. E.g. file name 
   */
  @JsonProperty
  @Override
  public @Nullable String name() {
    return name;
  }

  /**
   *The content path. 
   */
  @JsonProperty
  @Override
  public @Nullable String path() {
    return path;
  }

  /**
   *Git blob API URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI gitUrl() {
    return gitUrl;
  }

  /**
   *Content URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI htmlUrl() {
    return htmlUrl;
  }

  /**
   *Content download URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI downloadUrl() {
    return downloadUrl;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FolderContent#sha() sha} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sha (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFolderContent withSha(@Nullable String value) {
    if (Objects.equals(this.sha, value)) return this;
    return new ImmutableFolderContent(
        value,
        this.url,
        this.type,
        this.size,
        this.name,
        this.path,
        this.gitUrl,
        this.htmlUrl,
        this.downloadUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FolderContent#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFolderContent withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableFolderContent(
        this.sha,
        value,
        this.type,
        this.size,
        this.name,
        this.path,
        this.gitUrl,
        this.htmlUrl,
        this.downloadUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FolderContent#type() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFolderContent withType(@Nullable String value) {
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableFolderContent(
        this.sha,
        this.url,
        value,
        this.size,
        this.name,
        this.path,
        this.gitUrl,
        this.htmlUrl,
        this.downloadUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FolderContent#size() size} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for size (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFolderContent withSize(@Nullable Integer value) {
    if (Objects.equals(this.size, value)) return this;
    return new ImmutableFolderContent(
        this.sha,
        this.url,
        this.type,
        value,
        this.name,
        this.path,
        this.gitUrl,
        this.htmlUrl,
        this.downloadUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FolderContent#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFolderContent withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableFolderContent(
        this.sha,
        this.url,
        this.type,
        this.size,
        value,
        this.path,
        this.gitUrl,
        this.htmlUrl,
        this.downloadUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FolderContent#path() path} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for path (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFolderContent withPath(@Nullable String value) {
    if (Objects.equals(this.path, value)) return this;
    return new ImmutableFolderContent(
        this.sha,
        this.url,
        this.type,
        this.size,
        this.name,
        value,
        this.gitUrl,
        this.htmlUrl,
        this.downloadUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FolderContent#gitUrl() gitUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for gitUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFolderContent withGitUrl(@Nullable URI value) {
    if (this.gitUrl == value) return this;
    return new ImmutableFolderContent(
        this.sha,
        this.url,
        this.type,
        this.size,
        this.name,
        this.path,
        value,
        this.htmlUrl,
        this.downloadUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FolderContent#htmlUrl() htmlUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for htmlUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFolderContent withHtmlUrl(@Nullable URI value) {
    if (this.htmlUrl == value) return this;
    return new ImmutableFolderContent(
        this.sha,
        this.url,
        this.type,
        this.size,
        this.name,
        this.path,
        this.gitUrl,
        value,
        this.downloadUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FolderContent#downloadUrl() downloadUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for downloadUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFolderContent withDownloadUrl(@Nullable URI value) {
    if (this.downloadUrl == value) return this;
    return new ImmutableFolderContent(
        this.sha,
        this.url,
        this.type,
        this.size,
        this.name,
        this.path,
        this.gitUrl,
        this.htmlUrl,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFolderContent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFolderContent
        && equalTo(0, (ImmutableFolderContent) another);
  }

  private boolean equalTo(int synthetic, ImmutableFolderContent another) {
    return Objects.equals(sha, another.sha)
        && Objects.equals(url, another.url)
        && Objects.equals(type, another.type)
        && Objects.equals(size, another.size)
        && Objects.equals(name, another.name)
        && Objects.equals(path, another.path)
        && Objects.equals(gitUrl, another.gitUrl)
        && Objects.equals(htmlUrl, another.htmlUrl)
        && Objects.equals(downloadUrl, another.downloadUrl);
  }

  /**
   * Computes a hash code from attributes: {@code sha}, {@code url}, {@code type}, {@code size}, {@code name}, {@code path}, {@code gitUrl}, {@code htmlUrl}, {@code downloadUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(sha);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(size);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + Objects.hashCode(gitUrl);
    h += (h << 5) + Objects.hashCode(htmlUrl);
    h += (h << 5) + Objects.hashCode(downloadUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code FolderContent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FolderContent{"
        + "sha=" + sha
        + ", url=" + url
        + ", type=" + type
        + ", size=" + size
        + ", name=" + name
        + ", path=" + path
        + ", gitUrl=" + gitUrl
        + ", htmlUrl=" + htmlUrl
        + ", downloadUrl=" + downloadUrl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "FolderContent", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FolderContent {
    @Nullable String sha;
    @Nullable URI url;
    @Nullable String type;
    @Nullable Integer size;
    @Nullable String name;
    @Nullable String path;
    @Nullable URI gitUrl;
    @Nullable URI htmlUrl;
    @Nullable URI downloadUrl;
    @JsonProperty
    public void setSha(@Nullable String sha) {
      this.sha = sha;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @JsonProperty
    public void setSize(@Nullable Integer size) {
      this.size = size;
    }
    @JsonProperty
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty
    public void setPath(@Nullable String path) {
      this.path = path;
    }
    @JsonProperty
    public void setGitUrl(@Nullable URI gitUrl) {
      this.gitUrl = gitUrl;
    }
    @JsonProperty
    public void setHtmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
    }
    @JsonProperty
    public void setDownloadUrl(@Nullable URI downloadUrl) {
      this.downloadUrl = downloadUrl;
    }
    @Override
    public String sha() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public String type() { throw new UnsupportedOperationException(); }
    @Override
    public Integer size() { throw new UnsupportedOperationException(); }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public String path() { throw new UnsupportedOperationException(); }
    @Override
    public URI gitUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI htmlUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI downloadUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFolderContent fromJson(Json json) {
    ImmutableFolderContent.Builder builder = ImmutableFolderContent.builder();
    if (json.sha != null) {
      builder.sha(json.sha);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.size != null) {
      builder.size(json.size);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.path != null) {
      builder.path(json.path);
    }
    if (json.gitUrl != null) {
      builder.gitUrl(json.gitUrl);
    }
    if (json.htmlUrl != null) {
      builder.htmlUrl(json.htmlUrl);
    }
    if (json.downloadUrl != null) {
      builder.downloadUrl(json.downloadUrl);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FolderContent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FolderContent instance
   */
  public static ImmutableFolderContent copyOf(FolderContent instance) {
    if (instance instanceof ImmutableFolderContent) {
      return (ImmutableFolderContent) instance;
    }
    return ImmutableFolderContent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFolderContent ImmutableFolderContent}.
   * <pre>
   * ImmutableFolderContent.builder()
   *    .sha(String | null) // nullable {@link FolderContent#sha() sha}
   *    .url(java.net.URI | null) // nullable {@link FolderContent#url() url}
   *    .type(String | null) // nullable {@link FolderContent#type() type}
   *    .size(Integer | null) // nullable {@link FolderContent#size() size}
   *    .name(String | null) // nullable {@link FolderContent#name() name}
   *    .path(String | null) // nullable {@link FolderContent#path() path}
   *    .gitUrl(java.net.URI | null) // nullable {@link FolderContent#gitUrl() gitUrl}
   *    .htmlUrl(java.net.URI | null) // nullable {@link FolderContent#htmlUrl() htmlUrl}
   *    .downloadUrl(java.net.URI | null) // nullable {@link FolderContent#downloadUrl() downloadUrl}
   *    .build();
   * </pre>
   * @return A new ImmutableFolderContent builder
   */
  public static ImmutableFolderContent.Builder builder() {
    return new ImmutableFolderContent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFolderContent ImmutableFolderContent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FolderContent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String sha;
    private @Nullable URI url;
    private @Nullable String type;
    private @Nullable Integer size;
    private @Nullable String name;
    private @Nullable String path;
    private @Nullable URI gitUrl;
    private @Nullable URI htmlUrl;
    private @Nullable URI downloadUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.repos.FolderContent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(FolderContent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.git.ShaLink} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ShaLink instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof FolderContent) {
        FolderContent instance = (FolderContent) object;
        @Nullable String pathValue = instance.path();
        if (pathValue != null) {
          path(pathValue);
        }
        @Nullable Integer sizeValue = instance.size();
        if (sizeValue != null) {
          size(sizeValue);
        }
        @Nullable String nameValue = instance.name();
        if (nameValue != null) {
          name(nameValue);
        }
        @Nullable URI htmlUrlValue = instance.htmlUrl();
        if (htmlUrlValue != null) {
          htmlUrl(htmlUrlValue);
        }
        @Nullable URI downloadUrlValue = instance.downloadUrl();
        if (downloadUrlValue != null) {
          downloadUrl(downloadUrlValue);
        }
        @Nullable String typeValue = instance.type();
        if (typeValue != null) {
          type(typeValue);
        }
        if ((bits & 0x1L) == 0) {
          @Nullable String shaValue = instance.sha();
          if (shaValue != null) {
            sha(shaValue);
          }
          bits |= 0x1L;
        }
        @Nullable URI gitUrlValue = instance.gitUrl();
        if (gitUrlValue != null) {
          gitUrl(gitUrlValue);
        }
        if ((bits & 0x2L) == 0) {
          @Nullable URI urlValue = instance.url();
          if (urlValue != null) {
            url(urlValue);
          }
          bits |= 0x2L;
        }
      }
      if (object instanceof ShaLink) {
        ShaLink instance = (ShaLink) object;
        if ((bits & 0x1L) == 0) {
          @Nullable String shaValue = instance.sha();
          if (shaValue != null) {
            sha(shaValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable URI urlValue = instance.url();
          if (urlValue != null) {
            url(urlValue);
          }
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link FolderContent#sha() sha} attribute.
     * @param sha The value for sha (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sha(@Nullable String sha) {
      this.sha = sha;
      return this;
    }

    /**
     * Initializes the value for the {@link FolderContent#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link FolderContent#type() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link FolderContent#size() size} attribute.
     * @param size The value for size (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder size(@Nullable Integer size) {
      this.size = size;
      return this;
    }

    /**
     * Initializes the value for the {@link FolderContent#name() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link FolderContent#path() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link FolderContent#gitUrl() gitUrl} attribute.
     * @param gitUrl The value for gitUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder gitUrl(@Nullable URI gitUrl) {
      this.gitUrl = gitUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link FolderContent#htmlUrl() htmlUrl} attribute.
     * @param htmlUrl The value for htmlUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder htmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link FolderContent#downloadUrl() downloadUrl} attribute.
     * @param downloadUrl The value for downloadUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder downloadUrl(@Nullable URI downloadUrl) {
      this.downloadUrl = downloadUrl;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFolderContent ImmutableFolderContent}.
     * @return An immutable instance of FolderContent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFolderContent build() {
      return new ImmutableFolderContent(sha, url, type, size, name, path, gitUrl, htmlUrl, downloadUrl);
    }
  }
}
