package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Permissions}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePermissions.builder()}.
 */
@Generated(from = "Permissions", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePermissions implements Permissions {
  private final @Nullable Boolean admin;
  private final @Nullable Boolean push;
  private final @Nullable Boolean pull;

  private ImmutablePermissions(
      @Nullable Boolean admin,
      @Nullable Boolean push,
      @Nullable Boolean pull) {
    this.admin = admin;
    this.push = push;
    this.pull = pull;
  }

  /**
   *Has admin 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean admin() {
    return admin;
  }

  /**
   *Can push 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean push() {
    return push;
  }

  /**
   *Can pull 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean pull() {
    return pull;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Permissions#admin() admin} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for admin (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePermissions withAdmin(@Nullable Boolean value) {
    if (Objects.equals(this.admin, value)) return this;
    return new ImmutablePermissions(value, this.push, this.pull);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Permissions#push() push} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for push (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePermissions withPush(@Nullable Boolean value) {
    if (Objects.equals(this.push, value)) return this;
    return new ImmutablePermissions(this.admin, value, this.pull);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Permissions#pull() pull} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pull (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePermissions withPull(@Nullable Boolean value) {
    if (Objects.equals(this.pull, value)) return this;
    return new ImmutablePermissions(this.admin, this.push, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePermissions} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePermissions
        && equalTo(0, (ImmutablePermissions) another);
  }

  private boolean equalTo(int synthetic, ImmutablePermissions another) {
    return Objects.equals(admin, another.admin)
        && Objects.equals(push, another.push)
        && Objects.equals(pull, another.pull);
  }

  /**
   * Computes a hash code from attributes: {@code admin}, {@code push}, {@code pull}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(admin);
    h += (h << 5) + Objects.hashCode(push);
    h += (h << 5) + Objects.hashCode(pull);
    return h;
  }

  /**
   * Prints the immutable value {@code Permissions} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Permissions{"
        + "admin=" + admin
        + ", push=" + push
        + ", pull=" + pull
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Permissions", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Permissions {
    @Nullable Boolean admin;
    @Nullable Boolean push;
    @Nullable Boolean pull;
    @JsonProperty
    public void setAdmin(@Nullable Boolean admin) {
      this.admin = admin;
    }
    @JsonProperty
    public void setPush(@Nullable Boolean push) {
      this.push = push;
    }
    @JsonProperty
    public void setPull(@Nullable Boolean pull) {
      this.pull = pull;
    }
    @Override
    public Boolean admin() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean push() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean pull() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePermissions fromJson(Json json) {
    ImmutablePermissions.Builder builder = ImmutablePermissions.builder();
    if (json.admin != null) {
      builder.admin(json.admin);
    }
    if (json.push != null) {
      builder.push(json.push);
    }
    if (json.pull != null) {
      builder.pull(json.pull);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Permissions} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Permissions instance
   */
  public static ImmutablePermissions copyOf(Permissions instance) {
    if (instance instanceof ImmutablePermissions) {
      return (ImmutablePermissions) instance;
    }
    return ImmutablePermissions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePermissions ImmutablePermissions}.
   * <pre>
   * ImmutablePermissions.builder()
   *    .admin(Boolean | null) // nullable {@link Permissions#admin() admin}
   *    .push(Boolean | null) // nullable {@link Permissions#push() push}
   *    .pull(Boolean | null) // nullable {@link Permissions#pull() pull}
   *    .build();
   * </pre>
   * @return A new ImmutablePermissions builder
   */
  public static ImmutablePermissions.Builder builder() {
    return new ImmutablePermissions.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePermissions ImmutablePermissions}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Permissions", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Boolean admin;
    private @Nullable Boolean push;
    private @Nullable Boolean pull;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Permissions} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Permissions instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Boolean adminValue = instance.admin();
      if (adminValue != null) {
        admin(adminValue);
      }
      @Nullable Boolean pushValue = instance.push();
      if (pushValue != null) {
        push(pushValue);
      }
      @Nullable Boolean pullValue = instance.pull();
      if (pullValue != null) {
        pull(pullValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Permissions#admin() admin} attribute.
     * @param admin The value for admin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder admin(@Nullable Boolean admin) {
      this.admin = admin;
      return this;
    }

    /**
     * Initializes the value for the {@link Permissions#push() push} attribute.
     * @param push The value for push (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder push(@Nullable Boolean push) {
      this.push = push;
      return this;
    }

    /**
     * Initializes the value for the {@link Permissions#pull() pull} attribute.
     * @param pull The value for pull (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder pull(@Nullable Boolean pull) {
      this.pull = pull;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePermissions ImmutablePermissions}.
     * @return An immutable instance of Permissions
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePermissions build() {
      return new ImmutablePermissions(admin, push, pull);
    }
  }
}
