package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Protection}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProtection.builder()}.
 */
@Generated(from = "Protection", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableProtection implements Protection {
  private final boolean enabled;
  private final RequiredStatusChecks requiredStatusChecks;

  private ImmutableProtection(boolean enabled, RequiredStatusChecks requiredStatusChecks) {
    this.enabled = enabled;
    this.requiredStatusChecks = requiredStatusChecks;
  }

  /**
   * @return The value of the {@code enabled} attribute
   */
  @JsonProperty
  @Override
  public boolean enabled() {
    return enabled;
  }

  /**
   * @return The value of the {@code requiredStatusChecks} attribute
   */
  @JsonProperty("required_status_checks")
  @Override
  public RequiredStatusChecks requiredStatusChecks() {
    return requiredStatusChecks;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Protection#enabled() enabled} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enabled
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProtection withEnabled(boolean value) {
    if (this.enabled == value) return this;
    return new ImmutableProtection(value, this.requiredStatusChecks);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Protection#requiredStatusChecks() requiredStatusChecks} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for requiredStatusChecks
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProtection withRequiredStatusChecks(RequiredStatusChecks value) {
    if (this.requiredStatusChecks == value) return this;
    RequiredStatusChecks newValue = Objects.requireNonNull(value, "requiredStatusChecks");
    return new ImmutableProtection(this.enabled, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProtection} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProtection
        && equalTo(0, (ImmutableProtection) another);
  }

  private boolean equalTo(int synthetic, ImmutableProtection another) {
    return enabled == another.enabled
        && requiredStatusChecks.equals(another.requiredStatusChecks);
  }

  /**
   * Computes a hash code from attributes: {@code enabled}, {@code requiredStatusChecks}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Boolean.hashCode(enabled);
    h += (h << 5) + requiredStatusChecks.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Protection} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Protection{"
        + "enabled=" + enabled
        + ", requiredStatusChecks=" + requiredStatusChecks
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Protection", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Protection {
    boolean enabled;
    boolean enabledIsSet;
    @Nullable RequiredStatusChecks requiredStatusChecks;
    @JsonProperty
    public void setEnabled(boolean enabled) {
      this.enabled = enabled;
      this.enabledIsSet = true;
    }
    @JsonProperty("required_status_checks")
    public void setRequiredStatusChecks(RequiredStatusChecks requiredStatusChecks) {
      this.requiredStatusChecks = requiredStatusChecks;
    }
    @Override
    public boolean enabled() { throw new UnsupportedOperationException(); }
    @Override
    public RequiredStatusChecks requiredStatusChecks() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableProtection fromJson(Json json) {
    ImmutableProtection.Builder builder = ImmutableProtection.builder();
    if (json.enabledIsSet) {
      builder.enabled(json.enabled);
    }
    if (json.requiredStatusChecks != null) {
      builder.requiredStatusChecks(json.requiredStatusChecks);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Protection} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Protection instance
   */
  public static ImmutableProtection copyOf(Protection instance) {
    if (instance instanceof ImmutableProtection) {
      return (ImmutableProtection) instance;
    }
    return ImmutableProtection.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProtection ImmutableProtection}.
   * <pre>
   * ImmutableProtection.builder()
   *    .enabled(boolean) // required {@link Protection#enabled() enabled}
   *    .requiredStatusChecks(com.spotify.github.v3.repos.RequiredStatusChecks) // required {@link Protection#requiredStatusChecks() requiredStatusChecks}
   *    .build();
   * </pre>
   * @return A new ImmutableProtection builder
   */
  public static ImmutableProtection.Builder builder() {
    return new ImmutableProtection.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProtection ImmutableProtection}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Protection", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ENABLED = 0x1L;
    private static final long INIT_BIT_REQUIRED_STATUS_CHECKS = 0x2L;
    private long initBits = 0x3L;

    private boolean enabled;
    private @Nullable RequiredStatusChecks requiredStatusChecks;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Protection} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Protection instance) {
      Objects.requireNonNull(instance, "instance");
      enabled(instance.enabled());
      requiredStatusChecks(instance.requiredStatusChecks());
      return this;
    }

    /**
     * Initializes the value for the {@link Protection#enabled() enabled} attribute.
     * @param enabled The value for enabled 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder enabled(boolean enabled) {
      this.enabled = enabled;
      initBits &= ~INIT_BIT_ENABLED;
      return this;
    }

    /**
     * Initializes the value for the {@link Protection#requiredStatusChecks() requiredStatusChecks} attribute.
     * @param requiredStatusChecks The value for requiredStatusChecks 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("required_status_checks")
    public final Builder requiredStatusChecks(RequiredStatusChecks requiredStatusChecks) {
      this.requiredStatusChecks = Objects.requireNonNull(requiredStatusChecks, "requiredStatusChecks");
      initBits &= ~INIT_BIT_REQUIRED_STATUS_CHECKS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProtection ImmutableProtection}.
     * @return An immutable instance of Protection
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProtection build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableProtection(enabled, requiredStatusChecks);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ENABLED) != 0) attributes.add("enabled");
      if ((initBits & INIT_BIT_REQUIRED_STATUS_CHECKS) != 0) attributes.add("requiredStatusChecks");
      return "Cannot build Protection, some of required attributes are not set " + attributes;
    }
  }
}
