package com.spotify.github.v3.repos.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RepositoryDispatch}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRepositoryDispatch.builder()}.
 */
@Generated(from = "RepositoryDispatch", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRepositoryDispatch
    implements RepositoryDispatch {
  private final String eventType;
  private final @Nullable JsonNode clientPayload;

  private ImmutableRepositoryDispatch(
      String eventType,
      @Nullable JsonNode clientPayload) {
    this.eventType = eventType;
    this.clientPayload = clientPayload;
  }

  /**
   *The custom webhook event name 
   */
  @JsonProperty
  @Override
  public String eventType() {
    return eventType;
  }

  /**
   *JSON payload with extra information about the webhook event
   * that your action or workflow may use. 
   */
  @JsonProperty
  @Override
  public Optional<JsonNode> clientPayload() {
    return Optional.ofNullable(clientPayload);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryDispatch#eventType() eventType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryDispatch withEventType(String value) {
    String newValue = Objects.requireNonNull(value, "eventType");
    if (this.eventType.equals(newValue)) return this;
    return new ImmutableRepositoryDispatch(newValue, this.clientPayload);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryDispatch#clientPayload() clientPayload} attribute.
   * @param value The value for clientPayload
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryDispatch withClientPayload(JsonNode value) {
    JsonNode newValue = Objects.requireNonNull(value, "clientPayload");
    if (this.clientPayload == newValue) return this;
    return new ImmutableRepositoryDispatch(this.eventType, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryDispatch#clientPayload() clientPayload} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for clientPayload
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableRepositoryDispatch withClientPayload(Optional<? extends JsonNode> optional) {
    @Nullable JsonNode value = optional.orElse(null);
    if (this.clientPayload == value) return this;
    return new ImmutableRepositoryDispatch(this.eventType, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRepositoryDispatch} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRepositoryDispatch
        && equalTo(0, (ImmutableRepositoryDispatch) another);
  }

  private boolean equalTo(int synthetic, ImmutableRepositoryDispatch another) {
    return eventType.equals(another.eventType)
        && Objects.equals(clientPayload, another.clientPayload);
  }

  /**
   * Computes a hash code from attributes: {@code eventType}, {@code clientPayload}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + eventType.hashCode();
    h += (h << 5) + Objects.hashCode(clientPayload);
    return h;
  }

  /**
   * Prints the immutable value {@code RepositoryDispatch} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("RepositoryDispatch{");
    builder.append("eventType=").append(eventType);
    if (clientPayload != null) {
      builder.append(", ");
      builder.append("clientPayload=").append(clientPayload);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "RepositoryDispatch", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements RepositoryDispatch {
    @Nullable String eventType;
    @Nullable Optional<JsonNode> clientPayload = Optional.empty();
    @JsonProperty
    public void setEventType(String eventType) {
      this.eventType = eventType;
    }
    @JsonProperty
    public void setClientPayload(Optional<JsonNode> clientPayload) {
      this.clientPayload = clientPayload;
    }
    @Override
    public String eventType() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<JsonNode> clientPayload() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRepositoryDispatch fromJson(Json json) {
    ImmutableRepositoryDispatch.Builder builder = ImmutableRepositoryDispatch.builder();
    if (json.eventType != null) {
      builder.eventType(json.eventType);
    }
    if (json.clientPayload != null) {
      builder.clientPayload(json.clientPayload);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link RepositoryDispatch} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RepositoryDispatch instance
   */
  public static ImmutableRepositoryDispatch copyOf(RepositoryDispatch instance) {
    if (instance instanceof ImmutableRepositoryDispatch) {
      return (ImmutableRepositoryDispatch) instance;
    }
    return ImmutableRepositoryDispatch.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRepositoryDispatch ImmutableRepositoryDispatch}.
   * <pre>
   * ImmutableRepositoryDispatch.builder()
   *    .eventType(String) // required {@link RepositoryDispatch#eventType() eventType}
   *    .clientPayload(com.fasterxml.jackson.databind.JsonNode) // optional {@link RepositoryDispatch#clientPayload() clientPayload}
   *    .build();
   * </pre>
   * @return A new ImmutableRepositoryDispatch builder
   */
  public static ImmutableRepositoryDispatch.Builder builder() {
    return new ImmutableRepositoryDispatch.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRepositoryDispatch ImmutableRepositoryDispatch}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RepositoryDispatch", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_EVENT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String eventType;
    private @Nullable JsonNode clientPayload;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RepositoryDispatch} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RepositoryDispatch instance) {
      Objects.requireNonNull(instance, "instance");
      eventType(instance.eventType());
      Optional<JsonNode> clientPayloadOptional = instance.clientPayload();
      if (clientPayloadOptional.isPresent()) {
        clientPayload(clientPayloadOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryDispatch#eventType() eventType} attribute.
     * @param eventType The value for eventType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder eventType(String eventType) {
      this.eventType = Objects.requireNonNull(eventType, "eventType");
      initBits &= ~INIT_BIT_EVENT_TYPE;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryDispatch#clientPayload() clientPayload} to clientPayload.
     * @param clientPayload The value for clientPayload
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder clientPayload(JsonNode clientPayload) {
      this.clientPayload = Objects.requireNonNull(clientPayload, "clientPayload");
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryDispatch#clientPayload() clientPayload} to clientPayload.
     * @param clientPayload The value for clientPayload
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder clientPayload(Optional<? extends JsonNode> clientPayload) {
      this.clientPayload = clientPayload.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableRepositoryDispatch ImmutableRepositoryDispatch}.
     * @return An immutable instance of RepositoryDispatch
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRepositoryDispatch build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRepositoryDispatch(eventType, clientPayload);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_EVENT_TYPE) != 0) attributes.add("eventType");
      return "Cannot build RepositoryDispatch, some of required attributes are not set " + attributes;
    }
  }
}
