package com.spotify.github.v3.repos.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RepositoryUpdate}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRepositoryUpdate.builder()}.
 */
@Generated(from = "RepositoryUpdate", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRepositoryUpdate implements RepositoryUpdate {
  private final @Nullable String description;
  private final @Nullable Boolean allowAutoMerge;
  private final @Nullable Boolean allowForking;
  private final @Nullable Boolean allowSquashMerge;
  private final @Nullable Boolean allowMergeCommit;
  private final @Nullable Boolean allowRebaseMerge;
  private final @Nullable Boolean allowUpdateBranch;
  private final @Nullable String defaultBranch;
  private final @Nullable Boolean deleteBranchOnMerge;
  private final @Nullable String homepage;
  private final @Nullable Boolean hasDownloads;
  private final @Nullable Boolean hasIssues;
  private final @Nullable Boolean hasWiki;
  private final @Nullable Boolean hasPages;
  private final @Nullable Boolean hasProjects;
  private final @Nullable Boolean isArchived;
  private final @Nullable Boolean isPrivate;
  private final @Nullable Boolean isTemplate;
  private final @Nullable String squashMergeCommitMessage;
  private final @Nullable String squashMergeCommitTitle;
  private final @Nullable String mergeCommitMessage;
  private final @Nullable String mergeCommitTitle;
  private final @Nullable Integer teamId;
  private final @Nullable String visibility;
  private final @Nullable Boolean webCommitSignoffRequired;

  private ImmutableRepositoryUpdate(
      @Nullable String description,
      @Nullable Boolean allowAutoMerge,
      @Nullable Boolean allowForking,
      @Nullable Boolean allowSquashMerge,
      @Nullable Boolean allowMergeCommit,
      @Nullable Boolean allowRebaseMerge,
      @Nullable Boolean allowUpdateBranch,
      @Nullable String defaultBranch,
      @Nullable Boolean deleteBranchOnMerge,
      @Nullable String homepage,
      @Nullable Boolean hasDownloads,
      @Nullable Boolean hasIssues,
      @Nullable Boolean hasWiki,
      @Nullable Boolean hasPages,
      @Nullable Boolean hasProjects,
      @Nullable Boolean isArchived,
      @Nullable Boolean isPrivate,
      @Nullable Boolean isTemplate,
      @Nullable String squashMergeCommitMessage,
      @Nullable String squashMergeCommitTitle,
      @Nullable String mergeCommitMessage,
      @Nullable String mergeCommitTitle,
      @Nullable Integer teamId,
      @Nullable String visibility,
      @Nullable Boolean webCommitSignoffRequired) {
    this.description = description;
    this.allowAutoMerge = allowAutoMerge;
    this.allowForking = allowForking;
    this.allowSquashMerge = allowSquashMerge;
    this.allowMergeCommit = allowMergeCommit;
    this.allowRebaseMerge = allowRebaseMerge;
    this.allowUpdateBranch = allowUpdateBranch;
    this.defaultBranch = defaultBranch;
    this.deleteBranchOnMerge = deleteBranchOnMerge;
    this.homepage = homepage;
    this.hasDownloads = hasDownloads;
    this.hasIssues = hasIssues;
    this.hasWiki = hasWiki;
    this.hasPages = hasPages;
    this.hasProjects = hasProjects;
    this.isArchived = isArchived;
    this.isPrivate = isPrivate;
    this.isTemplate = isTemplate;
    this.squashMergeCommitMessage = squashMergeCommitMessage;
    this.squashMergeCommitTitle = squashMergeCommitTitle;
    this.mergeCommitMessage = mergeCommitMessage;
    this.mergeCommitTitle = mergeCommitTitle;
    this.teamId = teamId;
    this.visibility = visibility;
    this.webCommitSignoffRequired = webCommitSignoffRequired;
  }

  /**
   *Description 
   */
  @JsonProperty
  @Override
  public Optional<String> description() {
    return Optional.ofNullable(description);
  }

  /**
   *Allow auto merges 
   */
  @JsonProperty
  @Override
  public Optional<Boolean> allowAutoMerge() {
    return Optional.ofNullable(allowAutoMerge);
  }

  /**
   * Either true to allow private forks, or false to prevent private forks.
   * <p>Default: false
   */
  @JsonProperty
  @Override
  public Optional<Boolean> allowForking() {
    return Optional.ofNullable(allowForking);
  }

  /**
   *Allow squash merges 
   */
  @JsonProperty
  @Override
  public Optional<Boolean> allowSquashMerge() {
    return Optional.ofNullable(allowSquashMerge);
  }

  /**
   *Allow merge commits 
   */
  @JsonProperty
  @Override
  public Optional<Boolean> allowMergeCommit() {
    return Optional.ofNullable(allowMergeCommit);
  }

  /**
   *Allow rebase merges 
   */
  @JsonProperty
  @Override
  public Optional<Boolean> allowRebaseMerge() {
    return Optional.ofNullable(allowRebaseMerge);
  }

  /**
   * Either true to always allow a pull request head branch that is behind its base branch to be
   * updated even if it is not required to be up to date before merging, or false otherwise.
   * <p>Default: false
   */
  @JsonProperty
  @Override
  public Optional<Boolean> allowUpdateBranch() {
    return Optional.ofNullable(allowUpdateBranch);
  }

  /**
   *Updates the default branch for this repository. 
   */
  @JsonProperty
  @Override
  public Optional<String> defaultBranch() {
    return Optional.ofNullable(defaultBranch);
  }

  /**
   * Either true to allow automatically deleting head branches when pull requests are merged, or
   * false to prevent automatic deletion.
   * <p>Default: false
   */
  @JsonProperty
  @Override
  public Optional<Boolean> deleteBranchOnMerge() {
    return Optional.ofNullable(deleteBranchOnMerge);
  }

  /**
   *Homepage URL 
   */
  @JsonProperty
  @Override
  public Optional<String> homepage() {
    return Optional.ofNullable(homepage);
  }

  /**
   *Does it have downloads 
   */
  @JsonProperty
  @Override
  public Optional<Boolean> hasDownloads() {
    return Optional.ofNullable(hasDownloads);
  }

  /**
   *Does it have issues 
   */
  @JsonProperty
  @Override
  public Optional<Boolean> hasIssues() {
    return Optional.ofNullable(hasIssues);
  }

  /**
   *Does it have wiki 
   */
  @JsonProperty
  @Override
  public Optional<Boolean> hasWiki() {
    return Optional.ofNullable(hasWiki);
  }

  /**
   *Does it have pages 
   */
  @JsonProperty
  @Override
  public Optional<Boolean> hasPages() {
    return Optional.ofNullable(hasPages);
  }

  /**
   *Does it have projects 
   */
  @JsonProperty
  @Override
  public Optional<Boolean> hasProjects() {
    return Optional.ofNullable(hasProjects);
  }

  /**
   * Whether to archive this repository. false will unarchive a previously archived repository.
   * <p>Default: false
   */
  @JsonProperty("archived")
  @Override
  public Optional<Boolean> isArchived() {
    return Optional.ofNullable(isArchived);
  }

  /**
   *Is it private 
   */
  @JsonProperty("private")
  @Override
  public Optional<Boolean> isPrivate() {
    return Optional.ofNullable(isPrivate);
  }

  /**
   * Either true to make this repo available as a template repository or false to prevent it.
   * Default: false
   */
  @JsonProperty
  @Override
  public Optional<Boolean> isTemplate() {
    return Optional.ofNullable(isTemplate);
  }

  /**
   * The default value for a squash merge commit message:
   * <p>PR_BODY - default to the pull request's body. COMMIT_MESSAGES - default to the branch's
   * commit messages. BLANK - default to a blank commit message. Can be one of: PR_BODY,
   * COMMIT_MESSAGES, BLANK
   */
  @JsonProperty
  @Override
  public Optional<String> squashMergeCommitMessage() {
    return Optional.ofNullable(squashMergeCommitMessage);
  }

  /**
   * squash_merge_commit_title string The default value for a squash merge commit title:
   * <p>PR_TITLE - default to the pull request's title. COMMIT_OR_PR_TITLE - default to the commit's
   * title (if only one commit) or the pull request's title (when more than one commit). Can be one
   * of: PR_TITLE, COMMIT_OR_PR_TITLE
   */
  @JsonProperty
  @Override
  public Optional<String> squashMergeCommitTitle() {
    return Optional.ofNullable(squashMergeCommitTitle);
  }

  /**
   * The default value for a merge commit message.
   * <p>PR_TITLE - default to the pull request's title. PR_BODY - default to the pull request's
   * body. BLANK - default to a blank commit message.
   */
  @JsonProperty
  @Override
  public Optional<String> mergeCommitMessage() {
    return Optional.ofNullable(mergeCommitMessage);
  }

  /**
   * The default value for a merge commit title.
   * <p>PR_TITLE - default to the pull request's title. MERGE_MESSAGE - default to the classic title
   * for a merge message (e.g., Merge pull request #123 from branch-name). Can be one of: PR_TITLE,
   * MERGE_MESSAGE
   */
  @JsonProperty
  @Override
  public Optional<String> mergeCommitTitle() {
    return Optional.ofNullable(mergeCommitTitle);
  }

  /**
   * The id of the team that will be granted access to this repository. This is only valid when
   * creating a repository in an organization. Default: false
   */
  @JsonProperty
  @Override
  public Optional<Integer> teamId() {
    return Optional.ofNullable(teamId);
  }

  /**
   *The visibility of the repo. Can be one of `public`, `private`, `internal` 
   */
  @JsonProperty
  @Override
  public Optional<String> visibility() {
    return Optional.ofNullable(visibility);
  }

  /**
   * Either true to require contributors to sign off on web-based commits, or false to not require
   * contributors to sign off on web-based commits.
   * <p>Default: false
   */
  @JsonProperty
  @Override
  public Optional<Boolean> webCommitSignoffRequired() {
    return Optional.ofNullable(webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#description() description} attribute.
   * @param value The value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (Objects.equals(this.description, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        newValue,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#description() description} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withDescription(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableRepositoryUpdate(
        value,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#allowAutoMerge() allowAutoMerge} attribute.
   * @param value The value for allowAutoMerge
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withAllowAutoMerge(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.allowAutoMerge, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        newValue,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#allowAutoMerge() allowAutoMerge} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for allowAutoMerge
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withAllowAutoMerge(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.allowAutoMerge, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        value,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#allowForking() allowForking} attribute.
   * @param value The value for allowForking
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withAllowForking(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.allowForking, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        newValue,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#allowForking() allowForking} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for allowForking
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withAllowForking(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.allowForking, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        value,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#allowSquashMerge() allowSquashMerge} attribute.
   * @param value The value for allowSquashMerge
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withAllowSquashMerge(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.allowSquashMerge, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        newValue,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#allowSquashMerge() allowSquashMerge} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for allowSquashMerge
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withAllowSquashMerge(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.allowSquashMerge, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        value,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#allowMergeCommit() allowMergeCommit} attribute.
   * @param value The value for allowMergeCommit
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withAllowMergeCommit(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.allowMergeCommit, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        newValue,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#allowMergeCommit() allowMergeCommit} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for allowMergeCommit
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withAllowMergeCommit(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.allowMergeCommit, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        value,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#allowRebaseMerge() allowRebaseMerge} attribute.
   * @param value The value for allowRebaseMerge
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withAllowRebaseMerge(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.allowRebaseMerge, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        newValue,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#allowRebaseMerge() allowRebaseMerge} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for allowRebaseMerge
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withAllowRebaseMerge(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.allowRebaseMerge, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        value,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#allowUpdateBranch() allowUpdateBranch} attribute.
   * @param value The value for allowUpdateBranch
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withAllowUpdateBranch(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.allowUpdateBranch, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        newValue,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#allowUpdateBranch() allowUpdateBranch} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for allowUpdateBranch
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withAllowUpdateBranch(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.allowUpdateBranch, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        value,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#defaultBranch() defaultBranch} attribute.
   * @param value The value for defaultBranch
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withDefaultBranch(String value) {
    String newValue = Objects.requireNonNull(value, "defaultBranch");
    if (Objects.equals(this.defaultBranch, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        newValue,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#defaultBranch() defaultBranch} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for defaultBranch
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withDefaultBranch(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.defaultBranch, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        value,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#deleteBranchOnMerge() deleteBranchOnMerge} attribute.
   * @param value The value for deleteBranchOnMerge
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withDeleteBranchOnMerge(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.deleteBranchOnMerge, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        newValue,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#deleteBranchOnMerge() deleteBranchOnMerge} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for deleteBranchOnMerge
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withDeleteBranchOnMerge(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.deleteBranchOnMerge, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        value,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#homepage() homepage} attribute.
   * @param value The value for homepage
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withHomepage(String value) {
    String newValue = Objects.requireNonNull(value, "homepage");
    if (Objects.equals(this.homepage, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        newValue,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#homepage() homepage} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for homepage
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withHomepage(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.homepage, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        value,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#hasDownloads() hasDownloads} attribute.
   * @param value The value for hasDownloads
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withHasDownloads(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.hasDownloads, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        newValue,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#hasDownloads() hasDownloads} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for hasDownloads
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withHasDownloads(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.hasDownloads, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        value,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#hasIssues() hasIssues} attribute.
   * @param value The value for hasIssues
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withHasIssues(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.hasIssues, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        newValue,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#hasIssues() hasIssues} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for hasIssues
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withHasIssues(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.hasIssues, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        value,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#hasWiki() hasWiki} attribute.
   * @param value The value for hasWiki
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withHasWiki(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.hasWiki, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        newValue,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#hasWiki() hasWiki} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for hasWiki
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withHasWiki(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.hasWiki, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        value,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#hasPages() hasPages} attribute.
   * @param value The value for hasPages
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withHasPages(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.hasPages, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        newValue,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#hasPages() hasPages} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for hasPages
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withHasPages(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.hasPages, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        value,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#hasProjects() hasProjects} attribute.
   * @param value The value for hasProjects
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withHasProjects(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.hasProjects, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        newValue,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#hasProjects() hasProjects} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for hasProjects
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withHasProjects(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.hasProjects, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        value,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#isArchived() isArchived} attribute.
   * @param value The value for isArchived
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withIsArchived(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.isArchived, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        newValue,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#isArchived() isArchived} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for isArchived
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withIsArchived(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.isArchived, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        value,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#isPrivate() isPrivate} attribute.
   * @param value The value for isPrivate
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withIsPrivate(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.isPrivate, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        newValue,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#isPrivate() isPrivate} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for isPrivate
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withIsPrivate(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.isPrivate, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        value,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#isTemplate() isTemplate} attribute.
   * @param value The value for isTemplate
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withIsTemplate(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.isTemplate, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        newValue,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#isTemplate() isTemplate} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for isTemplate
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withIsTemplate(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.isTemplate, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        value,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#squashMergeCommitMessage() squashMergeCommitMessage} attribute.
   * @param value The value for squashMergeCommitMessage
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withSquashMergeCommitMessage(String value) {
    String newValue = Objects.requireNonNull(value, "squashMergeCommitMessage");
    if (Objects.equals(this.squashMergeCommitMessage, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        newValue,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#squashMergeCommitMessage() squashMergeCommitMessage} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for squashMergeCommitMessage
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withSquashMergeCommitMessage(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.squashMergeCommitMessage, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        value,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#squashMergeCommitTitle() squashMergeCommitTitle} attribute.
   * @param value The value for squashMergeCommitTitle
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withSquashMergeCommitTitle(String value) {
    String newValue = Objects.requireNonNull(value, "squashMergeCommitTitle");
    if (Objects.equals(this.squashMergeCommitTitle, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        newValue,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#squashMergeCommitTitle() squashMergeCommitTitle} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for squashMergeCommitTitle
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withSquashMergeCommitTitle(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.squashMergeCommitTitle, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        value,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#mergeCommitMessage() mergeCommitMessage} attribute.
   * @param value The value for mergeCommitMessage
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withMergeCommitMessage(String value) {
    String newValue = Objects.requireNonNull(value, "mergeCommitMessage");
    if (Objects.equals(this.mergeCommitMessage, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        newValue,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#mergeCommitMessage() mergeCommitMessage} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for mergeCommitMessage
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withMergeCommitMessage(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.mergeCommitMessage, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        value,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#mergeCommitTitle() mergeCommitTitle} attribute.
   * @param value The value for mergeCommitTitle
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withMergeCommitTitle(String value) {
    String newValue = Objects.requireNonNull(value, "mergeCommitTitle");
    if (Objects.equals(this.mergeCommitTitle, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        newValue,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#mergeCommitTitle() mergeCommitTitle} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for mergeCommitTitle
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withMergeCommitTitle(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.mergeCommitTitle, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        value,
        this.teamId,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#teamId() teamId} attribute.
   * @param value The value for teamId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withTeamId(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.teamId, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        newValue,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#teamId() teamId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for teamId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withTeamId(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.teamId, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        value,
        this.visibility,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#visibility() visibility} attribute.
   * @param value The value for visibility
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withVisibility(String value) {
    String newValue = Objects.requireNonNull(value, "visibility");
    if (Objects.equals(this.visibility, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        newValue,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#visibility() visibility} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for visibility
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withVisibility(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.visibility, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        value,
        this.webCommitSignoffRequired);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryUpdate#webCommitSignoffRequired() webCommitSignoffRequired} attribute.
   * @param value The value for webCommitSignoffRequired
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withWebCommitSignoffRequired(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.webCommitSignoffRequired, newValue)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryUpdate#webCommitSignoffRequired() webCommitSignoffRequired} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for webCommitSignoffRequired
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryUpdate withWebCommitSignoffRequired(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.webCommitSignoffRequired, value)) return this;
    return new ImmutableRepositoryUpdate(
        this.description,
        this.allowAutoMerge,
        this.allowForking,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.allowUpdateBranch,
        this.defaultBranch,
        this.deleteBranchOnMerge,
        this.homepage,
        this.hasDownloads,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasProjects,
        this.isArchived,
        this.isPrivate,
        this.isTemplate,
        this.squashMergeCommitMessage,
        this.squashMergeCommitTitle,
        this.mergeCommitMessage,
        this.mergeCommitTitle,
        this.teamId,
        this.visibility,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRepositoryUpdate} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRepositoryUpdate
        && equalTo(0, (ImmutableRepositoryUpdate) another);
  }

  private boolean equalTo(int synthetic, ImmutableRepositoryUpdate another) {
    return Objects.equals(description, another.description)
        && Objects.equals(allowAutoMerge, another.allowAutoMerge)
        && Objects.equals(allowForking, another.allowForking)
        && Objects.equals(allowSquashMerge, another.allowSquashMerge)
        && Objects.equals(allowMergeCommit, another.allowMergeCommit)
        && Objects.equals(allowRebaseMerge, another.allowRebaseMerge)
        && Objects.equals(allowUpdateBranch, another.allowUpdateBranch)
        && Objects.equals(defaultBranch, another.defaultBranch)
        && Objects.equals(deleteBranchOnMerge, another.deleteBranchOnMerge)
        && Objects.equals(homepage, another.homepage)
        && Objects.equals(hasDownloads, another.hasDownloads)
        && Objects.equals(hasIssues, another.hasIssues)
        && Objects.equals(hasWiki, another.hasWiki)
        && Objects.equals(hasPages, another.hasPages)
        && Objects.equals(hasProjects, another.hasProjects)
        && Objects.equals(isArchived, another.isArchived)
        && Objects.equals(isPrivate, another.isPrivate)
        && Objects.equals(isTemplate, another.isTemplate)
        && Objects.equals(squashMergeCommitMessage, another.squashMergeCommitMessage)
        && Objects.equals(squashMergeCommitTitle, another.squashMergeCommitTitle)
        && Objects.equals(mergeCommitMessage, another.mergeCommitMessage)
        && Objects.equals(mergeCommitTitle, another.mergeCommitTitle)
        && Objects.equals(teamId, another.teamId)
        && Objects.equals(visibility, another.visibility)
        && Objects.equals(webCommitSignoffRequired, another.webCommitSignoffRequired);
  }

  /**
   * Computes a hash code from attributes: {@code description}, {@code allowAutoMerge}, {@code allowForking}, {@code allowSquashMerge}, {@code allowMergeCommit}, {@code allowRebaseMerge}, {@code allowUpdateBranch}, {@code defaultBranch}, {@code deleteBranchOnMerge}, {@code homepage}, {@code hasDownloads}, {@code hasIssues}, {@code hasWiki}, {@code hasPages}, {@code hasProjects}, {@code isArchived}, {@code isPrivate}, {@code isTemplate}, {@code squashMergeCommitMessage}, {@code squashMergeCommitTitle}, {@code mergeCommitMessage}, {@code mergeCommitTitle}, {@code teamId}, {@code visibility}, {@code webCommitSignoffRequired}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(allowAutoMerge);
    h += (h << 5) + Objects.hashCode(allowForking);
    h += (h << 5) + Objects.hashCode(allowSquashMerge);
    h += (h << 5) + Objects.hashCode(allowMergeCommit);
    h += (h << 5) + Objects.hashCode(allowRebaseMerge);
    h += (h << 5) + Objects.hashCode(allowUpdateBranch);
    h += (h << 5) + Objects.hashCode(defaultBranch);
    h += (h << 5) + Objects.hashCode(deleteBranchOnMerge);
    h += (h << 5) + Objects.hashCode(homepage);
    h += (h << 5) + Objects.hashCode(hasDownloads);
    h += (h << 5) + Objects.hashCode(hasIssues);
    h += (h << 5) + Objects.hashCode(hasWiki);
    h += (h << 5) + Objects.hashCode(hasPages);
    h += (h << 5) + Objects.hashCode(hasProjects);
    h += (h << 5) + Objects.hashCode(isArchived);
    h += (h << 5) + Objects.hashCode(isPrivate);
    h += (h << 5) + Objects.hashCode(isTemplate);
    h += (h << 5) + Objects.hashCode(squashMergeCommitMessage);
    h += (h << 5) + Objects.hashCode(squashMergeCommitTitle);
    h += (h << 5) + Objects.hashCode(mergeCommitMessage);
    h += (h << 5) + Objects.hashCode(mergeCommitTitle);
    h += (h << 5) + Objects.hashCode(teamId);
    h += (h << 5) + Objects.hashCode(visibility);
    h += (h << 5) + Objects.hashCode(webCommitSignoffRequired);
    return h;
  }

  /**
   * Prints the immutable value {@code RepositoryUpdate} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("RepositoryUpdate{");
    if (description != null) {
      builder.append("description=").append(description);
    }
    if (allowAutoMerge != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("allowAutoMerge=").append(allowAutoMerge);
    }
    if (allowForking != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("allowForking=").append(allowForking);
    }
    if (allowSquashMerge != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("allowSquashMerge=").append(allowSquashMerge);
    }
    if (allowMergeCommit != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("allowMergeCommit=").append(allowMergeCommit);
    }
    if (allowRebaseMerge != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("allowRebaseMerge=").append(allowRebaseMerge);
    }
    if (allowUpdateBranch != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("allowUpdateBranch=").append(allowUpdateBranch);
    }
    if (defaultBranch != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("defaultBranch=").append(defaultBranch);
    }
    if (deleteBranchOnMerge != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("deleteBranchOnMerge=").append(deleteBranchOnMerge);
    }
    if (homepage != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("homepage=").append(homepage);
    }
    if (hasDownloads != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("hasDownloads=").append(hasDownloads);
    }
    if (hasIssues != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("hasIssues=").append(hasIssues);
    }
    if (hasWiki != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("hasWiki=").append(hasWiki);
    }
    if (hasPages != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("hasPages=").append(hasPages);
    }
    if (hasProjects != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("hasProjects=").append(hasProjects);
    }
    if (isArchived != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("isArchived=").append(isArchived);
    }
    if (isPrivate != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("isPrivate=").append(isPrivate);
    }
    if (isTemplate != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("isTemplate=").append(isTemplate);
    }
    if (squashMergeCommitMessage != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("squashMergeCommitMessage=").append(squashMergeCommitMessage);
    }
    if (squashMergeCommitTitle != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("squashMergeCommitTitle=").append(squashMergeCommitTitle);
    }
    if (mergeCommitMessage != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("mergeCommitMessage=").append(mergeCommitMessage);
    }
    if (mergeCommitTitle != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("mergeCommitTitle=").append(mergeCommitTitle);
    }
    if (teamId != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("teamId=").append(teamId);
    }
    if (visibility != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("visibility=").append(visibility);
    }
    if (webCommitSignoffRequired != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("webCommitSignoffRequired=").append(webCommitSignoffRequired);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "RepositoryUpdate", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements RepositoryUpdate {
    @Nullable Optional<String> description = Optional.empty();
    @Nullable Optional<Boolean> allowAutoMerge = Optional.empty();
    @Nullable Optional<Boolean> allowForking = Optional.empty();
    @Nullable Optional<Boolean> allowSquashMerge = Optional.empty();
    @Nullable Optional<Boolean> allowMergeCommit = Optional.empty();
    @Nullable Optional<Boolean> allowRebaseMerge = Optional.empty();
    @Nullable Optional<Boolean> allowUpdateBranch = Optional.empty();
    @Nullable Optional<String> defaultBranch = Optional.empty();
    @Nullable Optional<Boolean> deleteBranchOnMerge = Optional.empty();
    @Nullable Optional<String> homepage = Optional.empty();
    @Nullable Optional<Boolean> hasDownloads = Optional.empty();
    @Nullable Optional<Boolean> hasIssues = Optional.empty();
    @Nullable Optional<Boolean> hasWiki = Optional.empty();
    @Nullable Optional<Boolean> hasPages = Optional.empty();
    @Nullable Optional<Boolean> hasProjects = Optional.empty();
    @Nullable Optional<Boolean> isArchived = Optional.empty();
    @Nullable Optional<Boolean> isPrivate = Optional.empty();
    @Nullable Optional<Boolean> isTemplate = Optional.empty();
    @Nullable Optional<String> squashMergeCommitMessage = Optional.empty();
    @Nullable Optional<String> squashMergeCommitTitle = Optional.empty();
    @Nullable Optional<String> mergeCommitMessage = Optional.empty();
    @Nullable Optional<String> mergeCommitTitle = Optional.empty();
    @Nullable Optional<Integer> teamId = Optional.empty();
    @Nullable Optional<String> visibility = Optional.empty();
    @Nullable Optional<Boolean> webCommitSignoffRequired = Optional.empty();
    @JsonProperty
    public void setDescription(Optional<String> description) {
      this.description = description;
    }
    @JsonProperty
    public void setAllowAutoMerge(Optional<Boolean> allowAutoMerge) {
      this.allowAutoMerge = allowAutoMerge;
    }
    @JsonProperty
    public void setAllowForking(Optional<Boolean> allowForking) {
      this.allowForking = allowForking;
    }
    @JsonProperty
    public void setAllowSquashMerge(Optional<Boolean> allowSquashMerge) {
      this.allowSquashMerge = allowSquashMerge;
    }
    @JsonProperty
    public void setAllowMergeCommit(Optional<Boolean> allowMergeCommit) {
      this.allowMergeCommit = allowMergeCommit;
    }
    @JsonProperty
    public void setAllowRebaseMerge(Optional<Boolean> allowRebaseMerge) {
      this.allowRebaseMerge = allowRebaseMerge;
    }
    @JsonProperty
    public void setAllowUpdateBranch(Optional<Boolean> allowUpdateBranch) {
      this.allowUpdateBranch = allowUpdateBranch;
    }
    @JsonProperty
    public void setDefaultBranch(Optional<String> defaultBranch) {
      this.defaultBranch = defaultBranch;
    }
    @JsonProperty
    public void setDeleteBranchOnMerge(Optional<Boolean> deleteBranchOnMerge) {
      this.deleteBranchOnMerge = deleteBranchOnMerge;
    }
    @JsonProperty
    public void setHomepage(Optional<String> homepage) {
      this.homepage = homepage;
    }
    @JsonProperty
    public void setHasDownloads(Optional<Boolean> hasDownloads) {
      this.hasDownloads = hasDownloads;
    }
    @JsonProperty
    public void setHasIssues(Optional<Boolean> hasIssues) {
      this.hasIssues = hasIssues;
    }
    @JsonProperty
    public void setHasWiki(Optional<Boolean> hasWiki) {
      this.hasWiki = hasWiki;
    }
    @JsonProperty
    public void setHasPages(Optional<Boolean> hasPages) {
      this.hasPages = hasPages;
    }
    @JsonProperty
    public void setHasProjects(Optional<Boolean> hasProjects) {
      this.hasProjects = hasProjects;
    }
    @JsonProperty("archived")
    public void setIsArchived(Optional<Boolean> isArchived) {
      this.isArchived = isArchived;
    }
    @JsonProperty("private")
    public void setIsPrivate(Optional<Boolean> isPrivate) {
      this.isPrivate = isPrivate;
    }
    @JsonProperty
    public void setIsTemplate(Optional<Boolean> isTemplate) {
      this.isTemplate = isTemplate;
    }
    @JsonProperty
    public void setSquashMergeCommitMessage(Optional<String> squashMergeCommitMessage) {
      this.squashMergeCommitMessage = squashMergeCommitMessage;
    }
    @JsonProperty
    public void setSquashMergeCommitTitle(Optional<String> squashMergeCommitTitle) {
      this.squashMergeCommitTitle = squashMergeCommitTitle;
    }
    @JsonProperty
    public void setMergeCommitMessage(Optional<String> mergeCommitMessage) {
      this.mergeCommitMessage = mergeCommitMessage;
    }
    @JsonProperty
    public void setMergeCommitTitle(Optional<String> mergeCommitTitle) {
      this.mergeCommitTitle = mergeCommitTitle;
    }
    @JsonProperty
    public void setTeamId(Optional<Integer> teamId) {
      this.teamId = teamId;
    }
    @JsonProperty
    public void setVisibility(Optional<String> visibility) {
      this.visibility = visibility;
    }
    @JsonProperty
    public void setWebCommitSignoffRequired(Optional<Boolean> webCommitSignoffRequired) {
      this.webCommitSignoffRequired = webCommitSignoffRequired;
    }
    @Override
    public Optional<String> description() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> allowAutoMerge() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> allowForking() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> allowSquashMerge() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> allowMergeCommit() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> allowRebaseMerge() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> allowUpdateBranch() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> defaultBranch() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> deleteBranchOnMerge() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> homepage() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> hasDownloads() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> hasIssues() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> hasWiki() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> hasPages() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> hasProjects() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isArchived() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isPrivate() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isTemplate() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> squashMergeCommitMessage() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> squashMergeCommitTitle() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> mergeCommitMessage() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> mergeCommitTitle() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> teamId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> visibility() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> webCommitSignoffRequired() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRepositoryUpdate fromJson(Json json) {
    ImmutableRepositoryUpdate.Builder builder = ImmutableRepositoryUpdate.builder();
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.allowAutoMerge != null) {
      builder.allowAutoMerge(json.allowAutoMerge);
    }
    if (json.allowForking != null) {
      builder.allowForking(json.allowForking);
    }
    if (json.allowSquashMerge != null) {
      builder.allowSquashMerge(json.allowSquashMerge);
    }
    if (json.allowMergeCommit != null) {
      builder.allowMergeCommit(json.allowMergeCommit);
    }
    if (json.allowRebaseMerge != null) {
      builder.allowRebaseMerge(json.allowRebaseMerge);
    }
    if (json.allowUpdateBranch != null) {
      builder.allowUpdateBranch(json.allowUpdateBranch);
    }
    if (json.defaultBranch != null) {
      builder.defaultBranch(json.defaultBranch);
    }
    if (json.deleteBranchOnMerge != null) {
      builder.deleteBranchOnMerge(json.deleteBranchOnMerge);
    }
    if (json.homepage != null) {
      builder.homepage(json.homepage);
    }
    if (json.hasDownloads != null) {
      builder.hasDownloads(json.hasDownloads);
    }
    if (json.hasIssues != null) {
      builder.hasIssues(json.hasIssues);
    }
    if (json.hasWiki != null) {
      builder.hasWiki(json.hasWiki);
    }
    if (json.hasPages != null) {
      builder.hasPages(json.hasPages);
    }
    if (json.hasProjects != null) {
      builder.hasProjects(json.hasProjects);
    }
    if (json.isArchived != null) {
      builder.isArchived(json.isArchived);
    }
    if (json.isPrivate != null) {
      builder.isPrivate(json.isPrivate);
    }
    if (json.isTemplate != null) {
      builder.isTemplate(json.isTemplate);
    }
    if (json.squashMergeCommitMessage != null) {
      builder.squashMergeCommitMessage(json.squashMergeCommitMessage);
    }
    if (json.squashMergeCommitTitle != null) {
      builder.squashMergeCommitTitle(json.squashMergeCommitTitle);
    }
    if (json.mergeCommitMessage != null) {
      builder.mergeCommitMessage(json.mergeCommitMessage);
    }
    if (json.mergeCommitTitle != null) {
      builder.mergeCommitTitle(json.mergeCommitTitle);
    }
    if (json.teamId != null) {
      builder.teamId(json.teamId);
    }
    if (json.visibility != null) {
      builder.visibility(json.visibility);
    }
    if (json.webCommitSignoffRequired != null) {
      builder.webCommitSignoffRequired(json.webCommitSignoffRequired);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link RepositoryUpdate} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RepositoryUpdate instance
   */
  public static ImmutableRepositoryUpdate copyOf(RepositoryUpdate instance) {
    if (instance instanceof ImmutableRepositoryUpdate) {
      return (ImmutableRepositoryUpdate) instance;
    }
    return ImmutableRepositoryUpdate.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRepositoryUpdate ImmutableRepositoryUpdate}.
   * <pre>
   * ImmutableRepositoryUpdate.builder()
   *    .description(String) // optional {@link RepositoryUpdate#description() description}
   *    .allowAutoMerge(Boolean) // optional {@link RepositoryUpdate#allowAutoMerge() allowAutoMerge}
   *    .allowForking(Boolean) // optional {@link RepositoryUpdate#allowForking() allowForking}
   *    .allowSquashMerge(Boolean) // optional {@link RepositoryUpdate#allowSquashMerge() allowSquashMerge}
   *    .allowMergeCommit(Boolean) // optional {@link RepositoryUpdate#allowMergeCommit() allowMergeCommit}
   *    .allowRebaseMerge(Boolean) // optional {@link RepositoryUpdate#allowRebaseMerge() allowRebaseMerge}
   *    .allowUpdateBranch(Boolean) // optional {@link RepositoryUpdate#allowUpdateBranch() allowUpdateBranch}
   *    .defaultBranch(String) // optional {@link RepositoryUpdate#defaultBranch() defaultBranch}
   *    .deleteBranchOnMerge(Boolean) // optional {@link RepositoryUpdate#deleteBranchOnMerge() deleteBranchOnMerge}
   *    .homepage(String) // optional {@link RepositoryUpdate#homepage() homepage}
   *    .hasDownloads(Boolean) // optional {@link RepositoryUpdate#hasDownloads() hasDownloads}
   *    .hasIssues(Boolean) // optional {@link RepositoryUpdate#hasIssues() hasIssues}
   *    .hasWiki(Boolean) // optional {@link RepositoryUpdate#hasWiki() hasWiki}
   *    .hasPages(Boolean) // optional {@link RepositoryUpdate#hasPages() hasPages}
   *    .hasProjects(Boolean) // optional {@link RepositoryUpdate#hasProjects() hasProjects}
   *    .isArchived(Boolean) // optional {@link RepositoryUpdate#isArchived() isArchived}
   *    .isPrivate(Boolean) // optional {@link RepositoryUpdate#isPrivate() isPrivate}
   *    .isTemplate(Boolean) // optional {@link RepositoryUpdate#isTemplate() isTemplate}
   *    .squashMergeCommitMessage(String) // optional {@link RepositoryUpdate#squashMergeCommitMessage() squashMergeCommitMessage}
   *    .squashMergeCommitTitle(String) // optional {@link RepositoryUpdate#squashMergeCommitTitle() squashMergeCommitTitle}
   *    .mergeCommitMessage(String) // optional {@link RepositoryUpdate#mergeCommitMessage() mergeCommitMessage}
   *    .mergeCommitTitle(String) // optional {@link RepositoryUpdate#mergeCommitTitle() mergeCommitTitle}
   *    .teamId(Integer) // optional {@link RepositoryUpdate#teamId() teamId}
   *    .visibility(String) // optional {@link RepositoryUpdate#visibility() visibility}
   *    .webCommitSignoffRequired(Boolean) // optional {@link RepositoryUpdate#webCommitSignoffRequired() webCommitSignoffRequired}
   *    .build();
   * </pre>
   * @return A new ImmutableRepositoryUpdate builder
   */
  public static ImmutableRepositoryUpdate.Builder builder() {
    return new ImmutableRepositoryUpdate.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRepositoryUpdate ImmutableRepositoryUpdate}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RepositoryUpdate", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String description;
    private @Nullable Boolean allowAutoMerge;
    private @Nullable Boolean allowForking;
    private @Nullable Boolean allowSquashMerge;
    private @Nullable Boolean allowMergeCommit;
    private @Nullable Boolean allowRebaseMerge;
    private @Nullable Boolean allowUpdateBranch;
    private @Nullable String defaultBranch;
    private @Nullable Boolean deleteBranchOnMerge;
    private @Nullable String homepage;
    private @Nullable Boolean hasDownloads;
    private @Nullable Boolean hasIssues;
    private @Nullable Boolean hasWiki;
    private @Nullable Boolean hasPages;
    private @Nullable Boolean hasProjects;
    private @Nullable Boolean isArchived;
    private @Nullable Boolean isPrivate;
    private @Nullable Boolean isTemplate;
    private @Nullable String squashMergeCommitMessage;
    private @Nullable String squashMergeCommitTitle;
    private @Nullable String mergeCommitMessage;
    private @Nullable String mergeCommitTitle;
    private @Nullable Integer teamId;
    private @Nullable String visibility;
    private @Nullable Boolean webCommitSignoffRequired;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RepositoryUpdate} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RepositoryUpdate instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> descriptionOptional = instance.description();
      if (descriptionOptional.isPresent()) {
        description(descriptionOptional);
      }
      Optional<Boolean> allowAutoMergeOptional = instance.allowAutoMerge();
      if (allowAutoMergeOptional.isPresent()) {
        allowAutoMerge(allowAutoMergeOptional);
      }
      Optional<Boolean> allowForkingOptional = instance.allowForking();
      if (allowForkingOptional.isPresent()) {
        allowForking(allowForkingOptional);
      }
      Optional<Boolean> allowSquashMergeOptional = instance.allowSquashMerge();
      if (allowSquashMergeOptional.isPresent()) {
        allowSquashMerge(allowSquashMergeOptional);
      }
      Optional<Boolean> allowMergeCommitOptional = instance.allowMergeCommit();
      if (allowMergeCommitOptional.isPresent()) {
        allowMergeCommit(allowMergeCommitOptional);
      }
      Optional<Boolean> allowRebaseMergeOptional = instance.allowRebaseMerge();
      if (allowRebaseMergeOptional.isPresent()) {
        allowRebaseMerge(allowRebaseMergeOptional);
      }
      Optional<Boolean> allowUpdateBranchOptional = instance.allowUpdateBranch();
      if (allowUpdateBranchOptional.isPresent()) {
        allowUpdateBranch(allowUpdateBranchOptional);
      }
      Optional<String> defaultBranchOptional = instance.defaultBranch();
      if (defaultBranchOptional.isPresent()) {
        defaultBranch(defaultBranchOptional);
      }
      Optional<Boolean> deleteBranchOnMergeOptional = instance.deleteBranchOnMerge();
      if (deleteBranchOnMergeOptional.isPresent()) {
        deleteBranchOnMerge(deleteBranchOnMergeOptional);
      }
      Optional<String> homepageOptional = instance.homepage();
      if (homepageOptional.isPresent()) {
        homepage(homepageOptional);
      }
      Optional<Boolean> hasDownloadsOptional = instance.hasDownloads();
      if (hasDownloadsOptional.isPresent()) {
        hasDownloads(hasDownloadsOptional);
      }
      Optional<Boolean> hasIssuesOptional = instance.hasIssues();
      if (hasIssuesOptional.isPresent()) {
        hasIssues(hasIssuesOptional);
      }
      Optional<Boolean> hasWikiOptional = instance.hasWiki();
      if (hasWikiOptional.isPresent()) {
        hasWiki(hasWikiOptional);
      }
      Optional<Boolean> hasPagesOptional = instance.hasPages();
      if (hasPagesOptional.isPresent()) {
        hasPages(hasPagesOptional);
      }
      Optional<Boolean> hasProjectsOptional = instance.hasProjects();
      if (hasProjectsOptional.isPresent()) {
        hasProjects(hasProjectsOptional);
      }
      Optional<Boolean> isArchivedOptional = instance.isArchived();
      if (isArchivedOptional.isPresent()) {
        isArchived(isArchivedOptional);
      }
      Optional<Boolean> isPrivateOptional = instance.isPrivate();
      if (isPrivateOptional.isPresent()) {
        isPrivate(isPrivateOptional);
      }
      Optional<Boolean> isTemplateOptional = instance.isTemplate();
      if (isTemplateOptional.isPresent()) {
        isTemplate(isTemplateOptional);
      }
      Optional<String> squashMergeCommitMessageOptional = instance.squashMergeCommitMessage();
      if (squashMergeCommitMessageOptional.isPresent()) {
        squashMergeCommitMessage(squashMergeCommitMessageOptional);
      }
      Optional<String> squashMergeCommitTitleOptional = instance.squashMergeCommitTitle();
      if (squashMergeCommitTitleOptional.isPresent()) {
        squashMergeCommitTitle(squashMergeCommitTitleOptional);
      }
      Optional<String> mergeCommitMessageOptional = instance.mergeCommitMessage();
      if (mergeCommitMessageOptional.isPresent()) {
        mergeCommitMessage(mergeCommitMessageOptional);
      }
      Optional<String> mergeCommitTitleOptional = instance.mergeCommitTitle();
      if (mergeCommitTitleOptional.isPresent()) {
        mergeCommitTitle(mergeCommitTitleOptional);
      }
      Optional<Integer> teamIdOptional = instance.teamId();
      if (teamIdOptional.isPresent()) {
        teamId(teamIdOptional);
      }
      Optional<String> visibilityOptional = instance.visibility();
      if (visibilityOptional.isPresent()) {
        visibility(visibilityOptional);
      }
      Optional<Boolean> webCommitSignoffRequiredOptional = instance.webCommitSignoffRequired();
      if (webCommitSignoffRequiredOptional.isPresent()) {
        webCommitSignoffRequired(webCommitSignoffRequiredOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder description(Optional<String> description) {
      this.description = description.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#allowAutoMerge() allowAutoMerge} to allowAutoMerge.
     * @param allowAutoMerge The value for allowAutoMerge
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder allowAutoMerge(boolean allowAutoMerge) {
      this.allowAutoMerge = allowAutoMerge;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#allowAutoMerge() allowAutoMerge} to allowAutoMerge.
     * @param allowAutoMerge The value for allowAutoMerge
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder allowAutoMerge(Optional<Boolean> allowAutoMerge) {
      this.allowAutoMerge = allowAutoMerge.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#allowForking() allowForking} to allowForking.
     * @param allowForking The value for allowForking
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder allowForking(boolean allowForking) {
      this.allowForking = allowForking;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#allowForking() allowForking} to allowForking.
     * @param allowForking The value for allowForking
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder allowForking(Optional<Boolean> allowForking) {
      this.allowForking = allowForking.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#allowSquashMerge() allowSquashMerge} to allowSquashMerge.
     * @param allowSquashMerge The value for allowSquashMerge
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder allowSquashMerge(boolean allowSquashMerge) {
      this.allowSquashMerge = allowSquashMerge;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#allowSquashMerge() allowSquashMerge} to allowSquashMerge.
     * @param allowSquashMerge The value for allowSquashMerge
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder allowSquashMerge(Optional<Boolean> allowSquashMerge) {
      this.allowSquashMerge = allowSquashMerge.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#allowMergeCommit() allowMergeCommit} to allowMergeCommit.
     * @param allowMergeCommit The value for allowMergeCommit
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder allowMergeCommit(boolean allowMergeCommit) {
      this.allowMergeCommit = allowMergeCommit;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#allowMergeCommit() allowMergeCommit} to allowMergeCommit.
     * @param allowMergeCommit The value for allowMergeCommit
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder allowMergeCommit(Optional<Boolean> allowMergeCommit) {
      this.allowMergeCommit = allowMergeCommit.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#allowRebaseMerge() allowRebaseMerge} to allowRebaseMerge.
     * @param allowRebaseMerge The value for allowRebaseMerge
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder allowRebaseMerge(boolean allowRebaseMerge) {
      this.allowRebaseMerge = allowRebaseMerge;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#allowRebaseMerge() allowRebaseMerge} to allowRebaseMerge.
     * @param allowRebaseMerge The value for allowRebaseMerge
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder allowRebaseMerge(Optional<Boolean> allowRebaseMerge) {
      this.allowRebaseMerge = allowRebaseMerge.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#allowUpdateBranch() allowUpdateBranch} to allowUpdateBranch.
     * @param allowUpdateBranch The value for allowUpdateBranch
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder allowUpdateBranch(boolean allowUpdateBranch) {
      this.allowUpdateBranch = allowUpdateBranch;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#allowUpdateBranch() allowUpdateBranch} to allowUpdateBranch.
     * @param allowUpdateBranch The value for allowUpdateBranch
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder allowUpdateBranch(Optional<Boolean> allowUpdateBranch) {
      this.allowUpdateBranch = allowUpdateBranch.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#defaultBranch() defaultBranch} to defaultBranch.
     * @param defaultBranch The value for defaultBranch
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defaultBranch(String defaultBranch) {
      this.defaultBranch = Objects.requireNonNull(defaultBranch, "defaultBranch");
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#defaultBranch() defaultBranch} to defaultBranch.
     * @param defaultBranch The value for defaultBranch
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder defaultBranch(Optional<String> defaultBranch) {
      this.defaultBranch = defaultBranch.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#deleteBranchOnMerge() deleteBranchOnMerge} to deleteBranchOnMerge.
     * @param deleteBranchOnMerge The value for deleteBranchOnMerge
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder deleteBranchOnMerge(boolean deleteBranchOnMerge) {
      this.deleteBranchOnMerge = deleteBranchOnMerge;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#deleteBranchOnMerge() deleteBranchOnMerge} to deleteBranchOnMerge.
     * @param deleteBranchOnMerge The value for deleteBranchOnMerge
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder deleteBranchOnMerge(Optional<Boolean> deleteBranchOnMerge) {
      this.deleteBranchOnMerge = deleteBranchOnMerge.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#homepage() homepage} to homepage.
     * @param homepage The value for homepage
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder homepage(String homepage) {
      this.homepage = Objects.requireNonNull(homepage, "homepage");
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#homepage() homepage} to homepage.
     * @param homepage The value for homepage
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder homepage(Optional<String> homepage) {
      this.homepage = homepage.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#hasDownloads() hasDownloads} to hasDownloads.
     * @param hasDownloads The value for hasDownloads
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder hasDownloads(boolean hasDownloads) {
      this.hasDownloads = hasDownloads;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#hasDownloads() hasDownloads} to hasDownloads.
     * @param hasDownloads The value for hasDownloads
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder hasDownloads(Optional<Boolean> hasDownloads) {
      this.hasDownloads = hasDownloads.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#hasIssues() hasIssues} to hasIssues.
     * @param hasIssues The value for hasIssues
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder hasIssues(boolean hasIssues) {
      this.hasIssues = hasIssues;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#hasIssues() hasIssues} to hasIssues.
     * @param hasIssues The value for hasIssues
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder hasIssues(Optional<Boolean> hasIssues) {
      this.hasIssues = hasIssues.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#hasWiki() hasWiki} to hasWiki.
     * @param hasWiki The value for hasWiki
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder hasWiki(boolean hasWiki) {
      this.hasWiki = hasWiki;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#hasWiki() hasWiki} to hasWiki.
     * @param hasWiki The value for hasWiki
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder hasWiki(Optional<Boolean> hasWiki) {
      this.hasWiki = hasWiki.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#hasPages() hasPages} to hasPages.
     * @param hasPages The value for hasPages
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder hasPages(boolean hasPages) {
      this.hasPages = hasPages;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#hasPages() hasPages} to hasPages.
     * @param hasPages The value for hasPages
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder hasPages(Optional<Boolean> hasPages) {
      this.hasPages = hasPages.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#hasProjects() hasProjects} to hasProjects.
     * @param hasProjects The value for hasProjects
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder hasProjects(boolean hasProjects) {
      this.hasProjects = hasProjects;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#hasProjects() hasProjects} to hasProjects.
     * @param hasProjects The value for hasProjects
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder hasProjects(Optional<Boolean> hasProjects) {
      this.hasProjects = hasProjects.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#isArchived() isArchived} to isArchived.
     * @param isArchived The value for isArchived
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isArchived(boolean isArchived) {
      this.isArchived = isArchived;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#isArchived() isArchived} to isArchived.
     * @param isArchived The value for isArchived
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("archived")
    public final Builder isArchived(Optional<Boolean> isArchived) {
      this.isArchived = isArchived.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#isPrivate() isPrivate} to isPrivate.
     * @param isPrivate The value for isPrivate
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isPrivate(boolean isPrivate) {
      this.isPrivate = isPrivate;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#isPrivate() isPrivate} to isPrivate.
     * @param isPrivate The value for isPrivate
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("private")
    public final Builder isPrivate(Optional<Boolean> isPrivate) {
      this.isPrivate = isPrivate.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#isTemplate() isTemplate} to isTemplate.
     * @param isTemplate The value for isTemplate
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isTemplate(boolean isTemplate) {
      this.isTemplate = isTemplate;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#isTemplate() isTemplate} to isTemplate.
     * @param isTemplate The value for isTemplate
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder isTemplate(Optional<Boolean> isTemplate) {
      this.isTemplate = isTemplate.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#squashMergeCommitMessage() squashMergeCommitMessage} to squashMergeCommitMessage.
     * @param squashMergeCommitMessage The value for squashMergeCommitMessage
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder squashMergeCommitMessage(String squashMergeCommitMessage) {
      this.squashMergeCommitMessage = Objects.requireNonNull(squashMergeCommitMessage, "squashMergeCommitMessage");
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#squashMergeCommitMessage() squashMergeCommitMessage} to squashMergeCommitMessage.
     * @param squashMergeCommitMessage The value for squashMergeCommitMessage
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder squashMergeCommitMessage(Optional<String> squashMergeCommitMessage) {
      this.squashMergeCommitMessage = squashMergeCommitMessage.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#squashMergeCommitTitle() squashMergeCommitTitle} to squashMergeCommitTitle.
     * @param squashMergeCommitTitle The value for squashMergeCommitTitle
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder squashMergeCommitTitle(String squashMergeCommitTitle) {
      this.squashMergeCommitTitle = Objects.requireNonNull(squashMergeCommitTitle, "squashMergeCommitTitle");
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#squashMergeCommitTitle() squashMergeCommitTitle} to squashMergeCommitTitle.
     * @param squashMergeCommitTitle The value for squashMergeCommitTitle
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder squashMergeCommitTitle(Optional<String> squashMergeCommitTitle) {
      this.squashMergeCommitTitle = squashMergeCommitTitle.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#mergeCommitMessage() mergeCommitMessage} to mergeCommitMessage.
     * @param mergeCommitMessage The value for mergeCommitMessage
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mergeCommitMessage(String mergeCommitMessage) {
      this.mergeCommitMessage = Objects.requireNonNull(mergeCommitMessage, "mergeCommitMessage");
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#mergeCommitMessage() mergeCommitMessage} to mergeCommitMessage.
     * @param mergeCommitMessage The value for mergeCommitMessage
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder mergeCommitMessage(Optional<String> mergeCommitMessage) {
      this.mergeCommitMessage = mergeCommitMessage.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#mergeCommitTitle() mergeCommitTitle} to mergeCommitTitle.
     * @param mergeCommitTitle The value for mergeCommitTitle
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mergeCommitTitle(String mergeCommitTitle) {
      this.mergeCommitTitle = Objects.requireNonNull(mergeCommitTitle, "mergeCommitTitle");
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#mergeCommitTitle() mergeCommitTitle} to mergeCommitTitle.
     * @param mergeCommitTitle The value for mergeCommitTitle
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder mergeCommitTitle(Optional<String> mergeCommitTitle) {
      this.mergeCommitTitle = mergeCommitTitle.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#teamId() teamId} to teamId.
     * @param teamId The value for teamId
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder teamId(int teamId) {
      this.teamId = teamId;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#teamId() teamId} to teamId.
     * @param teamId The value for teamId
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder teamId(Optional<Integer> teamId) {
      this.teamId = teamId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#visibility() visibility} to visibility.
     * @param visibility The value for visibility
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder visibility(String visibility) {
      this.visibility = Objects.requireNonNull(visibility, "visibility");
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#visibility() visibility} to visibility.
     * @param visibility The value for visibility
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder visibility(Optional<String> visibility) {
      this.visibility = visibility.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#webCommitSignoffRequired() webCommitSignoffRequired} to webCommitSignoffRequired.
     * @param webCommitSignoffRequired The value for webCommitSignoffRequired
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder webCommitSignoffRequired(boolean webCommitSignoffRequired) {
      this.webCommitSignoffRequired = webCommitSignoffRequired;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryUpdate#webCommitSignoffRequired() webCommitSignoffRequired} to webCommitSignoffRequired.
     * @param webCommitSignoffRequired The value for webCommitSignoffRequired
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder webCommitSignoffRequired(Optional<Boolean> webCommitSignoffRequired) {
      this.webCommitSignoffRequired = webCommitSignoffRequired.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableRepositoryUpdate ImmutableRepositoryUpdate}.
     * @return An immutable instance of RepositoryUpdate
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRepositoryUpdate build() {
      return new ImmutableRepositoryUpdate(
          description,
          allowAutoMerge,
          allowForking,
          allowSquashMerge,
          allowMergeCommit,
          allowRebaseMerge,
          allowUpdateBranch,
          defaultBranch,
          deleteBranchOnMerge,
          homepage,
          hasDownloads,
          hasIssues,
          hasWiki,
          hasPages,
          hasProjects,
          isArchived,
          isPrivate,
          isTemplate,
          squashMergeCommitMessage,
          squashMergeCommitTitle,
          mergeCommitMessage,
          mergeCommitTitle,
          teamId,
          visibility,
          webCommitSignoffRequired);
    }
  }
}
