package com.spotify.github.v3.search.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SearchParameters}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSearchParameters.builder()}.
 */
@Generated(from = "SearchParameters", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSearchParameters implements SearchParameters {
  private final @Nullable String q;
  private final @Nullable String sort;
  private final @Nullable String order;
  private final @Nullable Integer per_page;
  private final @Nullable Integer page;

  private ImmutableSearchParameters(
      @Nullable String q,
      @Nullable String sort,
      @Nullable String order,
      @Nullable Integer per_page,
      @Nullable Integer page) {
    this.q = q;
    this.sort = sort;
    this.order = order;
    this.per_page = per_page;
    this.page = page;
  }

  /**
   *The search keywords, as well as any qualifiers. 
   */
  @JsonProperty
  @Override
  public @Nullable String q() {
    return q;
  }

  /**
   *The sort field. One of stars, forks, or updated. Default: results are sorted by best match. 
   */
  @JsonProperty
  @Override
  public Optional<String> sort() {
    return Optional.ofNullable(sort);
  }

  /**
   *The sort order if sort parameter is provided. One of asc or desc. Default: desc 
   */
  @JsonProperty
  @Override
  public Optional<String> order() {
    return Optional.ofNullable(order);
  }

  /**
   * The number of results per page (max 100). Default: 30
   */
  @JsonProperty
  @Override
  public Optional<Integer> per_page() {
    return Optional.ofNullable(per_page);
  }

  /**
   * Page number of the results to fetch. Default: 1
   */
  @JsonProperty
  @Override
  public Optional<Integer> page() {
    return Optional.ofNullable(page);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchParameters#q() q} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for q (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchParameters withQ(@Nullable String value) {
    if (Objects.equals(this.q, value)) return this;
    return new ImmutableSearchParameters(value, this.sort, this.order, this.per_page, this.page);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SearchParameters#sort() sort} attribute.
   * @param value The value for sort
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearchParameters withSort(String value) {
    String newValue = Objects.requireNonNull(value, "sort");
    if (Objects.equals(this.sort, newValue)) return this;
    return new ImmutableSearchParameters(this.q, newValue, this.order, this.per_page, this.page);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SearchParameters#sort() sort} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for sort
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearchParameters withSort(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.sort, value)) return this;
    return new ImmutableSearchParameters(this.q, value, this.order, this.per_page, this.page);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SearchParameters#order() order} attribute.
   * @param value The value for order
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearchParameters withOrder(String value) {
    String newValue = Objects.requireNonNull(value, "order");
    if (Objects.equals(this.order, newValue)) return this;
    return new ImmutableSearchParameters(this.q, this.sort, newValue, this.per_page, this.page);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SearchParameters#order() order} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for order
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearchParameters withOrder(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.order, value)) return this;
    return new ImmutableSearchParameters(this.q, this.sort, value, this.per_page, this.page);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SearchParameters#per_page() per_page} attribute.
   * @param value The value for per_page
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearchParameters withPer_page(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.per_page, newValue)) return this;
    return new ImmutableSearchParameters(this.q, this.sort, this.order, newValue, this.page);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SearchParameters#per_page() per_page} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for per_page
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearchParameters withPer_page(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.per_page, value)) return this;
    return new ImmutableSearchParameters(this.q, this.sort, this.order, value, this.page);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SearchParameters#page() page} attribute.
   * @param value The value for page
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearchParameters withPage(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.page, newValue)) return this;
    return new ImmutableSearchParameters(this.q, this.sort, this.order, this.per_page, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SearchParameters#page() page} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for page
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearchParameters withPage(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.page, value)) return this;
    return new ImmutableSearchParameters(this.q, this.sort, this.order, this.per_page, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSearchParameters} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSearchParameters
        && equalTo(0, (ImmutableSearchParameters) another);
  }

  private boolean equalTo(int synthetic, ImmutableSearchParameters another) {
    return Objects.equals(q, another.q)
        && Objects.equals(sort, another.sort)
        && Objects.equals(order, another.order)
        && Objects.equals(per_page, another.per_page)
        && Objects.equals(page, another.page);
  }

  /**
   * Computes a hash code from attributes: {@code q}, {@code sort}, {@code order}, {@code per_page}, {@code page}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(q);
    h += (h << 5) + Objects.hashCode(sort);
    h += (h << 5) + Objects.hashCode(order);
    h += (h << 5) + Objects.hashCode(per_page);
    h += (h << 5) + Objects.hashCode(page);
    return h;
  }

  /**
   * Prints the immutable value {@code SearchParameters} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SearchParameters{");
    if (q != null) {
      builder.append("q=").append(q);
    }
    if (sort != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("sort=").append(sort);
    }
    if (order != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("order=").append(order);
    }
    if (per_page != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("per_page=").append(per_page);
    }
    if (page != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("page=").append(page);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "SearchParameters", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SearchParameters {
    @Nullable String q;
    @Nullable Optional<String> sort = Optional.empty();
    @Nullable Optional<String> order = Optional.empty();
    @Nullable Optional<Integer> per_page = Optional.empty();
    @Nullable Optional<Integer> page = Optional.empty();
    @JsonProperty
    public void setQ(@Nullable String q) {
      this.q = q;
    }
    @JsonProperty
    public void setSort(Optional<String> sort) {
      this.sort = sort;
    }
    @JsonProperty
    public void setOrder(Optional<String> order) {
      this.order = order;
    }
    @JsonProperty
    public void setPer_page(Optional<Integer> per_page) {
      this.per_page = per_page;
    }
    @JsonProperty
    public void setPage(Optional<Integer> page) {
      this.page = page;
    }
    @Override
    public String q() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> sort() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> order() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> per_page() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> page() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSearchParameters fromJson(Json json) {
    ImmutableSearchParameters.Builder builder = ImmutableSearchParameters.builder();
    if (json.q != null) {
      builder.q(json.q);
    }
    if (json.sort != null) {
      builder.sort(json.sort);
    }
    if (json.order != null) {
      builder.order(json.order);
    }
    if (json.per_page != null) {
      builder.per_page(json.per_page);
    }
    if (json.page != null) {
      builder.page(json.page);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SearchParameters} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SearchParameters instance
   */
  public static ImmutableSearchParameters copyOf(SearchParameters instance) {
    if (instance instanceof ImmutableSearchParameters) {
      return (ImmutableSearchParameters) instance;
    }
    return ImmutableSearchParameters.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSearchParameters ImmutableSearchParameters}.
   * <pre>
   * ImmutableSearchParameters.builder()
   *    .q(String | null) // nullable {@link SearchParameters#q() q}
   *    .sort(String) // optional {@link SearchParameters#sort() sort}
   *    .order(String) // optional {@link SearchParameters#order() order}
   *    .per_page(Integer) // optional {@link SearchParameters#per_page() per_page}
   *    .page(Integer) // optional {@link SearchParameters#page() page}
   *    .build();
   * </pre>
   * @return A new ImmutableSearchParameters builder
   */
  public static ImmutableSearchParameters.Builder builder() {
    return new ImmutableSearchParameters.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSearchParameters ImmutableSearchParameters}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SearchParameters", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String q;
    private @Nullable String sort;
    private @Nullable String order;
    private @Nullable Integer per_page;
    private @Nullable Integer page;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SearchParameters} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SearchParameters instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String qValue = instance.q();
      if (qValue != null) {
        q(qValue);
      }
      Optional<String> sortOptional = instance.sort();
      if (sortOptional.isPresent()) {
        sort(sortOptional);
      }
      Optional<String> orderOptional = instance.order();
      if (orderOptional.isPresent()) {
        order(orderOptional);
      }
      Optional<Integer> per_pageOptional = instance.per_page();
      if (per_pageOptional.isPresent()) {
        per_page(per_pageOptional);
      }
      Optional<Integer> pageOptional = instance.page();
      if (pageOptional.isPresent()) {
        page(pageOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SearchParameters#q() q} attribute.
     * @param q The value for q (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder q(@Nullable String q) {
      this.q = q;
      return this;
    }

    /**
     * Initializes the optional value {@link SearchParameters#sort() sort} to sort.
     * @param sort The value for sort
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sort(String sort) {
      this.sort = Objects.requireNonNull(sort, "sort");
      return this;
    }

    /**
     * Initializes the optional value {@link SearchParameters#sort() sort} to sort.
     * @param sort The value for sort
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sort(Optional<String> sort) {
      this.sort = sort.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SearchParameters#order() order} to order.
     * @param order The value for order
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder order(String order) {
      this.order = Objects.requireNonNull(order, "order");
      return this;
    }

    /**
     * Initializes the optional value {@link SearchParameters#order() order} to order.
     * @param order The value for order
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder order(Optional<String> order) {
      this.order = order.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SearchParameters#per_page() per_page} to per_page.
     * @param per_page The value for per_page
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder per_page(int per_page) {
      this.per_page = per_page;
      return this;
    }

    /**
     * Initializes the optional value {@link SearchParameters#per_page() per_page} to per_page.
     * @param per_page The value for per_page
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder per_page(Optional<Integer> per_page) {
      this.per_page = per_page.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SearchParameters#page() page} to page.
     * @param page The value for page
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder page(int page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the optional value {@link SearchParameters#page() page} to page.
     * @param page The value for page
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder page(Optional<Integer> page) {
      this.page = page.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableSearchParameters ImmutableSearchParameters}.
     * @return An immutable instance of SearchParameters
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSearchParameters build() {
      return new ImmutableSearchParameters(q, sort, order, per_page, page);
    }
  }
}
